package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;


import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanOutDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.RedPacketQueryScheme2Dto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 活动细案(ActivityDetailPlan)表服务实现类
 *
 * @author wanghaojia
 * @since 2022-11-04 16:52:04
 */
@Service("activityDetailPlanSdkService")
public class ActivityDetailPlanSdkServiceImpl implements ActivityDetailPlanSdkService {

    @Autowired(required = false)
    private ActivityDetailPlanRepository activityDetailPlanRepository;

    @Autowired(required = false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;

    @Autowired(required = false)
    private ActivityDetailPlanService activityDetailPlanService;
    @Autowired(required = false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param activityDetailPlanDto 查询实体
     * @return 所有数据
     */
    @Override
    public Page<ActivityDetailPlanVo> findByConditions(Pageable pageable, ActivityDetailPlanDto activityDetailPlanDto) {
        return activityDetailPlanService.findByConditions(pageable,activityDetailPlanDto);
    }

    @Override
    public Page<ActivityDetailPlanItemVo> queryActivityDetailPlan(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(activityDetailPlanItemDto)) {
            activityDetailPlanItemDto = new ActivityDetailPlanItemDto();
        }
        return activityDetailPlanRepository.queryActivityDetailPlan(pageable,activityDetailPlanItemDto);
    }

    /**
     * 通过细案编码查询细案
     * @param detailPlanCodes 细案编码集合
     * @return
     */
    @Override
    public List<ActivityDetailPlanVo> findByCodes(Collection<String> detailPlanCodes) {
        if(CollectionUtils.isEmpty(detailPlanCodes)){
            return new ArrayList<ActivityDetailPlanVo>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq("del_flag", DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq("tenant_code", TenantUtils.getTenantCode());
        wrapper.in("detail_plan_code",detailPlanCodes);
        List<ActivityDetailPlan> list = activityDetailPlanRepository.list(wrapper);
        return (List<ActivityDetailPlanVo>) nebulaToolkitService.copyCollectionByWhiteList(list,ActivityDetailPlan.class,ActivityDetailPlanVo.class,HashSet.class,ArrayList.class);
    }

    @Override
    public List<ActivityDetailPlanVo> findActivityDetailPlanByCodes(List<String> codes) {

        List<ActivityDetailPlan> list = activityDetailPlanRepository.findByDetailPlanCodeList(codes);

        if (CollUtil.isEmpty(list)){
            return Lists.newArrayList();
        }

        return new ArrayList<>(this.nebulaToolkitService
                .copyCollectionByWhiteList(list
                        , ActivityDetailPlan.class
                        , ActivityDetailPlanVo.class
                        , HashSet.class
                        , ArrayList.class));

    }

    /**
     * 通过细案名称模糊查细案编码
     * @param planName 细案名称
     * @return 细案编码
     */
    @Override
    public String findPlanCodeByPlanName(String planName) {
        if(StringUtils.isBlank(planName)){
           return "";
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq("del_flag",DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq("tenant_code",TenantUtils.getTenantCode());
        wrapper.like("detail_plan_name",planName);
        wrapper.last("limit 1");
        ActivityDetailPlan one = activityDetailPlanRepository.getOne(wrapper);
        return one != null ? one.getDetailPlanCode() : "";
    }

    @Override
    public List<ActivityDetailPlanDto> buildActivityDetailPlanParams(List<String> detailPlanCodeList) {
        return activityDetailPlanService.buildActivityDetailPlanParams(detailPlanCodeList);
    }

    @Override
    public List<RedPacketQueryScheme2Vo> redPacketQueryScheme(RedPacketQueryScheme2Dto dto2) {
        Validate.notNull(dto2.getSupplierCode(),"供应商编码不能为空");
        return this.activityDetailPlanService.redPacketQueryScheme(dto2);
    }

    @Override
    public List<ActivityDetailPlanVo> getCanAutoAuditDto(Page<ActivityDetailPlanVo> page, String autoDate) {

        return this.activityDetailPlanService.getCanAutoAuditDto(page, autoDate);
    }

    @Override
    public List<ActivityDetailPlanVo> findCanAutoAudit(Page<ActivityDetailPlanVo> page, AutoAuditParamsDto autoAuditParams) {

        return this.activityDetailPlanService.findCanAutoAudit(page, autoAuditParams);

    }

    @Override
    public List<ActivityDetailPlanItemVo> findCanAutoAuditItem(AutoAuditParamsDto autoAuditParams) {
        return null;
    }

    @Override
    public int getActivityDetailNum(String autoDate, String businessUnitCode) {
        return this.activityDetailPlanService.getDetailPlanNum(autoDate, businessUnitCode);
    }

    @Override
    public int getActivityTotalNumber(AutoAuditParamsDto autoAuditParams) {
        return this.activityDetailPlanService.getActivityTotalNumber(autoAuditParams);
    }

    @Override
    public void updateAutoAudit(String detailPlanCode) {

        this.activityDetailPlanService.updateAutoAudit(detailPlanCode);

    }

    @Override
    public List<ActivityDetailPlanVo> findByPlanCodes(Set<String> codeSet) {
        if (CollectionUtils.isEmpty(codeSet)){
            return new ArrayList<>();
        }
        return this.activityDetailPlanRepository.findPlanCodes(codeSet);
    }

    @Override
    public void updateAutoAuditFlag(List<String> codeList, String autoAudit) {
        this.activityDetailPlanRepository.updateAutoAuditFlag(codeList, autoAudit);
    }

    @Override
    public List<ActivityDetailPlanBudgetVo> findByPlanItemCode(Set<String> itemCodeSet) {
        if (CollectionUtils.isEmpty(itemCodeSet)) {
            return null;
        }
        return this.activityDetailPlanBudgetRepository.findByPlanItemCode(itemCodeSet);
    }

    @Override
    public ActivityDetailPlanVo findByPlanCode(String planCode) {
        if(StringUtils.isEmpty(planCode)){
            return null;
        }
        List<ActivityDetailPlan> activityDetailPlanList = this.activityDetailPlanRepository.findByPlanCode(planCode);
        if(CollectionUtils.isEmpty(activityDetailPlanList)){
            return null;
        }
        return this.nebulaToolkitService.copyObjectByBlankList(activityDetailPlanList.get(0),ActivityDetailPlanVo.class,null,null);
    }

    @Override
    public ActivityDetailPlanVo findById(String id) {
        return null;
    }

    @Override
    public ActivityDetailPlanOutDto createOrUpdateForOut(ActivityDetailPlanOutDto dto) {
        return null;
    }

    @Override
    public void delete(List<String> ids) {

    }

    @Override
    public ActivityDetailPlanOutDto atomicCreateForOut(ActivityDetailPlanOutDto dto) {
        return null;
    }

    @Override
    public Page<ActivityDetailPlanVo> findPageForOut(Pageable pageable, ActivityDetailPlanDto activityDetailPlanDto) {
        return null;
    }

    /**
     * 根据 dot查询
     * @param dto
     * @return
     */
    @Override
    public Page<String> findByDtoForPrediction(Pageable pageable, ActivityDetailPlanDto dto) {
        if (Objects.isNull(dto) || Objects.isNull(dto.getActivityBeginDate()) || Objects.isNull(dto.getActivityEndDate())) {
            return null;
        }
        return this.activityDetailPlanService.findByDtoForPrediction(pageable, dto);
    }

    @Override
    public Page<ActivityDetailPlanItemVo> findPlanItemByConditions(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return null;
    }

}

