package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItem;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanPlanRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItemTerminal;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.*;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.*;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanApproveSubmitDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityPlanDetailPlanAndBudgetEditDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityPlanMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanRollbackMqTagConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.*;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.log.ActivityDetailPlanLogEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.*;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.event.SapAmountListener;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.event.log.ActivityDetailPlanLogEventListener;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.*;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormExeDetailVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.*;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanBudgetOccupyTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanStatusEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanBudgetSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanBudgetVerticalService;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeBudgetDto;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeRelationDto;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetGroupEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import liquibase.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动细案接口实现
 * @author wanghaojia
 * @date 2022/11/22 15:47
 */
@Slf4j
@Service
public class ActivityDetailPlanServiceImpl implements ActivityDetailPlanService {

    @Autowired(required = false)
    private ActivityDetailPlanRepository activityDetailPlanRepository;
    @Autowired(required = false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;
    @Autowired(required = false)
    private ActivityDetailPlanPlanRepository activityDetailPlanPlanRepository;

    @Autowired(required = false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;
    @Autowired(required = false)
    private ActivityDetailPlanItemProductService activityDetailPlanItemProductService;

    @Autowired(required = false)
    private ActivityDetailPlanPlanService activityDetailPlanPlanService;

    @Autowired(required = false)
    private ActivityDetailPlanBudgetService activityDetailPlanBudgetService;

    @Autowired(required = false)
    private ActivityPlanBudgetSdkService activityPlanBudgetSdkService;

    @Autowired(required = false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private ProcessBatchBusinessService processBatchBusinessService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    @Autowired(required = false)
    private ActivityPlanSdkService activityPlanSdkService;

    /**
     * 月度预算服务
     */
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private ActivityTypeService activityTypeService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;

    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private ActivityDetailPlanItemTerminalRepository activityDetailPlanItemTerminalRepository;


    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private ActivityPlanBudgetVerticalService activityPlanBudgetVerticalService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param activityDetailPlanDto 查询实体
     * @return 所有数据
     */
    @Override
    public Page<ActivityDetailPlanVo> findByConditions(Pageable pageable, ActivityDetailPlanDto activityDetailPlanDto) {
        return activityDetailPlanRepository.findByConditions(pageable,activityDetailPlanDto);
    }

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @Override
    public Page<ActivityDetailPlanReportVo> findDetailByConditions(Pageable pageable, ActivityDetailPlanReportDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new ActivityDetailPlanReportDto();
        }
        //默认查当月
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(dto.getTenantCode(), "租户号为空！");
        if (StringUtils.isEmpty(dto.getFeeYearMonthStr())
                && StringUtils.isEmpty(dto.getFeeYearMonthStrBegin())
                && StringUtils.isEmpty(dto.getFeeYearMonthStrEnd())) {
            dto.setFeeYearMonthStr(DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH));
        }
        dto.appendStr();

        Page<ActivityDetailPlanReportVo> page = activityDetailPlanRepository.findDetailByConditions(pageable, dto);
        List<ActivityDetailPlanReportVo> records = page.getRecords();
        Set<String> detailPlanCodeSet = records.stream().map(ActivityDetailPlanReportVo::getDetailPlanCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List<ActivityPlanMessageVo> activityPlanMessageVoList = activityDetailPlanRepository.findPlanMessageByDetailPlanCodeSet(detailPlanCodeSet);
        Map<String, List<ActivityPlanMessageVo>> detailPlanCodeToMessageVoList = activityPlanMessageVoList.stream().collect(Collectors.groupingBy(ActivityPlanMessageVo::getDetailPlanCode));
        records.forEach(e->{
            String detailPlanCode = e.getDetailPlanCode();
            if(detailPlanCodeToMessageVoList.containsKey(detailPlanCode)){
                List<ActivityPlanMessageVo> messageVoList = detailPlanCodeToMessageVoList.get(detailPlanCode);
                e.setRelatePlanCode(messageVoList.stream().map(ActivityPlanMessageVo::getRelatePlanCode).distinct().collect(Collectors.joining(",")));
                e.setRelatePlanItemCode(messageVoList.stream().map(ActivityPlanMessageVo::getRelatePlanItemCode).distinct().collect(Collectors.joining(",")));
                e.setPlanClassify(messageVoList.stream().map(ActivityPlanMessageVo::getPlanClassify).distinct().collect(Collectors.joining(",")));
                e.setRelatePlanName(messageVoList.stream().map(ActivityPlanMessageVo::getRelatePlanName).distinct().collect(Collectors.joining(",")));
            }
        });
        page.setRecords(records);
        return page;
    }

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @Override
    public Page<ActivityDetailPlanReportVo> findDetailByConditionsFotExport(Pageable pageable, ActivityDetailPlanReportDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new ActivityDetailPlanReportDto();
        }
        return activityDetailPlanRepository.findDetailByConditions(pageable, dto);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityDetailPlan(ActivityDetailPlanDto dto, String cacheKey) {
        List<ActivityDetailPlanItemDto> itemCacheList = activityDetailPlanItemService.findCacheList(cacheKey);
        saveActivityDetailPlan(dto,itemCacheList);
        activityDetailPlanItemService.clearCache(cacheKey);
    }

    /**
     * 活动方案新增编辑
     *
     * @param itemDtoList 活动方案明细数据
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityDetailPlan(ActivityDetailPlanDto dto, List<ActivityDetailPlanItemDto> itemDtoList) {
        ActivityDetailPlan entity = null;
        boolean tempSave = Optional.ofNullable(dto.getTempSave()).orElse(false);
        if (tempSave) {
            tempSaveValidate(dto,itemDtoList);
        }else {
            createValidate(dto,itemDtoList);
        }
        boolean update = StringUtil.isNotEmpty(dto.getId());
        ActivityDetailPlanDto oldDto = new ActivityDetailPlanDto();
        if (update) {
            ActivityDetailPlan oldEntity = activityDetailPlanRepository.getById(dto.getId());
            Assert.notNull(oldEntity, "编辑的数据不存在,请刷新重试!");
            if (!ProcessStatusEnum.PREPARE.getKey().equals(oldEntity.getProcessStatus()) &&
                    !ProcessStatusEnum.REJECT.getKey().equals(oldEntity.getProcessStatus()) &&
                    !ProcessStatusEnum.RECOVER.getKey().equals(oldEntity.getProcessStatus())) {
                throw new RuntimeException("只能编辑待提交、驳回、追回状态的数据！");
            }
            dto.setPlanStatus(ActivityPlanStatusEnum.normal.getCode());
            dto.setDetailPlanCode(oldEntity.getDetailPlanCode());
            dto.setTenantCode(oldEntity.getTenantCode());
            dto.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            dto.setIsValidate(!tempSave ? BooleanEnum.TRUE.getCapital() : BooleanEnum.FALSE.getCapital());
            entity = nebulaToolkitService.copyObjectByWhiteList(dto, ActivityDetailPlan.class, HashSet.class, ArrayList.class);
            activityDetailPlanRepository.updateById(entity);
            oldDto = nebulaToolkitService.copyObjectByWhiteList(oldEntity, ActivityDetailPlanDto.class, HashSet.class, ArrayList.class);
        } else {
            // redis生成营销策略编码，编码规则为MS+年月日+5位顺序数。每天都从00001开始
            String ruleCode = this.generateCodeService.generateCode(ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_RULE_CODE_PRE, 1, 6, 2, TimeUnit.DAYS).get(0);
            dto.setDetailPlanCode(ruleCode);
            entity = nebulaToolkitService.copyObjectByWhiteList(dto, ActivityDetailPlan.class, HashSet.class, ArrayList.class);
            entity.setDetailPlanCode(ruleCode);
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            entity.setPlanStatus(ActivityPlanStatusEnum.normal.getCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantContextHolder.getTenantInfo().getTenantCode());
            entity.setWhereFrom("手工新增");
            entity.setIsValidate(!tempSave ? BooleanEnum.TRUE.getCapital() : BooleanEnum.FALSE.getCapital());
            activityDetailPlanRepository.save(entity);
        }
        //保存活动细案方案-方案关联
        activityDetailPlanPlanService.saveActivityDetailPlanPlanList(entity,update,dto.getRelatePlanList());

        //保存方案明细
        activityDetailPlanItemService.saveActivityDetailPlanItemList(entity,update,itemDtoList,false,tempSave);

        //保存方案多选产品
        activityDetailPlanItemProductService.saveActivityDetailPlanItemProductList(entity,update,itemDtoList);

        //保存方案关联预算
        activityDetailPlanBudgetService.saveActivityDetailPlanBudgetList(entity,update,itemDtoList);

        //新增修改业务日志
        ActivityDetailPlanLogEventDto logEventDto = new ActivityDetailPlanLogEventDto();
        dto.setId(entity.getId());
        logEventDto.setNewest(dto);
        if (!update) {
            logEventDto.setOriginal(null);
            SerializableBiConsumer<ActivityDetailPlanLogEventListener, ActivityDetailPlanLogEventDto> onCreate =
                    ActivityDetailPlanLogEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, ActivityDetailPlanLogEventListener.class, onCreate);
        } else {
            logEventDto.setOriginal(oldDto);
            SerializableBiConsumer<ActivityDetailPlanLogEventListener, ActivityDetailPlanLogEventDto> onUpdate =
                    ActivityDetailPlanLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish(logEventDto, ActivityDetailPlanLogEventListener.class, onUpdate);
        }
    }

    private void tempSaveValidate(ActivityDetailPlanDto dto, List<ActivityDetailPlanItemDto> itemCacheList) {
        Validate.notNull(dto, "新增时，对象信息不能为空！");

        if (!CollectionUtils.isEmpty(itemCacheList)) {
            itemCacheList.forEach(item->{
                item.setBusinessUnitCode(dto.getBusinessUnitCode());
                item.setBusinessFormatCode(dto.getBusinessFormatCode());
            });
        }
        initIndexNo(itemCacheList);
        activityDetailPlanItemService.tempSaveValidate(itemCacheList);

        //设置表头汇总金额
        BigDecimal feeAmount = BigDecimal.ZERO;
        BigDecimal headFeeAmount = BigDecimal.ZERO;
        BigDecimal departmentFeeAmount = BigDecimal.ZERO;
        BigDecimal customerFeeAmount = BigDecimal.ZERO;
        BigDecimal totalFeeAmount = BigDecimal.ZERO;
        for (ActivityDetailPlanItemDto activityPlanItemDto : itemCacheList) {
            BigDecimal thisFeeAmount = BigDecimal.ZERO;
            if (null != activityPlanItemDto.getHeadFeeAmount()){
                headFeeAmount = headFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
            }
            if (null != activityPlanItemDto.getDepartmentFeeAmount()){
                departmentFeeAmount = departmentFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
            }
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                //非垂直，申请金额=总部承担金额+大区承担金额
                activityPlanItemDto.setFeeAmount(thisFeeAmount);
            }
            if (null != activityPlanItemDto.getCustomerFeeAmount()){
                customerFeeAmount = customerFeeAmount.add(activityPlanItemDto.getCustomerFeeAmount());
            }
            if (null != activityPlanItemDto.getTotalFeeAmount()){
                totalFeeAmount = totalFeeAmount.add(activityPlanItemDto.getTotalFeeAmount());
            }
            if (null != activityPlanItemDto.getFeeAmount()){
                feeAmount = feeAmount.add(activityPlanItemDto.getFeeAmount());
            }
        }
        dto.setFeeAmount(feeAmount);
        dto.setTotalFeeAmount(totalFeeAmount);
        dto.setHeadFeeAmount(headFeeAmount);
        dto.setDepartmentFeeAmount(departmentFeeAmount);
        dto.setCustomerFeeAmount(customerFeeAmount);

    }

    /**
     * 策略新增保存逻辑
     * @param dto 策略数据
     * @param itemCacheList 策略行数据
     */
    private void createValidate(ActivityDetailPlanDto dto, List<ActivityDetailPlanItemDto> itemCacheList) {
        Validate.notNull(dto, "新增时，对象信息不能为空！");
//        方案编码：提交时系统自动生成，可不显示。
        Validate.notBlank(dto.getBusinessFormatCode(), "新增时，业态不能为空！");
        Validate.notBlank(dto.getBusinessUnitCode(), "新增时，业务单元不能为空！");

        itemCacheList.forEach(item->{
            item.setBusinessUnitCode(dto.getBusinessUnitCode());
            item.setBusinessFormatCode(dto.getBusinessFormatCode());
        });

        Validate.isTrue(!CollectionUtils.isEmpty(itemCacheList),"新增时，细案明细不能为空");
        initIndexNo(itemCacheList);
        activityDetailPlanItemService.createValidateList(dto,itemCacheList);
        List<ActivityDetailPlanBudgetDto> budgetDtos = matchActivityPlanBudgetRelate(dto,itemCacheList);
        activityDetailPlanBudgetService.useMonthBudget(budgetDtos,false);

        if (BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            //垂直多选预算，校验预算金额之和要等于行上的费用金额
            for (ActivityDetailPlanItemDto itemDto : itemCacheList) {
                BigDecimal feeAmount = Optional.ofNullable(itemDto.getFeeAmount()).orElse(BigDecimal.ZERO);
                BigDecimal budgetFeeAmount = BigDecimal.ZERO;
                if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())){
                    for (ActivityDetailPlanBudgetDto budgetShare : itemDto.getBudgetShares()) {
                        NumberStringDealUtil.validateNumberStrAndSet(itemDto.getFeeAmountStr(), "新增时，策略明细费用金额", false,dto::setFeeAmount, BigDecimal.class);
                        if (null != budgetShare.getUseAmount()){
                            budgetFeeAmount = budgetFeeAmount.add(budgetShare.getUseAmount());
                        }
                    }
                }
                if (feeAmount.compareTo(budgetFeeAmount) != 0){
                    throw new RuntimeException("费用金额["+feeAmount+"]不等于实际预算使用金额["+budgetFeeAmount+"]");
                }
            }
        } else {
            //根据客户编码查询主数据RTM模式，如果RTM为分子公司则校验：分子公司点内金额+分子公司点外金额=总部承担金额+大区承担金额
            Set<String> customerCodeSet = itemCacheList.stream().filter(e -> StringUtils.isNotBlank(e.getCustomerCode())).map(e -> e.getCustomerCode()).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(customerCodeSet)) {
                List<CustomerVo> customerVos = customerVoService.findBaseByCustomerCodes(new ArrayList<>(customerCodeSet));
                Map<String, CustomerVo> customerMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
                for (ActivityDetailPlanItemDto itemDto : itemCacheList) {
                    boolean subComCustomer = false;
                    if (StringUtils.isNotBlank(itemDto.getCustomerCode())) {
                        CustomerVo customerVo = customerMap.get(itemDto.getCustomerCode());
                        if (null == customerVo){
                            throw new RuntimeException("客户编码"+itemDto.getCustomerCode()+"有误");
                        }
                        if (RtmModelCodeEnum.SON_COMPANY.getCode().equals(customerVo.getRtmModelCode())) {
                            subComCustomer = true;
                            Validate.isTrue(null != itemDto.getIntraCompanyAmount() && itemDto.getIntraCompanyAmount().compareTo(BigDecimal.ZERO) >= 0,"分子公司点内金额必须大于等于0！");
                            //总部承担金额
                            BigDecimal headFeeAmount = itemDto.getHeadFeeAmount() == null ? new BigDecimal(0) : itemDto.getHeadFeeAmount();
                            //大区承担金额
                            BigDecimal departmentFeeAmount = itemDto.getDepartmentFeeAmount() == null ? new BigDecimal(0) : itemDto.getDepartmentFeeAmount();
                            //分子公司点内金额
                            BigDecimal intraCompanyAmount = itemDto.getIntraCompanyAmount() == null ? new BigDecimal(0) : itemDto.getIntraCompanyAmount();
                            //分子公司点外金额
                            BigDecimal offPointAmount = itemDto.getOffPointAmount() == null ? new BigDecimal(0) : itemDto.getOffPointAmount();
                            BigDecimal subtract = headFeeAmount.add(departmentFeeAmount).subtract(intraCompanyAmount);
                            if (subtract.compareTo(offPointAmount) != 0){
                                throw new RuntimeException("分子公司点外金额=总部承担金额+大区承担金额-分子公司点内金额，请检查数据填写是否正确");
                            }
                        }
                    }
                    if (!subComCustomer){
                        if (null != itemDto.getOffPointAmount() && itemDto.getOffPointAmount().compareTo(BigDecimal.ZERO) != 0){
                            throw new RuntimeException("非分子公司客户,分子公司点内金额和分子公司点外金额不允许＞0");
                        }
                        if (null != itemDto.getIntraCompanyAmount() && itemDto.getIntraCompanyAmount().compareTo(BigDecimal.ZERO) != 0){
                            throw new RuntimeException("非分子公司客户,分子公司点内金额和分子公司点外金额不允许＞0");
                        }
                    }
                }
            }
        }

        //设置表头汇总金额
        BigDecimal feeAmount = BigDecimal.ZERO;
        BigDecimal headFeeAmount = BigDecimal.ZERO;
        BigDecimal departmentFeeAmount = BigDecimal.ZERO;
        BigDecimal customerFeeAmount = BigDecimal.ZERO;
        BigDecimal totalFeeAmount = BigDecimal.ZERO;
        for (ActivityDetailPlanItemDto activityPlanItemDto : itemCacheList) {
            BigDecimal thisFeeAmount = BigDecimal.ZERO;
            if (null != activityPlanItemDto.getHeadFeeAmount()){
                headFeeAmount = headFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
            }
            if (null != activityPlanItemDto.getDepartmentFeeAmount()){
                departmentFeeAmount = departmentFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
            }
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                //非垂直，申请金额=总部承担金额+大区承担金额
                activityPlanItemDto.setFeeAmount(thisFeeAmount);
            }
            if (null != activityPlanItemDto.getCustomerFeeAmount()){
                customerFeeAmount = customerFeeAmount.add(activityPlanItemDto.getCustomerFeeAmount());
            }
            if (null != activityPlanItemDto.getTotalFeeAmount()){
                totalFeeAmount = totalFeeAmount.add(activityPlanItemDto.getTotalFeeAmount());
            }
            if (null != activityPlanItemDto.getFeeAmount()){
                feeAmount = feeAmount.add(activityPlanItemDto.getFeeAmount());
            }
        }
        dto.setFeeAmount(feeAmount);
        dto.setTotalFeeAmount(totalFeeAmount);
        dto.setHeadFeeAmount(headFeeAmount);
        dto.setDepartmentFeeAmount(departmentFeeAmount);
        dto.setCustomerFeeAmount(customerFeeAmount);

    }

    private void createValidateForOut(ActivityDetailPlanDto dto, List<ActivityDetailPlanItemDto> itemCacheList) {
        Validate.notNull(dto, "新增时，对象信息不能为空！");
//        方案编码：提交时系统自动生成，可不显示。
        Validate.notBlank(dto.getBusinessFormatCode(), "新增时，业态不能为空！");
        Validate.notBlank(dto.getBusinessUnitCode(), "新增时，业务单元不能为空！");
        itemCacheList.forEach(item->{
            item.setBusinessUnitCode(dto.getBusinessUnitCode());
            item.setBusinessFormatCode(dto.getBusinessFormatCode());
        });
        Validate.isTrue(!CollectionUtils.isEmpty(itemCacheList),"新增时，细案明细不能为空");
        activityDetailPlanItemService.createValidateListForOut(itemCacheList);
        List<ActivityDetailPlanBudgetDto> budgetDtos = matchActivityPlanBudgetRelate(dto,itemCacheList);
        activityDetailPlanBudgetService.useMonthBudget(budgetDtos,false);

        //设置表头汇总金额
        BigDecimal feeAmount = BigDecimal.ZERO;
        BigDecimal headFeeAmount = BigDecimal.ZERO;
        BigDecimal departmentFeeAmount = BigDecimal.ZERO;
        BigDecimal customerFeeAmount = BigDecimal.ZERO;
        BigDecimal totalFeeAmount = BigDecimal.ZERO;
        for (ActivityDetailPlanItemDto activityPlanItemDto : itemCacheList) {
            BigDecimal thisFeeAmount = BigDecimal.ZERO;
            if (null != activityPlanItemDto.getHeadFeeAmount()){
                headFeeAmount = headFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
            }
            if (null != activityPlanItemDto.getDepartmentFeeAmount()){
                departmentFeeAmount = departmentFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
            }
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                //非垂直，申请金额=总部承担金额+大区承担金额
                activityPlanItemDto.setFeeAmount(thisFeeAmount);
            }
            if (null != activityPlanItemDto.getCustomerFeeAmount()){
                customerFeeAmount = customerFeeAmount.add(activityPlanItemDto.getCustomerFeeAmount());
            }
            if (null != activityPlanItemDto.getTotalFeeAmount()){
                totalFeeAmount = totalFeeAmount.add(activityPlanItemDto.getTotalFeeAmount());
            }
            if (null != activityPlanItemDto.getFeeAmount()){
                feeAmount = feeAmount.add(activityPlanItemDto.getFeeAmount());
            }
        }
        dto.setFeeAmount(feeAmount);
        dto.setTotalFeeAmount(totalFeeAmount);
        dto.setHeadFeeAmount(headFeeAmount);
        dto.setDepartmentFeeAmount(departmentFeeAmount);
        dto.setCustomerFeeAmount(customerFeeAmount);
    }

    /**
     * 活动方案预算关联策略、方案
     *
     * @param planDto 方案头数据
     */
    public List<ActivityDetailPlanBudgetDto> matchActivityPlanBudgetRelate(ActivityDetailPlanDto planDto,List<ActivityDetailPlanItemDto> itemList){
        List<ActivityDetailPlanPlanDto> relatePlanList = planDto.getRelatePlanList();
        if (!BooleanEnum.TRUE.getCapital().equals(planDto.getIsTemporary())) {
            //不是临时方案必须关联方案
            Validate.isTrue(!CollectionUtils.isEmpty(relatePlanList), "非临时方案必须关联方案!");
        }

        Set<String> monthBudgetCodeSet = org.apache.commons.compress.utils.Sets.newHashSet();
        Map<String, List<ActivityPlanBudgetDto>> relatePlanBudgetMap = Maps.newHashMap();
        Map<String, List<ActivityPlanBudgetDto>> planBudgetMap = Maps.newHashMap();
        Map<String, List<ActivityPlanBudgetDto>> relatePlanCustomerBudgetMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(relatePlanList)){
            List<String> planCodeList = relatePlanList.stream().map(ActivityDetailPlanPlanDto::getPlanCode).distinct().collect(Collectors.toList());
            List<ActivityPlanBudgetDto> activityPlanBudgets = activityPlanBudgetSdkService.listDtoByPlanCodeList(planCodeList);
            planBudgetMap = activityPlanBudgets.stream().collect(Collectors.groupingBy(ActivityPlanBudgetDto::getPlanItemCode));
            relatePlanBudgetMap = activityPlanBudgets.stream().filter(item -> StringUtils.isNotEmpty(item.getMonthBudgetCode())).collect(Collectors.groupingBy(ActivityPlanBudgetDto::getMonthBudgetCode));
            relatePlanCustomerBudgetMap = activityPlanBudgets.stream().filter(item -> ActivityPlanBudgetOccupyTypeEnum.CUSTOMER.getCode().equals(item.getOccupyType())).collect(Collectors.groupingBy(ActivityPlanBudgetDto::getPlanItemCode));

            monthBudgetCodeSet.addAll(activityPlanBudgets.stream().map(ActivityPlanBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        }

        //1、临时方案
        if (BooleanEnum.TRUE.getCapital().equals(planDto.getIsTemporary())) {
            monthBudgetCodeSet.addAll(itemList.stream().map(ActivityDetailPlanItemDto::getMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        }

        //查下月度预算信息，保存费用归口
        Map<String, MonthBudgetVo> monthBudgetMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(monthBudgetCodeSet)){
            List<MonthBudgetVo> monthBudgetList = monthBudgetService.listByCodes(Lists.newArrayList(monthBudgetCodeSet));
            monthBudgetMap = monthBudgetList.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode,Function.identity()));
        }



        List<ActivityDetailPlanBudgetDto> budgetDtos = Lists.newArrayList();
        for (int i = 0; i < itemList.size(); i++) {
            ActivityDetailPlanItemDto itemDto = itemList.get(i);
            //业务单元不是垂直，清空掉明细上的预算信息，按明细上的预算信息重新保存
            List<ActivityDetailPlanBudgetDto> budgetList = Lists.newArrayList();
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())){
                //其他业务单元重新组装预算信息
                Validate.isTrue(!StringUtils.isEmpty(itemDto.getHeadMonthBudgetCode()) || !StringUtils.isEmpty(itemDto.getMonthBudgetCode()), "活动细案总部预算和大区预算不能同时为空!");
                if (StringUtils.isNotEmpty(itemDto.getHeadMonthBudgetCode())){
                    BigDecimal headFeeAmount = itemDto.getHeadFeeAmount();
                    if (null == headFeeAmount || BigDecimal.ZERO.compareTo(headFeeAmount) == 0){
                        //选择总部预算后总部承担金额不能为空
                        throw new RuntimeException("选择总部预算后总部承担金额不能为空或0");
                    }
                }else if (null != itemDto.getHeadFeeAmount() && itemDto.getHeadFeeAmount().compareTo(BigDecimal.ZERO) != 0){
                    throw new RuntimeException("未选择总部预算编码，总部承担金额只能为0");
                }
                if (StringUtils.isNotEmpty(itemDto.getMonthBudgetCode())){
                    BigDecimal departmentFeeAmount = itemDto.getDepartmentFeeAmount();
                    if (null == departmentFeeAmount || BigDecimal.ZERO.compareTo(departmentFeeAmount) == 0){
                        //选择总部预算后总部承担金额不能为空
                        throw new RuntimeException("选择大区预算后大区承担金额不能为空或0");
                    }
                }else if (null != itemDto.getDepartmentFeeAmount() && itemDto.getDepartmentFeeAmount().compareTo(BigDecimal.ZERO) != 0){
                    throw new RuntimeException("未选择大区预算编码，大区承担金额只能为0");
                }

                //1、临时方案
                if (BooleanEnum.TRUE.getCapital().equals(planDto.getIsTemporary())) {
//                    BigDecimal customerFeeAmount = itemDto.getCustomerFeeAmount();
//                    if (null != customerFeeAmount && BigDecimal.ZERO.compareTo(customerFeeAmount) != 0){
//                        throw new RuntimeException("临时方案客户金额必须为0");
//                    }
                    if (StringUtils.isNotEmpty(itemDto.getHeadMonthBudgetCode())){
                        throw new RuntimeException("临时方案不能选择总部统筹预算！");
//                        ActivityDetailPlanBudgetDto monthBudget = new ActivityDetailPlanBudgetDto();
//                        monthBudget.setMonthBudgetCode(itemDto.getHeadMonthBudgetCode());
//                        monthBudget.setBudgetItemCode(itemDto.getHeadBudgetItemCode());
//                        monthBudget.setBudgetItemName(itemDto.getHeadBudgetItemName());
//                        monthBudget.setUseAmount(itemDto.getHeadFeeAmount());
//                        monthBudget.setRelatePlanCode(itemDto.getRelatePlanCode());
//                        monthBudget.setRelatePlanItemCode(itemDto.getRelatePlanItemCode());
//                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
//                        budgetList.add(monthBudget);
                    }
                    if (StringUtils.isNotEmpty(itemDto.getMonthBudgetCode())){
                        ActivityDetailPlanBudgetDto monthBudget = new ActivityDetailPlanBudgetDto();
                        monthBudget.setMonthBudgetCode(itemDto.getMonthBudgetCode());
                        monthBudget.setUseAmount(itemDto.getDepartmentFeeAmount());
                        monthBudget.setRelatePlanCode(itemDto.getRelatePlanCode());
                        monthBudget.setRelatePlanItemCode(itemDto.getRelatePlanItemCode());
                        monthBudget.setBudgetItemCode(itemDto.getBudgetItemCode());
                        monthBudget.setBudgetItemName(itemDto.getBudgetItemName());
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                        monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getMonthBudgetCode()).getFeeBelongCode(): null);
                        budgetList.add(monthBudget);
                    }

                    itemDto.setBudgetShares(budgetList);
                    if (!CollectionUtils.isEmpty(budgetList)){
                        for (ActivityDetailPlanBudgetDto activityDetailPlanBudgetDto : budgetList) {
                            activityDetailPlanBudgetDto.setIndexNo(itemDto.getIndexNo());
                        }
                        budgetDtos.addAll(budgetList);
                    }
                    continue ;
                }

                //2、非临时方案指定了方案明细编码，按指定的来，校验预算必须在范围内
                String relatePlanCode = itemDto.getRelatePlanCode();
                String relatePlanItemCode = itemDto.getRelatePlanItemCode();
                if (StringUtils.isNotEmpty(relatePlanItemCode)){
                    List<ActivityPlanBudgetDto> planItemBudgetList = planBudgetMap.get(relatePlanItemCode);
                    Set<String> planBudgetItemSet = Sets.newHashSet();
                    if (!CollectionUtils.isEmpty(planItemBudgetList)){
                        planBudgetItemSet = planItemBudgetList.stream().map(ActivityPlanBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
                    }
                    if (StringUtils.isNotEmpty(itemDto.getHeadMonthBudgetCode())){
                        if(!planBudgetItemSet.contains(itemDto.getHeadMonthBudgetCode())){
                            throw new RuntimeException("总部预算编码["+itemDto.getHeadMonthBudgetCode()+"]不属于方案明细["+relatePlanItemCode+"]");
                        }
                        ActivityDetailPlanBudgetDto monthBudget = new ActivityDetailPlanBudgetDto();
                        monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                        monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                        monthBudget.setRelatePlanCode(planItemBudgetList.get(0).getPlanCode());
                        monthBudget.setRelatePlanItemCode(itemDto.getRelatePlanItemCode());
                        monthBudget.setMonthBudgetCode(itemDto.getHeadMonthBudgetCode());
                        monthBudget.setBudgetItemCode(itemDto.getHeadBudgetItemCode());
                        monthBudget.setBudgetItemName(itemDto.getHeadBudgetItemName());
                        monthBudget.setUseAmount(itemDto.getHeadFeeAmount());
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                        monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getHeadMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getHeadMonthBudgetCode()).getFeeBelongCode(): null);
                        budgetList.add(monthBudget);
                    }
                    if (StringUtils.isNotEmpty(itemDto.getMonthBudgetCode())){
                        if(!planBudgetItemSet.contains(itemDto.getMonthBudgetCode())) {
                            throw new RuntimeException("大区预算编码[" + itemDto.getMonthBudgetCode() + "]不属于方案明细[" + relatePlanItemCode + "]");
                        }

                        ActivityDetailPlanBudgetDto monthBudget = new ActivityDetailPlanBudgetDto();
                        monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                        monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                        monthBudget.setRelatePlanCode(planItemBudgetList.get(0).getPlanCode());
                        monthBudget.setRelatePlanItemCode(itemDto.getRelatePlanItemCode());
                        monthBudget.setMonthBudgetCode(itemDto.getMonthBudgetCode());
                        monthBudget.setBudgetItemCode(itemDto.getBudgetItemCode());
                        monthBudget.setBudgetItemName(itemDto.getBudgetItemName());
                        monthBudget.setUseAmount(itemDto.getDepartmentFeeAmount());
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                        monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getMonthBudgetCode()).getFeeBelongCode(): null);
                        budgetList.add(monthBudget);
                    }

                    BigDecimal customerFeeAmount = itemDto.getCustomerFeeAmount();
                    customer:if (null != customerFeeAmount && BigDecimal.ZERO.compareTo(customerFeeAmount) != 0){
                        List<ActivityPlanBudgetDto> customerBudgetList = relatePlanCustomerBudgetMap.get(relatePlanItemCode);
                        if (CollectionUtils.isEmpty(customerBudgetList)){
//                            throw new RuntimeException("未获取到匹配方案的客户承担金额");
                            break customer;
                        }
                        BigDecimal usableCustomerAmount = customerBudgetList.stream().map(item -> {
                            return item.getUseAmount().subtract(Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO));
                        }).reduce(BigDecimal.ZERO, BigDecimal::add);
                        if (usableCustomerAmount.compareTo(customerFeeAmount) < 0){
//                            throw new RuntimeException("客户承担金额【"+customerFeeAmount+"】超过方案明细["+relatePlanItemCode+"]剩余可用客户承担金额["+usableCustomerAmount+"]");
                        }
                        //有客户承担金额的话也生成一条数据
                        ActivityDetailPlanBudgetDto monthBudget = new ActivityDetailPlanBudgetDto();
                        monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                        monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                        monthBudget.setRelatePlanCode(customerBudgetList.get(0).getPlanCode());
                        monthBudget.setRelatePlanItemCode(relatePlanItemCode);
                        monthBudget.setUseAmount(customerFeeAmount);
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.CUSTOMER.getCode());
                        budgetList.add(monthBudget);
                    }
                    itemDto.setRelatePlanCode(relatePlanCode);
                    itemDto.setRelatePlanItemCode(relatePlanItemCode);
                    itemDto.setBudgetShares(budgetList);
                    if (!CollectionUtils.isEmpty(budgetList)){
                        for (ActivityDetailPlanBudgetDto activityDetailPlanBudgetDto : budgetList) {
                            activityDetailPlanBudgetDto.setIndexNo(itemDto.getIndexNo());
                        }
                        budgetDtos.addAll(budgetList);
                    }
                    continue ;
                }

                //3、导入的预算，没有指定关联的方案明细，匹配预算信息
                if (StringUtils.isNotEmpty(itemDto.getHeadMonthBudgetCode())){
                    BigDecimal headFeeAmount = itemDto.getHeadFeeAmount();
                    BigDecimal leaveAmount = headFeeAmount;
                    //非临时方案，占预算
                    List<ActivityPlanBudgetDto> activityPlanBudgets = relatePlanBudgetMap.get(itemDto.getHeadMonthBudgetCode());
                    if (CollectionUtils.isEmpty(activityPlanBudgets)){
                        throw new RuntimeException("总部预算["+itemDto.getHeadMonthBudgetCode()+"]不属于关联方案内");
                    }
                    for (ActivityPlanBudgetDto activityPlanBudget : activityPlanBudgets) {
                        if (leaveAmount.compareTo(BigDecimal.ZERO) == 0){
                            break;
                        }
                        BigDecimal useAmount = Optional.ofNullable(activityPlanBudget.getUseAmount()).orElse(BigDecimal.ZERO);
                        BigDecimal usedAmount = Optional.ofNullable(activityPlanBudget.getUsedAmount()).orElse(BigDecimal.ZERO);
                        BigDecimal usableAmount = useAmount.subtract(usedAmount);
                        if (usableAmount.compareTo(BigDecimal.ZERO) <= 0){
                            continue;
                        }
                        if (StringUtils.isNotEmpty(relatePlanItemCode)){
                            if (!relatePlanItemCode.equals(activityPlanBudget.getPlanItemCode())){
                                //选中一个了就一个到底
                                continue;
                            }
                        }else{
                            relatePlanItemCode = activityPlanBudget.getPlanItemCode();
                            relatePlanCode = activityPlanBudget.getPlanCode();
                        }
                        BigDecimal thisAmount = leaveAmount;
                        if (usableAmount.compareTo(thisAmount) < 0){
                            thisAmount = usableAmount;
                        }
                        ActivityDetailPlanBudgetDto monthBudget = new ActivityDetailPlanBudgetDto();
                        monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                        monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                        monthBudget.setRelatePlanCode(activityPlanBudget.getPlanCode());
                        monthBudget.setRelatePlanItemCode(activityPlanBudget.getPlanItemCode());
                        monthBudget.setMonthBudgetCode(itemDto.getHeadMonthBudgetCode());
                        monthBudget.setUseAmount(thisAmount);
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                        monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getHeadMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getHeadMonthBudgetCode()).getFeeBelongCode(): null);
                        budgetList.add(monthBudget);
                        leaveAmount = leaveAmount.subtract(thisAmount);
                        activityPlanBudget.setUsedAmount(usedAmount.add(thisAmount));
                    }
                    if (leaveAmount.compareTo(BigDecimal.ZERO) > 0){
                        throw new RuntimeException("活动细案占用总部承担金额["+headFeeAmount+"]超过实际可用余额");
                    }
                }
                if (StringUtils.isNotEmpty(itemDto.getMonthBudgetCode())){
                    BigDecimal departmentFeeAmount = itemDto.getDepartmentFeeAmount();
                    BigDecimal leaveAmount = departmentFeeAmount;
                    //非临时方案，占预算
                    List<ActivityPlanBudgetDto> activityPlanBudgets = relatePlanBudgetMap.get(itemDto.getMonthBudgetCode());
                    if (CollectionUtils.isEmpty(activityPlanBudgets)){
                        throw new RuntimeException("大区预算["+itemDto.getMonthBudgetCode()+"]不属于关联方案内");
                    }
                    for (ActivityPlanBudgetDto activityPlanBudget : activityPlanBudgets) {
                        if (leaveAmount.compareTo(BigDecimal.ZERO) == 0){
                            break;
                        }
                        BigDecimal useAmount = Optional.ofNullable(activityPlanBudget.getUseAmount()).orElse(BigDecimal.ZERO);
                        BigDecimal usedAmount = Optional.ofNullable(activityPlanBudget.getUsedAmount()).orElse(BigDecimal.ZERO);
                        BigDecimal usableAmount = useAmount.subtract(usedAmount);
                        if (usableAmount.compareTo(BigDecimal.ZERO) <= 0){
                            continue;
                        }
                        if (StringUtils.isNotEmpty(relatePlanItemCode)){
                            if (!relatePlanItemCode.equals(activityPlanBudget.getPlanItemCode())){
                                //选中一个了就一个到底
                                continue;
                            }
                        }else{
                            relatePlanItemCode = activityPlanBudget.getPlanItemCode();
                            relatePlanCode = activityPlanBudget.getPlanCode();
                        }

                        BigDecimal thisAmount = leaveAmount;
                        if (usableAmount.compareTo(thisAmount) < 0){
                            thisAmount = usableAmount;
                        }
                        ActivityDetailPlanBudgetDto monthBudget = new ActivityDetailPlanBudgetDto();
                        monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                        monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                        monthBudget.setRelatePlanCode(activityPlanBudget.getPlanCode());
                        monthBudget.setRelatePlanItemCode(activityPlanBudget.getPlanItemCode());
                        monthBudget.setMonthBudgetCode(itemDto.getMonthBudgetCode());
                        monthBudget.setBudgetItemCode(activityPlanBudget.getBudgetItemCode());
                        monthBudget.setBudgetItemName(activityPlanBudget.getBudgetItemName());
                        monthBudget.setUseAmount(thisAmount);
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                        monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getMonthBudgetCode()).getFeeBelongCode(): null);
                        budgetList.add(monthBudget);
                        leaveAmount = leaveAmount.subtract(thisAmount);
                        activityPlanBudget.setUsedAmount(usedAmount.add(thisAmount));
                    }
                    if (leaveAmount.compareTo(BigDecimal.ZERO) > 0){
                        throw new RuntimeException("活动细案占用大区承担金额["+departmentFeeAmount+"]超过实际可用余额");
                    }
                }
                BigDecimal customerFeeAmount = itemDto.getCustomerFeeAmount();
                customer:if (null != customerFeeAmount && BigDecimal.ZERO.compareTo(customerFeeAmount) != 0){
                    if (StringUtils.isEmpty(relatePlanItemCode)){
//                        throw new RuntimeException("客户金额不为空，未匹配到可用的方案明细");
                        break customer;
                    }
                    List<ActivityPlanBudgetDto> customerBudgetList = relatePlanCustomerBudgetMap.get(relatePlanItemCode);
                    if (CollectionUtils.isEmpty(customerBudgetList)){
//                        throw new RuntimeException("未获取到匹配方案的客户承担金额");
                        break customer;
                    }
                    BigDecimal usableCustomerAmount = customerBudgetList.stream().map(item -> {
                        return item.getUseAmount().subtract(Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO));
                    }).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (usableCustomerAmount.compareTo(customerFeeAmount) < 0){
//                        throw new RuntimeException("客户承担金额【"+customerFeeAmount+"】超过方案明细["+relatePlanItemCode+"]剩余可用客户承担金额["+usableCustomerAmount+"]");
                    }
                    //有客户承担金额的话也生成一条数据，供细案占用处理
                    ActivityDetailPlanBudgetDto monthBudget = new ActivityDetailPlanBudgetDto();
                    monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                    monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                    monthBudget.setRelatePlanCode(relatePlanCode);
                    monthBudget.setRelatePlanItemCode(relatePlanItemCode);
                    monthBudget.setUseAmount(customerFeeAmount);
                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.CUSTOMER.getCode());
                    budgetList.add(monthBudget);
                }
                itemDto.setRelatePlanCode(relatePlanCode);
                itemDto.setRelatePlanItemCode(relatePlanItemCode);
            }else{
                //垂直预算的逻辑
                if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())){
                    for (ActivityDetailPlanBudgetDto budgetDto : itemDto.getBudgetShares()) {
                        BigDecimal useAmount = budgetDto.getUseAmount();
                        BigDecimal leaveAmount = useAmount;
                        List<ActivityPlanBudgetDto> activityPlanBudgets = relatePlanBudgetMap.get(budgetDto.getMonthBudgetCode());
                        if (!CollectionUtils.isEmpty(activityPlanBudgets)){
                            for (ActivityPlanBudgetDto activityPlanBudget : activityPlanBudgets) {
                                if (leaveAmount.compareTo(BigDecimal.ZERO) == 0){
                                    break;
                                }
                                BigDecimal planBudgetUseAmount = Optional.ofNullable(activityPlanBudget.getUseAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usedAmount = Optional.ofNullable(activityPlanBudget.getUsedAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usableAmount = planBudgetUseAmount.subtract(usedAmount);
                                if (usableAmount.compareTo(BigDecimal.ZERO) <= 0){
                                    continue;
                                }
                                BigDecimal thisAmount = leaveAmount;
                                if (usableAmount.compareTo(thisAmount) < 0){
                                    thisAmount = usableAmount;
                                }
                                ActivityDetailPlanBudgetDto monthBudget = nebulaToolkitService.copyObjectByWhiteList(budgetDto,ActivityDetailPlanBudgetDto.class,HashSet.class,ArrayList.class);
                                monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                                monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                                monthBudget.setRelatePlanCode(activityPlanBudget.getPlanCode());
                                monthBudget.setRelatePlanItemCode(activityPlanBudget.getPlanItemCode());
                                monthBudget.setMonthBudgetCode(itemDto.getHeadMonthBudgetCode());
                                monthBudget.setUseAmount(thisAmount);
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                                budgetList.add(monthBudget);
                                leaveAmount = leaveAmount.subtract(thisAmount);
                                activityPlanBudget.setUsedAmount(usedAmount.add(thisAmount));
                            }
                        }
                        if (leaveAmount.compareTo(BigDecimal.ZERO) != 0){
                            //还有没处理的就直接扣预算了
                            ActivityDetailPlanBudgetDto monthBudget = nebulaToolkitService.copyObjectByWhiteList(budgetDto,ActivityDetailPlanBudgetDto.class,HashSet.class,ArrayList.class);
                            monthBudget.setDetailPlanCode(itemDto.getDetailPlanCode());
                            monthBudget.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                            monthBudget.setMonthBudgetCode(itemDto.getHeadMonthBudgetCode());
                            monthBudget.setUseAmount(leaveAmount);
                            monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                            budgetList.add(monthBudget);
                        }
                    }
                }
            }
            itemDto.setBudgetShares(budgetList);
            if (!CollectionUtils.isEmpty(budgetList)){
                for (ActivityDetailPlanBudgetDto activityDetailPlanBudgetDto : budgetList) {
                    activityDetailPlanBudgetDto.setIndexNo(itemDto.getIndexNo());
                }
                budgetDtos.addAll(budgetList);
            }
        }

        return budgetDtos;
    }

    private void initIndexNo(List<ActivityDetailPlanItemDto> itemCacheList){
        int size = itemCacheList.size();
        for (int i = 0; i < size; i++) {
            ActivityDetailPlanItemDto itemDto = itemCacheList.get(i);
            itemDto.setIndexNo(i+1);
        }
    }

    @Override
    public ActivityDetailPlanVo findById(String id) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        ActivityDetailPlan entity = activityDetailPlanRepository.findById(id);
        if (null != entity) {
            ActivityDetailPlanVo vo = nebulaToolkitService.copyObjectByWhiteList(entity, ActivityDetailPlanVo.class, HashSet.class, ArrayList.class);
            //再查下大区方案关联的总部方案
            List<ActivityDetailPlanPlanVo> relatePlanList = activityDetailPlanPlanRepository.findListVoByDetailPlanCode(vo.getDetailPlanCode());
            if (!CollectionUtils.isEmpty(relatePlanList)){
                List<String> planCodeList = relatePlanList.stream().map(ActivityDetailPlanPlanVo::getPlanCode).collect(Collectors.toList());
                List<ActivityPlanVo> activityPlanVos = this.activityPlanSdkService.findActivityUsableBudget(planCodeList);
                Map<String, ActivityPlanVo> voMap = new HashMap<>();
                if (!CollectionUtils.isEmpty(activityPlanVos)){
                     voMap = activityPlanVos.stream().collect(Collectors.toMap(ActivityPlanVo::getPlanCode, a -> a));
                }
                for (ActivityDetailPlanPlanVo activityDetailPlanPlanVo : relatePlanList) {
                    String planCode = activityDetailPlanPlanVo.getPlanCode();
                    ActivityPlanVo planVo = voMap.get(planCode);
                    if (ObjectUtils.isNotEmpty(planVo)) {
                        if ("3".equals(entity.getProcessStatus()) || "2".equals(entity.getProcessStatus())) {
                            activityDetailPlanPlanVo.setUsedAmount(planVo.getUsedAmount());
                            activityDetailPlanPlanVo.setUsableAmount(planVo.getUsableAmount());
                        }
                    }
                }
            }
            vo.setRelatePlanList(relatePlanList);
            return vo;
        }
        return null;
    }

    @Override
    public Page<MonthBudgetVo> findMonthBudgetByConditions(Pageable pageable,ActivityDetailPlanBudgetDto planBudgetDto, MonthBudgetDto dto) {
        Validate.notBlank(dto.getBusinessFormatCode(), "业态不能为空");
        Validate.notBlank(dto.getBusinessUnitCode(), "业务单元不能为空");
        List<String> budgetItemCodeList = new ArrayList<>();
        // 活动分类
        if (StringUtils.isNotEmpty(dto.getActivityTypeCode())) {
            ActivityTypeVo activityTypeVo = activityTypeService.getActivityTypeByActivityTypeCode(dto.getActivityTypeCode());
            if (ObjectUtils.isEmpty(activityTypeVo)) {
                return new Page<>();
            }
            List<ActivityTypeRelationDto> activityTypeRelationDtoList = activityTypeVo.getActivityTypeRelationDtoList();
            if (CollectionUtils.isEmpty(activityTypeRelationDtoList)) {
                return new Page<>();
            }
            activityTypeRelationDtoList.forEach(activityTypeRelationDto -> {
                if (CollectionUtils.isEmpty(activityTypeRelationDto.getActivityTypeBudgetDtoList())) {
                    return;
                }
                List<String> collect = activityTypeRelationDto.getActivityTypeBudgetDtoList().stream()
                        .map(ActivityTypeBudgetDto::getBudgetProjectCode)
                        .collect(Collectors.toList());
                budgetItemCodeList.addAll(collect);
            });
        }
        dto.setBudgetItemCodeList(budgetItemCodeList);
        List<String> monthBudgetCodeList = Lists.newArrayList();
        if(!CollectionUtils.isEmpty(planBudgetDto.getRelatePlanCodeList())){
            List<ActivityPlanBudgetDto> activityPlanBudgets = activityPlanBudgetSdkService.listDtoByPlanCodeList(planBudgetDto.getRelatePlanCodeList());
            monthBudgetCodeList.addAll(activityPlanBudgets.stream().map(ActivityPlanBudgetDto::getMonthBudgetCode).distinct().collect(Collectors.toList()));
        }
        dto.setMonthBudgetCodeList(monthBudgetCodeList);
        return monthBudgetService.findByConditionsNoFilter(pageable, dto);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(List<String> ids) {
        Validate.notEmpty(ids,"请选择要删除的数据");
//        只能删除【待提交】、【驳回】状态的方案
        List<ActivityDetailPlan> entityList = activityDetailPlanRepository.listByIds(ids);
        Validate.notEmpty(entityList,"要删除的数据不存在");
        for (ActivityDetailPlan entity : entityList) {
            if (!ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) && !ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus())
                    && !ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus())) {
                throw new RuntimeException("活动细案[" + entity.getDetailPlanCode() + "]未处于【待提交】、【驳回】、【追回】状态，不能删除！");
            }
        }

        //删除业务日志
        Collection<ActivityDetailPlanDto> dtoList = nebulaToolkitService.copyCollectionByWhiteList(entityList,
                ActivityDetailPlan.class, ActivityDetailPlanDto.class, HashSet.class, ArrayList.class);
        SerializableBiConsumer<ActivityDetailPlanLogEventListener, ActivityDetailPlanLogEventDto> onDelete =
                ActivityDetailPlanLogEventListener::onDelete;
        for (ActivityDetailPlanDto dto : dtoList) {
            ActivityDetailPlanLogEventDto logEventDto = new ActivityDetailPlanLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish(logEventDto, ActivityDetailPlanLogEventListener.class, onDelete);
        }

        activityDetailPlanRepository.deleteByIds(ids);
        List<String> detailPlanCodes = entityList.stream().map(ActivityDetailPlan::getDetailPlanCode).collect(Collectors.toList());
        activityDetailPlanItemService.deleteByDetailPlanCodes(detailPlanCodes);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void submitApproval(List<String> ids, ActivityDetailPlanApproveSubmitDto dto) {
        List<ActivityDetailPlan> entityList = activityDetailPlanRepository.listByIds(ids);
        for (ActivityDetailPlan entity : entityList) {
            if (!BooleanEnum.TRUE.getCapital().equals(entity.getIsValidate())) {
                throw new RuntimeException("【"+entity.getDetailPlanCode()+"】该细案当前数据为草稿状态，请前往编辑，完善信息并提交！");
            }
            //待提交、驳回、追回的数据才能提交
            if (!ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) &&
                    !ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) &&
                    !ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus())){
                throw new RuntimeException("活动细案["+entity.getDetailPlanCode()+"]不处于待提交、驳回、追回状态，不能提交审批！");
            }
        }
        List<String> businessNoList = entityList.stream().map(ActivityDetailPlan::getDetailPlanCode).collect(Collectors.toList());
        List<com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityDetailPlanPlanVo> planVoList
                = activityDetailPlanRepository.findPlanByRelateDetailPlanCode(businessNoList);
        if (CollectionUtil.isNotEmpty(planVoList)) {
            planVoList.forEach(item -> {
                Assert.isTrue(BooleanEnum.FALSE.getCapital().equals(item.getIsClose()),
                        "关联的方案明细" + item.getPlanItemCode() + "已被关闭，请重新选择!");
            });
        }
        //扣减部门预算
        activityDetailPlanBudgetService.useMonthBudgetByPlanCodeList(businessNoList);

        //扣减客户预算
        this.operateCustomerMonthBudgetByPlanCodeList(businessNoList, BudgetOperationTypeEnum.USE.getCode());

        ProcessBusinessDto processBusinessDto = dto.getProcessBusiness();
        processBusinessDto.setBusinessNoList(businessNoList);
        processBusinessDto.setBusinessCode(ActivityDetailPlanConstant.PROCESS_NAME_ACTIVITY_DETAIL_PLAN);
        //批量提交-业务编码设置为uuid
        String businessNo = UUID.randomUUID().toString().replace("-", "");
        processBusinessDto.setBusinessNo(businessNo);
        ProcessBusinessVo processBusinessVo = processBatchBusinessService.processStart(processBusinessDto);
        //提交成功
        activityDetailPlanRepository.updateProcessStatusAndProcessNo(businessNoList,ProcessStatusEnum.COMMIT.getKey(),processBusinessVo.getProcessNo());
    }

    /**
     * 操作客户月度预算
     *
     * @param detailPlanCodeList 细案明细编码
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void operateCustomerMonthBudgetByPlanCodeList(List<String> detailPlanCodeList, String operationType) {
        List<ActivityDetailPlanItem> itemList = activityDetailPlanItemRepository.findListByDetailPlanCodeList(detailPlanCodeList);
        //查活动细案明细上大区预算编码和客户不为空的数据，并且查客户主数据，RGM模式=分子公司的数据
        List<ActivityDetailPlanItem> customerItem = itemList.stream().filter(e -> Objects.nonNull(e.getFeeYearMonth()) && Objects.nonNull(e.getIntraCompanyAmount()) && StringUtils.isNotEmpty(e.getCustomerCode()) && StringUtils.isNotEmpty(e.getBudgetItemCode())).collect(Collectors.toList());
        log.error("活动细案操作客户月度预算customerItem:{}", customerItem);
        if (CollectionUtils.isEmpty(customerItem)) {
            return;
        }
        List<CustomerVo> customerVoList = customerVoService.findBaseByCustomerCodes(customerItem.stream().map(ActivityDetailPlanItem::getCustomerCode).distinct().collect(Collectors.toList()));
        List<String> subComCustomerCodeList = customerVoList.stream().filter(e -> RtmModelCodeEnum.SON_COMPANY.getCode().equals(e.getRtmModelCode())).map(CustomerVo::getCustomerCode).collect(Collectors.toList());
        List<ActivityDetailPlanItem> finalItemList = customerItem.stream().filter(e -> subComCustomerCodeList.contains(e.getCustomerCode())).collect(Collectors.toList());
        log.error("活动细案操作客户月度预算finalItemList:{}", finalItemList);
        if (CollectionUtils.isEmpty(finalItemList)) {
            return;
        }
        //费用归属年月+客户编码+大区预算的预算科目
        MonthBudgetDto dto = new MonthBudgetDto();
        List<String> yearMonthLyList = finalItemList.stream().map(e -> DateUtil.dateToStr(e.getFeeYearMonth(), DateUtil.date_yyyy_MM)).collect(Collectors.toList());
        List<String> budgetItemCodeList = finalItemList.stream().map(ActivityDetailPlanItem::getBudgetItemCode).collect(Collectors.toList());
        dto.setGroupCode(MonthBudgetGroupEnum.customer.getCode());
        dto.setYearMonthLyList(yearMonthLyList);
        dto.setCustomerCodeList(subComCustomerCodeList);
        dto.setBudgetItemCodeList(budgetItemCodeList);
        List<MonthBudgetVo> monthBudgetVoList = monthBudgetService.findListByConditions(dto);
        log.error("活动细案操作客户月度预算monthBudgetVoList:{}", monthBudgetVoList);
        if (CollectionUtils.isEmpty(monthBudgetVoList)) {
            return;
        }
        Map<String, MonthBudgetVo> monthBudgetCodeToVoMap = monthBudgetVoList.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity(), (e1, e2) -> e1));
        //操作月度预算
        Map<String, String> dimensionToMonthBudgetCodeMap = monthBudgetVoList.stream().collect(Collectors.toMap(e -> e.getYearMonthLy() + e.getCustomerCode() + e.getBudgetItemCode(), MonthBudgetVo::getMonthBudgetCode, (e1, e2) -> e1));
        List<OperateMonthBudgetDto> operateList = Lists.newArrayList();
        List<ActivityDetailPlanBudget> saveBudgetList = Lists.newArrayList();
        List<String> delItemCodeList = Lists.newArrayList();
        finalItemList.forEach(item -> {
            String dimension = DateUtil.dateToStr(item.getFeeYearMonth(), DateUtil.date_yyyy_MM) + item.getCustomerCode() + item.getBudgetItemCode();
            if (dimensionToMonthBudgetCodeMap.containsKey(dimension)) {
                OperateMonthBudgetDto monthBudgetDto = new OperateMonthBudgetDto();
                String monthBudgetCode = dimensionToMonthBudgetCodeMap.get(dimension);
                monthBudgetDto.setMonthBudgetCode(monthBudgetCode);
                BigDecimal intraCompanyAmount = item.getIntraCompanyAmount();
                monthBudgetDto.setOperationAmount(intraCompanyAmount);
                monthBudgetDto.setOperationType(operationType);
                monthBudgetDto.setBusinessCode(item.getDetailPlanItemCode());
                monthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
                operateList.add(monthBudgetDto);
                //月度预算操作记录
                if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
                    ActivityDetailPlanBudget planBudget = new ActivityDetailPlanBudget();
                    planBudget.setDetailPlanCode(item.getDetailPlanCode());
                    planBudget.setDetailPlanItemCode(item.getDetailPlanItemCode());
                    planBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.SUB_CUSTOMER.getCode());
                    planBudget.setTenantCode(item.getTenantCode());
                    planBudget.setMonthBudgetCode(monthBudgetCode);
                    planBudget.setBudgetItemCode(item.getBudgetItemCode());
                    planBudget.setBudgetItemName(item.getBudgetItemName());
                    planBudget.setUseAmount(intraCompanyAmount);
                    planBudget.setCustomerCode(item.getCustomerCode());
                    MonthBudgetVo monthBudgetVo = monthBudgetCodeToVoMap.get(monthBudgetCode);
                    if (Objects.nonNull(monthBudgetVo)) {
                        planBudget.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
                    }
                    saveBudgetList.add(planBudget);
                }
                if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
                    delItemCodeList.add(item.getDetailPlanItemCode());
                }
            }
        });
        log.error("活动细案操作客户月度预算operateList:{}", operateList);
        if (CollectionUtils.isEmpty(operateList)) {
            return;
        }
        monthBudgetService.operateBudget(operateList);
        if (!CollectionUtils.isEmpty(saveBudgetList)) {
            activityDetailPlanBudgetRepository.saveOrUpdateBatch(saveBudgetList);
        }
        activityDetailPlanBudgetRepository.deletePhysicalByDetailPlanCodeAndOccupyType(delItemCodeList, ActivityPlanBudgetOccupyTypeEnum.SUB_CUSTOMER.getCode());
    }

    /**
     * 营销策略审批通过
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processPass(ProcessStatusDto dto) {
        activityDetailPlanRepository.updateProcessStatus(dto.getBusinessNoList(),dto.getProcessStatus());
    }

    /**
     * 审批驳回|流程追回
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processRejectAndRecover(ProcessStatusDto dto) {
        List<String> businessNoList = dto.getBusinessNoList();
        activityDetailPlanBudgetService.returnMonthBudgetByPlanCodeList(businessNoList);
        activityDetailPlanRepository.updateProcessStatus(businessNoList,dto.getProcessStatus());
        //退回客户预算
        this.operateCustomerMonthBudgetByPlanCodeList(businessNoList, BudgetOperationTypeEnum.RETURN.getCode());
    }

    @Override
    public List<ActivityDetailPlanDto> buildActivityDetailPlanParams(List<String> detailPlanCodeList) {
        List<ActivityDetailPlanDto> list = new ArrayList<>();
        if(!CollectionUtils.isEmpty(detailPlanCodeList)) {
            List<ActivityDetailPlan> entityList = this.activityDetailPlanRepository.lambdaQuery().in(ActivityDetailPlan::getDetailPlanCode, detailPlanCodeList).list();

            List<ActivityDetailPlanItem> itemList = activityDetailPlanItemRepository.list(Wrappers.<ActivityDetailPlanItem>lambdaQuery()
                    .in(ActivityDetailPlanItem::getDetailPlanCode, detailPlanCodeList)
                    .eq(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            );
            Map<String, List<ActivityDetailPlanItem>> itemMap = itemList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItem::getDetailPlanCode));

            List<ActivityDetailPlanBudget> activityPlanBudgets = activityDetailPlanBudgetRepository.listByDetailPlanCodeList(detailPlanCodeList);
            Map<String, List<ActivityDetailPlanBudget>> budgetMap = new HashMap<>();
            if(!CollectionUtils.isEmpty(activityPlanBudgets)) {
                budgetMap = activityPlanBudgets.stream().collect(Collectors.groupingBy(o -> o.getDetailPlanCode() + "-" + o.getDetailPlanItemCode()));
            }

//            List<ActivityDetailPlanItemTerminal> terminalList = activityPlanItemTerminalRepository.lambdaQuery().in(ActivityPlanItemTerminal::getPlanCode, businessNoList).list();
//
//            Map<String, List<ActivityPlanItemTerminal>> terminalMap = new HashMap<>();
//            if(!CollectionUtils.isEmpty(terminalList)){
//                terminalMap = terminalList.stream().collect(Collectors.groupingBy(o -> o.getPlanCode() + "-" + o.getPlanItemCode()));
//            }
            for (ActivityDetailPlan entity : entityList) {
                String businessUnitCode = entity.getBusinessUnitCode();
                String businessFormatCode = entity.getBusinessFormatCode();
                ActivityDetailPlanDto activityPlanDto = this.nebulaToolkitService.copyObjectByWhiteList(entity, ActivityDetailPlanDto.class, null, null);
                List<ActivityDetailPlanItem> activityPlanItemList = itemMap.get(activityPlanDto.getDetailPlanCode());
                if(!CollectionUtils.isEmpty(activityPlanItemList)){
                    List<ActivityDetailPlanItemDto> activityPlanItemDtos = (List<ActivityDetailPlanItemDto>)this.nebulaToolkitService.copyCollectionByBlankList(activityPlanItemList, ActivityDetailPlanItem.class, ActivityDetailPlanItemDto.class, LinkedHashSet.class, ArrayList.class);
                    for (ActivityDetailPlanItemDto activityPlanItemDto : activityPlanItemDtos) {
                        activityPlanItemDto.setBusinessUnitCode(businessUnitCode);
                        activityPlanItemDto.setBusinessFormatCode(businessFormatCode);
                        List<ActivityDetailPlanBudget> activityPlanBudgetList = budgetMap.get(activityPlanItemDto.getDetailPlanCode() + "-" + activityPlanItemDto.getDetailPlanItemCode());
                        if(!CollectionUtils.isEmpty(activityPlanBudgetList)){
                            Collection<ActivityDetailPlanBudgetDto> activityPlanBudgetDtos = this.nebulaToolkitService.copyCollectionByBlankList(activityPlanBudgetList, ActivityDetailPlanBudget.class, ActivityDetailPlanBudgetDto.class, LinkedHashSet.class, ArrayList.class);
                            activityPlanItemDto.setBudgetShares((List<ActivityDetailPlanBudgetDto>) activityPlanBudgetDtos);
                        }
//                        List<ActivityPlanItemTerminal> activityPlanItemTerminalList = terminalMap.get(activityPlanItemDto.getPlanCode() + "-" + activityPlanItemDto.getPlanItemCode());
//                        if(!CollectionUtils.isEmpty(activityPlanItemTerminalList)){
//                            Collection<ActivityPlanItemTerminalDto> activityPlanItemTerminalDtos = this.nebulaToolkitService.copyCollectionByBlankList(activityPlanItemTerminalList, ActivityPlanItemTerminal.class, ActivityPlanItemTerminalDto.class, LinkedHashSet.class, ArrayList.class);
//                            activityPlanItemDto.setActivityPlanItemTerminalList((List<ActivityPlanItemTerminalDto>) activityPlanItemTerminalDtos);
//                        }
                    }
                    activityPlanDto.setItemList(activityPlanItemDtos);
                }
                list.add(activityPlanDto);
            }
        }
        return list;
    }

    @Override
    public List<RedPacketQueryScheme2Vo> redPacketQueryScheme(RedPacketQueryScheme2Dto dto2) {

        return this.activityDetailPlanItemRepository.redPacketQueryScheme(dto2);
    }

    @Override
    public List<ActivityDetailPlanVo> getCanAutoAuditDto(Page<ActivityDetailPlanVo> page, String auditDate) {
        //获取可核销总条数
        List<ActivityDetailPlanVo> list = this.activityDetailPlanRepository.findCanAutoAudit(page, auditDate);

        if (CollectionUtils.isEmpty(list)){
            return null;
        }

        List<String> detailPlanCodes = list
                .stream()
                .map(ActivityDetailPlanVo::getDetailPlanCode)
                .collect(Collectors.toList());

        List<ActivityDetailPlanItemVo> itemList = this.activityDetailPlanItemRepository
                .findDetailPlanItemByCodes(detailPlanCodes, auditDate, BooleanEnum.TRUE.getCapital(), BooleanEnum.TRUE.getCapital());

        Map<String, List<ActivityDetailPlanItemVo>> itemMap = null;

        if (!CollectionUtils.isEmpty(itemList)){

            itemMap = itemList
                    .stream()
                    .collect(Collectors.groupingBy(ActivityDetailPlanItemVo::getDetailPlanCode));

        }

        if (itemMap != null){

            Map<String, List<ActivityDetailPlanItemVo>> finalItemMap = itemMap;

            list.forEach(detailPlan -> {

                String detailPlanCode = detailPlan.getDetailPlanCode();
                List<ActivityDetailPlanItemVo> itemVoList = finalItemMap.get(detailPlanCode);
                if (itemVoList != null && itemVoList.size() > 0){
                    itemVoList.forEach(item -> item.setDetailPlanName(detailPlan.getDetailPlanName()));
                }
                detailPlan.setActivityDetailPlanItemList(itemVoList);

            });
        }

        return list;
    }

    @Override
    public List<ActivityDetailPlanVo> findCanAutoAudit(Page<ActivityDetailPlanVo> page, AutoAuditParamsDto autoAuditParams) {

        List<ActivityDetailPlanVo> list = this.activityDetailPlanRepository.findCanAutoAudit(page, autoAuditParams);

        if (CollectionUtils.isEmpty(list)){
            return null;
        }

        List<String> detailPlanCodes = list
                .stream()
                .map(ActivityDetailPlanVo::getDetailPlanCode)
                .collect(Collectors.toList());

        List<ActivityDetailPlanItemVo> itemList = this.activityDetailPlanItemRepository.findDetailItemByParams(autoAuditParams);

        Map<String, List<ActivityDetailPlanItemVo>> itemMap = null;

        if (!CollectionUtils.isEmpty(itemList)){

            itemMap = itemList
                    .stream()
                    .collect(Collectors.groupingBy(ActivityDetailPlanItemVo::getDetailPlanCode));

        }

        if (itemMap != null){

            Map<String, List<ActivityDetailPlanItemVo>> finalItemMap = itemMap;

            list.forEach(detailPlan -> {

                String detailPlanCode = detailPlan.getDetailPlanCode();

                List<ActivityDetailPlanItemVo> itemVoList = finalItemMap.get(detailPlanCode);

                if (itemVoList != null && itemVoList.size() > 0){

                    itemVoList.forEach(item -> item.setDetailPlanName(detailPlan.getDetailPlanName()));

                }

                detailPlan.setActivityDetailPlanItemList(itemVoList);

            });
        }


        return null;
    }

    @Override
    public List<ActivityDetailPlanVo> findCanAutoAudit(AutoAuditParamsDto autoAuditParams) {

        return null;
    }

    @Override
    public int getDetailPlanNum(String autoDate, String businessUnitCode) {
        return this.activityDetailPlanRepository.getCanAutoAuditNumber(autoDate, businessUnitCode);
    }

    @Override
    public int getActivityTotalNumber(AutoAuditParamsDto autoAuditParams) {
        return this.activityDetailPlanRepository.getActivityTotalNumber(autoAuditParams);
    }

    @Override
    public void updateAutoAudit(String detailPlanCode) {
        this.activityDetailPlanRepository.updateActivityDetailPlanAutoAudit(detailPlanCode);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<String> autoBatchCreate(ActivityPlanListDto listDto) {
        List<String> detailPlanCodeList = Lists.newArrayList();

        log.info("方案自动创建细案，方案数据{}",JSON.toJSONString(listDto));
        if(!CollectionUtils.isEmpty(listDto.getList())){
            List<String> planCodeList = listDto.getList().stream().map(ActivityPlanDto::getPlanCode).collect(Collectors.toList());
            boolean lockSuccess = false;
            try {
                lockSuccess = redisLockService.batchLock(ActivityDetailPlanConstant.LOCK_ACTIVITY_DETAIL_PLAN_SAVE, planCodeList, TimeUnit.HOURS, 2);
                if (!lockSuccess){
                    throw new RuntimeException("活动方案自动创建细案正在处理中，请稍后再试！");
                }
                for (ActivityPlanDto activityPlanDto : listDto.getList()) {
                    List<String> codeList = autoCreate(activityPlanDto);
                    if (!CollectionUtils.isEmpty(codeList)){
                        detailPlanCodeList.addAll(codeList);
                    }
                }
            }finally {
                if (lockSuccess){
                    redisLockService.batchUnLock(ActivityDetailPlanConstant.LOCK_ACTIVITY_DETAIL_PLAN_SAVE, planCodeList);
                }
            }
        }
        return detailPlanCodeList;
    }

    //活动方案创建活动细案
    private List<String> autoCreate(ActivityPlanDto activityPlanDto) {
        UrlAddressVo mdmUser = new UrlAddressVo();
        mdmUser.setUserName(activityPlanDto.getCreateAccount());
        mdmUser.setFullName(activityPlanDto.getCreateName());
        loginUserService.refreshAuthentication(mdmUser);

        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String toDay = df.format(new Date());
        List<String> detailPlanCodeList = Lists.newArrayList();

        Set<String> templateConfigCodeSet = activityPlanDto.getItemList().stream().map(ActivityPlanItemDto::getTemplateConfigCode).collect(Collectors.toSet());

        Map<String, ActivitiesTemplateConfigVo> activitiesTemplateConfigMap = new HashMap<>();
        if(!CollectionUtils.isEmpty(templateConfigCodeSet)){
            List<ActivitiesTemplateConfigVo> activitiesTemplateConfigList = activitiesTemplateSdkService.findByCodeList(new ArrayList<>(templateConfigCodeSet));
            activitiesTemplateConfigMap = activitiesTemplateConfigList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
        }

        Map<String, List<ActivityPlanItemDto>> activityPlanItemDtoMap = activityPlanDto.getItemList().stream().collect(Collectors.groupingBy(ActivityPlanItemDto::getTemplateConfigCode));

        List<ActivityDetailPlan> activityDetailPlanVoList = this.findByPlanCode(activityPlanDto.getPlanCode());
        if(!CollectionUtils.isEmpty(activityDetailPlanVoList)){
            log.info("方案自动生成细案");
            return Lists.newArrayList();
        }

        for (Map.Entry<String, List<ActivityPlanItemDto>> one : activityPlanItemDtoMap.entrySet()) {
            ActivitiesTemplateConfigVo activitiesTemplateConfigVo = activitiesTemplateConfigMap.get(one.getKey());
            if(activitiesTemplateConfigVo==null){
                log.info("方案自动生成细案未找到模板"+one.getKey());
                continue;
            }
            if(YesOrNoEnum.NO.getCode().equals(activitiesTemplateConfigVo.getIsAutoCreateActivityDetailPlan())){
                log.info("方案自动生成细案是否自动生成细案未否");
                continue;
            }

            activityPlanDto.setItemList(one.getValue());
            log.info("方案自动生成细案开始生成细案");
            //1.创建活动细案抬头
            ActivityDetailPlan activityDetailPlan = createActivityDetailPlanHeader(activityPlanDto);
            log.info("方案自动生成细案细案抬头已经生成，开始生成方案关联细案");
            //2.方案关联细案
            createActivityDetailPlanPlan(activityPlanDto,activityDetailPlan);

            log.info("方案自动生成细案开始生成方案关联细案,开始创建细案行明细");
            //3.创建细案行明细
            createActivityDetailPlanItem(activityPlanDto,activityDetailPlan,activitiesTemplateConfigVo.getGenerateRule(),toDay);
            log.info("方案自动生成细案成功！！！");
            detailPlanCodeList.add(activityDetailPlan.getDetailPlanCode());
        }
        //自动创建的细案要占用下预算
        activityDetailPlanBudgetService.useMonthBudgetByPlanCodeList(detailPlanCodeList);
        return detailPlanCodeList;
    }

    @Override
    public List<ActivityDetailPlan> findByPlanCode(String planCode) {
        if(StringUtils.isEmpty(planCode)){
            return null;
        }
        List<ActivityDetailPlan> activityDetailPlanList = this.activityDetailPlanRepository.findByPlanCode(planCode);
        return activityDetailPlanList;
    }

    private void createActivityDetailPlanPlan(ActivityPlanDto activityPlanDto, ActivityDetailPlan activityDetailPlan) {

        List<ActivityDetailPlanPlanDto> dtoList = new ArrayList<>();
        ActivityDetailPlanPlanDto activityDetailPlanPlanDto = new ActivityDetailPlanPlanDto();
        activityDetailPlanPlanDto.setDetailPlanCode(activityDetailPlan.getDetailPlanCode());
        activityDetailPlanPlanDto.setPlanCode(activityPlanDto.getPlanCode());
        activityDetailPlanPlanDto.setUsedAmount(BigDecimal.ZERO);
        activityDetailPlanPlanDto.setUsePlanAmount(activityPlanDto.getTotalFeeAmount());

        dtoList.add(activityDetailPlanPlanDto);
        activityDetailPlanPlanService.saveActivityDetailPlanPlanList(activityDetailPlan,false,dtoList);
    }

    private void createActivityDetailPlanItem(ActivityPlanDto activityPlanDto, ActivityDetailPlan activityDetailPlan, String generateRule, String toDay) {

        List<ActivityPlanItemDto> itemList = activityPlanDto.getItemList();
        if(!CollectionUtils.isEmpty(itemList)){
            List<ActivityPlanItemRelateDetailItemDto> relateDetailItemDtoList = activityPlanDto.getRelateDetailItemDtoList();
            activityDetailPlanItemService.createActivityDetailPlanItem(itemList,activityDetailPlan,generateRule,toDay,relateDetailItemDtoList);
        }
    }

    private ActivityDetailPlan createActivityDetailPlanHeader(ActivityPlanDto activityPlanDto) {
        ActivityDetailPlan activityDetailPlan = this.nebulaToolkitService.copyObjectByWhiteList(activityPlanDto, ActivityDetailPlan.class, null, null);
        List<ActivityPlanItemDto> itemList = activityPlanDto.getItemList();
        if(!CollectionUtils.isEmpty(itemList)) {
            Set<String> planTemplateConfigs = itemList.stream().map(ActivityPlanItemDto::getTemplateConfigCode).collect(Collectors.toSet());
            List<DictDataVo> planMapDetailList = dictDataVoService.findByDictTypeCode("plan_map_detail");
            Map<String, DictDataVo> planMapDetailMap = planMapDetailList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
            List<String> detailPlanConfig = new ArrayList<>();
            for (String planTemplateConfig : planTemplateConfigs) {
                DictDataVo dictDataVo = planMapDetailMap.get(planTemplateConfig);
                Validate.notNull(dictDataVo,"方案模板【%s】未在数据字典plan_map_detail中配置",planTemplateConfig);
                detailPlanConfig.add(dictDataVo.getDictValue());
            }
            activityDetailPlan.setTemplateConfigCode(String.join(",",detailPlanConfig));
        }
//        String ruleCode = StringUtils.join(ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_RULE_CODE_PRE, DateFormatUtils.format(new Date(), "yyyyMMdd"));
        String code = this.generateCodeService.generateCode(ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_RULE_CODE_PRE, 1, 6, 2, TimeUnit.DAYS).get(0);
        activityDetailPlan.setDetailPlanCode(code);
        activityDetailPlan.setIsTemporary(YesOrNoEnum.NO.getCode());//默认非临时方案
        activityDetailPlan.setDetailPlanName(activityPlanDto.getPlanName());
        activityDetailPlan.setWhereFrom("方案生成");
        activityDetailPlan.setTenantCode(TenantUtils.getTenantCode());
        activityDetailPlan.setFeeAmount(activityPlanDto.getTotalFeeAmount());
        activityDetailPlan.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());


        activityDetailPlan.setId(null);
        activityDetailPlanRepository.save(activityDetailPlan);
        log.info("细案抬头数据:{}", JSON.toJSONString(activityDetailPlan));
        return activityDetailPlan;
    }

    /**
     * 垂直活动方案，细案关闭回退预算
     */
    @Override
    public void syncBudgetRollbackVertical() {
        log.info("======================垂直活动方案关闭回退预算开始");
        //分页查询已关闭，未回退预算的方案明细
        ActivityPlanItemDto itemDto = new ActivityPlanItemDto();
        itemDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        itemDto.setIsClose(BooleanEnum.TRUE.getCapital());
        itemDto.setIsRollbackBudget(BooleanEnum.FALSE.getCapital());
        int k = 1;
        while (true) {
            Pageable pageable = PageRequest.of(k, 200);
            Page<ActivityPlanItemVo> itemVoPage = this.activityPlanItemSdkService.findByConditions(pageable, itemDto);
            log.info("垂直活动方案关闭预算回退查询总数[{}]",itemVoPage.getTotal());
            if (CollectionUtils.isEmpty(itemVoPage.getRecords())) {
                break;
            }
            this.planBudgetCal(itemVoPage.getRecords());
//            k++;//数据已经更新了，还查第一页就行了。。。
        }
        log.info("======================垂直活动方案关闭回退预算结束，开始活动细案单独关闭回退预算");
        //分页查询细案单独已关闭，未回退预算，方案未关闭得活动细案明细
        int y = 1;
        ActivityDetailPlanItemDto detailPlanItemDto = new ActivityDetailPlanItemDto();
        detailPlanItemDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        detailPlanItemDto.setRollbackBudgetTag(ActivityDetailPlanRollbackBudgetEnum.NO_ROLLBACK.getCode());
        while (true) {
            Pageable pageable = PageRequest.of(y, 200);
            Page<ActivityDetailPlanItemVo> detailItemVoPage = this.activityDetailPlanItemService.findNoRollBackByConditions(pageable, detailPlanItemDto);
            log.info("垂直活动细案关闭预算回退查询总数[{}]",detailItemVoPage.getTotal());
            if (CollectionUtils.isEmpty(detailItemVoPage.getRecords())) {
                break;
            }
            this.detailPlanBudgetCal(detailItemVoPage.getRecords());
//            y++;//数据已经更新了，还查第一页就行了。。。
        }
        log.info("======================垂直活动细案单独关闭回退预算结束");
    }

    @Override
    public void updateAutoAuditFlag(List<String> codeList, String autoAudit) {
        this.activityDetailPlanRepository.updateAutoAuditFlag(codeList, autoAudit);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ActivityDetailPlanDto saveActivityDetailPlanNoCache(ActivityDetailPlanDto dto) {
        dto.setTempSave(false);
        saveActivityDetailPlan(dto,dto.getItemList());
        return dto;
    }


    /**
     * 1 汇总
     * 2 修改操作预算的记录
     * 3 保存
     *
     * @param dto dto
     */
    @Override
    public void summary(ActivityDetailPlanDto dto) {
        if (CollectionUtils.isEmpty(dto.getIdCollection()) && CollectionUtils.isEmpty(dto.getDetailPlanCodeCollection())) {
            return;
        }
        List<SummaryDimensionEnum> summaryDimensionEnumList = Lists.newArrayList();
        String summaryDimensionStr = dto.getSummaryDimension();
        Validate.notBlank(summaryDimensionStr, "请选择汇总维度！");
        if (summaryDimensionStr.contains(SummaryDimensionEnum.customer.getCode())) {
            summaryDimensionEnumList.add(SummaryDimensionEnum.customer);
        }
        if (summaryDimensionStr.contains(SummaryDimensionEnum.firstChannel.getCode())) {
            summaryDimensionEnumList.add(SummaryDimensionEnum.firstChannel);
        }
        if (summaryDimensionStr.contains(SummaryDimensionEnum.secondChannel.getCode())) {
            summaryDimensionEnumList.add(SummaryDimensionEnum.secondChannel);
        }
        if (summaryDimensionStr.contains(SummaryDimensionEnum.system.getCode())) {
            summaryDimensionEnumList.add(SummaryDimensionEnum.system);
        }
        if (summaryDimensionStr.contains(SummaryDimensionEnum.terminal.getCode())) {
            summaryDimensionEnumList.add(SummaryDimensionEnum.terminal);
        }
        if (summaryDimensionStr.contains(SummaryDimensionEnum.formDescription.getCode())) {
            summaryDimensionEnumList.add(SummaryDimensionEnum.formDescription);
        }
        Validate.isTrue(!CollectionUtils.isEmpty(summaryDimensionEnumList), "请维护汇总维度数据字典【tpm_detail_plan_summary_dimension】");
        List<ActivityDetailPlan> detailPlanList = activityDetailPlanRepository.findHaveNotAuditDetailPlanEntity(dto);
        //只汇总主体细案且没有汇总的
        List<ActivityDetailPlan> needSummaryDetailPlanList = detailPlanList.stream()
                .filter(e -> BusinessUnitEnum.HEADQUARTERS.getCode().equals(e.getBusinessUnitCode())).collect(Collectors.toList());
        List<String> detailPlanCodeList = needSummaryDetailPlanList.stream()
                .map(ActivityDetailPlan::getDetailPlanCode).filter(Objects::nonNull).collect(Collectors.toList());
        List<ActivityDetailPlanItem> needSummaryItemList = activityDetailPlanItemRepository.findListByDetailPlanCodeList(detailPlanCodeList);
        if (CollectionUtils.isEmpty(detailPlanCodeList)) {
            return;
        }

        //汇总前编码，汇总后编码
        Map<String, String> oldItemCodeToNewItemCodeMap = Maps.newHashMap();
        List<ActivityDetailPlanItemTerminal> terminalEntityList = Lists.newArrayList();
        List<ActivityDetailPlanItem> itemEntityList = Lists.newArrayList();

        Map<String, List<ActivityDetailPlanItem>> detailCodeToNeedSummatyItemListMap = needSummaryItemList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItem::getDetailPlanCode));
        detailCodeToNeedSummatyItemListMap.forEach((key, value) -> {
            //汇总
            Map<String, List<ActivityDetailPlanItem>> dimensionToItemListMap = needSummaryItemList.stream().collect(Collectors.groupingBy(item -> {
                        String dimension =
                                //活动类型编码、活动形式编码、活动开始时间 活动结束时间
                                item.getActivityTypeCode() + item.getActivityFormCode() + item.getActivityBeginDate() + item.getActivityEndDate()
                                        //订单开始时间 订单结束时间 总部统筹预算编码 、大区统筹预算编码
                                        + item.getOrderBeginDate() + item.getOrderEndDate() + item.getHeadMonthBudgetCode() + item.getMonthBudgetCode()
                                        //大区编码、省区编码、品牌编码、品类编码
                                        + item.getSalesRegionCode() + item.getSalesOrgCode() + item.getProductBrandCode() + item.getProductCategoryCode()
                                        //品项编码、产品编码、物料编码、采购类型
                                        + item.getProductItemCode() + item.getProductCode() + item.getMaterialCode() + item.getProcurementType()
                                        //是否扣减费用池、核销类型、付款方式、是否和价额有关
                                        + item.getIsDeductionFeePool() + item.getAuditType() + item.getPaymentMethod() + item.getRelateToPrice()
                                        //是否涨价政策、是否考核扣款、是否责任利润调整
                                        + item.getIncreasePricePromotion() + item.getDeductType() + item.getDutyProfitAdjust()
                                        //促销对象、新品归类、是否占用划拨预算、活动力度
                                        + item.getPromotionObject() + item.getNewProductType() + item.getOccupyTransferBudget() + item.getActivityIntensity()
                                        //陈列批次、是否客户上账、是否发起巡查需求
                                        + item.getDisplayLot() + item.getIsCustomerAccount() + item.getIsStartPatrol();
                        if (summaryDimensionEnumList.contains(SummaryDimensionEnum.customer)) {
                            dimension += item.getCustomerCode();
                        }
                        if (summaryDimensionEnumList.contains(SummaryDimensionEnum.firstChannel)) {
                            dimension += item.getFirstChannelCode();
                        }
                        if (summaryDimensionEnumList.contains(SummaryDimensionEnum.secondChannel)) {
                            dimension += item.getSecondChannelCode();
                        }
                        if (summaryDimensionEnumList.contains(SummaryDimensionEnum.system)) {
                            dimension += item.getSystemCode();
                        }
                        if (summaryDimensionEnumList.contains(SummaryDimensionEnum.terminal)) {
                            dimension += item.getTerminalCode();
                        }
                        if (summaryDimensionEnumList.contains(SummaryDimensionEnum.formDescription)) {
                            dimension += item.getFormDescription();
                        }
                        return dimension;
                    }
            ));

            log.error("汇总维度：{}", dimensionToItemListMap.keySet());
            //重新生成细案编码
            int modifySize = dimensionToItemListMap.size();
            List<String> itemCodeList = Lists.newArrayList();
            AtomicInteger index = new AtomicInteger(0);
            if (modifySize > 0) {
                // Z-+8位流水
                String ruleCode = ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_ITEM_RULE_CODE_PRE;
                itemCodeList = this.generateCodeService.generateCode(ruleCode, modifySize, 8, 0, TimeUnit.DAYS);
            }

            List<String> finalItemCodeList = itemCodeList;
            dimensionToItemListMap.forEach((subKey, subValue) -> {
                List<ActivityDetailPlanItemTerminal> thisDimensionTerminalEntityList = Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(subValue, ActivityDetailPlanItem.class, ActivityDetailPlanItemTerminal.class, HashSet.class, ArrayList.class));
                //汇总：费用合计、 总部承担金额、 大区承担金额、分子公司点内金额、分子公司点外金额、 客户承担金额
                BigDecimal totalFeeAmount = subValue.stream().map(ActivityDetailPlanItem::getTotalFeeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal headFeeAmount = subValue.stream().map(ActivityDetailPlanItem::getHeadFeeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal departmentFeeAmount = subValue.stream().map(ActivityDetailPlanItem::getDepartmentFeeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal intraCompanyAmount = subValue.stream().map(ActivityDetailPlanItem::getIntraCompanyAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal offPointAmount = subValue.stream().map(ActivityDetailPlanItem::getOffPointAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal customerFeeAmount = subValue.stream().map(ActivityDetailPlanItem::getCustomerFeeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                ActivityDetailPlanItem newItem = nebulaToolkitService.copyObjectByWhiteList(subValue.get(0), ActivityDetailPlanItem.class, LinkedHashSet.class, ArrayList.class);
                //新编码
                String newDetailPlanItemCode = finalItemCodeList.get(index.getAndIncrement());
                newItem.setDetailPlanItemCode(newDetailPlanItemCode);
                thisDimensionTerminalEntityList.forEach(oldItemRecord -> {
                    oldItemCodeToNewItemCodeMap.put(oldItemRecord.getDetailPlanItemCode(), newDetailPlanItemCode);
                    oldItemRecord.setDetailPlanItemCode(newDetailPlanItemCode);
                    oldItemRecord.setId(null);
                });
                newItem.setTotalFeeAmount(totalFeeAmount);
                newItem.setHeadFeeAmount(headFeeAmount);
                newItem.setDepartmentFeeAmount(departmentFeeAmount);
                newItem.setIntraCompanyAmount(intraCompanyAmount);
                newItem.setOffPointAmount(offPointAmount);
                newItem.setCustomerFeeAmount(customerFeeAmount);
                newItem.setId(null);
                newItem.setTerminalName(null);
                newItem.setTerminalCode(null);
                newItem.setTerminalType(null);
                newItem.setQuantity(null);
                newItem.setPrice(null);
                newItem.setTerminalMonthSalesAmount(null);
                newItem.setPersonCode(null);
                newItem.setPersonName(null);
                newItem.setPersonType(null);
                newItem.setIdentityCard(null);
                newItem.setPersonIdCard(null);
                itemEntityList.add(newItem);
                terminalEntityList.addAll(thisDimensionTerminalEntityList);
            });
        });

        //2 修改操作预算的记录
        Set<String> oldItemCodeSets = oldItemCodeToNewItemCodeMap.keySet();
        List<ActivityDetailPlanBudget> activityDetailPlanBudgetList = activityDetailPlanBudgetRepository.listByDetailPlanItemCodeList(oldItemCodeSets);
        activityDetailPlanBudgetList.forEach(detailItemBudget->{
            String newDetailItemCode = oldItemCodeToNewItemCodeMap.get(detailItemBudget.getDetailPlanItemCode());
            detailItemBudget.setDetailPlanCode(newDetailItemCode);
        });

        //保存
        needSummaryItemList.forEach(oldItem -> oldItem.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        itemEntityList.addAll(needSummaryItemList);
        needSummaryDetailPlanList.forEach(detailPlan -> detailPlan.setIsGather(BooleanEnum.TRUE.getCapital()));
        activityDetailPlanRepository.saveOrUpdateBatch(needSummaryDetailPlanList);
        activityDetailPlanItemRepository.saveOrUpdateBatch(itemEntityList);
        activityDetailPlanItemTerminalRepository.saveOrUpdateBatch(terminalEntityList);
        activityDetailPlanBudgetRepository.saveOrUpdateBatch(activityDetailPlanBudgetList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ActivityDetailPlanDto atomicCreateForOut(ActivityDetailPlanDto dto) {

        ActivityDetailPlan entity = nebulaToolkitService.copyObjectByWhiteList(dto,ActivityDetailPlan.class,HashSet.class,ArrayList.class);
        String ruleCode = StringUtils.join(ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_RULE_CODE_PRE, DateFormatUtils.format(new Date(), "yyyyMMdd"));
        String code = this.generateCodeService.generateCode(ruleCode, 1, 6, 2, TimeUnit.DAYS).get(0);
        entity.setDetailPlanCode(code);
        entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setTenantCode(TenantContextHolder.getTenantInfo().getTenantCode());
        entity.setWhereFrom("手工新增");
        entity.setIsValidate(BooleanEnum.TRUE.getCapital());
        dto.setDetailPlanCode(code);

        List<ActivityDetailPlanItemDto> itemDtoList = dto.getItemList();
        activityDetailPlanRepository.save(entity);
        createValidateForOut(dto, itemDtoList);
        dto.setId(entity.getId());

        //保存活动细案方案-方案关联
        activityDetailPlanPlanService.createDetailLinkPlanForOut(entity,dto.getRelatePlanList());

        //保存方案明细
        activityDetailPlanItemService.atomicCreateForOut(entity,itemDtoList);

        //保存方案多选产品
        activityDetailPlanItemProductService.atomicCreateForOut(entity,itemDtoList);

        //保存方案关联预算
        activityDetailPlanBudgetService.atomicCreateForOut(entity,itemDtoList);

        return dto;
    }

    @Override
    public Page<ActivityDetailPlanVo> findPageForOut(Pageable pageable, ActivityDetailPlanDto dto) {
        return activityDetailPlanRepository.findPageForOut(pageable,dto);
    }

    /**
     * 垂直活动方案关闭，计算回退预算，组装预算退回参数
     *
     * @param itemVos 细案列表
     */
    public void planBudgetCal(List<ActivityPlanItemVo> itemVos) {
        //判断方案是否是推送sap的活动
        List<String> actFormCodes = itemVos.stream().map(ActivityPlanItemVo::getActivityFormCode).distinct().collect(Collectors.toList());
        Map<String, List<ActivityFormExeDetailVo>> formMap = this.activityFormService.findPushSap(actFormCodes);

        //细案明细修改list
        List<ActivityDetailPlanItem> edits = new ArrayList<>();
        //细案预算修改list
        List<OperateActivityDetailPlanBudgetDto> operateList = new ArrayList<>();
        List<OperateActivityPlanBudgetVerticalDto> planOperateList = new ArrayList<>();

        for (ActivityPlanItemVo record : itemVos) {
            //申请金额为0直接跳过
            if(BigDecimal.ZERO.compareTo(record.getFeeAmount()) == 0){
                continue;
            }
            //是推送sap的活动,且是共用
            if (formMap.containsKey(record.getActivityFormCode())
                    && StringUtils.isNotBlank(record.getPublicOrNot())
                    && BooleanEnum.TRUE.getCapital().equals(record.getPublicOrNot())) {
                //共用需判断同一个活动号的都要关闭才退预算
                if (StringUtils.isNotBlank(record.getActivityNumber())
                        && !this.activityPlanItemSdkService.getAllColseByActNumber(record.getActivityNumber())) {
                    continue;
                }
            }
            //根据方案明细编码，获取关联的细案明细
            List<ActivityDetailPlanItem> detailPlanItems = this.activityDetailPlanItemRepository.lambdaQuery()
                    .eq(ActivityDetailPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                    .eq(ActivityDetailPlanItem::getTenantCode, TenantUtils.getTenantCode())
                    .eq(ActivityDetailPlanItem::getRelatePlanItemCode, record.getPlanItemCode())
                    .list();
            if (CollectionUtils.isEmpty(detailPlanItems)) {
                continue;
            }
            //判断状态是否都已关闭
            Set<String> noCloseSet = detailPlanItems.stream().filter(i -> BooleanEnum.FALSE.getCapital().equals(i.getIsClose()))
                    .map(ActivityDetailPlanItem::getDetailPlanItemCode).collect(Collectors.toSet());
            if (!noCloseSet.isEmpty()) {
                log.error("垂直活动方案明细[{}]关闭退预算时，出现未关闭的活动细案明细[{}]", record.getPlanItemCode(), noCloseSet.toString());
                continue;
            }
            //过滤已退过预算的细案，因细案可以单独关闭
            detailPlanItems = detailPlanItems.stream().filter(i -> StringUtils.isNotBlank(i.getRollbackBudgetTag()) &&
                    ActivityDetailPlanRollbackBudgetEnum.NO_ROLLBACK.getCode().equals(i.getRollbackBudgetTag())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(detailPlanItems)) {
                continue;
            }
            //统计细案明细占用的总预算金额
            Set<String> detailPlanCodes = detailPlanItems.stream().map(ActivityDetailPlanItem::getDetailPlanItemCode).collect(Collectors.toSet());
            List<ActivityDetailPlanBudget> budgets = this.activityDetailPlanBudgetRepository.lambdaQuery()
                    .eq(ActivityDetailPlanBudget::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                    .in(ActivityDetailPlanBudget::getDetailPlanItemCode, detailPlanCodes)
                    .eq(ActivityDetailPlanBudget::getTenantCode, TenantUtils.getTenantCode())
                    .list();
            if (CollectionUtils.isEmpty(budgets)) {
                continue;
            }
            Map<String, BigDecimal> budgetMap = new HashMap<>();
            for (ActivityDetailPlanBudget budget : budgets) {
                if (budgetMap.containsKey(budget.getDetailPlanItemCode())) {
                    BigDecimal b = budgetMap.get(budget.getDetailPlanItemCode());
                    b = b.add(null == budget.getUseAmount() ? BigDecimal.ZERO : budget.getUseAmount());
                    budgetMap.put(budget.getDetailPlanItemCode(), b);
                } else {
                    budgetMap.put(budget.getDetailPlanItemCode(), null == budget.getUseAmount() ? BigDecimal.ZERO : budget.getUseAmount());
                }
            }
            //获取细案中的活动形式，用于判断是否推送sap
            List<String> detailFormCodes = detailPlanItems.stream().map(ActivityDetailPlanItem::getActivityFormCode).collect(Collectors.toList());
            Map<String, List<ActivityFormExeDetailVo>> detailFormMap = this.activityFormService.findPushSap(detailFormCodes);

            //循环细案明细,统计总的回退预算金额
            BigDecimal total = BigDecimal.ZERO;
            Boolean tag = true;
            for (ActivityDetailPlanItem planItem : detailPlanItems) {
                //默认设置成全部回滚
                planItem.setRollbackBudgetTag(ActivityDetailPlanRollbackBudgetEnum.ALL_ROLLBACK.getCode());
                planItem.setRollbackAmount(BigDecimal.ZERO);
                edits.add(planItem);

//                Date closeDate = planItem.getCloseDate();
//                //活动未开始-》完全回退预算
//                if (closeDate.getTime() < planItem.getActivityBeginDate().getTime()) {
//                    total = total.add(budgetMap.get(planItem.getDetailPlanItemCode()));
//                    planItem.setRollbackBudgetTag(ActivityDetailPlanRollbackBudgetEnum.ALL_ROLLBACK.getCode());
//                    planItem.setRollbackAmount(budgetMap.get(planItem.getDetailPlanItemCode()));
//                    edits.add(planItem);
//                    operateList.add(new OperateActivityDetailPlanBudgetDto() {{
//                        this.setBusinessCode(planItem.getDetailPlanItemCode());
//                        this.setDetailPlanCode(planItem.getDetailPlanCode());
//                        this.setDetailPlanItemCode(planItem.getDetailPlanItemCode());
////                            this.setMonthBudgetCode(planItem.getMonthBudgetCode());
//                        this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
//                        this.setOperationAmount(budgetMap.get(planItem.getDetailPlanItemCode()));
//                    }});
//                    continue;
//                }
//                //活动进行中-》判断是否推送sap
//                if (closeDate.getTime() < planItem.getActivityEndDate().getTime()) {
                //不推送sap-》完全回退预算
                BigDecimal alreadyAuditAmount = Optional.ofNullable(planItem.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO);
                if (!detailFormMap.containsKey(planItem.getActivityFormCode())) {
                    total = total.add(budgetMap.get(planItem.getDetailPlanItemCode()));
                    planItem.setRollbackBudgetTag(ActivityDetailPlanRollbackBudgetEnum.ALL_ROLLBACK.getCode());
                    planItem.setRollbackAmount(budgetMap.get(planItem.getDetailPlanItemCode()).subtract(alreadyAuditAmount));
                    operateList.add(new OperateActivityDetailPlanBudgetDto() {{
                        this.setBusinessCode(planItem.getDetailPlanItemCode());
                        this.setDetailPlanCode(planItem.getDetailPlanCode());
                        this.setDetailPlanItemCode(planItem.getDetailPlanItemCode());
//                                this.setMonthBudgetCode(planItem.getMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                        this.setOperationAmount(budgetMap.get(planItem.getDetailPlanItemCode()));
                        log.error("细案明细退预算：细案编码：{},细案明细编码：{},操作金额：{}",
                                this.getDetailPlanCode(),this.getDetailPlanItemCode(),this.getOperationAmount());
                    }});
                    continue;
                } else {
                    //推送sap-》判断是否共用
                    if (StringUtils.isNotBlank(planItem.getPublicOrNot())
                            && BooleanEnum.TRUE.getCapital().equals(planItem.getPublicOrNot())) {
                        //共用需判断同一个活动号的都要关闭才退预算
                        if (StringUtils.isNotBlank(planItem.getActivityNumber())
                                && !this.activityDetailPlanItemService.getAllColseByActNumber(planItem.getActivityNumber())) {
                            tag = false;
                            continue;
                        }
                    }
                    //获取发生额,走事件
                    SapAmountEventDto eventDto = new SapAmountEventDto();
                    eventDto.setItemNos(Lists.newArrayList(planItem.getDetailPlanItemCode()));
                    SerializableBiConsumer<SapAmountListener, SapAmountEventDto> getSapAmountByDetailItemNos =
                            SapAmountListener::getSapAmountByDetailItemNos;
                    SapAmountResponse sapAmountResponse = (SapAmountResponse) this.nebulaNetEventClient.directPublish(eventDto,
                            SapAmountListener.class, getSapAmountByDetailItemNos);
                    Map<String, BigDecimal> sapMap = sapAmountResponse.getAmountMap();

                    BigDecimal bu = budgetMap.getOrDefault(planItem.getDetailPlanItemCode(), BigDecimal.ZERO);
                    BigDecimal sap = sapMap.getOrDefault(planItem.getDetailPlanItemCode(), BigDecimal.ZERO);

                    //            1、活动细案进行关闭时，
                    //            申请金额为正
                    //            判断MAX（SAP发生额，已结案金额），回退金额=申请金额-MAX（SAP发生额，已结案金额），若MAX（SAP发生额，已结案金额）＞申请金额，则回退金额为0。
                    //            申请金额为负时
                    //            若无核销记录则，回退对应申请金额
                    //            若存在核销记录（未完全结案）
                    //            1、核销金额小于申请金额，回退金额为  申请金额N-核销金额M
                    //            2、核销金额大于申请金额，回退金额为0。
                    BigDecimal ro = BigDecimal.ZERO;
                    if (bu.compareTo(BigDecimal.ZERO) > 0){
                        ro = bu.subtract(sap);
                        if (alreadyAuditAmount.compareTo(sap) > 0){
                            ro = bu.subtract(alreadyAuditAmount);
                        }
                        if (ro.compareTo(BigDecimal.ZERO) < 0){
                            ro = BigDecimal.ZERO;
                        }
                    }else{
                        if (alreadyAuditAmount.compareTo(BigDecimal.ZERO) != 0){
                            if (alreadyAuditAmount.compareTo(bu) < 0){
                                ro = bu.subtract(alreadyAuditAmount);
                            }
                        }else{
                            ro = bu;
                        }
                    }
                    planItem.setRollbackAmount(ro);
                    total = total.add(ro);
                    BigDecimal finalRo = ro;
                    operateList.add(new OperateActivityDetailPlanBudgetDto() {{
                        this.setBusinessCode(planItem.getDetailPlanItemCode());
                        this.setDetailPlanCode(planItem.getDetailPlanCode());
                        this.setDetailPlanItemCode(planItem.getDetailPlanItemCode());
//                                this.setMonthBudgetCode(planItem.getMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                        this.setOperationAmount(finalRo);
                    }});
                }
            }

            BigDecimal finalTotal = total;
            Boolean finalTag = tag;
            planOperateList.add(new OperateActivityPlanBudgetVerticalDto() {{
                this.setBusinessCode(record.getPlanItemCode());
                this.setPlanCode(record.getPlanCode());
                this.setPlanItemCode(record.getPlanItemCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(finalTotal);
                this.setIsRollbackBudget(finalTag);
            }});
        }

        //方案退预算，细案明细，细案预算明细修改
        ActivityPlanDetailPlanAndBudgetEditDto editDto = new ActivityPlanDetailPlanAndBudgetEditDto();
        editDto.setDetailPlanBudgetList(operateList);
        editDto.setDetailPlanList(edits);
        editDto.setPlanOperateList(planOperateList);
        this.activityDetailPlanItemService.editPlanDetailPlanAndBudget(editDto);

        //修改方案明细状态
        List<String> planItemCodeList = itemVos.stream().map(ActivityPlanItemVo::getPlanItemCode).collect(Collectors.toList());
        if (!planItemCodeList.isEmpty()) {
            //处理了全部更新成已回退
            activityPlanBudgetVerticalService.updatePlanItemRollbackBudget(planItemCodeList);
        }
        // edits  退回预算后，将回退预算状态 推送给扣费预测
        this.pushToAuditFeePredictionByMq(edits);
    }


    /**
     * 垂直活动细案单独关闭，计算回退预算，组装预算退回参数
     *
     * @param itemVos 细案列表
     */
    public void detailPlanBudgetCal(List<ActivityDetailPlanItemVo> itemVos) {
        //统计细案明细占用的总预算金额
        Set<String> detailPlanCodes = itemVos.stream().map(ActivityDetailPlanItemVo::getDetailPlanItemCode).collect(Collectors.toSet());
        List<ActivityDetailPlanBudget> budgets = this.activityDetailPlanBudgetRepository.lambdaQuery()
                .eq(ActivityDetailPlanBudget::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(ActivityDetailPlanBudget::getDetailPlanItemCode, detailPlanCodes)
                .eq(ActivityDetailPlanBudget::getTenantCode, TenantUtils.getTenantCode())
                .list();
        Map<String, BigDecimal> budgetMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(budgets)) {
            for (ActivityDetailPlanBudget budget : budgets) {
                if (budgetMap.containsKey(budget.getDetailPlanItemCode())) {
                    BigDecimal b = budgetMap.get(budget.getDetailPlanItemCode());
                    b = b.add(null == budget.getUseAmount() ? BigDecimal.ZERO : budget.getUseAmount());
                    budgetMap.put(budget.getDetailPlanItemCode(), b);
                } else {
                    budgetMap.put(budget.getDetailPlanItemCode(), null == budget.getUseAmount() ? BigDecimal.ZERO : budget.getUseAmount());
                }
            }
        }

        //获取细案中的活动形式，用于判断是否推送sap
        List<String> detailFormCodes = itemVos.stream().map(ActivityDetailPlanItemVo::getActivityFormCode).distinct().collect(Collectors.toList());
        Map<String, List<ActivityFormExeDetailVo>> detailFormMap = this.activityFormService.findPushSap(detailFormCodes);

        //细案明细修改
        List<ActivityDetailPlanItem> edits = new ArrayList<>();
        List<OperateActivityDetailPlanBudgetDto> operateList = new ArrayList<>();
        Map<String, OperateActivityPlanBudgetVerticalDto> planMap = new HashMap<>();

        //循环细案明细,计算回退预算金额
        for (ActivityDetailPlanItemVo planItemVo : itemVos) {
            ActivityDetailPlanItem edit = new ActivityDetailPlanItem();
            edit.setRollbackBudgetTag(ActivityDetailPlanRollbackBudgetEnum.ALL_ROLLBACK.getCode());
            edit.setRollbackAmount(BigDecimal.ZERO);
            edit.setId(planItemVo.getId());
            edits.add(edit);
            //申请金额为0直接跳过
            if(BigDecimal.ZERO.compareTo(planItemVo.getFeeAmount()) == 0){
                continue;
            }
            Date closeDate = planItemVo.getCloseDate();
            BigDecimal returnAmount = BigDecimal.ZERO;
            //活动未开始-》完全回退预算
//            if (closeDate.getTime() < planItemVo.getActivityBeginDate().getTime()) {
//                edits.add(new ActivityDetailPlanItem() {{
//                    this.setRollbackBudgetTag(ActivityDetailPlanRollbackBudgetEnum.ALL_ROLLBACK.getCode());
//                    this.setRollbackAmount(budgetMap.get(planItemVo.getDetailPlanItemCode()));
//                    this.setId(planItemVo.getId());
//                }});
//                operateList.add(new OperateActivityDetailPlanBudgetDto() {{
//                    this.setBusinessCode(planItemVo.getDetailPlanItemCode());
//                    this.setDetailPlanCode(planItemVo.getDetailPlanCode());
//                    this.setDetailPlanItemCode(planItemVo.getDetailPlanItemCode());
//                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
//                    this.setOperationAmount(budgetMap.get(planItemVo.getDetailPlanItemCode()));
//                }});
//                returnAmount = budgetMap.get(planItemVo.getDetailPlanItemCode());
//            } else if (closeDate.getTime() < planItemVo.getActivityEndDate().getTime()) {
            //活动进行中-》判断是否推送sap
            //不推送sap-》完全回退预算
            BigDecimal alreadyAuditAmount = Optional.ofNullable(planItemVo.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO);
            if (!detailFormMap.containsKey(planItemVo.getActivityFormCode())) {
                edit.setRollbackBudgetTag(ActivityDetailPlanRollbackBudgetEnum.ALL_ROLLBACK.getCode());
                BigDecimal rollbackAmount = budgetMap.get(planItemVo.getDetailPlanItemCode());
                edit.setRollbackAmount(rollbackAmount);
                edit.setDetailPlanItemCode(planItemVo.getDetailPlanItemCode());
                operateList.add(new OperateActivityDetailPlanBudgetDto() {{
                    this.setBusinessCode(planItemVo.getDetailPlanItemCode());
                    this.setDetailPlanCode(planItemVo.getDetailPlanCode());
                    this.setDetailPlanItemCode(planItemVo.getDetailPlanItemCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(rollbackAmount);
                }});
                returnAmount = rollbackAmount;
            } else if (StringUtils.isNotBlank(planItemVo.getPublicOrNot())
                    && BooleanEnum.TRUE.getCapital().equals(planItemVo.getPublicOrNot())) {
                //推送sap-》判断是否共用
                //共用需判断同一个活动号的都要关闭才退预算
                if (StringUtils.isNotBlank(planItemVo.getActivityNumber())
                        && !this.activityDetailPlanItemService.getAllColseByActNumber(planItemVo.getActivityNumber())) {
                    continue;
                }
            }
            //获取发生额,走事件
            SapAmountEventDto eventDto = new SapAmountEventDto();
            eventDto.setItemNos(Lists.newArrayList(planItemVo.getDetailPlanItemCode()));
            SerializableBiConsumer<SapAmountListener, SapAmountEventDto> getSapAmountByDetailItemNos =
                    SapAmountListener::getSapAmountByDetailItemNos;
            SapAmountResponse sapAmountResponse = (SapAmountResponse) this.nebulaNetEventClient.directPublish(eventDto,
                    SapAmountListener.class, getSapAmountByDetailItemNos);
            Map<String, BigDecimal> sapMap = sapAmountResponse.getAmountMap();

            BigDecimal bu = budgetMap.getOrDefault(planItemVo.getDetailPlanItemCode(), BigDecimal.ZERO);
            BigDecimal sap = sapMap.getOrDefault(planItemVo.getDetailPlanItemCode(), BigDecimal.ZERO);
//            1、活动细案进行关闭时，
//            申请金额为正
//            判断MAX（SAP发生额，已结案金额），回退金额=申请金额-MAX（SAP发生额，已结案金额），若MAX（SAP发生额，已结案金额）＞申请金额，则回退金额为0。
//            申请金额为负时
//            若无核销记录则，回退对应申请金额
//            若存在核销记录（未完全结案）
//            1、核销金额小于申请金额，回退金额为  申请金额N-核销金额M
//            2、核销金额大于申请金额，回退金额为0。
            BigDecimal ro = BigDecimal.ZERO;
            if (bu.compareTo(BigDecimal.ZERO) > 0){
                ro = bu.subtract(sap);
                if (alreadyAuditAmount.compareTo(sap) > 0){
                    ro = bu.subtract(alreadyAuditAmount);
                }
                if (ro.compareTo(BigDecimal.ZERO) < 0){
                    ro = BigDecimal.ZERO;
                }
            }else{
                if (alreadyAuditAmount.compareTo(BigDecimal.ZERO) != 0){
                    if (alreadyAuditAmount.compareTo(bu) < 0){
                        ro = bu.subtract(alreadyAuditAmount);
                    }
                }else{
                    ro = bu;
                }
            }

            ActivityDetailPlanItem pI = new ActivityDetailPlanItem();
            if(ro.compareTo(BigDecimal.ZERO) < 0){
                continue;
            }
            pI.setRollbackAmount(ro);
            if (bu.compareTo(ro) == 0) {
                edit.setRollbackBudgetTag(ActivityDetailPlanRollbackBudgetEnum.ALL_ROLLBACK.getCode());
            } else {
                edit.setRollbackBudgetTag(ActivityDetailPlanRollbackBudgetEnum.PART_ROLLBACK.getCode());
            }
            edit.setRollbackAmount(ro);
            edit.setId(planItemVo.getId());
            edit.setDetailPlanItemCode(planItemVo.getDetailPlanItemCode());
            BigDecimal finalRo = ro;
            operateList.add(new OperateActivityDetailPlanBudgetDto() {{
                this.setBusinessCode(planItemVo.getDetailPlanItemCode());
                this.setDetailPlanCode(planItemVo.getDetailPlanCode());
                this.setDetailPlanItemCode(planItemVo.getDetailPlanItemCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(finalRo);
            }});
            returnAmount = ro;

//            }

            if (StringUtils.isNotBlank(planItemVo.getRelatePlanItemCode())) {
                if (planMap.containsKey(planItemVo.getRelatePlanItemCode())) {
                    OperateActivityPlanBudgetVerticalDto verticalDto = planMap.get(planItemVo.getRelatePlanItemCode());
                    verticalDto.setOperationAmount(verticalDto.getOperationAmount().add(returnAmount));
                    planMap.put(planItemVo.getRelatePlanItemCode(), verticalDto);
                } else {
                    OperateActivityPlanBudgetVerticalDto verticalDto = new OperateActivityPlanBudgetVerticalDto();
                    verticalDto.setBusinessCode(planItemVo.getRelatePlanItemCode());
                    verticalDto.setPlanItemCode(planItemVo.getRelatePlanItemCode());
                    verticalDto.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    verticalDto.setOperationAmount(returnAmount);
                    verticalDto.setIsRollbackBudget(false);
                    planMap.put(planItemVo.getRelatePlanItemCode(), verticalDto);
                }
            }
        }

        //方案退预算，细案明细，细案预算明细修改
        ActivityPlanDetailPlanAndBudgetEditDto editDto = new ActivityPlanDetailPlanAndBudgetEditDto();
        editDto.setDetailPlanBudgetList(operateList);
        editDto.setDetailPlanList(edits);
        editDto.setPlanOperateList(new ArrayList<>(planMap.values()));
        this.activityDetailPlanItemService.editPlanDetailPlanAndBudget(editDto);
        // edits  退回预算后，将回退预算状态 推送给扣费预测
        this.pushToAuditFeePredictionByMq(edits);
    }

    /**
     * 退回预算后，将回退预算状态 推送给扣费预测
     */
    private void pushToAuditFeePredictionByMq(List<ActivityDetailPlanItem> edits) {
        if (!CollectionUtils.isEmpty(edits)) {
            List<String> itemCodeTotalList = edits.stream().map(ActivityDetailPlanItem::getDetailPlanItemCode).collect(Collectors.toList());
            List<List<String>> groupList = Lists.partition(itemCodeTotalList, 200);
            groupList.forEach(itemCodes->{
                for (ActivityDetailPlanRollbackMqTagEnum mqTagEnum : ActivityDetailPlanRollbackMqTagEnum.values()) {
                    MqMessageVo mqMessageVo = new MqMessageVo();
                    mqMessageVo.setMsgBody(JSON.toJSONString(itemCodes));
                    mqMessageVo.setTopic(ActivityDetailPlanRollbackMqTagConstant.ROLLBACK_TOPIC + RocketMqUtil.mqEnvironment());
                    mqMessageVo.setTag(mqTagEnum.getCode());
                    rocketMqProducer.sendMqMsg(mqMessageVo);
                    try {
                        //单位：毫秒 防止MQ消息发送过于频繁
                        Thread.sleep(200);
                    } catch (Exception e) {
                        log.error("", e);
                    }
                }
            });
        }
    }


    /**
     * 更新细案活动状态
     *
     * @param detailPlanCodeList
     * @param statusEnum
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-08-26 02:29
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updatePlanStatusByDetailPlanCodeList(List<String> detailPlanCodeList, ActivityPlanStatusEnum statusEnum) {
        if (CollectionUtil.isEmpty(detailPlanCodeList)
                || Objects.isNull(statusEnum)) {
            return;
        }
        log.info("活动细案活动状态更新service {} {}", detailPlanCodeList, statusEnum);
        this.activityDetailPlanRepository.updatePlanStatusByDetailPlanCodeList(detailPlanCodeList, statusEnum);
    }

    /**
     * 根据dto查询（扣费预测用）
     * 查询:此处只查询了细案明细数据
     * @param pageable
     * @param dto
     * @return
     */
    @Override
    public Page<String> findByDtoForPrediction(Pageable pageable, ActivityDetailPlanDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        Page<String> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        if (Objects.isNull(dto)) {
            dto = new ActivityDetailPlanDto();
        }
        ActivityDetailPlanItemDto itemDto = new ActivityDetailPlanItemDto();
        itemDto.setProcessStatus(dto.getProcessStatus());
        itemDto.setActivityBeginDate(dto.getActivityBeginDate());
        itemDto.setActivityEndDate(dto.getActivityEndDate());
        return this.activityDetailPlanItemRepository.findByDtoForPrediction(page, itemDto);
    }

    /**
     * 根据方案明细编码获取细案信息
     *
     * @param planItemCodeList
     * @return java.util.List<com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityDetailPlanPlanVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-11-29 15:08
     */
    @Override
    public List<com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityDetailPlanPlanVo> getDetailPlanInfoByPlanItemCodeList(List<String> planItemCodeList) {
        if(CollectionUtil.isEmpty(planItemCodeList)){
            return Collections.emptyList();
        }
        return this.activityDetailPlanRepository.getDetailPlanInfoByPlanItemCodeList(planItemCodeList);
    }

    @Override
    public void updatePlanAlreadyAmount(Map<String, BigDecimal> detailItemAlreadyAuditAmountMap) {
        if (CollectionUtils.isEmpty(detailItemAlreadyAuditAmountMap)) {
            return;
        }

        List<ActivityPlanItemDto> activityPlanItemDtoList = new ArrayList<>();
        List<String> detailPlanItemCodes = new ArrayList<>(detailItemAlreadyAuditAmountMap.keySet());
        List<ActivityDetailPlanBudgetVo> activityDetailPlanBudgetVos = activityDetailPlanBudgetService.findPlanItemCodeByActivityDetailItemCodes(detailPlanItemCodes);
        if (!CollectionUtils.isEmpty(activityDetailPlanBudgetVos)) {
            Map<String, List<ActivityDetailPlanBudgetVo>> collect = activityDetailPlanBudgetVos.stream().collect(Collectors.groupingBy(ActivityDetailPlanBudgetVo::getRelatePlanItemCode));
            collect.forEach((key, value) -> {
                ActivityPlanItemDto activityPlanItemDto = new ActivityPlanItemDto();
                activityPlanItemDto.setPlanItemCode(key);
                for (ActivityDetailPlanBudgetVo activityDetailPlanBudgetVo : value) {
                    BigDecimal alreadyAuditAmount = detailItemAlreadyAuditAmountMap.get(activityDetailPlanBudgetVo.getDetailPlanItemCode());
                    if (Objects.nonNull(alreadyAuditAmount)) {
                        activityPlanItemDto.setAlreadyAuditAmount(
                                Optional.ofNullable(activityPlanItemDto.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO)
                                        .add(alreadyAuditAmount));
                    }
                }
                activityPlanItemDtoList.add(activityPlanItemDto);
            });
        }

        activityPlanItemSdkService.updateAlreadyAuditAmount(activityPlanItemDtoList);
    }
}
