package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanVoService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 活动方案查询服务
 * @author wanghaojia
 * @date 2023/12/20 15:03
 */
@Service
public class ActivityDetailPlanVoServiceImpl implements ActivityDetailPlanVoService {

    @Autowired(required = false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;

    @Autowired(required = false)
    private ProcessBusinessMappingService processBusinessMappingService;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Override
    public List<ActivityDetailPlanItemVo> findActivityDetailPlanItemSumInfoByProcessNo(String processNo) {
        if (StringUtils.isEmpty(processNo)){
            return Lists.newArrayList();
        }
        List<ProcessBusinessMappingVo> processBusinessMappingVos = processBusinessMappingService.findAllByProcessNoCollection(Lists.newArrayList(processNo));
        List<String> detailPlanCodeList = processBusinessMappingVos.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
        List<ActivityDetailPlanItemVo> itemVos = activityDetailPlanItemRepository.findVoListByActivityDetailPlanCode(detailPlanCodeList);

//        年月	省区名称	活动分类	活动形式	客户名称	费用合计（元）	总部承担金额（元）	大区承担金额(元)	期间渠道促销额（元）	投产比（%）
//        以申请的活动细案明细的活动开始时间、活动结束时间、省区名称、活动分类、活动形式、客户名称维度进行统计									费用合计/期间渠道促销额*100
        Map<String, List<ActivityDetailPlanItemVo>> groupMap = itemVos.stream().collect(Collectors.groupingBy(item -> {
            return item.getFeeYearMonthStr() + item.getActivityOrgCode() + item.getActivityTypeCode() + item.getActivityFormCode() + item.getCustomerCode();
        }));

        List<ActivityDetailPlanItemVo> result = Lists.newArrayList();
        BigDecimal multiplicand = new BigDecimal(100);
        for (Map.Entry<String, List<ActivityDetailPlanItemVo>> entry : groupMap.entrySet()) {
            List<ActivityDetailPlanItemVo> value = entry.getValue();
            ActivityDetailPlanItemVo firstVo = value.get(0);
            ActivityDetailPlanItemVo vo = new ActivityDetailPlanItemVo();
            vo.setFeeYearMonthStr(firstVo.getFeeYearMonthStr());
            vo.setActivityOrgCode(firstVo.getActivityOrgCode());
            vo.setActivityOrgName(firstVo.getActivityOrgName());
            vo.setActivityTypeCode(firstVo.getActivityTypeCode());
            vo.setActivityTypeName(firstVo.getActivityTypeName());
            vo.setCustomerCode(firstVo.getCustomerCode());
            vo.setCustomerName(firstVo.getCustomerName());
            vo.setActivityForm(firstVo.getActivityFormCode());
            vo.setActivityFormName(firstVo.getActivityFormName());
            vo.setTotalFeeAmount(BigDecimal.ZERO);
            vo.setHeadFeeAmount(BigDecimal.ZERO);
            vo.setDepartmentFeeAmount(BigDecimal.ZERO);
            vo.setPeriodChPromoteAmount(BigDecimal.ZERO);
            for (ActivityDetailPlanItemVo ActivityDetailPlanItemVo : value) {
                if (null != ActivityDetailPlanItemVo.getTotalFeeAmount()){
                    vo.setTotalFeeAmount(vo.getTotalFeeAmount().add(ActivityDetailPlanItemVo.getTotalFeeAmount()));
                }
                if (null != ActivityDetailPlanItemVo.getHeadFeeAmount()){
                    vo.setHeadFeeAmount(vo.getHeadFeeAmount().add(ActivityDetailPlanItemVo.getHeadFeeAmount()));
                }
                if (null != ActivityDetailPlanItemVo.getDepartmentFeeAmount()){
                    vo.setDepartmentFeeAmount(vo.getDepartmentFeeAmount().add(ActivityDetailPlanItemVo.getDepartmentFeeAmount()));
                }
                if (null != ActivityDetailPlanItemVo.getPeriodChPromoteAmount()){
                    vo.setPeriodChPromoteAmount(vo.getPeriodChPromoteAmount().add(ActivityDetailPlanItemVo.getPeriodChPromoteAmount()));
                }
            }
            String feeRateStr = null;
            if (null != vo.getPeriodChPromoteAmount() && vo.getPeriodChPromoteAmount().compareTo(BigDecimal.ZERO) != 0){
                //            费用合计/预估销售额
                BigDecimal feeRate = vo.getTotalFeeAmount().multiply(multiplicand).divide(vo.getPeriodChPromoteAmount(),2,BigDecimal.ROUND_HALF_UP);
                feeRateStr = feeRate + "%";
            }
            vo.setFeeRateStr(feeRateStr);
            result.add(vo);
        }
        return result;
    }

}
