package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.BusinessUnitSetTable;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.BusinessUnitSetTableRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.BusinessUnitSetTableService;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @CLASS_DESCRIBE: 业务单元套表_渠道-跑帆软
 * @AUTHOR: create by zkey on 2023-11-11
 */
@Slf4j
@Service
public class BusinessUnitSetTableServiceImpl implements BusinessUnitSetTableService {

    @Autowired(required = false)
    private BusinessUnitSetTableRepository businessUnitSetTableRepository;

    @Autowired(required = false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;

    @Autowired(required = false)
    private SalesPerformanceVoService salesPerformanceVoService;

    @Autowired(required = false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void frJob(List<String> yearMonths) {
        //首先删除对应月数据
        this.businessUnitSetTableRepository.removeByYearMonth(yearMonths);

        //分页处理
        int current = 1;
        int pageSize = 300;
        int count = 1;
        String tenantCode = TenantUtils.getTenantCode();
        Page<BusinessUnitSetTable> result;
        do {
            Page<BusinessUnitSetTable> page = new Page<>(current, pageSize);
            result = this.activityDetailPlanItemRepository.findListForFR(page, yearMonths);
            log.info("业务单元套表_渠道查询主数据:{}", JSON.toJSONString(result));
            if (Objects.isNull(result) || CollectionUtils.isEmpty(result.getRecords())) break;
            current++;

            //取垂直销售业绩
            List<SalesPerformanceDto> salesPerformanceDtos = result.getRecords().stream().map(e -> new SalesPerformanceDto() {{
                this.setSalesMonth(e.getYearMonthStr().replace("-", ""));
                this.setRetailer(e.getSystemName());
            }}).collect(Collectors.toList());
            log.info("业务单元套表_渠道查询垂直销售业绩参数:{}", JSON.toJSONString(salesPerformanceDtos));
            List<SalesPerformanceVo> salesPerformanceVos = this.salesPerformanceVoService.findBusinessUnitSetTableForFR(salesPerformanceDtos);
            log.info("业务单元套表_渠道查询垂直销售业绩:{}", JSON.toJSONString(salesPerformanceVos));
            Map<String, SalesPerformanceVo> salesPerformanceVoMap = salesPerformanceVos.stream().collect(Collectors.toMap(e -> StringUtils.join(e.getSalesMonth(), e.getRetailer()), Function.identity()));
            log.info("业务单元套表_渠道查询垂直销售业绩map:{}", JSON.toJSONString(salesPerformanceVoMap));

            //取POS
            List<SalesDataDto> salesDataDtos = result.getRecords().stream().map(e -> new SalesDataDto() {{
                this.setYearMonth(e.getYearMonthStr());
                this.setCustomerRetailerCode(e.getSystemCode());
            }}).collect(Collectors.toList());
            log.info("业务单元套表_渠道查询KMS销售数据表参数:{}", JSON.toJSONString(salesDataDtos));
            List<SalesDataVo> salesDataVos = this.invoiceSalesDataVoService.findBusinessUnitSetTableForFR(salesDataDtos);
            log.info("业务单元套表_渠道查询KMS销售数据表:{}", JSON.toJSONString(salesDataVos));
            Map<String, SalesDataVo> salesDataVoMap = salesDataVos.stream().collect(Collectors.toMap(e -> StringUtils.join(e.getYearMonth(), e.getCustomerRetailerCode()), Function.identity()));
            log.info("业务单元套表_渠道查询KMS销售数据表map:{}", JSON.toJSONString(salesDataVoMap));

            //同期
            List<BusinessUnitSetTable> tableList = result.getRecords().stream().map(e -> new BusinessUnitSetTable() {{
                this.setYearMonthStr(e.getLastYear());
                this.setSystemCode(e.getSystemCode());
            }}).collect(Collectors.toList());
            List<BusinessUnitSetTable> tables = this.businessUnitSetTableRepository.findListForFR(tableList);
            Map<String, BusinessUnitSetTable> tableMap = tables.stream().collect(Collectors.toMap(e -> StringUtils.join(e.getYearMonthStr(), e.getSystemCode()), Function.identity(), (v1, v2) -> v1));

            result.getRecords().forEach(e -> {
                e.setTenantCode(tenantCode);
                e.setDqzxfyxj(e.getDqcpcx().add(e.getDqclf()).add(e.getDqcxyfy()).add(e.getDqhtnfy()).add(e.getDqqtfy()).add(e.getDqxxfy()));
                e.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                e.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());

                String key = StringUtils.join(e.getYearMonthStr(), e.getSystemCode());
                String key1 = StringUtils.join(e.getYearMonthStr().replace("-", ""), e.getSystemName());
                e.setDqzxfylzh(BigDecimal.ZERO);
                if (salesPerformanceVoMap.containsKey(key1)) {
                    e.setDqzxfylzh(salesPerformanceVoMap.get(key1).getWarehsOutDiscountAmtIncM());
                }
                e.setDqzxfylpos(BigDecimal.ZERO);
                if (salesDataVoMap.containsKey(key)) {
                    e.setDqzxfylpos(salesDataVoMap.get(key).getSalesAmount());
                }

                //同期
                e.setTqclf(BigDecimal.ZERO);
                e.setTqcpcx(BigDecimal.ZERO);
                e.setTqcxyfy(BigDecimal.ZERO);
                e.setTqhtnfy(BigDecimal.ZERO);
                e.setTqqtfy(BigDecimal.ZERO);
                e.setTqxxfy(BigDecimal.ZERO);
                e.setTqzxfylpos(BigDecimal.ZERO);
                e.setTqzxfylzh(BigDecimal.ZERO);
                e.setTqzxfyxj(BigDecimal.ZERO);
                String key2 = StringUtils.join(e.getLastYear(), e.getSystemCode());
                if (tableMap.containsKey(key2)) {
                    e.setTqclf(tableMap.get(key2).getTqclf());
                    e.setTqcpcx(tableMap.get(key2).getTqcpcx());
                    e.setTqcxyfy(tableMap.get(key2).getTqcxyfy());
                    e.setTqhtnfy(tableMap.get(key2).getTqhtnfy());
                    e.setTqqtfy(tableMap.get(key2).getTqqtfy());
                    e.setTqxxfy(tableMap.get(key2).getTqxxfy());
                    e.setTqzxfylpos(tableMap.get(key2).getTqzxfylpos());
                    e.setTqzxfylzh(tableMap.get(key2).getTqzxfylzh());
                    e.setTqzxfyxj(tableMap.get(key2).getTqzxfyxj());
                }
            });
            this.businessUnitSetTableRepository.saveOrUpdateBatch(result.getRecords());

            count++;
        } while (count <= 1000 && result.hasNext());
    }
}
