package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.constant.CommonConstant;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.enums.RtmModelEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.exception.DataDuplicationException;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItemExtend;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemExtendRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ForeignActivityDetailPlanApiAsyncService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.foreign.ForeignActivityDetailPlanEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.AcceptTypeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ForeignActivityDetailPlanEvent;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.enums.ApplicationDimensionEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.beans.PropertyDescriptor;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 外部系统创建活动细案异步执行接口
 * @author wanghaojia
 * @date 2023/11/27 11:23
 */
@Slf4j
@Service
public class ForeignActivityDetailPlanApiAsyncServiceImpl implements ForeignActivityDetailPlanApiAsyncService {

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private ActivityDetailPlanService activityDetailPlanService;

    @Autowired(required = false)
    private ActivityDetailPlanRepository activityDetailPlanRepository;

    @Autowired(required = false)
    private ActivityDetailPlanItemExtendRepository activityDetailPlanItemExtendRepository;

    @Autowired(required = false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private MdmTerminalChannelVoService terminalChannelVoService;

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Autowired(required = false)
    private ActivityPlanSdkService activityPlanSdkService;

    @Autowired(required = false)
    private ActivityFormService activityFormService;

    /**
     * 异步执行活动细案创建接口
     *
     * @param object       活动细案内容对象
     * @param userIdentity 当前登录人
     */
    @Override
    @Async
    public void create(JSONObject object, AbstractCrmUserIdentity userIdentity) {
        loginUserService.refreshAuthentication(userIdentity);
//        log.info("外部系统创建活动细案参数："+JSONObject.toJSONString(object));
        log.info("外部系统创建活动细案");
        Result<ActivityDetailPlanDto> result = new Result<>();
        boolean lockSuccess = false;
        String lockKey = null;
        String foreignPlanCode = object.getString("foreignPlanCode");
        try {
            Validate.notBlank(foreignPlanCode,"外部系统业务编码不能为空！");

            ActivityDetailPlanDto activityDetailPlanDto = new ActivityDetailPlanDto();
            activityDetailPlanDto.setForeignPlanCode(foreignPlanCode);
            result.setResult(activityDetailPlanDto);

            lockKey = ActivityPlanConstant.LOCK_ACTIVITY_PLAN_SAVE + foreignPlanCode;
            lockSuccess = redisLockService.tryLock(lockKey, TimeUnit.MINUTES, 30);
            Validate.isTrue(lockSuccess,"活动细案["+foreignPlanCode+"]创建正在处理中，请稍后再试");

            ActivityDetailPlanDto detailPlanDto = JSONObject.parseObject(object.toJSONString(), ActivityDetailPlanDto.class);
            validate(detailPlanDto,activityDetailPlanDto);
            activityDetailPlanService.saveActivityDetailPlanNoCache(detailPlanDto);

            //创建成功，构建返回结果
            activityDetailPlanDto.setDetailPlanCode(detailPlanDto.getDetailPlanCode());
            List<ActivityDetailPlanItemDto> itemDtoList = Lists.newArrayList();
            activityDetailPlanDto.setItemList(itemDtoList);
            for (ActivityDetailPlanItemDto itemDto : detailPlanDto.getItemList()) {
                ActivityDetailPlanItemDto detailPlanItemDto = new ActivityDetailPlanItemDto();
                detailPlanItemDto.setForeignPlanItemCode(itemDto.getForeignPlanItemCode());
                detailPlanItemDto.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                itemDtoList.add(detailPlanItemDto);
            }
        }catch (DataDuplicationException ignore){
            //重复创建不处理
        }catch (Exception e){
            log.error("活动细案创建失败:" + e.getMessage(),e);
            result.setCode(CommonConstant.SC_INTERNAL_SERVER_ERROR_500);
            result.setMessage("活动细案[" + foreignPlanCode + "]创建失败:" + e.getMessage());
            result.setSuccess(false);
        }finally {
            if (lockSuccess){
                redisLockService.unlock(lockKey);
            }
        }
        log.info("外部系统创建活动细案[" + foreignPlanCode + "]结果：" + JSONObject.toJSONString(result));
        ForeignActivityDetailPlanEventDto eventDto = new ForeignActivityDetailPlanEventDto();
        eventDto.setResult(result);
        SerializableBiConsumer<ForeignActivityDetailPlanEvent, ForeignActivityDetailPlanEventDto> createFinish =
                ForeignActivityDetailPlanEvent::createFinish;
        this.nebulaNetEventClient.publish(eventDto,ForeignActivityDetailPlanEvent.class, createFinish);
    }

    //验重复
    private void validate(ActivityDetailPlanDto detailPlanDto,ActivityDetailPlanDto result){
        //验下重
        String foreignPlanCode = detailPlanDto.getForeignPlanCode();
        Validate.notEmpty(detailPlanDto.getItemList(),"活动细案明细不能为空！");


        //关联方案校验
        if (CollectionUtils.isEmpty(detailPlanDto.getRelatePlanList())){
            throw new RuntimeException("关联方案不能为空!");
        }
        List<String> planCodeList = detailPlanDto.getRelatePlanList().stream().map(ActivityDetailPlanPlanDto::getPlanCode).collect(Collectors.toList());
        List<ActivityPlanVo> planVoList = activityPlanSdkService.findByPlanCodeList(Sets.newHashSet(planCodeList));
        if (CollectionUtils.isEmpty(planVoList)){
            throw new RuntimeException("关联活动方案有误！");
        }
        Map<String, ActivityPlanVo> planVoMap = planVoList.stream().collect(Collectors.toMap(ActivityPlanVo::getPlanCode, Function.identity(), (o, n) -> o));
        String[] ignoreFieldArr = Arrays.stream(BeanUtils.getPropertyDescriptors(TenantFlagOpDto.class)).map(PropertyDescriptor::getName).toArray(String[]::new);
        for (ActivityDetailPlanPlanDto planPlanDto : detailPlanDto.getRelatePlanList()) {
            ActivityPlanVo activityPlanVo = planVoMap.get(planPlanDto.getPlanCode());
            if (null == activityPlanVo){
                throw new RuntimeException("关联活动方案["+planPlanDto.getPlanCode()+"]有误");
            }
            BeanUtils.copyProperties(activityPlanVo,planPlanDto,ignoreFieldArr);
            detailPlanDto.setDepartmentCode(activityPlanVo.getDepartmentCode());//取关联方案的部门设置到方案上
        }

        setDefaultProperty(detailPlanDto);
        List<ActivityDetailPlan> existsList = activityDetailPlanRepository.findByForeignPlanCodeList(Lists.newArrayList(foreignPlanCode));
        if (!CollectionUtils.isEmpty(existsList)){
            ActivityDetailPlan activityDetailPlan = existsList.get(0);
            //创建成功，构建返回结果
            result.setDetailPlanCode(activityDetailPlan.getDetailPlanCode());
            List<ActivityDetailPlanItemDto> itemDtoList = Lists.newArrayList();
            result.setItemList(itemDtoList);
            List<ActivityDetailPlanItemExtend> existsItemList = activityDetailPlanItemExtendRepository.findByForeignPlanCode(foreignPlanCode);
            for (ActivityDetailPlanItemExtend itemDto : existsItemList) {
                ActivityDetailPlanItemDto detailPlanItemDto = new ActivityDetailPlanItemDto();
                detailPlanItemDto.setForeignPlanItemCode(itemDto.getForeignPlanItemCode());
                detailPlanItemDto.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                itemDtoList.add(detailPlanItemDto);
            }
            throw new DataDuplicationException("活动细案["+foreignPlanCode+"]已创建，请勿重复操作");
        }

        if (StringUtils.isNotEmpty(detailPlanDto.getDepartmentCode())){
            OrgVo orgVo = null;
            try {
                orgVo = orgVoService.findByOrgCode(detailPlanDto.getDepartmentCode());
            }catch (Exception ignore){}
            if (null == orgVo){
                throw new RuntimeException("部门编码["+detailPlanDto.getDepartmentCode()+"]有误");
            }
            detailPlanDto.setDepartmentName(orgVo.getOrgName());
            setOrgDefaultProperty(detailPlanDto,orgVo);
        }

        //明细数据校验处理
        Set<String> planItemCodeList = Sets.newHashSet();
        List<String> foreignPlanItemCodeList = Lists.newArrayList();
        List<ActivityDetailPlanItemDto> itemList = detailPlanDto.getItemList();
        Set<String> salesOrgCodeSet = Sets.newHashSet();
        Set<String> customerCodeSet = Sets.newHashSet();
        Set<String> terminalChannelSet = Sets.newHashSet();
        Set<String> activityFormCodeSet = Sets.newHashSet();
        for (ActivityDetailPlanItemDto itemDto : itemList) {
            //行明细上也都把外部系统编码赋值上去
            itemDto.setForeignPlanCode(foreignPlanCode);
            Validate.notBlank(itemDto.getForeignPlanItemCode(),"活动方案明细编码不能为空！");
            Validate.notBlank(itemDto.getRelatePlanItemCode(),"关联活动方案编码不能为空！");
            Validate.notBlank(itemDto.getDistributionChannelCode(),"分销渠道不能为空！");
            planItemCodeList.add(itemDto.getRelatePlanItemCode());

            if (foreignPlanItemCodeList.contains(itemDto.getForeignPlanItemCode())){
                throw new RuntimeException("活动方案明细编码["+itemDto.getForeignPlanItemCode()+"]不能重复！");
            }
            foreignPlanItemCodeList.add(itemDto.getForeignPlanItemCode());

            //拼接销售组织编码
            if (StringUtils.isNotEmpty(itemDto.getSalesInstitutionErpCode())){
                String salesInstitutionCode = itemDto.getDistributionChannelCode() + detailPlanDto.getBusinessFormatCode() + itemDto.getSalesInstitutionErpCode();
                itemDto.setSalesInstitutionCode(salesInstitutionCode);
                salesOrgCodeSet.add(salesInstitutionCode);
            }
            if (StringUtils.isNotEmpty(itemDto.getSalesRegionErpCode())){
                if (StringUtils.isEmpty(itemDto.getSalesInstitutionCode())){
                    throw new RuntimeException("活动方案明细["+itemDto.getForeignPlanItemCode()+"]销售机构编码不能为空");
                }
                String salesRegionCode = itemDto.getSalesInstitutionCode() + itemDto.getSalesRegionErpCode();
                itemDto.setSalesRegionCode(salesRegionCode);
                salesOrgCodeSet.add(salesRegionCode);
            }
            if (StringUtils.isNotEmpty(itemDto.getSalesOrgErpCode())){
                if (StringUtils.isEmpty(itemDto.getSalesRegionCode())){
                    throw new RuntimeException("活动方案明细["+itemDto.getForeignPlanItemCode()+"]销售机构编码和销售大区编码不能为空");
                }
                String salesOrgCode = itemDto.getSalesRegionCode() + itemDto.getSalesOrgErpCode();
                itemDto.setSalesOrgCode(salesOrgCode);
                salesOrgCodeSet.add(salesOrgCode);
            }

            if (StringUtils.isNotEmpty(itemDto.getCustomerErpCode())){
                if (StringUtils.isEmpty(itemDto.getSalesInstitutionErpCode())){
                    throw new RuntimeException("活动方案明细["+itemDto.getForeignPlanItemCode()+"]销售机构编码不能为空");
                }
                String customerCode = itemDto.getCustomerErpCode() + itemDto.getSalesInstitutionErpCode() + itemDto.getDistributionChannelCode() + detailPlanDto.getBusinessFormatCode();
                itemDto.setCustomerCode(customerCode);
                customerCodeSet.add(customerCode);
            }


            if (StringUtils.isNotEmpty(itemDto.getFirstChannelCode())) {
                terminalChannelSet.add(itemDto.getFirstChannelCode());
            }
            if (StringUtils.isNotEmpty(itemDto.getSecondChannelCode())) {
                terminalChannelSet.add(itemDto.getSecondChannelCode());
            }
            if (StringUtils.isNotEmpty(itemDto.getActivityFormCode())) {
                List<String> formCodes = Arrays.asList(itemDto.getActivityFormCode().split(","));
                activityFormCodeSet.addAll(formCodes);
            }
        }

        //匹配销售组织编码名称
        if (!CollectionUtils.isEmpty(salesOrgCodeSet)){
            List<SalesOrgVo> salesOrgList = salesOrgVoService.findBySalesOrgCodes(Lists.newArrayList(salesOrgCodeSet));
            if (CollectionUtils.isEmpty(salesOrgList)){
                throw new RuntimeException("销售组织编码有误！");
            }
            Map<String,SalesOrgVo> salesOrgVoMap = salesOrgList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(), (o, n) -> n));
            for (ActivityDetailPlanItemDto itemDto : itemList) {
                if (StringUtils.isNotEmpty(itemDto.getSalesInstitutionErpCode())){
                    String salesInstitutionCode = itemDto.getDistributionChannelCode() + detailPlanDto.getBusinessFormatCode() + itemDto.getSalesInstitutionErpCode();
                    SalesOrgVo salesOrgVo = salesOrgVoMap.get(salesInstitutionCode);
                    if (null == salesOrgVo){
                        throw new RuntimeException("活动方案明细["+itemDto.getForeignPlanItemCode()+"]销售组织编码["+itemDto.getSalesInstitutionErpCode()+"]有误");
                    }
                    itemDto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                }
                if (StringUtils.isNotEmpty(itemDto.getSalesRegionErpCode())){
                    String salesRegionCode = itemDto.getSalesInstitutionCode() + itemDto.getSalesRegionErpCode();
                    SalesOrgVo salesOrgVo = salesOrgVoMap.get(salesRegionCode);
                    if (null == salesOrgVo){
                        throw new RuntimeException("活动方案明细["+itemDto.getForeignPlanItemCode()+"]销售大区编码["+itemDto.getSalesRegionErpCode()+"]有误");
                    }
                    itemDto.setSalesRegionName(salesOrgVo.getSalesOrgName());
                }
                if (StringUtils.isNotEmpty(itemDto.getSalesOrgErpCode())){
                    String salesOrgCode = itemDto.getSalesRegionCode() + itemDto.getSalesOrgErpCode();
                    SalesOrgVo salesOrgVo = salesOrgVoMap.get(salesOrgCode);
                    if (null == salesOrgVo){
                        throw new RuntimeException("活动方案明细["+itemDto.getForeignPlanItemCode()+"]销售省区编码["+itemDto.getSalesOrgErpCode()+"]有误");
                    }
                    itemDto.setSalesOrgName(salesOrgVo.getSalesOrgName());
                }
            }
        }


        //匹配客户编码名称
        if (!CollectionUtils.isEmpty(customerCodeSet)){
            List<CustomerVo> customerVos = customerVoService.findBaseByCustomerCodes(Lists.newArrayList(customerCodeSet));
            if (CollectionUtils.isEmpty(customerVos)) {
                throw new RuntimeException("客户编码有误！");
            }
            Map<String, CustomerVo> customerMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            for (ActivityDetailPlanItemDto itemDto : itemList) {
                if (StringUtils.isNotEmpty(itemDto.getCustomerErpCode())){
                    String customerCode = itemDto.getCustomerErpCode() + itemDto.getSalesInstitutionErpCode() + itemDto.getDistributionChannelCode() + detailPlanDto.getBusinessFormatCode();
                    CustomerVo customerVo = customerMap.get(customerCode);
                    if (null == customerVo){
                        throw new RuntimeException("活动方案明细["+itemDto.getForeignPlanItemCode()+"]客户编码["+itemDto.getCustomerErpCode()+"]有误");
                    }
                    itemDto.setCustomerCode(customerVo.getCustomerCode());
                    itemDto.setCustomerName(customerVo.getCustomerName());
                    setItemCustomerDefaultProperty(itemDto,customerVo);
                }
            }
        }

        //匹配门店渠道
        if (!CollectionUtils.isEmpty(terminalChannelSet)){
            List<MdmTerminalChannelVo> mdmTerminalChannelVos = terminalChannelVoService.listByCodes(Lists.newArrayList(terminalChannelSet));
            if (CollectionUtils.isEmpty(mdmTerminalChannelVos)){
                throw new RuntimeException("门店渠道有误！");
            }
            Map<String,String> terminalChannelMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode,MdmTerminalChannelVo::getTerminalChannelName,(o,n)->n));
            for (ActivityDetailPlanItemDto itemDto : itemList) {
                if (StringUtils.isNotEmpty(itemDto.getFirstChannelCode())){
                    String terminalChannelName = terminalChannelMap.get(itemDto.getFirstChannelCode());
                    if (StringUtils.isEmpty(terminalChannelName)){
                        throw new RuntimeException("活动方案明细["+itemDto.getForeignPlanItemCode()+"]一级渠道编码["+itemDto.getFirstChannelCode()+"]有误");
                    }
                    itemDto.setFirstChannelName(terminalChannelName);
                }
                if (StringUtils.isNotEmpty(itemDto.getSecondChannelCode())){
                    String terminalChannelName = terminalChannelMap.get(itemDto.getSecondChannelCode());
                    if (StringUtils.isEmpty(terminalChannelName)){
                        throw new RuntimeException("活动方案明细["+itemDto.getForeignPlanItemCode()+"]二级渠道编码["+itemDto.getSecondChannelCode()+"]有误");
                    }
                    itemDto.setSecondChannelName(terminalChannelName);
                }
            }
        }


        //匹配活动形式
        if (!CollectionUtils.isEmpty(activityFormCodeSet)){
            List<String> activityFormCodeList = Lists.newArrayList(activityFormCodeSet);
            ActivityFormDto activityFormDto = new ActivityFormDto();
            activityFormDto.setActivityFormCodeList(activityFormCodeList);
            activityFormDto.setBusinessUnitCode(detailPlanDto.getBusinessUnitCode());
            List<ActivityFormVo> activityFormVos = activityFormService.findListByConditions(activityFormDto);
            if (CollectionUtils.isEmpty(activityFormVos)){
                throw new RuntimeException("活动形式有误！");
            }
            Map<String,ActivityFormVo> activityFormMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode,Function.identity(),(o,n)->n));
            for (ActivityDetailPlanItemDto itemDto : itemList) {
                if (StringUtils.isNotEmpty(itemDto.getActivityFormCode())){
                    String[] codes = itemDto.getActivityFormCode().split(",");
                    LinkedList<String> allNames = new LinkedList<>();
                    Set<String> activityTypeCodeSet = Sets.newHashSet();
                    Set<String> activityTypeNameSet = Sets.newHashSet();
                    for (String code : codes) {
                        ActivityFormVo activityFormVo = activityFormMap.get(code);
                        if (null == activityFormVo) {
                            throw new RuntimeException("活动方案明细["+itemDto.getForeignPlanItemCode()+"]活动形式编码[" + code + "]有误");
                        } else {
                            allNames.add(activityFormVo.getActivityFormName());
                            activityTypeCodeSet.add(activityFormVo.getActivityTypeCode());
                            activityTypeNameSet.add(activityFormVo.getActivityTypeName());
                        }
                    }
                    itemDto.setActivityForm(itemDto.getActivityFormCode());
                    itemDto.setActivityFormName(String.join(",", allNames));
                    itemDto.setActivityTypeCode(String.join(",", activityTypeCodeSet));
                    itemDto.setActivityType(itemDto.getActivityTypeCode());
                    itemDto.setActivityTypeName(String.join(",", activityTypeNameSet));
                }
            }
        }


        //验重
        List<ActivityDetailPlanItemExtend> existsItemList = activityDetailPlanItemExtendRepository.findByForeignPlanItemCodeList(foreignPlanItemCodeList);
        List<String> existsForeignPlanItemCodeList = existsItemList.stream().map(ActivityDetailPlanItemExtend::getForeignPlanItemCode).collect(Collectors.toList());
        Validate.isTrue(CollectionUtils.isEmpty(existsForeignPlanItemCodeList),"活动细案明细["+String.join(",",foreignPlanItemCodeList)+"]已创建，请勿重复操作");

        //外部系统只传关联方案明细编码，查对应的方案，匹配对应的预算信息
        List<ActivityPlanItemVo> planItemVos = activityPlanItemSdkService.listByItemCodeList(Lists.newArrayList(planItemCodeList));
        Map<String, ActivityPlanItemVo> planItemVoMap = planItemVos.stream().collect(Collectors.toMap(ActivityPlanItemVo::getPlanItemCode, Function.identity(), (o, n) -> n));
        for (ActivityDetailPlanItemDto itemDto : itemList) {
            ActivityPlanItemVo activityPlanItemVo = planItemVoMap.get(itemDto.getRelatePlanItemCode());
            Validate.notNull(activityPlanItemVo,"关联方案编码["+itemDto.getRelatePlanItemCode()+"]有误！");
            itemDto.setRelatePlanCode(activityPlanItemVo.getPlanCode());
            if (StringUtils.isNotEmpty(itemDto.getHeadBudgetItemCode())){
                itemDto.setHeadMonthBudgetCode(activityPlanItemVo.getHeadMonthBudgetCode());
                itemDto.setHeadBudgetItemName(activityPlanItemVo.getHeadBudgetItemName());
            }
            if (StringUtils.isNotEmpty(itemDto.getBudgetItemCode())){
                itemDto.setMonthBudgetCode(activityPlanItemVo.getMonthBudgetCode());
                itemDto.setBudgetItemName(activityPlanItemVo.getBudgetItemName());
            }
        }
    }

    /**
     * 设置细案默认属性
     */
    private void setDefaultProperty(ActivityDetailPlanDto detailPlanDto) {
        if ("HDMBPZ3898".equals(detailPlanDto.getTemplateConfigCode())){
            //销售费用模板-陈列
            setDefaultPropertyDisplay(detailPlanDto);
        }
        for (ActivityDetailPlanItemDto itemDto : detailPlanDto.getItemList()) {
            setItemDefaultProperty(itemDto);
        }
    }

    /**
     * 陈列方案设置默认属性
     * @param detailPlanDto
     */
    public void setDefaultPropertyDisplay(ActivityDetailPlanDto detailPlanDto){
//        是否临时方案：TPM生成----默认为【否】
        detailPlanDto.setIsTemporary(BooleanEnum.FALSE.getCapital());
//        是否汇总：TPM生成----默认为【否】
        detailPlanDto.setIsGather(BooleanEnum.FALSE.getCapital());
    }

    /**
     * 设置细案默认属性
     *
     * @param detailPlanDto
     * @param orgVo
     */
    private void setOrgDefaultProperty(ActivityDetailPlanDto detailPlanDto, OrgVo orgVo) {
        if ("HDMBPZ3898".equals(detailPlanDto.getTemplateConfigCode())){
            //销售费用模板-陈列
            setOrgDefaultPropertyDisplay(detailPlanDto,orgVo);
        }
    }

    /**
     * 陈列方案设置默认属性
     * @param detailPlanDto
     */
    public void setOrgDefaultPropertyDisplay(ActivityDetailPlanDto detailPlanDto, OrgVo orgVo){
//        细案名称：TPM生成----大区名称+年月+关联的方案名称
        String parentName = Optional.ofNullable(orgVo.getParentName()).orElse("");
        String yearMonth = DateUtil.getDateStrByFormat(new Date(), DateUtil.DEFAULT_YEAR_MONTH);
        detailPlanDto.setDetailPlanName(parentName+yearMonth+detailPlanDto.getRelatePlanList().get(0).getPlanName());
    }

    /**
     * 设置行明细默认属性
     */
    public void setItemDefaultProperty(ActivityDetailPlanItemDto itemDto){
        if ("HDMBPZ3898".equals(itemDto.getTemplateConfigCode())){
            //销售费用模板-陈列
            setItemDefaultPropertyDisplay(itemDto);
        }
    }

    public void setItemDefaultPropertyDisplay(ActivityDetailPlanItemDto itemDto){
//        1038796 [2023年11月30日]【需求】渠道平台对接---陈列活动细案接收接口开发
        //        销售机构编码：TPM默认：6000
        itemDto.setSalesInstitutionErpCode("6000");
        itemDto.setDistributionChannelCode("20");
//        品牌编码：TPM默认“130000”
//        品牌名称：TPM默认“常温全品”
//        品类编码：TPM默认为空
//        品类名称：TPM默认为空
//        产品编码：TPM默认“130100000000”
//        产品名称：TPM默认“常温全品”
        itemDto.setProductBrandCode("130000");
        itemDto.setProductBrandName("常温全品");
        itemDto.setProductCode("130100000000");
        itemDto.setProductName("常温全品");
//        零售商编码：渠道平台推送
//        零售商名称：根据编码在【零售商】菜单查询“零售商名称”字段带出
//
//        是否扣减费用池：TPM默认“否”
        itemDto.setIsDeductionFeePool(BooleanEnum.FALSE.getCapital());
//        核销类型：TPM默认“制度核销”
        itemDto.setAuditType(TpmAuditTypeEnum.AUDITTYPE1.getCode());
//        结案形式：TPM默认为“报销”
        itemDto.setAuditForm("2");
//        是否和价格有关、是否涨价政策、是否考核扣款、是否责任利润调整：TPM默认“否”
        itemDto.setRelateToPrice(BooleanEnum.FALSE.getCapital());
        itemDto.setIncreasePricePromotion(BooleanEnum.FALSE.getCapital());
        itemDto.setDeductType(BooleanEnum.FALSE.getNumStr());
        itemDto.setDutyProfitAdjust(BooleanEnum.FALSE.getCapital());
//        新品对象TPM默认“无”
        itemDto.setNewProductType("无");
//        是否占用划拨预算：TPM默认“否”
        itemDto.setOccupyTransferBudget(BooleanEnum.FALSE.getCapital());
//        活动力度：TPM默认“0”
        itemDto.setActivityIntensity("0");
//        是否客户上账：TPM默认“是”
        itemDto.setIsCustomerAccount(BooleanEnum.FALSE.getCapital());
//        承接方式：TPM默认“不承接”
        itemDto.setUndertakingMode(AcceptTypeEnum.NO_ACCEPT.getCode());
    }

    /**
     * 根据客户信息设置默认属性
     * @param itemDto
     * @param customerVo
     */
    private void setItemCustomerDefaultProperty(ActivityDetailPlanItemDto itemDto, CustomerVo customerVo){
        if ("HDMBPZ3898".equals(itemDto.getTemplateConfigCode())){
            //销售费用模板-陈列
            if (RtmModelEnum.SON_COMPANY.getDictCode().equals(customerVo.getRtmModelCode())){
                //        促销对象：TPM根据客户编码在【客户管理】菜单查询“RTM模式”字段，为“分子公司”时，促销对象默认为“分子公司”；为空时，促销对象默认为“经销商”
                itemDto.setPromotionObject("6");
                //        分子公司点内金额：当客户为分子公司客户时，默认等于大区承担金额；当客户为非分子公司客户时，默认为空
                //        分子公司点位金额：当客户为分子公司客户时，默认等于总部承担金额；当客户为非分子公司客户时，默认为空
                itemDto.setIntraCompanyAmountStr(itemDto.getDepartmentFeeAmountStr());
                itemDto.setOffPointAmountStr(itemDto.getHeadFeeAmountStr());
            }

        }
//        1040517 对接渠道平台细案创建接口变更：省区编码自动带出客户的，不用接口的
        if (null != customerVo){
            if (StringUtils.isNotEmpty(customerVo.getSalesOrgCode())){
                itemDto.setSalesOrgCode(customerVo.getSalesOrgCode());
                itemDto.setSalesOrgErpCode(customerVo.getSalesOrgErpCode());
                itemDto.setSalesOrgName(customerVo.getSalesOrgName());
            }
        }
    }

}
