package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.PushActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanPassMqTagEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 活动方案审批通过回调
 *
 * @author wanghaojia
 * @date 2022/11/30 20:57
 */
@Slf4j
@Component
public class PushActivityDetailPlanServiceImpl implements PushActivityDetailPlanService {

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private LoginUserService loginUserService;


    /**
     * 审批通过推送mq处理
     *
     * @param processNo      流程编号
     * @param businessNoList 业务编码集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void passPushMqDirect(String processNo, List<String> businessNoList) {
        if (CollectionUtils.isEmpty(businessNoList)) {
            return;
        }

        for (ActivityDetailPlanPassMqTagEnum mqTagEnum : ActivityDetailPlanPassMqTagEnum.values()) {
            // 排除：活动细案审批通过推送扣费预测管理的MQ
            if (!ActivityDetailPlanPassMqTagEnum.PASS_AUDIT_FEE_PREDICTION.getCode().equals(mqTagEnum.getCode())) {
                MqMessageVo mqMessageVo = new MqMessageVo();
                mqMessageVo.setMsgBody(JSON.toJSONString(businessNoList));
                mqMessageVo.setTopic(ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
                mqMessageVo.setTag(mqTagEnum.getCode());
                rocketMqProducer.sendMqMsg(mqMessageVo,10);
                try {
                    //单位：毫秒 防止MQ消息发送过于频繁
                    Thread.sleep(200);
                } catch (Exception e) {
                    log.error("", e);
                }
            }
        }
    }


}
