package com.biz.crm.tpm.business.activity.detail.plan.local.service.third;

import com.aliyun.tea.utils.StringUtils;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.*;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanProduct;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:  提取促销活动-牛人管家接口数据
 * @Author qiancheng
 * @Date 2023/1/16
 */
@Component
public class ActivityCowManagerInterData {

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    /**
     * 组装行销活动接口数据
     * @param ItemList 明细集合
     * @param close 是否关闭 true：关闭
     * @return 待推送行销活动接口数据集合
     */

    public List<CowManagerCellActivityDto> buildCellActivityInterfaceData(List<ActivityDetailPlanItemVo> ItemList,boolean close) {
        if(CollectionUtils.isEmpty(ItemList)){
            return Lists.newArrayList();
        }
        List<CowManagerCellActivityDto> cowManagerCellActivityDtoList = new ArrayList<>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM-dd");
        ItemList.forEach( item -> {
            CowManagerCellActivityDto cowManagerCellActivity = new CowManagerCellActivityDto();
            if(close){
                cowManagerCellActivity.setActivityStatus("已关闭");
                Date currentDate = new Date();
                cowManagerCellActivity.setActivityEndTime(sif2.format(currentDate));
            }else {
                cowManagerCellActivity.setActivityStatus("审批通过");
                cowManagerCellActivity.setActivityEndTime(item.getActivityEndDate() != null ? sif2.format(item.getActivityEndDate()) : "");
            }
            cowManagerCellActivity.setActivityNo(item.getDetailPlanCode());
            cowManagerCellActivity.setActiveNumber(item.getDetailPlanItemCode());
            cowManagerCellActivity.setCostYearMonth(item.getFeeYearMonth() != null ? sif.format(item.getFeeYearMonth()) : "");
            cowManagerCellActivity.setRegionInfo(item.getRegion());
            cowManagerCellActivity.setSystemInfo(item.getSystemCode());
            cowManagerCellActivity.setStoreId(item.getTerminalCode());
            cowManagerCellActivity.setStoreName(item.getTerminalName());
            cowManagerCellActivity.setChannelFirst(item.getFirstChannelName());
            cowManagerCellActivity.setChannelSecond(item.getSecondChannelName());
            cowManagerCellActivity.setActivityBrand(item.getProductBrandName());
            cowManagerCellActivity.setActivityStartTime(item.getActivityBeginDate() != null ? sif2.format(item.getActivityBeginDate()) : "");
            cowManagerCellActivity.setActivityTypeCode(item.getActivityTypeCode());
            cowManagerCellActivity.setActivityTypeName(item.getActivityTypeName());
            cowManagerCellActivity.setActivityCode(item.getActivityFormCode());
            cowManagerCellActivity.setActivityName(item.getActivityFormName());
            cowManagerCellActivity.setActivityDesc(item.getActivityDesc());
            cowManagerCellActivity.setActivityIndicators(item.getQuantity() != null ? item.getQuantity().toString() : "");//关键指标
            cowManagerCellActivity.setApplyTotalCost(item.getTotalFeeAmount() != null ? String.format("%.2f", item.getTotalFeeAmount()) : "0.00");
            cowManagerCellActivityDtoList.add(cowManagerCellActivity);
        });
        return cowManagerCellActivityDtoList;
    }

    /**
     * 组装陈列活动接口数据
     * @param ItemList 明细集合
     * @param close 是否关闭 true：关闭
     * @return  待推送的陈列活动接口数据集合
     */

    public List<CowManagerDisplayActivityDto> buildDisplayActivityInterfaceData(List<ActivityDetailPlanItemVo> ItemList,boolean close) {
        if(CollectionUtils.isEmpty(ItemList)){
            return null;
        }
        List<String> directTypeCodes = Lists.newArrayList();
        directTypeCodes.add(ActivityDetailPlanConstant.purchaseMethod);
        Map<String, List<DictDataVo>> directTypeMap = dictDataVoService.findByDictTypeCodeList(directTypeCodes);
        List<CowManagerDisplayActivityDto> cowManagerDisplayActivityDtoList = new ArrayList<>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM-dd");
        ItemList.forEach(detailPlanItem -> {
            CowManagerDisplayActivityDto cowManagerDisplayActivity = new CowManagerDisplayActivityDto();
            if(close){
                cowManagerDisplayActivity.setActivityStatus("已关闭");
                Date currentDate = new Date();
                cowManagerDisplayActivity.setActivityEndTime(sif2.format(currentDate));
            }else {
                cowManagerDisplayActivity.setActivityStatus("审批通过");
                cowManagerDisplayActivity.setActivityEndTime(detailPlanItem.getActivityEndDate() != null ? sif2.format(detailPlanItem.getActivityEndDate()) : "");
            }
            cowManagerDisplayActivity.setActivityNo(detailPlanItem.getDetailPlanCode());
            cowManagerDisplayActivity.setActiveNumber(detailPlanItem.getDetailPlanItemCode());
            cowManagerDisplayActivity.setCostYearMonth(detailPlanItem.getFeeYearMonth() != null ? sif.format(detailPlanItem.getFeeYearMonth()) : "");
            cowManagerDisplayActivity.setActivityStartTime(detailPlanItem.getActivityBeginDate() != null ? sif2.format(detailPlanItem.getActivityBeginDate()) : "");
            cowManagerDisplayActivity.setActivityTypeCode(detailPlanItem.getActivityTypeCode());
            cowManagerDisplayActivity.setActivityTypeName(detailPlanItem.getActivityTypeName());
            cowManagerDisplayActivity.setActivityCode(detailPlanItem.getActivityFormCode());
            cowManagerDisplayActivity.setActivityName(detailPlanItem.getActivityFormName());
            cowManagerDisplayActivity.setStoreId(detailPlanItem.getTerminalCode());
            cowManagerDisplayActivity.setStoreName(detailPlanItem.getTerminalName());
            cowManagerDisplayActivity.setActivityDesc(detailPlanItem.getActivityDesc());
            cowManagerDisplayActivity.setProcurementMethod(this.findDictValue(directTypeMap,ActivityDetailPlanConstant.purchaseMethod,detailPlanItem.getBuyWay()));
            cowManagerDisplayActivity.setScheduleStartTime(detailPlanItem.getScheduleBeginDate() != null ? sif2.format(detailPlanItem.getScheduleBeginDate()) : "");
            cowManagerDisplayActivity.setScheduleEndTime(detailPlanItem.getScheduleEndDate() != null ? sif2.format(detailPlanItem.getScheduleEndDate()) : "");
            cowManagerDisplayActivity.setDisplayApplyNum(detailPlanItem.getDisplayQuantity() != null ? String.format("%.2f", detailPlanItem.getDisplayQuantity()) : "0.00");//陈列申请数量
            cowManagerDisplayActivity.setDisplayApplyCost(detailPlanItem.getTotalFeeAmount() != null ? String.format("%.2f", detailPlanItem.getTotalFeeAmount()) : "0.00");//陈列申请费用
//            if(!StringUtils.isEmpty(detailPlanItem.getProductCode())){
                List<CowManagerDisplayActivityItemDto> cowManagerDisplayActivityItemList = new ArrayList<>();
                cowManagerDisplayActivity.setProductLists(cowManagerDisplayActivityItemList);
                CowManagerDisplayActivityItemDto cowManagerDisplayActivityItem = new CowManagerDisplayActivityItemDto();
                cowManagerDisplayActivityItem.setBranCode(detailPlanItem.getProductBrandCode());
                cowManagerDisplayActivityItem.setBranName(detailPlanItem.getProductBrandName());
                cowManagerDisplayActivityItem.setBrandItemCode(detailPlanItem.getProductItemCode());
                cowManagerDisplayActivityItem.setBrandItemName(detailPlanItem.getProductItemName());
                cowManagerDisplayActivityItem.setBrandTypeCode(detailPlanItem.getProductCategoryCode());
                cowManagerDisplayActivityItem.setBrandTypeName(detailPlanItem.getProductCategoryName());
                cowManagerDisplayActivityItem.setProductNo(detailPlanItem.getProductCode());
                cowManagerDisplayActivityItem.setProductName(detailPlanItem.getProductName());
                cowManagerDisplayActivityItemList.add(cowManagerDisplayActivityItem);

//            };
            cowManagerDisplayActivityDtoList.add(cowManagerDisplayActivity);

        });
        return cowManagerDisplayActivityDtoList;
    }

    /**
     * 获取字典值
     *
     * @param mapDict
     * @param dictTypeCode
     * @param code
     * @return
     */
    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (java.util.Objects.isNull(mapDict) || org.apache.commons.lang3.StringUtils.isBlank(dictTypeCode) || org.apache.commons.lang3.StringUtils.isBlank(code)) {
            return org.apache.commons.lang3.StringUtils.EMPTY;
        }
        final List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return org.apache.commons.lang3.StringUtils.EMPTY;
        }
        final Optional<String> first =
                vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse(org.apache.commons.lang3.StringUtils.EMPTY);
    }

    /**
     * 组装促销活动接口数据
     * @param itemList 明细集合
     * @param close 是否关闭 true：关闭
     * @return 待推送的促销活动接口数据
     */

    public List<CowManagerPromotionActivityDto> buildPromotionActivityInterfaceData(List<ActivityDetailPlanItemVo> itemList,boolean close) {
        if(CollectionUtils.isEmpty(itemList)){
            return null;
        }
        Set<String> productCodes = itemList.stream().map(ActivityDetailPlanItemVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> giftCodes = itemList.stream().map(ActivityDetailPlanItemVo::getGiftCode).filter(Objects::nonNull).collect(Collectors.toSet());
        productCodes.addAll(giftCodes);
        ArrayList<String> productCodeList = new ArrayList<>(productCodes);
        //根据产品赠品编码从产品主数据中查询产品详细信息
        List<ProductVo> productMainList = productVoService.findDetailsByIdsOrProductCodes(null, productCodeList);
        List<CowManagerPromotionActivityDto> cowManagerPromotionActivityDtoList = new ArrayList<>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM-dd");
        itemList.forEach(item -> {
            CowManagerPromotionActivityDto cowManagerPromotionActivity = new CowManagerPromotionActivityDto();
            if(close){
                cowManagerPromotionActivity.setActivityStatus("已关闭");
                Date currentDate = new Date();
                cowManagerPromotionActivity.setActivityEndTime(sif2.format(currentDate));
            }else {
                cowManagerPromotionActivity.setActivityStatus("审批通过");
                cowManagerPromotionActivity.setActivityEndTime(item.getActivityEndDate() != null ? sif2.format(item.getActivityEndDate()) : "");
            }
            cowManagerPromotionActivity.setActivityNo(item.getDetailPlanCode());
            cowManagerPromotionActivity.setActiveNumber(item.getDetailPlanItemCode());
            cowManagerPromotionActivity.setCostYearMonth(item.getFeeYearMonth() != null ? sif.format(item.getFeeYearMonth()) : "");
            cowManagerPromotionActivity.setRegionInfo(item.getRegion());
            cowManagerPromotionActivity.setSystemInfo(item.getSystemCode());
            cowManagerPromotionActivity.setStoreId(item.getTerminalCode());
            cowManagerPromotionActivity.setStoreName(item.getTerminalName());
            cowManagerPromotionActivity.setStoreType(item.getTerminalType());
            cowManagerPromotionActivity.setChannelFirst(item.getFirstChannelName());
            cowManagerPromotionActivity.setChannelSecond(item.getSecondChannelName());
            cowManagerPromotionActivity.setActivityStartTime(item.getActivityBeginDate() != null ? sif2.format(item.getActivityBeginDate()) : "");
            cowManagerPromotionActivity.setActivityTypeCode(item.getActivityTypeCode());
            cowManagerPromotionActivity.setActivityTypeName(item.getActivityTypeName());
            cowManagerPromotionActivity.setActivityCode(item.getActivityFormCode());
            cowManagerPromotionActivity.setActivityName(item.getActivityFormName());
            cowManagerPromotionActivity.setActivityDesc(item.getActivityDesc());
            cowManagerPromotionActivity.setOriginalPrice(item.getRetailPrice() != null ? String.format("%.2f", item.getRetailPrice()) : "0.00");
            cowManagerPromotionActivity.setPromotionalPrice(item.getPromotionalPrice() != null ? String.format("%.2f", item.getPromotionalPrice()) : "0.00");
            if(!StringUtils.isEmpty(item.getProductCode())){
                List<CowManagerPromotionActivityItemDto> promotionActivityItemDtoList = new ArrayList<>();
                cowManagerPromotionActivity.setSalesPromotionProductList(promotionActivityItemDtoList);
                ProductVo productVo = productMainList.stream().filter(k -> k.getProductCode().equals(item.getProductCode())).findAny().orElse(null);
                CowManagerPromotionActivityItemDto productDto = new CowManagerPromotionActivityItemDto();
                productDto.setProductType("BP");
                productDto.setProductTypeName("本品");
                productDto.setActivityBrand(productVo.getProductBrandName());
                /* 1031007
                productDto.setPackageNo(productVo.getBarCode());
                 */
                productDto.setPackageNo(productVo.getCartonBarCode());
                productDto.setSapCode(productVo.getProductCode());
                productDto.setSapName(productVo.getProductName());
                productDto.setProdDate(item.getThisProductProductionDate() != null ? sif2.format(item.getThisProductProductionDate()) : null);
                promotionActivityItemDtoList.add(productDto);
                if(!StringUtils.isEmpty(item.getGiftCode())){
                    ProductVo giftVo = productMainList.stream().filter(k -> k.getProductCode().equals(item.getGiftCode())).findAny().orElse(null);
                    CowManagerPromotionActivityItemDto giftDto = new CowManagerPromotionActivityItemDto();
                    giftDto.setProductType("ZP");
                    giftDto.setProductTypeName("赠品");
                    giftDto.setActivityBrand(giftVo.getProductBrandName());
                    /*
                     *giftDto.setPackageNo(giftVo.getBarCode());
                     */
                    giftDto.setPackageNo(giftVo.getCartonBarCode());
                    giftDto.setSapCode(giftVo.getProductCode());
                    giftDto.setSapName(giftVo.getProductName());
                    giftDto.setProdDate(item.getGiftProductionDate() != null ? sif2.format(item.getGiftProductionDate()) : null);
                    promotionActivityItemDtoList.add(giftDto);
                }
            }
            cowManagerPromotionActivityDtoList.add(cowManagerPromotionActivity);
        });
        return cowManagerPromotionActivityDtoList;
    }

    /**
     * 组装临促人员活动接口数据
     * @param itemList 明细集合
     * @param close 是否关闭 true：关闭
     * @return 待推送的临促人员活动接口数据集合
     */
    public List<CowManagerTemporaryPersonnelActivityDto> buildTemporaryPersonnelActivity(List<ActivityDetailPlanItemVo> itemList,boolean close) {
        if(CollectionUtils.isEmpty(itemList)){
            return null;
        }
        List<CowManagerTemporaryPersonnelActivityDto> temporaryPersonnelActivityDtoList = new ArrayList<>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM-dd");
        itemList.forEach(item -> {
            CowManagerTemporaryPersonnelActivityDto temporaryPersonnelActivity = new CowManagerTemporaryPersonnelActivityDto();
            if(close){
                temporaryPersonnelActivity.setActivityStatus("已关闭");
                Date currentDate = new Date();
                temporaryPersonnelActivity.setActivityEndTime(sif2.format(currentDate));
            }else {
                temporaryPersonnelActivity.setActivityStatus("审批通过");
                temporaryPersonnelActivity.setActivityEndTime(item.getActivityEndDate() != null ? sif2.format(item.getActivityEndDate()) : "");
            }
            temporaryPersonnelActivity.setActivityNo(item.getDetailPlanCode());
            temporaryPersonnelActivity.setActiveNumber(item.getDetailPlanItemCode());
            temporaryPersonnelActivity.setCostYearMonth(item.getFeeYearMonth() != null ? sif.format(item.getFeeYearMonth()) : "");
            temporaryPersonnelActivity.setSystemInfo(item.getSystemCode());
            temporaryPersonnelActivity.setStoreId(item.getTerminalCode());
            temporaryPersonnelActivity.setStoreName(item.getTerminalName());
            temporaryPersonnelActivity.setActivityStartTime(item.getActivityBeginDate() != null ? sif2.format(item.getActivityBeginDate()) : "");
            temporaryPersonnelActivity.setActivityTypeCode(item.getActivityTypeCode());
            temporaryPersonnelActivity.setActivityTypeName(item.getActivityTypeName());
            temporaryPersonnelActivity.setActivityCode(item.getActivityFormCode());
            temporaryPersonnelActivity.setActivityName(item.getProductCategoryName());
            temporaryPersonnelActivity.setUserNum(item.getQuantity() != null ? item.getQuantity().toString() : "0.00");
            temporaryPersonnelActivity.setActivityDesc(item.getActivityDesc());
            if(!StringUtils.isEmpty(item.getProductCode())){
                List<CowManagerTemporaryPersonnelActivityItemDto> productLists = new ArrayList<>();
                temporaryPersonnelActivity.setProductLists(productLists);
                CowManagerTemporaryPersonnelActivityItemDto tpProductDto = new CowManagerTemporaryPersonnelActivityItemDto();
                tpProductDto.setBranCode(item.getProductBrandCode());
                tpProductDto.setBranName(item.getProductBrandName());
                tpProductDto.setBrandItemCode(item.getProductItemCode());
                tpProductDto.setBrandItemName(item.getProductItemName());
                tpProductDto.setBrandTypeCode(item.getProductCategoryCode());
                tpProductDto.setBrandTypeName(item.getProductCategoryName());
                tpProductDto.setProductNo(item.getProductCode());
                tpProductDto.setProductName(item.getProductCode());
                productLists.add(tpProductDto);

            };
            temporaryPersonnelActivityDtoList.add(temporaryPersonnelActivity);
        });
        return temporaryPersonnelActivityDtoList;
    }

    /**
     * 组装长促人员活动接口数据
     * @param itemList 明细集合
     * @param close 是否关闭 true：关闭
     * @return  待推送的长促人员活动接口数据集合
     */
    public List<CowManagerLongTermPersonnelActivityDto> buildLongTermPersonnelActivity(List<ActivityDetailPlanItemVo> itemList,boolean close) {
        if(CollectionUtils.isEmpty(itemList)){
            return null;
        }
        List<CowManagerLongTermPersonnelActivityDto> longTermPersonnelActivityDtoList = new ArrayList<>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM-dd");
        itemList.forEach( item -> {
            CowManagerLongTermPersonnelActivityDto longTermPersonnelActivity = new CowManagerLongTermPersonnelActivityDto();
            if(close){
                longTermPersonnelActivity.setActivityStatus("已关闭");
                Date currentDate = new Date();
                longTermPersonnelActivity.setActivityEndTime(sif2.format(currentDate));
            }else {
                longTermPersonnelActivity.setActivityStatus("审批通过");
                longTermPersonnelActivity.setActivityEndTime(item.getActivityEndDate() != null ? sif2.format(item.getActivityEndDate()) : "");
            }
            longTermPersonnelActivity.setActivityNo(item.getDetailPlanCode());
            longTermPersonnelActivity.setActiveNumber(item.getDetailPlanItemCode());
            longTermPersonnelActivity.setCostYearMonth(item.getFeeYearMonth() != null ? sif.format(item.getFeeYearMonth()) : "");
            longTermPersonnelActivity.setRegionInfo(item.getRegion());
            longTermPersonnelActivity.setSystemInfo(item.getSystemCode());
            longTermPersonnelActivity.setStoreId(item.getTerminalCode());
            longTermPersonnelActivity.setStoreName(item.getTerminalName());
            longTermPersonnelActivity.setActivityStartTime(item.getActivityBeginDate() != null ? sif2.format(item.getActivityBeginDate()) : "");
            longTermPersonnelActivity.setActivityTypeCode(item.getActivityTypeCode());
            longTermPersonnelActivity.setActivityTypeName(item.getActivityTypeName());
            longTermPersonnelActivity.setActivityCode(item.getActivityFormCode());
            longTermPersonnelActivity.setActivityName(item.getProductCategoryName());
            longTermPersonnelActivity.setUserName(item.getNameOfShoppingGuide());
            longTermPersonnelActivity.setUserId(item.getEmployeeId());
            longTermPersonnelActivity.setIdNumber(item.getIdentityCard());
            longTermPersonnelActivity.setPhone(item.getTelephone());
            longTermPersonnelActivity.setActivityDesc(item.getActivityDesc());
            if(!StringUtils.isEmpty(item.getProductCode())){
                List<CowManagerLongTermPersonnelActivityItemDto> productLists = new ArrayList<>();
                longTermPersonnelActivity.setProductLists(productLists);
                CowManagerLongTermPersonnelActivityItemDto ltProductDto = new CowManagerLongTermPersonnelActivityItemDto();
                ltProductDto.setBranCode(item.getProductBrandCode());
                ltProductDto.setBranName(item.getProductBrandName());
                ltProductDto.setBrandItemCode(item.getProductItemCode());
                ltProductDto.setBrandItemName(item.getProductItemName());
                ltProductDto.setBrandTypeCode(item.getProductCategoryCode());
                ltProductDto.setBrandTypeName(item.getProductCategoryName());
                ltProductDto.setProductNo(item.getProductCode());
                ltProductDto.setProductName(item.getProductName());
                productLists.add(ltProductDto);
            }
            longTermPersonnelActivityDtoList.add(longTermPersonnelActivity);
        });
        return longTermPersonnelActivityDtoList;
    }


}
