package com.biz.crm.tpm.business.activity.detail.plan.local.service.third;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.sd.sdk.dto.MessageHeaderDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.FreeGoodsInterfaceDto;
import com.biz.crm.mn.third.system.sd.sdk.service.ActivityPushSapApiService;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.FreeGoodsMapping;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.FreeGoodsMappingRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.OperationTypeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormExeDetailVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.CarGiftGroupEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.PromotionTypeEnum;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/2/10
 */
@Slf4j
//@Component
public class ActivityPushFreeGoods {

    @Autowired(required = false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;

    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Autowired(required = false)
    private ActivityPushSapApiService activityPushSapApiService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private FreeGoodsMappingRepository freeGoodsMappingRepository;
    @Autowired(required = false)
    private CustomerVoService customerVoService;


    /**
     * 主体活动 推送 Sap免费货物接口
     * @param detailPlanItemList 明细集合
     * @param operation 新增/修改/删除枚举。
     */
    public void pushActivityToFreeGoods(List<ActivityDetailPlanItemVo> detailPlanItemList, OperationTypeEnum operation){
        if(CollectionUtils.isEmpty(detailPlanItemList) || ObjectUtils.isEmpty(operation)) {
            return;
        }
        List<String> formCodes = detailPlanItemList.stream().map(ActivityDetailPlanItemVo::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map<String, List<ActivityFormExeDetailVo>> activityFormMap = activityFormService.findPushSap(formCodes);
        if(CollectionUtils.isEmpty(activityFormMap)) {
            return;
        }
        Set<String> keySet = activityFormMap.keySet();

        List<ActivityDetailPlanItemVo> itemList = detailPlanItemList.stream()
                .filter(k -> keySet.contains(k.getActivityFormCode()) &&
                        PromotionTypeEnum.PROMOTION_GIFT.getCode().equals(k.getPromotionType()))
                .collect(Collectors.toList());

        this.filterNotPush(itemList,activityFormMap);
        List<FreeGoodsMapping> freeGoodsMappingList = Lists.newArrayList();
        if (!OperationTypeEnum.CREATE.equals(operation)) {
            List<String> detailPlanItemCodeList = itemList.stream().map(ActivityDetailPlanItemVo::getDetailPlanItemCode).collect(Collectors.toList());
            freeGoodsMappingList = freeGoodsMappingRepository.list(Wrappers.<FreeGoodsMapping>lambdaQuery()
                    .in(FreeGoodsMapping::getDetailPlanItemCode,detailPlanItemCodeList)
                    .isNotNull(FreeGoodsMapping::getCondNoNew)
            );
        }
        List<FreeGoodsInterfaceDto> freeGoodsDtoList = this.makeFreeGoodsInterfaceDate(itemList, operation,freeGoodsMappingList);
        //先保存下映射关系数据
        if (OperationTypeEnum.CREATE.equals(operation)) {
            freeGoodsMappingRepository.saveBatch(freeGoodsMappingList);
        }
        this.pushFreeGoods(freeGoodsDtoList);
    }

    /**
     * 过滤不需要推送的活动
     * @param detailPlanItemList
     * @param activityFormMap
     */
    private void filterNotPush(List<ActivityDetailPlanItemVo> detailPlanItemList, Map<String, List<ActivityFormExeDetailVo>> activityFormMap) {
        if(CollectionUtils.isEmpty(detailPlanItemList)){
            return;
        }
        if(CollectionUtils.isEmpty(activityFormMap) || CollectionUtils.isEmpty(activityFormMap.keySet())){
            detailPlanItemList.clear();
        }
        //推送sap的活动形式编码
        Set<String> formCodes = activityFormMap.keySet();
        Iterator<ActivityDetailPlanItemVo> iterator = detailPlanItemList.iterator();
        while (iterator.hasNext()) {
            ActivityDetailPlanItemVo next = iterator.next();
            if(!formCodes.contains(next.getActivityFormCode())){
                iterator.remove();
            }
        }

    }

    /**
     * 组装 SD160 免费货物接口数据
     * @param itemVoList 活动细案明细集合
     * @param operation 操作类型枚举
     */
    private List<FreeGoodsInterfaceDto> makeFreeGoodsInterfaceDate(List<ActivityDetailPlanItemVo> itemVoList,OperationTypeEnum operation,List<FreeGoodsMapping> freeGoodsMappingList){
        if(CollectionUtils.isEmpty(itemVoList)){
            return Lists.newArrayList();
        }
        Set<String> salesInstitutionCodes = itemVoList.stream().map(ActivityDetailPlanItemVo::getSalesInstitutionCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> salesRegionCodes = itemVoList.stream().map(ActivityDetailPlanItemVo::getSalesRegionCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> salesOrgCodes = itemVoList.stream().map(ActivityDetailPlanItemVo::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List<String> sapOrgCodes = new ArrayList<>();
        sapOrgCodes.addAll(salesInstitutionCodes);
        sapOrgCodes.addAll(salesRegionCodes);
        sapOrgCodes.addAll(salesOrgCodes);
        Map<String, String> sapCodesMap = salesOrgVoService.findSapCodesBySalesOrgCodes(sapOrgCodes);
        List<String> customerCodes = itemVoList.stream().map(ActivityDetailPlanItemVo::getCustomerCode).distinct().collect(Collectors.toList());
        List<CustomerVo> customerVoList = customerVoService.findByCustomerCodes(customerCodes);
        Map<String, CustomerVo> customerVoMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(customerVoList)) {
            customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity(),(v1,v2) -> v2));
        }
        List<FreeGoodsInterfaceDto> list = new ArrayList<>();
        itemVoList.forEach( item -> {
        });
        int i = 0;

        Map<String, FreeGoodsMapping> freeGoodsMappingMap = freeGoodsMappingList.stream().collect(Collectors.toMap(FreeGoodsMapping::getDetailPlanItemCode, Function.identity(),(o,n) -> n));
        for (ActivityDetailPlanItemVo item : itemVoList ) {

            FreeGoodsInterfaceDto dto = new FreeGoodsInterfaceDto();
            FreeGoodsInterfaceDto.Item1 item1 = this.takeItem1DataFromItem(item,operation,sapCodesMap,customerVoMap);
            if(!ObjectUtils.isEmpty(item1)) {
                dto.setITEM1(new ArrayList<>());
                dto.getITEM1().add(item1);

                FreeGoodsInterfaceDto.Item2 item2 = this.takeItem2DataFromItem(item,operation);
                dto.setITEM2(Lists.newArrayList(item2));

                ++i;

                if (OperationTypeEnum.CREATE.equals(operation)){
                    item1.setCOND_NO("$"+String.format("%09d",i));
                    item2.setCOND_NO("$"+String.format("%09d",i));

                    String messageId = UuidCrmUtil.general();
                    dto.setMessageHeader(new MessageHeaderDto(){{
                        this.setMessageId(messageId);
                    }});

                    FreeGoodsMapping freeGoodsMapping = new FreeGoodsMapping();
                    freeGoodsMapping.setDetailPlanCode(item.getDetailPlanCode());
                    freeGoodsMapping.setDetailPlanItemCode(item.getDetailPlanItemCode());
                    freeGoodsMapping.setCondNo(item1.getCOND_NO());
                    freeGoodsMapping.setMessageId(messageId);
                    freeGoodsMappingList.add(freeGoodsMapping);
                }else{
                    FreeGoodsMapping freeGoodsMapping = freeGoodsMappingMap.get(item.getDetailPlanItemCode());
                    if (null == freeGoodsMapping){
                        break;//错误数据
                    }
                    item1.setCOND_NO(freeGoodsMapping.getCondNoNew());
                    item2.setCOND_NO(freeGoodsMapping.getCondNoNew());
                }

                list.add(dto);
            }
        }

        return list;
    }


    /**
     * 从明细中提取 SD160Item1信息
     * @param item 明细对象
     * @param operation 操作类型枚举
     * @param customerVoMap
     * @return
     */
    private FreeGoodsInterfaceDto.Item1 takeItem1DataFromItem(ActivityDetailPlanItemVo item, OperationTypeEnum operation, Map<String, String> sapCodesMap, Map<String, CustomerVo> customerVoMap) {
        if (ObjectUtils.isEmpty(item)) {
            return null;
        }
        FreeGoodsInterfaceDto.Item1 item1 = new FreeGoodsInterfaceDto.Item1();
        String varKey = this.takeCarGiftGroupItem(item,sapCodesMap,customerVoMap);
        if(StringUtils.isBlank(varKey)) {
            return null;
        }
        item1.setVARKEY(varKey);

        SimpleDateFormat sif = new SimpleDateFormat("yyyyMMdd");
        item1.setOPERATION(operation.getCode());
        item1.setCOND_USAGE("N");
        item1.setAPPLICATIO("V");
        item1.setCOND_TYPE("ZFG");
        item1.setVALID_FROM(item.getOrderBeginDate() != null ? sif.format(item.getOrderBeginDate()) : null);
        item1.setVALID_TO(item.getOrderEndDate() != null ? sif.format(item.getOrderEndDate()) : null);
        item1.setTABLE_NO(item.getCarGiftGroup());

        return item1;
    }

    /**
     * 随车搭赠组合详情
     *      销售机构编码 = 渠道+业态+SAP编码
     *      销售部门编码 = 渠道+业态+SAP销售机构编码+SAP销售部门编码
     *      销售组编码  = 渠道(2位)+业态(2位)+SAP销售机构编码(4位)+SAP销售部门编码(4位)+SAP销售组编码(3位)
     * @param item 明细
     * @param sapCodesMap
     * @param customerVoMap
     * @return
     */
    private String takeCarGiftGroupItem(ActivityDetailPlanItemVo item, Map<String, String> sapCodesMap, Map<String, CustomerVo> customerVoMap) {
        if (ObjectUtils.isEmpty(item) || StringUtils.isBlank(item.getCarGiftGroup())) {
            return "";
        }
        String varKay = "";
        String carGiftGroup = item.getCarGiftGroup();
        if(CarGiftGroupEnum.GroupA.getCode().equals(carGiftGroup)){
            String instiCode = "";
            String regionCode = "";
            if(StringUtils.isNotBlank(item.getSalesOrgCode()) && item.getSalesOrgCode().length() >= 15){
                instiCode = item.getSalesOrgCode().substring(4,8);
                regionCode = item.getSalesOrgCode().substring(8,12);
            }else if(StringUtils.isNotBlank(item.getSalesRegionCode()) && item.getSalesRegionCode().length() >= 12){
                instiCode = item.getSalesRegionCode().substring(4,8);
                regionCode = item.getSalesRegionCode().substring(8,12);
            }
            if (StringUtils.isNotBlank(instiCode) && StringUtils.isNotBlank(regionCode) && StringUtils.isNotBlank(item.getCustomerGroupCode()) && StringUtils.isNotBlank(item.getProductCode())) {
                varKay =  instiCode + "/"+ regionCode +"/"+item.getCustomerGroupCode()+"/"+item.getProductCode();
            }
        }
        if(CarGiftGroupEnum.GroupB.getCode().equals(carGiftGroup)){
            String customerCode = item.getCustomerCode();
            String salesOrgCode = "";
            if (StringUtils.isNotBlank(customerCode)){
                CustomerVo customerVo = customerVoMap.get(customerCode);
                if (!Objects.isNull(customerVo)) {
                    customerCode = customerVo.getErpCode();
                }
            }
            if(StringUtils.isNotBlank(item.getSalesOrgCode()) && item.getSalesOrgCode().length() >= 15){
                salesOrgCode = item.getSalesOrgCode().substring(4,8);
            }else if(StringUtils.isNotBlank(item.getSalesRegionCode()) && item.getSalesRegionCode().length() >= 12){
                salesOrgCode = item.getSalesRegionCode().substring(4,8);
            }else if(StringUtils.isNotBlank(item.getSalesInstitutionCode()) && item.getSalesInstitutionCode().length() >= 4){
                salesOrgCode = item.getSalesInstitutionCode().substring(4);
            }
            if (StringUtils.isNotBlank(salesOrgCode) && StringUtils.isNotBlank(customerCode) && StringUtils.isNotBlank(item.getProductCode())) {
                varKay = salesOrgCode + "/" + customerCode + "/" + item.getProductCode();
            }
        }
        if(CarGiftGroupEnum.GroupC.getCode().equals(carGiftGroup)){
            String instCode = "";
            String saleCode = "";
            if(StringUtils.isNotBlank(item.getSalesOrgCode()) && item.getSalesOrgCode().length() >= 15){
                instCode = item.getSalesOrgCode().substring(4,8);
                saleCode = item.getSalesOrgCode().substring(12,15);
            }
            if(StringUtils.isNotBlank(instCode) && StringUtils.isNotBlank(saleCode) && StringUtils.isNotBlank(item.getCustomerGroupCode()) && StringUtils.isNotBlank(item.getProductCode())) {
                varKay = instCode+"/"+saleCode+"/"+item.getCustomerGroupCode()+"/"+item.getProductCode();
            }
        }
        if(CarGiftGroupEnum.GroupD.getCode().equals(carGiftGroup)){
            String instCode = "";
            String saleCode = "";
            if(StringUtils.isNotBlank(item.getSalesOrgCode()) && item.getSalesOrgCode().length() >= 15){
                instCode = item.getSalesOrgCode().substring(4,8);
                saleCode = item.getSalesOrgCode().substring(12,15);
            }
            if(StringUtils.isNotBlank(instCode) && StringUtils.isNotBlank(saleCode) && StringUtils.isNotBlank(item.getDistributionChannelCode())
                    && StringUtils.isNotBlank(item.getCustomerGroupCode()) && StringUtils.isNotBlank(item.getProductCode())) {
                varKay = instCode +"/"+item.getDistributionChannelCode()+"/"+ saleCode +"/"+item.getCustomerGroupCode()+"/"+item.getProductCode();
            }
        }
        if(CarGiftGroupEnum.GroupE.getCode().equals(carGiftGroup)){
            String instCode = "";
            String regionCode = "";
            if(StringUtils.isNotBlank(item.getSalesRegionCode()) && item.getSalesRegionCode().length() >= 12){
                instCode = item.getSalesRegionCode().substring(4,8);
                regionCode = item.getSalesRegionCode().substring(8,12);
            }
            if(StringUtils.isNotBlank(instCode) && StringUtils.isNotBlank(regionCode) && StringUtils.isNotBlank(item.getDistributionChannelCode())
                    && StringUtils.isNotBlank(item.getCustomerGroupCode()) && StringUtils.isNotBlank(item.getProductCode())) {
                varKay = instCode +"/"+item.getDistributionChannelCode()+"/"+ regionCode +"/"+item.getCustomerGroupCode()+"/"+item.getProductCode();
            }
        }
        if(CarGiftGroupEnum.GroupF.getCode().equals(carGiftGroup)){
            if(StringUtils.isNotBlank(item.getSalesInstitutionCode()) && item.getSalesInstitutionCode().length() >= 4
                    && StringUtils.isNotBlank(item.getDistributionChannelCode()) && StringUtils.isNotBlank(item.getProductCode())){
                String code = item.getSalesInstitutionCode().substring(4);
                varKay = code +"/"+item.getDistributionChannelCode()+"/"+item.getProductCode();
            }
        }
        if(CarGiftGroupEnum.GroupG.getCode().equals(carGiftGroup)){
            if(StringUtils.isNotBlank(item.getSalesInstitutionCode()) && item.getSalesInstitutionCode().length() >= 4
                    && StringUtils.isNotBlank(item.getDistributionChannelCode()) && StringUtils.isNotBlank(item.getCustomerGroupCode()) && StringUtils.isNotBlank(item.getProductCode())){
                String code = item.getSalesInstitutionCode().substring(4);
                varKay = code +"/"+item.getDistributionChannelCode()+"/"+item.getCustomerGroupCode()+"/"+item.getProductCode();
            }
        }
        if(CarGiftGroupEnum.GroupH.getCode().equals(carGiftGroup)){
            String saleCode = "";
            if(StringUtils.isNotBlank(item.getSalesOrgCode()) && item.getSalesOrgCode().length() >= 15){
                saleCode = item.getSalesOrgCode().substring(4,8);
            }else if(StringUtils.isNotBlank(item.getSalesRegionCode()) && item.getSalesRegionCode().length() >= 12){
                saleCode = item.getSalesRegionCode().substring(4,8);
            }else if(StringUtils.isNotBlank(item.getSalesInstitutionCode()) && item.getSalesInstitutionCode().length() >= 4){
                saleCode = item.getSalesInstitutionCode().substring(4);
            }
            if(StringUtils.isNotBlank(saleCode) && StringUtils.isNotBlank(item.getProductCode())) {
                varKay = saleCode +"/"+item.getProductCode();
            }
        }
        if(CarGiftGroupEnum.GroupI.getCode().equals(carGiftGroup)){
            if (StringUtils.isNotBlank(item.getSalesInstitutionCode()) && item.getSalesInstitutionCode().length() >= 4
                    && StringUtils.isNotBlank(item.getCustomerGroupCode()) && StringUtils.isNotBlank(item.getProductCode())) {
                String code = item.getSalesInstitutionCode().substring(4);
                varKay = code +"/"+item.getCustomerGroupCode()+"/"+item.getProductCode();
            }
        }
        return varKay;
    }

    /**
     * 从明细中提取 SD160Item2信息
     * @param item 明细对象
     * @param operation 操作类型枚举
     * @return
     */
    private FreeGoodsInterfaceDto.Item2 takeItem2DataFromItem(ActivityDetailPlanItemVo item,OperationTypeEnum operation) {
        if (ObjectUtils.isEmpty(item)) {
            return null;
        }
        FreeGoodsInterfaceDto.Item2 item2 = new FreeGoodsInterfaceDto.Item2();
        item2.setOPERATION(operation.getCode());
        int productQuantity = item.getProductQuantity() != null ? item.getProductQuantity() : 0;
        int giftQuantity = item.getGiftQuantity() != null ? item.getGiftQuantity() : 0;
        item2.setMIN_FG_QNT(String.valueOf(productQuantity + giftQuantity));
        item2.setFG_QNT(String.valueOf(productQuantity + giftQuantity));
        item2.setUNITFG_QNT("PC");
        item2.setADD_FG_QNT(String.valueOf(giftQuantity));
        item2.setUNITADDQNT("PC");
        item2.setTABLE_NO(item.getCarGiftGroup());
        item2.setCALC_TYPE("2");
        item2.setEXCL_INCL("1");
        item2.setCOND_USAGE("N");
        item2.setAPPLICATIO("V");
        item2.setCOND_TYPE("ZFG");
        return item2;
    }

    /**
     * 推送
     * @param freeGoodsDtoList 待推送的数据集合
     */
    private void pushFreeGoods(List<FreeGoodsInterfaceDto> freeGoodsDtoList) {
        if(CollectionUtils.isEmpty(freeGoodsDtoList)) {
            return;
        }
        freeGoodsDtoList.forEach( goods -> {
            try {
                activityPushSapApiService.pushFeeGoodsMaintenance(goods);
            } catch (Exception e) {
                log.error("活动细案活动 明细编码[ " + goods.getITEM1().get(0).getCOND_NO() + " ],推送失败！");
                e.printStackTrace();
            }
        });
    }

}
