package com.biz.crm.tpm.business.activity.detail.plan.local.service.third;

import com.biz.crm.mn.third.system.sd.sdk.dto.activity.CreatePromotionActivityBranchDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.UpdatePromotionActivityBranchDto;
import com.biz.crm.mn.third.system.sd.sdk.service.ActivityPushSapApiService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormExeDetailVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanWhereFrom;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/1/16
 */
@Slf4j
@Component
public class ActivityPushSapBranch {

    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Autowired(required = false)
    private ActivityPlanSdkService activityPlanSdkService;

    @Autowired(required = false)
    private ActivitySapBranchInterData activitySapBranchInterData;

    @Autowired(required = false)
    private ActivityPushSapApiService activityPushSapApiService;


    /**
     * 促销活动创建——分公司
     *
     * @param detailPlanItemList
     */
    public void createPromotionActivityBranch(List<ActivityDetailPlanItemVo> detailPlanItemList){
        if(CollectionUtils.isEmpty(detailPlanItemList)){
            return;
        }
        //需推送SAP的活动形式编码和核销方式
        List<String> formCodes = detailPlanItemList.stream().map(ActivityDetailPlanItemVo::getActivityFormCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, List<ActivityFormExeDetailVo>> activityFormMap = activityFormService.findPushSap(formCodes);
        if (CollectionUtils.isEmpty(activityFormMap)) {
            return;
        }

        this.removeNotPushWithDetailPlanItem(detailPlanItemList, activityFormMap);
        List<CreatePromotionActivityBranchDto> dtoList = activitySapBranchInterData.buildDetailPlanItemForCreateInter(detailPlanItemList);
        this.validateCreateData(dtoList);
        for (CreatePromotionActivityBranchDto dto : dtoList) {
            activityPushSapApiService.pushCreatePromotionActivityBranch(dto);
        }
    }



    /**
     * 校验活动创建待推送的数据
     *
     * @param dtoList
     */
    private void validateCreateData(List<CreatePromotionActivityBranchDto> dtoList) {
        dtoList.forEach(dto -> {
            String itemCode = dto.getITEM1().get(0).getZFCXHD();
            Validate.notBlank(itemCode,"促销活动号不能为空！");
            Validate.notBlank(dto.getITEM1().get(0).getVKORG(),"明细[ "+itemCode+" ] 销售机构不能为空！");
            Validate.notBlank(dto.getITEM1().get(0).getVTWEG(),"明细[ "+itemCode+" ] 分销渠道不能为空！");
            Validate.notBlank(dto.getITEM1().get(0).getZFHDBQ(),"明细[ "+itemCode+" ] 促销活动便笺号不能为空！");
            Validate.notBlank(dto.getITEM1().get(0).getZFHDFAM(),"明细[ "+itemCode+" ] 细案名称不能为空！");
            Validate.notBlank(dto.getITEM1().get(0).getZFHDXS(),"明细[ "+itemCode+" ] 活动形式编号不能为空！");
            Validate.notBlank(dto.getITEM1().get(0).getZFCXKUN(),"明细[ "+itemCode+" ] 执行客户编号不能为空！");
            Validate.notBlank(dto.getITEM1().get(0).getZFSQFY(),"明细[ "+itemCode+" ] 申请费用不能为空！");
            Validate.notBlank(dto.getITEM1().get(0).getDATAB(),"明细[ "+itemCode+" ] 开始生效日期不能为空！");
            Validate.notBlank(dto.getITEM1().get(0).getDATBI(),"明细[ "+itemCode+" ] 有效截至日期不能为空！");
            Validate.notBlank(dto.getITEM1().get(0).getZFBEGIN(),"明细[ "+itemCode+" ] 订单开始日期不能为空！");
            Validate.notBlank(dto.getITEM1().get(0).getZFEND(),"明细[ "+itemCode+" ] 订单结束日期不能为空！");
            Validate.notBlank(dto.getITEM1().get(0).getZFHXFS(),"明细[ "+itemCode+" ] 核销方式不能为空！");
            Validate.notBlank(dto.getITEM3().get(0).getZFYT(),"明细[ "+itemCode+" ] 业态不能为空！");
            Validate.notBlank(dto.getITEM3().get(0).getVRKME(),"明细[ "+itemCode+" ] 销售单位不能为空！");
        });
    }

    /**
     * 促销活动变更/关闭——分公司
     *
     * @param detailPlanItemList
     */
    public void updateOrClosePromotionActivityBranch(List<ActivityDetailPlanItemVo> detailPlanItemList,boolean close){
        if (CollectionUtils.isEmpty(detailPlanItemList)){
            return;
        }
        //需推送SAP的活动形式编码和核销方式
        List<String> formCodes = detailPlanItemList.stream().map(ActivityDetailPlanItemVo::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map<String, List<ActivityFormExeDetailVo>> activityFormMap = activityFormService.findPushSap(formCodes);
        if (CollectionUtils.isEmpty(activityFormMap)) {
            return;
        }
        this.removeNotPushWithDetailPlanItem(detailPlanItemList, activityFormMap);
        List<UpdatePromotionActivityBranchDto> updateDto = activitySapBranchInterData.buildDetailPlanItemForUpdateInter(detailPlanItemList,close);
        updateDto.forEach( dto -> {
            activityPushSapApiService.pushUpdatePromotionActivityBranch(dto);
        });
    }



    /**
     * 根据活动形式编码+核销方式匹配，剔除不需推送第三发系统的明细
     * @param planItemList 明细集合
     * @param activityFormMap 需推送第三方的活动形式map（key:活动形式编码集合，value:核销方式）
     */

    private void removeNotPushWithDetailPlanItem(List<ActivityDetailPlanItemVo> planItemList, Map<String, List<ActivityFormExeDetailVo>> activityFormMap) {
        if (CollectionUtils.isEmpty(planItemList)) {
            return;
        }
        if (CollectionUtils.isEmpty(activityFormMap)) {
            planItemList.clear();
        }
        Iterator<ActivityDetailPlanItemVo> it = planItemList.iterator();
        while (it.hasNext()) {
            ActivityDetailPlanItemVo next = it.next();
            if (!activityFormMap.containsKey(next.getActivityFormCode())) {
                it.remove();
            }
        }
        //垂直的查询关联的方案，如果是未匹配费用单、未匹配结算单，不推送SAP
        List<String> planCodeList = planItemList.stream().map(ActivityDetailPlanItemVo::getRelatePlanCode).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(planCodeList)){
            List<ActivityPlanVo> planList = activityPlanSdkService.findByPlanCodeList(Sets.newHashSet(planCodeList));
            if (CollectionUtils.isEmpty(planList)){
                throw new RuntimeException("关联活动方案查询失败！");
            }
            Map<String, ActivityPlanVo> planMap = planList.stream().collect(Collectors.toMap(ActivityPlanVo::getPlanCode, Function.identity()));
            Iterator<ActivityDetailPlanItemVo> iterator = planItemList.iterator();
            while (iterator.hasNext()){
                ActivityDetailPlanItemVo detailPlanItemVo = iterator.next();
                if (StringUtils.isEmpty(detailPlanItemVo.getRelatePlanCode())){
                    continue;
                }
                ActivityPlanVo planVo = planMap.get(detailPlanItemVo.getRelatePlanCode());
                if (!ActivityPlanWhereFrom.MANUAL.getCode().equals(planVo.getWhereFrom())){
                    iterator.remove();
                }
            }
        }
    }

}
