package com.biz.crm.tpm.business.activity.detail.plan.local.service.third;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.CreatePromotionActivityBranchDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.UpdatePromotionActivityBranchDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.SapInterfaceEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.promotion.policy.sdk.service.PromotionPolicyService;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/1/16
 */
@Slf4j
@Component
public class ActivitySapBranchInterData {


    @Autowired(required = false)
    private PromotionPolicyService promotionPolicyService;

    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;


    /**
     * 组装sap-促销活动创建-分公司接口数据
     *
     * @param planItemList 明细集合
     * @return
     */
    public List<CreatePromotionActivityBranchDto> buildDetailPlanItemForCreateInter(List<ActivityDetailPlanItemVo> planItemList) {
        if(CollectionUtils.isEmpty(planItemList)){
            return Lists.newArrayList();
        }
        Map<String, String> sapCodeMap = this.getSapCodeMap(planItemList);
        List<String> salesCodes = planItemList.stream().map(ActivityDetailPlanItemVo::getActivityOrgCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map<String, String> sapSalesMap = salesOrgVoService.findSapCodesBySalesOrgCodes(salesCodes);
        List<CreatePromotionActivityBranchDto> dtoList = new ArrayList<>();

        //共用类型明细
        List<ActivityDetailPlanItemVo> shareList = planItemList.stream()
                .filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getPublicOrNot()))
                .collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(shareList)){
            //按活动便签号分组
            Map<String, List<ActivityDetailPlanItemVo>> activityMap = shareList.stream()
                    .collect(Collectors.groupingBy(k -> k.getActivityNumber() + k.getDetailPlanCode()));
            for (Map.Entry<String, List<ActivityDetailPlanItemVo>> entry : activityMap.entrySet()) {
                List<ActivityDetailPlanItemVo> items = entry.getValue();
                List<CreatePromotionActivityBranchDto> dto = this.takeShareItemData(items,sapCodeMap,sapSalesMap);
                dtoList.addAll(dto);
            }
        }

        //不共用类型明细
        List<ActivityDetailPlanItemVo> noShareList = planItemList.stream()
                .filter(k -> BooleanEnum.FALSE.getCapital().equals(k.getPublicOrNot()))
                .collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(noShareList)) {
            noShareList.forEach( item -> {
                CreatePromotionActivityBranchDto dto = new CreatePromotionActivityBranchDto();
                dto.setITEM1(new ArrayList<>());
                CreatePromotionActivityBranchDto.Item1 item1 = this.takeItem1FromPlanItem(item, sapCodeMap,sapSalesMap);
                dto.getITEM1().add(item1);
                dto.setITEM3(new ArrayList<>());
                CreatePromotionActivityBranchDto.Item3 item3 = this.takeItem3FromPlanItem(item);
                dto.getITEM3().add(item3);
                dtoList.add(dto);
            });
        }

        for (CreatePromotionActivityBranchDto createPromotionActivityBranchDto : dtoList) {
            if (!CollectionUtils.isEmpty(createPromotionActivityBranchDto.getITEM3())){
                int i = 0;
                for (CreatePromotionActivityBranchDto.Item3 item3 : createPromotionActivityBranchDto.getITEM3()) {
                    item3.setZFHDITEM(item3.getZFCXHD()+String.format("%04d",++i));
                }
            }
        }

        return dtoList;
    }

    /**
     * 提取同管控组明细数据
     * @param items 同组明细集合
     * @param sapCodeMap sap编码集合
     * @return
     */
    private List<CreatePromotionActivityBranchDto> takeShareItemData(List<ActivityDetailPlanItemVo> items, Map<String, String> sapCodeMap,Map<String, String> sapSaleMap) {
        if(CollectionUtils.isEmpty(items)) {
            return Lists.newArrayList();
        }
        List<CreatePromotionActivityBranchDto> dtoList = new ArrayList<>();
        items.forEach( item -> {
            CreatePromotionActivityBranchDto dto = new CreatePromotionActivityBranchDto();
            dto.setITEM1(new ArrayList<>());
            CreatePromotionActivityBranchDto.Item1 item1 = this.takeItem1FromPlanItem(item, sapCodeMap,sapSaleMap);
            dto.getITEM1().add(item1);

            dto.setITEM2(new ArrayList<>());
            CreatePromotionActivityBranchDto.Item2  item2 = new CreatePromotionActivityBranchDto.Item2();
            //本组总计'申请费用'
            BigDecimal totalCost = items.stream().map(ActivityDetailPlanItemVo::getTotalFeeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            item2.setZFHDBQ(item.getActivityNumber());
            item2.setZFSQFY(String.format("%.2f", totalCost));
            item2.setZFSQCXL(item.getStoreUtility() != null ? item.getStoreUtility().toString() : "0.000");
            dto.getITEM2().add(item2);
            dto.setITEM3(new ArrayList<>());
            CreatePromotionActivityBranchDto.Item3 item3 = takeItem3FromPlanItem(item);
            dto.getITEM3().add(item3);
            dtoList.add(dto);
        });

        return dtoList;
    }


    /**
     * 从明细中提取出接口Item1对象数据
     * @param planItem 明细
     * @param sapCodeMap sap编码集合
     * @return
     */
    private CreatePromotionActivityBranchDto.Item1 takeItem1FromPlanItem(ActivityDetailPlanItemVo planItem,Map<String,String> sapCodeMap,Map<String,String> sapSaleMap){
        CreatePromotionActivityBranchDto.Item1 item1 = new CreatePromotionActivityBranchDto.Item1();
        SimpleDateFormat sif = new SimpleDateFormat("yyyyMMdd");
        item1.setZFCXHD(planItem.getDetailPlanItemCode());
        if(!StringUtils.isBlank(planItem.getActivityOrgCode())){
            item1.setVKORG(sapSaleMap.get(planItem.getActivityOrgCode()));
        }
//        item1.setVTWEG(planItem.getDistributionChannelCode());
        item1.setVTWEG("A1");
        item1.setZFHDBQ(planItem.getActivityNumber());
        item1.setZFHDFAM(planItem.getDetailPlanName());
        item1.setZFCXKUN(planItem.getTerminalCode());
        item1.setZFHDGROUP(BooleanEnum.TRUE.getCapital().equals(planItem.getPublicOrNot()) ? "X" : "");
        if(!StringUtils.isBlank(planItem.getActivityFormCode())){
            item1.setZFHDXS(sapCodeMap.get(planItem.getActivityFormCode()));
        }
        item1.setZFSQFY(planItem.getFeeAmount() != null ? String.format("%.2f", planItem.getFeeAmount()) : "0.00");
        item1.setWAERS("CNY");
        item1.setDATAB(planItem.getActivityBeginDate() != null ? sif.format(planItem.getActivityBeginDate()) : null);
        item1.setDATBI(planItem.getActivityEndDate() != null ? sif.format(planItem.getActivityEndDate()) : null);
        item1.setZFBEGIN(planItem.getOrderBeginDate() != null ? sif.format(planItem.getOrderBeginDate()) : null);
        item1.setZFEND(planItem.getOrderEndDate() != null ? sif.format(planItem.getOrderEndDate()) : null);
        item1.setZFHXFS(StringUtils.isEmpty(planItem.getWriteOffMethod()) ? "" : (SapInterfaceEnum.THINGS.getCode().equals(planItem.getWriteOffMethod()) ? SapInterfaceEnum.THINGS.getValue() : SapInterfaceEnum.AFTER_THE_EVENT.getValue()));
        item1.setZFHDZT(SapInterfaceEnum.VALID.getCode());
        return item1;
    }


    /**
     * 从明细中提取出接口Item3对象数据
     *
     * @param item 明细
     * @return
     */
    private CreatePromotionActivityBranchDto.Item3 takeItem3FromPlanItem(ActivityDetailPlanItemVo item) {
        CreatePromotionActivityBranchDto.Item3 item3 = new CreatePromotionActivityBranchDto.Item3();
        item3.setZFCXHD(item.getDetailPlanItemCode());
        item3.setZFHDITEM(item.getDetailPlanItemCode());
        item3.setZFCXKUN(item.getTerminalCode());


        DictDataVo businessFormatCodeVo = dictDataVoService.findByDictTypeCodeAndDictCode(ActivityDetailPlanConstant.MDM_BUSINESS_FORMAT, item.getBusinessFormatCode());
        Validate.notNull(businessFormatCodeVo,"未查询到业态【%s】的数据字典",item.getBusinessFormatCode());
        Map<String, String> extendMap = businessFormatCodeVo.getExtendMap();
        if(extendMap != null ){
            String zfyt = extendMap.get(ActivityDetailPlanConstant.MDM_BUSINESS_FORMAT_SAP);
            // 业态
            item3.setZFYT(zfyt);
        }
        item3.setZFPP(item.getProductBrandCode());
        item3.setZFPL(item.getProductCategoryCode());
        item3.setZFPX(item.getProductItemCode());
        item3.setMATNR(item.getProductCode());
        item3.setKBETR(item.getPromotionPriceTax() != null ? String.format("%.2f", item.getPromotionPriceTax()) : "0.00");
        item3.setZFYPSL(item.getProductQuantity() != null ? item.getProductQuantity().toString() : "0.000");
        item3.setZFCPBM(item.getGiftCode());
        item3.setZFCPSL(item.getGiftQuantity() != null ?  item.getGiftQuantity().toString() : "0.000");
        item3.setVRKME("PC");
        item3.setWAERS("CNY");
        item3.setZFXSSM(item.getRemark());
        //item3.setZFXSSM(item.getActivityDesc());
        item3.setZFHDLD(item.getActivityDesc());
        if(BooleanEnum.TRUE.getCapital().equals(item.getPublicOrNot())) {
            item3.setZFSQFY(item.getFloatingAmount() != null ? String.format("%.2f", item.getFloatingAmount()) : "0.00");
            item3.setZFSQCXL(item.getFloatingNumber() != null ? String.format("%.3f", item.getFloatingNumber()) : "0.00");
        }else{
            item3.setZFSQFY(item.getFeeAmount() != null ? String.format("%.2f", item.getFeeAmount()) : "0.00");
            item3.setZFSQCXL(item.getPeriodPromotionalNumber() != null ? item.getPeriodPromotionalNumber().toString() : "0.000");
        }
        return item3;
    }


    /**
     * 组装待推送的变更数据
     *
     * @param detailPlanItemList 明细集合
     * @return
     */
    public List<UpdatePromotionActivityBranchDto> buildDetailPlanItemForUpdateInter(List<ActivityDetailPlanItemVo> detailPlanItemList, boolean close) {
        if(CollectionUtils.isEmpty(detailPlanItemList)){
            return null;
        }
        List<UpdatePromotionActivityBranchDto> list = new ArrayList<>();
        SimpleDateFormat sif = new SimpleDateFormat("yyyyMMdd");
        detailPlanItemList.forEach( detailPlanItem -> {
            UpdatePromotionActivityBranchDto updateDto = new UpdatePromotionActivityBranchDto();
            updateDto.setITEM1(new ArrayList<>());
            updateDto.setITEM2(new ArrayList<>());
            updateDto.setITEM3(new ArrayList<>());

            UpdatePromotionActivityBranchDto.Item1 item1 = new UpdatePromotionActivityBranchDto.Item1();
            item1.setZFCXHD(detailPlanItem.getDetailPlanItemCode());
            item1.setZFSQFY_H(detailPlanItem.getFeeAmount() != null ? String.format("%.2f", detailPlanItem.getFeeAmount()) : "0.00");
            item1.setDATAB(detailPlanItem.getActivityBeginDate() != null ? sif.format(detailPlanItem.getActivityBeginDate()) : "");
            item1.setZFBEGIN(detailPlanItem.getOrderBeginDate() != null ? sif.format(detailPlanItem.getOrderBeginDate()) : "");
            if(close){
                Date currentDate = new Date();
                item1.setDATBI(detailPlanItem.getActivityEndDate() != null ? sif.format(currentDate) : null);
                item1.setZFEND(detailPlanItem.getOrderEndDate() != null ? sif.format(currentDate) : null);
                item1.setZFHDZT(SapInterfaceEnum.INVALID.getCode());
            }else{
                item1.setZFEND(detailPlanItem.getOrderEndDate() != null ? sif.format(detailPlanItem.getOrderEndDate()) : null);
                item1.setDATBI(detailPlanItem.getActivityEndDate() != null ? sif.format(detailPlanItem.getActivityEndDate()) : null);
                item1.setZFHDZT(SapInterfaceEnum.VALID.getCode());
            }
            updateDto.getITEM1().add(item1);

            UpdatePromotionActivityBranchDto.Item2 item2 = new UpdatePromotionActivityBranchDto.Item2();
            item2.setZFCXHD(detailPlanItem.getDetailPlanItemCode());
            item2.setZFHDITEM(detailPlanItem.getDetailPlanItemCode());
            if (BooleanEnum.TRUE.getCapital().equals(detailPlanItem.getPublicOrNot())){
                item2.setZFSQFY_I(detailPlanItem.getTerminalTotalAmount() != null ? String.format("%.2f", detailPlanItem.getTerminalTotalAmount()) : "0.00");
                item2.setZFSQCXL(detailPlanItem.getTerminalTotalQuantity() != null ? String.format("%.3f", detailPlanItem.getTerminalTotalQuantity()) : "0.000");
            }else {
                item2.setZFSQFY_I(detailPlanItem.getFeeAmount() != null ? String.format("%.2f", detailPlanItem.getFeeAmount()) : "0.00");
                item2.setZFSQCXL(detailPlanItem.getPeriodPromoteQuantity() != null ? String.format("%.3f", detailPlanItem.getPeriodPromoteQuantity()) : "0.000");
            }
            updateDto.getITEM2().add(item2);

            UpdatePromotionActivityBranchDto.Item3 item3 = new UpdatePromotionActivityBranchDto.Item3();
            item3.setZFCXHD(detailPlanItem.getDetailPlanItemCode());
            item3.setZFCXKUN(detailPlanItem.getTerminalCode());
            updateDto.getITEM3().add(item3);

            list.add(updateDto);
        });

        for (UpdatePromotionActivityBranchDto updatePromotionActivityBranchDto : list) {
            if (!CollectionUtils.isEmpty(updatePromotionActivityBranchDto.getITEM2())){
                int i = 0;
                for (UpdatePromotionActivityBranchDto.Item2 item2 : updatePromotionActivityBranchDto.getITEM2()) {
                    item2.setZFHDITEM(item2.getZFCXHD()+String.format("%04d",++i));
                }
            }
        }

        return list;
    }

    /**
     * 获取明细中关联的促销政策
     *
     * @param DetailPlanItemVos 细案明细集合
     * @return 促销政策集合
     */
    public Map<String, PromotionPolicyVO> getPromotionPolicyMap(List<ActivityDetailPlanItemVo> DetailPlanItemVos) {
        List<String> promotionCodeList = DetailPlanItemVos.stream()
                .filter(k -> StringUtils.isNotBlank(k.getPromotionCode()))
                .map(ActivityDetailPlanItemVo::getPromotionCode)
                .distinct()
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(promotionCodeList)) {
            return null;
        }
        //根据促销政策编码集合获取促销政策
        List<PromotionPolicyVO> promotionPolicyVoList = promotionPolicyService.findByPromotionCodes(promotionCodeList);
        Map<String, PromotionPolicyVO> policyVOMap = new HashMap<>(promotionCodeList.size());
        promotionPolicyVoList.forEach(policy -> {
            policyVOMap.put(policy.getPromotionCode(), policy);
        });

        return policyVOMap;
    }

    /**
     * 获取活动形式编码对应的SAP活动形式编码
     *
     * @param itemList 分子公司细案明细编码
     * @return
     */
    public Map<String,String> getSapCodeMap(List<ActivityDetailPlanItemVo> itemList){
        if (CollectionUtils.isEmpty(itemList)) {
            return Maps.newHashMap();
        }
        List<String> fromCodes = itemList.stream().map(ActivityDetailPlanItemVo::getActivityFormCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map<String,String> sapCodeMap = activityFormService.findSapCode(fromCodes);
        return sapCodeMap;
    }


}

