package com.biz.crm.tpm.business.activity.detail.plan.local.service.third;

import com.alibaba.excel.util.StringUtils;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.third.system.sd.sdk.dto.FreeGoodsInterfaceCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.PromotionActivityCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.PromotionActivityCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.service.ActivitySapCallbackService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.SapCallbackEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.SapInterfaceEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.event.thrid.SapCallbackEventListener;
import com.biz.crm.tpm.business.activity.plan.sdk.service.FreeGoodsMappingService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.LinkedHashSet;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/2/5
 */
@Service
@Slf4j
public class ActivitySapCallbackServiceImpl implements ActivitySapCallbackService {

    @Autowired(required = false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private FreeGoodsMappingService freeGoodsMappingService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * SAP促销活动创建-分公司 回调
     * @param dto
     */
    @Override
    public void createBranchCallback(PromotionActivityCallbackDto dto) {
        if(ObjectUtils.isEmpty(dto)){
            return;
        }
        this.updateBranchInterfaceStatus(dto);
    }

    /**
     * SAP促销活动变更/关闭--分公司 回调
     * @param dto
     */
    @Override
    public void updateBranchCallback(PromotionActivityCallbackDto dto) {
        if(ObjectUtils.isEmpty(dto)){
            return;
        }
        this.updateBranchInterfaceStatus(dto);
    }

    @Override
    public void createHeadCallback(PromotionActivityCallbackDto dto) {
        return;
    }

    @Override
    public void updateHeadCallback(PromotionActivityCallbackDto dto) {
        return;
    }

    /**
     * SAP-免费货物维护接口回调
     * @param dto
     */
    @Override
    public void freeGoodsCallback(FreeGoodsInterfaceCallbackDto dto) {

        com.biz.crm.tpm.business.activity.plan.sdk.dto.FreeGoodsInterfaceCallbackDto freeGoodsInterfaceCallbackDto = this.nebulaToolkitService.copyObjectByWhiteList(dto, com.biz.crm.tpm.business.activity.plan.sdk.dto.FreeGoodsInterfaceCallbackDto.class, LinkedHashSet.class, ArrayList.class);
        freeGoodsMappingService.freeGoodsCallback(freeGoodsInterfaceCallbackDto);
    }

    /**
     * 更据SAP-分公司回调接口信息，更新促销活动推送状态
     * @param dto
     */
    private void updateBranchInterfaceStatus(PromotionActivityCallbackDto dto){
        loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();
        PromotionActivityCallbackDataDto dataDto = dto.getITEM1().get(0);
        if (ObjectUtils.isEmpty(dataDto)) {
            return;
        }
        String itemCode = dataDto.getZFCXHD();
        String flag = dataDto.getFLAG();
        if (StringUtils.isBlank(itemCode) || StringUtils.isBlank(flag)) {
            return;
        }
        if(itemCode.startsWith(ActivityDetailPlanConstant.ACTIVITY_DETAIL_PLAN_ITEM_RULE_CODE_PRE)){
            // itemCode 为 活动细案明细 ’明细编码‘
            if(SapInterfaceEnum.SUCCESS.getCode().equals(flag)){
                activityDetailPlanItemService.updateDetailPlanSapState(itemCode,true);
            }else if(SapInterfaceEnum.FAIL.getCode().equals(flag)){
                activityDetailPlanItemService.updateDetailPlanSapState(itemCode,false);
            }
        }else{
            //itemCode 为 分子公司活动明细的‘促销活动号’
            SapCallbackEventDto sapCallbackEventDto = new SapCallbackEventDto();
            sapCallbackEventDto.setItemCode(itemCode);
            sapCallbackEventDto.setFlag(flag);
            SerializableBiConsumer<SapCallbackEventListener, SapCallbackEventDto> sapCallback = SapCallbackEventListener::sapCallbackBranch;
            nebulaNetEventClient.publish(sapCallbackEventDto, SapCallbackEventListener.class, sapCallback);
        }

    }

}
