package com.biz.crm.tpm.business.activity.detail.plan.local.service.third;

import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.third.system.cow.manager.sdk.dto.CowManagerExecutionDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.PushActivityToThirdSystemService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description: 活动细案—促销活动 推送 第三方服务
 * @Author qiancheng
 * @Date 2023/1/16
 */
@Slf4j
@Service
public class PushActivityToThirdSystemServiceImpl implements PushActivityToThirdSystemService {

    @Autowired(required = false)
    private ActivityPushSapBranch activityPushSapBranch;

    @Autowired(required = false)
    private ActivityPushCowManager activityPushCowManager;

    @Autowired(required = false)
    private ActivityDetailPlanService activityDetailPlanService;

    @Autowired(required = false)
    private ActivityPushFreeGoods activityPushFreeGoods;

    @Autowired(required = false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;

    /**
     * ==============================牛人管家===================================
     */

    /**
     * 促销活动创建、变更 —— 牛人管家
     * @param planCodes 活动细案编码集合
     */
    @Override
    public void activityCreateOrUpdatePushCowManager(List<String> planCodes) {
        if(CollectionUtils.isEmpty(planCodes)) {
            return;
        }
        activityPushCowManager.buildAndPushActivityDetailPlan(planCodes);
    }

    /**
     * 促销活动关闭 —— 牛人管家
     * @param itemCodes 明细编码集合
     */
    @Override
    public void activityClosePushCowManager(List<String> itemCodes) {
        if(CollectionUtils.isEmpty(itemCodes)) {
            return;
        }
        activityPushCowManager.closeActivityDetailPlan(itemCodes);
    }


    /**
     * 活动执行查询 —— 牛人管家
     * @param type 费用类型
     * @param activeNumber 明细编码
     * @return 查询结构
     */
    @Override
    public List<CowManagerExecutionDto> queryActivityExecution(String type ,String activeNumber) {
        return activityPushCowManager.queryActivityExecution(type,activeNumber);
    }


    /**
     * =================================SAP===============================
     */


    /**
     *  创建  ——案细案编码
     *
     * SAP-免费货物维护接口
     * SAP-分公司—促销活动创建接口
     *
     * @param planCodes 分子公司活动细案编码集合
     */
    @Override
    public void createActivityPushSapByPlanCodes(List<String> planCodes) {
        if(CollectionUtils.isEmpty(planCodes)) {
            return;
        }
        List<ActivityDetailPlanItemVo> itemVoList = activityDetailPlanItemService.findByDetailPlanCode(planCodes);
        if(CollectionUtils.isEmpty(itemVoList)){
            return;
        }
        //主体活动明细集合
        List<ActivityDetailPlanItemVo> headquartersItemList = itemVoList.stream()
                .filter(k -> BusinessUnitEnum.isDefaultBusinessUnit(k.getBusinessUnitCode()))
                .collect(Collectors.toList());
        //垂直活动明细集合
        List<ActivityDetailPlanItemVo> verticalItemList = itemVoList.stream()
                .filter(k -> BusinessUnitEnum.VERTICAL.getCode().equals(k.getBusinessUnitCode()))
                .collect(Collectors.toList());

        //主体推送SD160接口 移动到方案推接口
//        activityPushFreeGoods.pushActivityToFreeGoods(headquartersItemList, OperationTypeEnum.CREATE);
        //垂直推送SD促销活动创建-分公司接口
        activityPushSapBranch.createPromotionActivityBranch(verticalItemList);
    }

    /**
     *   创建 ——案明细编码
     *
     * SAP-免费货物维护接口
     * SAP-分公司—促销活动创建接口
     *
     * @param itemCodes 分子公司活动细案明细编码集合
     */
    @Override
    public void createActivityPushSapByItemCodes(List<String> itemCodes) {
        if(CollectionUtils.isEmpty(itemCodes)) {
            return;
        }
        List<ActivityDetailPlanItemVo> itemVoList = activityDetailPlanItemService.findByItemCodes(itemCodes);
        if(CollectionUtils.isEmpty(itemVoList)){
            return;
        }
        //主体活动明细集合
        List<ActivityDetailPlanItemVo> headquartersItemList = itemVoList.stream()
                .filter(k -> BusinessUnitEnum.isDefaultBusinessUnit(k.getBusinessUnitCode()))
                .collect(Collectors.toList());
        //垂直活动明细集合
        List<ActivityDetailPlanItemVo> verticalItemList = itemVoList.stream()
                .filter(k -> BusinessUnitEnum.VERTICAL.getCode().equals(k.getBusinessUnitCode()))
                .collect(Collectors.toList());
        //主体推送SD160接口 移动到方案推接口
//        activityPushFreeGoods.pushActivityToFreeGoods(headquartersItemList, OperationTypeEnum.CREATE);
        //垂直推送SD促销活动创建-分公司接口
        activityPushSapBranch.createPromotionActivityBranch(verticalItemList);
    }


    /**
     *    变更    ——案细案编码
     *
     * SAP-免费货物维护接口
     * SAP-分公司—促销活动变更接口
     *
     * @param planCodes 明细编码集合
     * @param isClose 活动是否关闭 true：关闭 （SAP-分公司—促销活动变更接口使用）
     */
    @Override
    public void updateActivityPushSapByPlanCodes(List<String> planCodes, boolean isClose) {
        if(CollectionUtils.isEmpty(planCodes)) {
            return;
        }
        List<ActivityDetailPlanItemVo> itemVoList = activityDetailPlanItemService.findByDetailPlanCode(planCodes);
        if(CollectionUtils.isEmpty(itemVoList)){
            return;
        }
        //主体活动明细集合
        List<ActivityDetailPlanItemVo> headquartersItemList = itemVoList.stream()
                .filter(k -> BusinessUnitEnum.isDefaultBusinessUnit(k.getBusinessUnitCode()))
                .collect(Collectors.toList());
        //垂直活动明细集合
        List<ActivityDetailPlanItemVo> verticalItemList = itemVoList.stream()
                .filter(k -> BusinessUnitEnum.VERTICAL.getCode().equals(k.getBusinessUnitCode()))
                .collect(Collectors.toList());

        //移动到方案推接口
//        if (isClose) {
//            activityPushFreeGoods.pushActivityToFreeGoods(headquartersItemList, OperationTypeEnum.DELETE);
//        } else {
//            //主体推送SD160接口
//            activityPushFreeGoods.pushActivityToFreeGoods(headquartersItemList, OperationTypeEnum.UPDATE);
//        }

        //垂直推送SD促销活动变更-分公司接口
        activityPushSapBranch.updateOrClosePromotionActivityBranch(verticalItemList,isClose);
    }

    /**
     *    变更    ——案明细编码
     *
     * SAP-免费货物维护接口
     * SAP-分公司—促销活动变更接口
     *
     * @param itemCodes 明细编码集合
     * @param isClose 活动是否关闭 true：关闭 （SAP-分公司—促销活动变更接口使用）
     */
    @Override
    public void updateActivityPushSapByItemCodes(List<String> itemCodes, boolean isClose) {
        if(CollectionUtils.isEmpty(itemCodes)) {
            return;
        }
        List<ActivityDetailPlanItemVo> itemVoList = activityDetailPlanItemService.findByItemCodes(itemCodes);
        if(CollectionUtils.isEmpty(itemVoList)){
            return;
        }
        //主体活动明细集合
        List<ActivityDetailPlanItemVo> headquartersItemList = itemVoList.stream()
                .filter(k -> BusinessUnitEnum.isDefaultBusinessUnit(k.getBusinessUnitCode()))
                .collect(Collectors.toList());
        //垂直活动明细集合
        List<ActivityDetailPlanItemVo> verticalItemList = itemVoList.stream()
                .filter(k -> BusinessUnitEnum.VERTICAL.getCode().equals(k.getBusinessUnitCode()))
                .collect(Collectors.toList());

        //移动到方案推接口
//        if(isClose){
//            activityPushFreeGoods.pushActivityToFreeGoods(headquartersItemList, OperationTypeEnum.DELETE);
//        }else {
//            //主体推送SD160接口
//            activityPushFreeGoods.pushActivityToFreeGoods(headquartersItemList, OperationTypeEnum.UPDATE);
//        }
        //垂直推送SD促销活动变更-分公司接口
        activityPushSapBranch.updateOrClosePromotionActivityBranch(verticalItemList,isClose);
    }

}
