package com.biz.crm.tpm.business.activity.detail.plan.local.util;

import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.MarketingApprovalVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-08
 */
@Component
public class MarketingApprovalInfoBuilder {

    @Autowired(required = false)
    private BudgetItemService budgetItemService;
    @Autowired(required = false)
    private ActivityDetailPlanPlanService activityDetailPlanPlanService;

    /**
     * 查询预算项目信息
     *
     * @param
     * @return
     */
    public Map<String, BudgetItemVo> getBudgetItemDataTypeCodeMap(List<MarketingApprovalVo> marketingApprovalVos) {
        if (CollectionUtils.isEmpty(marketingApprovalVos)) {
            return Maps.newHashMap();
        }
        List<String> headBudgetItemCodes = marketingApprovalVos.stream().map(MarketingApprovalVo::getHeadBudgetItemCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        List<String> budgetItemCodes = marketingApprovalVos.stream().map(MarketingApprovalVo::getBudgetItemCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        budgetItemCodes.addAll(headBudgetItemCodes);
        List<BudgetItemVo> list = budgetItemService.findByCodes(budgetItemCodes);
        return list.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, v -> v, (v1, v2) -> v2));
    }

    /**
     * 查询方案信息
     *
     * @param
     * @return
     */
//    public Map<String, ActivityDetailPlanPlanVo> getPlanInfoMap(List<MarketingApprovalVo> marketingApprovalVos) {
//        if (CollectionUtils.isEmpty(marketingApprovalVos)) {
//            return Maps.newHashMap();
//        }
//        List<String> detailPlanCodes = marketingApprovalVos.stream().map(MarketingApprovalVo::getDetailPlanCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
//        List<ActivityDetailPlanPlanVo> list = this.activityDetailPlanPlanService.findForSalesApproval(detailPlanCodes);
//        return list.stream().collect(Collectors.toMap(ActivityDetailPlanPlanVo::getDetailPlanCode, v -> v, (v1, v2) -> v2));
//    }
}
