package com.biz.crm.tpm.business.activity.detail.plan.local.util;

import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.SalesApprovalVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-08
 */
@Component
public class SalesApprovalInfoBuilder {

    @Autowired(required = false)
    private BudgetItemService budgetItemService;
    @Autowired(required = false)
    private ActivityDetailPlanPlanService activityDetailPlanPlanService;

    /**
     * 查询预算项目信息
     *
     * @param headBudgetItemCodes
     * @return
     */
    public Map<String, BudgetItemVo> getBudgetItemDataTypeCodeMap(List<SalesApprovalVo> salesApprovalVos) {
        if (CollectionUtils.isEmpty(salesApprovalVos)) {
            return Maps.newHashMap();
        }
        List<String> headBudgetItemCodes = salesApprovalVos.stream().map(SalesApprovalVo::getHeadBudgetItemCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        List<String> budgetItemCodes = salesApprovalVos.stream().map(SalesApprovalVo::getBudgetItemCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        budgetItemCodes.addAll(headBudgetItemCodes);
        List<BudgetItemVo> list = budgetItemService.findByCodes(budgetItemCodes);
        return list.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, v -> v, (v1, v2) -> v2));
    }

    /**
     * 查询方案信息
     *
     * @param salesApprovalVos
     * @return
     */
    public Map<String, ActivityDetailPlanBudgetVo> getPlanInfoMap(List<SalesApprovalVo> salesApprovalVos) {
        if (CollectionUtils.isEmpty(salesApprovalVos)) {
            return Maps.newHashMap();
        }
        List<String> detailPlanItemCodes = salesApprovalVos.stream().map(SalesApprovalVo::getDetailPlanItemCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        List<ActivityDetailPlanBudgetVo> list = this.activityDetailPlanPlanService.findForSalesApproval(detailPlanItemCodes);
        return list.stream().collect(Collectors.toMap(ActivityDetailPlanBudgetVo::getDetailPlanItemCode, v -> v, (v1, v2) -> v2));
    }
}
