package com.biz.crm.tpm.business.activity.detail.plan.local.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 预算汇总信息
 */
@Data
public class ActivityDetailPlanBudgetSumVo {

    /**
     * 活动细案编码
     */
    @ApiModelProperty("活动细案编码")
    private String detailPlanCode;

    /**
     * 预算编码
     */
    @ApiModelProperty("预算编码")
    private String monthBudgetCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty("预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty("预算项目名称")
    private String budgetItemName;

    /**
     * 归口
     */
    @ApiModelProperty("归口")
    private String feeBelongCode;

    /**
     * 年月
     */
    @ApiModelProperty("年月")
    private String yearMonthLy;

    /**
     * 组织编码
     */
    @ApiModelProperty("组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String orgName;

    /**
     * 本月累计可用金额
     */
    @ApiModelProperty("本月累计可用金额")
    private BigDecimal accumulatedAvailableBalance;
    /**
     * 预算管控可用余额
     */
    @ApiModelProperty(value = "预算管控可用余额", notes = "")
    private BigDecimal controlBalanceAmount;

    /**
     * 本次使用金额
     */
    @ApiModelProperty("本次使用金额")
    private BigDecimal useAmount;

}
