package com.biz.crm.tpm.business.activity.detail.plan.local.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author baokai
 * @date 2023/7/18 17:20
 */
@Data
@CrmExcelExport
public class ActivityDetailPlanItemsExportsVo extends CrmExcelVo {
    /**
     * 审批状态
     */
    @CrmExcelColumn("审批状态")
    private String processStatus;

    /**
     * 业态
     */
    @CrmExcelColumn("业态")
    private String businessFormatName;

    @ExcelIgnore
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @CrmExcelColumn("业务单元")
    private String businessUnitName;

    /**
     * 业务单元
     */
    @ExcelIgnore
    private String businessUnitCode;

    /**
     * 部门
     */
    @CrmExcelColumn("部门")
    private String departmentName;

    @ExcelIgnore
    private String departmentCode;

    /**
     * 上级部门
     */
    @CrmExcelColumn("上级部门")
    private String parentOrgName;

    /**
     * 细案编码
     */
    @CrmExcelColumn("细案编码")
    private String detailPlanCode;

    /**
     * 细案名称
     */
    @CrmExcelColumn("细案名称")
    private String detailPlanName;

    /**
     * 区域
     */
    @CrmExcelColumn("区域")
    private String regionName;

    /**
     * 区域
     */
    @CrmExcelColumn("是否临时方案")
    private String isTemporary;

    /**
     * 是否汇总
     */
    @CrmExcelColumn("是否汇总")
    private String isGather;

    /**
     * 汇总维度
     */
    @CrmExcelColumn("汇总维度")
    private String summaryDimension;

    /**
     * 是否关闭字段
     */
    @CrmExcelColumn("是否关闭字段")
    private String isClose;

    /**
     * 关联方案明细编码
     */
    @CrmExcelColumn("关联方案明细编码")
    private String relatePlanItemCode;

    /**
     * 细案明细编码
     */
    @CrmExcelColumn("细案明细编码")
    private String detailPlanItemCode;

    /**
     * 活动分类编码
     */
    @CrmExcelColumn("活动分类编码")
    private String activityTypeCode;

    /**
     * 活动分类
     */
    @CrmExcelColumn("活动分类")
    private String activityTypeName;

    /**
     * 活动形式编码
     */
    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;

    /**
     * 活动形式
     */
    @CrmExcelColumn("活动形式")
    private String activityFormName;

    /**
     * 活动开始时间
     */
    @ExcelIgnore
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @ExcelIgnore
    private Date activityEndDate;
    /**
     * 活动开始时间-字符串，前端用
     */
    @CrmExcelColumn("活动开始时间")
    private String activityBeginDateStr;

    /**
     * 活动结束时间-字符串，前端用
     */
    @CrmExcelColumn("活动结束时间")
    private String activityEndDateStr;
    /**
     * 订单开始时间
     */
    @ExcelIgnore
    private Date orderBeginDate;
    /**
     * 订单结束时间
     */
    @ExcelIgnore
    private Date orderEndDate;
    /**
     * 订单开始时间-字符串，前端用
     */
    @CrmExcelColumn("订单开始时间")
    private String orderBeginDateStr;
    /**
     * 订单结束时间-字符串，前端用
     */
    @CrmExcelColumn("订单结束时间")
    private String orderEndDateStr;

    /**
     * 总部预算编码
     */
    @CrmExcelColumn("总部统筹预算编码")
    private String headMonthBudgetCode;
    /**
     * 总部预算项目编码
     */
    @ExcelIgnore
    private String headBudgetItemCode;
    /**
     * 总部预算项目名称
     */
    @CrmExcelColumn("总部预算项目名称")
    private String headBudgetItemName;
    /**
     * 大区自控预算编码
     */
    @CrmExcelColumn("大区自控预算编码")
    private String monthBudgetCode;
    /**
     * 大区自控预算名称
     */
    @CrmExcelColumn("大区自控预算名称")
    private String budgetItemName;

    /**
     * 渠道编码
     */
    @CrmExcelColumn("渠道编码")
    private String distributionChannelCode;

    /**
     * 销售机构编码
     */
    @CrmExcelColumn("销售机构编码")
    private String salesInstitutionCode;

    /**
     * 大区
     */
    @CrmExcelColumn("大区")
    private String salesRegionCode;

    /**
     * 省区
     */
    @CrmExcelColumn("省区")
    private String salesOrgCode;

    /**
     * 一级渠道编码
     */
    @CrmExcelColumn("一级渠道编码")
    private String firstChannelCode;
    /**
     * 一级渠道名称
     */
    @CrmExcelColumn("一级渠道名称")
    private String firstChannelName;
    /**
     * 二级渠道编码
     */
    @CrmExcelColumn("二级渠道编码")
    private String secondChannelCode;
    /**
     * 二级渠道名称
     */
    @CrmExcelColumn("二级渠道名称")
    private String secondChannelName;

    /**
     * 零售商编码
     */
    @CrmExcelColumn("零售商编码")
    private String systemCode;
    /**
     * 零售商名称
     */
    @CrmExcelColumn("零售商名称")
    private String systemName;

    /**
     * 客户编码
     */
    @CrmExcelColumn("客户编码")
    private String customerCode;
    /**
     * 客户名称
     */
    @CrmExcelColumn("客户名称")
    private String customerName;

    /**
     * 品牌编码
     */
    @CrmExcelColumn("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @CrmExcelColumn("品牌名称")
    private String productBrandName;

    /**
     * 品类编码
     */
    @CrmExcelColumn("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @CrmExcelColumn("品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @CrmExcelColumn("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @CrmExcelColumn("品项名称")
    private String productItemName;
    /**
     * 产品编码
     */
    @CrmExcelColumn("产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @CrmExcelColumn("产品名称")
    private String productName;

    /**
     * 赠品编码
     */
    @CrmExcelColumn("赠品编码")
    private String giftCode;
    /**
     * 赠品名称
     */
    @CrmExcelColumn("赠品名称")
    private String giftName;
    /**
     * 赠品价格
     */
    @CrmExcelColumn("赠品价格")
    private Integer giftPrice;

    /**
     * 原品数量
     */
    @CrmExcelColumn("原品数量")
    private Integer productQuantity;

    /**
     * 赠品总量
     */
    @CrmExcelColumn("赠品总量")
    private Integer giftWeight;

    /**
     * 月销售任务
     */
    @CrmExcelColumn("月销售任务（元）")
    private BigDecimal monthSalesTarget;

    /**
     * 目前铺市率
     */
    @CrmExcelColumn("目前铺市率")
    private BigDecimal currentMarketRate;

    /**
     * 月目标铺市率
     */
    @CrmExcelColumn("月目标铺市率")
    private BigDecimal monthTargetMarketRate;

    /**
     * 是否发起巡查需求
     */
    @CrmExcelColumn("是否发起巡查需求")
    private String isStartPatrol;

    /**
     * 期间促销量（件）
     */
    @CrmExcelColumn("期间促销量（件）")
    private BigDecimal periodPromoteQuantity;

    /**
     * 期间促销额（元）
     */
    @CrmExcelColumn("期间促销额（元）")
    private BigDecimal periodPromoteAmount;

    /**
     * 期间渠道促销量（件）
     */
    @CrmExcelColumn("期间渠道促销量（件）")
    private BigDecimal periodChPromoteQuantity;

    /**
     * 期间渠道促销额（元）
     */
    @CrmExcelColumn("期间渠道促销额（元）")
    private BigDecimal periodChPromoteAmount;

    /**
     * 全月回复量（件）
     */
    @CrmExcelColumn("全月回复量（件）")
    private BigDecimal monthReturnQuantity;
    /**
     * 全月回复额（元）
     */
    @CrmExcelColumn("全月回复额（元）")
    private BigDecimal monthReturnAmount;
    /**
     * 本月投入产出比(小数)
     */
    @CrmExcelColumn("本月投入产出比（小数）")
    private BigDecimal monthPutOutputRatio;

    /**
     * 门店编码
     */
    @CrmExcelColumn("门店编码")
    private String terminalCode;
    /**
     * 门店名称
     */
    @CrmExcelColumn("门店名称")
    private String terminalName;
    /**
     * 门店类型
     */
    @CrmExcelColumn("门店类型")
    private String terminalType;

    /**
     * 堆头陈列数量（个/月）
     */
    @CrmExcelColumn("堆头陈列数量（个/月）")
    private String quantity;

    /**
     * 堆头陈列单价（元）
     */
    @CrmExcelColumn("堆头陈列单价（元）")
    private String price;


    /**
     * 门店预计月销售额
     */
    @CrmExcelColumn("门店预计月销售额（元）")
    private BigDecimal terminalMonthSalesAmount;

    /**
     * 人员编码
     */
    @CrmExcelColumn("人员编码")
    private String personCode;

    /**
     * 人员名称
     */
    @CrmExcelColumn("人员名称")
    private String personName;

    /**
     * 人员类型
     */
    @CrmExcelColumn("人员类型")
    private String personType;

    /**
     * 身份证号码
     */
    @CrmExcelColumn("身份证号码")
    private String personIdCard;

    /**
     * 物料编码
     */
    @CrmExcelColumn("物料编码")
    private String materialCode;
    /**
     * 物料名称
     */
    @CrmExcelColumn("物料名称")
    private String materialName;

    /**
     * 物料数量
     */
    @CrmExcelColumn("物料数量")
    private BigDecimal materialQuantity;

    /**
     * 物料单价
     */
    @CrmExcelColumn("单价")
    private BigDecimal materialPrice;

    /**
     * 采购类型
     */
    @CrmExcelColumn("采购类型")
    private String procurementType;

    /**
     * 费用合计
     */
    @CrmExcelColumn("费用合计（元）")
    private BigDecimal totalFeeAmount;

    /**
     * 总部承担金额
     */
    @CrmExcelColumn("总部承担金额（元）")
    private BigDecimal headFeeAmount;

    /**
     * 大区承担金额
     */
    @CrmExcelColumn("大区承担金额（元）")
    private BigDecimal departmentFeeAmount;

    /**
     * 分子公司点内金额
     */
    @CrmExcelColumn("分子公司点内金额（元）")
    private BigDecimal intraCompanyAmount;

    /**
     * 分子公司点外金额
     */
    @CrmExcelColumn("分子公司点外金额（元）")
    private BigDecimal offPointAmount;

    /**
     * 客户承担金额
     */
    @CrmExcelColumn("客户承担金额（元）")
    private BigDecimal customerFeeAmount;

    /**
     * 是否扣减费用池
     */
    @CrmExcelColumn("是否扣减费用池")
    private String isDeductionFeePool;

    /**
     * 核销类型
     */
    @CrmExcelColumn("核销类型")
    private String auditType;

    /**
     * 核销条件编码
     */
    @CrmExcelColumn("核销条件编码")
    private String auditConditionCode;

    /**
     * 结案形式
     */
    @CrmExcelColumn("结案形式")
    private String auditForm;

    /**
     * 付款方式
     */
    @CrmExcelColumn("付款方式")
    private String paymentMethod;

    /**
     * 是否和价格有关
     */
    @CrmExcelColumn("是否和价格有关")
    private String relateToPrice;

    /**
     * 形式说明
     */
    @CrmExcelColumn("形式说明")
    private String formDescription;

    /**
     * 是否涨价政策
     */
    @CrmExcelColumn("是否涨价政策")
    private String increasePricePromotion;

    /**
     * 是否考核扣款
     */
    @CrmExcelColumn("是否考核扣款")
    private String deductType;

    /**
     * 是否责任利润调整
     */
    @CrmExcelColumn("是否责任利润调整")
    private String dutyProfitAdjust;
    /**
     * 促销对象
     */
    @CrmExcelColumn("促销对象")
    private String promotionObject;

    /**
     * 新品归类
     */
    @CrmExcelColumn("新品归类")
    private String newProductType;

    /**
     * 是否占用划拨预算
     */
    @CrmExcelColumn("是否占用划拨预算")
    private String occupyTransferBudget;

    /**
     * 方案明细编码
     */
    @CrmExcelColumn("方案明细编码")
    private String planItemCode;

    /**
     * 活动力度
     */
    @CrmExcelColumn("活动力度")
    private String activityIntensity;

    /**
     * 陈列批次
     */
    @CrmExcelColumn("陈列批次")
    private String displayLot;

    /**
     * 是否客户上账
     */
    @CrmExcelColumn("是否客户上账")
    private String isCustomerAccount;

    /**
     * 活动承接形式
     */
    @CrmExcelColumn("活动承接形式")
    private String undertakingMode;

    /**
     * 客户组编码
     */
    @CrmExcelColumn("客户组编码")
    private String customerGroupCode;

    /**
     * 客户组名称
     */
    @CrmExcelColumn("客户组名称")
    private String customerGroupName;

    /**
     * 随车搭赠组合
     */
    @CrmExcelColumn("随车搭赠组合")
    private String carGiftGroup;

    /**
     * 供应商编码
     */
    @CrmExcelColumn("供应商编码")
    private String supplierCode;
    /**
     * 供应商名称
     */
    @CrmExcelColumn("供应商名称")
    private String supplierName;

    /**
     * 面值
     */
    @CrmExcelColumn("面值")
    private BigDecimal faceValue;

    /**
     * 个税金额
     */
    @CrmExcelColumn("个税金额（元）")
    private BigDecimal personalIncomeTax;

}
