package com.biz.crm.tpm.business.activity.detail.plan.local.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description: 分子规划获取关联向上细案导出
 * @Author qiancheng
 * @Date 2023/3/24
 */
@Data
@CrmExcelExport
public class SubRelatedDetailPlanItemExportsVo extends CrmExcelVo {

    @CrmExcelColumn("字段")
    private String column1;
    @CrmExcelColumn("*活动规划名称")
    private String column2;
    @CrmExcelColumn("*组织编码")
    private String column3;
    @CrmExcelColumn("*组织名称")
    private String column4;
    @CrmExcelColumn("*年月")
    private String column5;
    @CrmExcelColumn("*活动便签号")
    private String column6;
    @CrmExcelColumn("*是否共用量")
    private String column7;
    @CrmExcelColumn("*关联类型")
    private String column8;
    /**
     * 承接方式
     */
    @CrmExcelColumn("*承接方式")
    private String undertakingMode;
    /**
     * 活动细案明细编码
     */
    @CrmExcelColumn("关联数据编码")
    private String detailPlanItemCode;

    @CrmExcelColumn("*预算项目")
    private String column60;

    /**
     * 活动类型编码
     */
    @CrmExcelColumn("活动类型编码")
    private String activityTypeCode;
    /**
     * 活动形式编码
     */
    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;

    @CrmExcelColumn("活动形式")
    private String activityFormName;
    @CrmExcelColumn("活动形式说明")
    private String formDescription;
    @CrmExcelColumn("*核销方式")
    private String column11;
    @CrmExcelColumn("*客户编码")
    private String column12;
    @CrmExcelColumn("*客户名称")
    private String column13;

    /**
     * 活动开始时间
     */
    @CrmExcelColumn("*活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String activityBeginDateStr;
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @CrmExcelColumn("*活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String activityEndDateStr;
    private Date activityEndDate;
    /**
     * 订单开始时间
     */
    @CrmExcelColumn("订单开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String orderBeginDateStr;
    private Date orderBeginDate;
    /**
     * 订单结束时间
     */
    @CrmExcelColumn("订单结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String orderEndDateStr;
    private Date orderEndDate;

    @CrmExcelColumn("*费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private String feeYearMonthStr;
    private Date feeYearMonth;

    /**
     * 销售机构编码
     */
    @CrmExcelColumn("*销售机构编码")
    private String salesInstitutionCode;

    /**
     * 分销渠道
     */
    @CrmExcelColumn("*分销渠道")
    private String firstChannelCode;

    @CrmExcelColumn("销售部门")
    private String column14;


    @CrmExcelColumn("销售组")
    private String column15;

    /**
     * 品牌编码
     */
    @CrmExcelColumn("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @CrmExcelColumn("品牌名称")
    private String productBrandName;
    /**
     * 品类编码
     */
    @CrmExcelColumn("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @CrmExcelColumn("品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @CrmExcelColumn("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @CrmExcelColumn("品项名称")
    private String productItemName;
    /**
     * 产品编码
     */
    @CrmExcelColumn("产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @CrmExcelColumn("产品名称")
    private String productName;

    @CrmExcelColumn("产品日期")
    private String column70;

    @CrmExcelColumn("共用组")
    private String column16;

    /**
     * 单位编码
     */
    @CrmExcelColumn("*单位编码")
    private String productUnit;

    @CrmExcelColumn("单位")
    private String column17;
    @CrmExcelColumn("原品单价（元）")
    private String column18;
    @CrmExcelColumn("活动价（元）")
    private String column19;

    /**
     * 原品数量
     */
    @CrmExcelColumn("原品数量")
    private Integer productQuantity;

    /**
     * 赠品编码
     */
    @CrmExcelColumn("赠品编码")
    private String giftCode;
    /**
     * 赠品名称
     */
    @CrmExcelColumn("赠品名称")
    private String giftName;

    @CrmExcelColumn("赠品单价")
    private String column20;

    /**
     * 赠品数量
     */
    @CrmExcelColumn("赠品数量")
    private Integer giftQuantity;

    @CrmExcelColumn("*是否关联促销政策")
    private String column21;
    @CrmExcelColumn("促销政策编码")
    private String column22;
    @CrmExcelColumn("门店类型")
    private String column23;
    @CrmExcelColumn("门店编码")
    private String column24;
    @CrmExcelColumn("门店名称")
    private String column25;
    @CrmExcelColumn("陈列类型")
    private String column26;

    /**
     * 单价
     */
    @CrmExcelColumn("陈列单价")
    private BigDecimal price;

    /**
     * 数量
     */
    @CrmExcelColumn("陈列数量")
    private Integer quantity;

    @CrmExcelColumn("推广场次")
    private String column27;
    @CrmExcelColumn("单场预估费用")
    private String column28;
    @CrmExcelColumn("采购类型")
    private String column29;
    @CrmExcelColumn("人员数量")
    private String column30;

    /**
     * 身份证号码
     */
    @CrmExcelColumn("身份证号码")
    private String personIdCard;
    /**
     * 人员类型
     */
    @CrmExcelColumn("人员类型")
    private String personType;
    /**
     * 人员名称
     */
    @CrmExcelColumn("人员名称")
    private String personName;
    /**
     * 人员编码
     */
    @CrmExcelColumn("人员编码")
    private String personCode;

    /**
     * 物料编码
     */
    @CrmExcelColumn("物料编码")
    private String materialCode;
    /**
     * 物料名称
     */
    @CrmExcelColumn("物料名称")
    private String materialName;
    /**
     * 物料数量
     */
    @CrmExcelColumn("物料数量")
    private BigDecimal materialQuantity;

    @CrmExcelColumn("供应商编码")
    private String column31;
    @CrmExcelColumn("供应商名称")
    private String column32;
    @CrmExcelColumn("合同编号")
    private String column33;
    @CrmExcelColumn("帐期")
    private String column34;
    @CrmExcelColumn("物料单位")
    private String column35;

    /**
     * 物料单价
     */
    @CrmExcelColumn("物料单价")
    private BigDecimal materialPrice;

    @CrmExcelColumn("*费用合计")
    private BigDecimal totalCostAmount;
    @CrmExcelColumn("总部支持金额")
    private BigDecimal headInvestmentFeeAmount;
    //("公司自投金额")
    private BigDecimal selfInvestmentFeeAmount;
    @CrmExcelColumn("期间促销量")
    private BigDecimal periodChPromoteQuantity;
    @CrmExcelColumn("期间促销额（元）")
    private BigDecimal periodChPromoteAmount;



    /**
     * 核销条件
     */
    @CrmExcelColumn("*核销条件")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @CrmExcelColumn("自定义核销编码")
    private String auditConditionName;

    @CrmExcelColumn("备注")
    private String column61;
    @CrmExcelColumn("✳是否大日期")
    private String column62;
    @CrmExcelColumn("*是否档期")
    private String column63;
    @CrmExcelColumn("档期时间")
    private String column64;

    /**
     * 是否价格相关
     */
    @ApiModelProperty("*是否价格相关")
    @CrmExcelColumn("*是否价格相关")
    private String relateToPrice;

    /**
     * 是否发起巡查需求
     */
    @ApiModelProperty("*是否巡查")
    @CrmExcelColumn("*是否巡查")
    private String isStartPatrol;

    @CrmExcelColumn("管理分级-非必填")
    private String column41;
    @CrmExcelColumn("管理分级代码-非必填")
    private String column42;
    @CrmExcelColumn("促销员工资标准（（工资标准））")
    private String column43;
    @CrmExcelColumn("资产编号")
    private String column44;
    @CrmExcelColumn("资产标牌号码")
    private String column45;
    @CrmExcelColumn("资产属性")
    private String column46;
    @CrmExcelColumn("使用状态")
    private String column47;
    @CrmExcelColumn("规格型号")
    private String column48;
    @CrmExcelColumn("资产采购金额")
    private String column49;
    @CrmExcelColumn("本次返还金额")
    private String column50;
    @CrmExcelColumn("已返还金额")
    private String column51;
    @CrmExcelColumn("剩余返还金额")
    private String column52;
    @CrmExcelColumn("地址")
    private String column53;
    @CrmExcelColumn("联系人")
    private String column54;
    @CrmExcelColumn("联系电话")
    private String column55;
    @CrmExcelColumn("投放年份")
    private String column56;
    @CrmExcelColumn("是否费用池扣款")
    private String column57;
    @CrmExcelColumn("*结案形式")
    private String column58;
    @CrmExcelColumn("付款方式")
    private String column59;

    /**
     * 查询/转换使用
     */
    //客户编码
    private String customerCode;
    //总部支持金额
    private BigDecimal headFeeAmount;
    //大区承担金额
    private BigDecimal departmentFeeAmount;
    //客户承担金额
    private BigDecimal customerFeeAmount;



}
