package com.biz.crm.tpm.business.activity.detail.plan.local.xxjob;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author: chenlong
 * @date: 2023/3/16 10:13
 * @description: 活动方案，细案关闭回退预算定时任务 垂直 job
 */
@Slf4j
@Service
public class ActivityDetailPlanBudgetRollbackVerticalXxjob {

    @Autowired(required = false)
    private ActivityDetailPlanService activityDetailPlanService;
    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     *  垂直活动方案，细案关闭回退预算定时任务
     */
    @DynamicTaskService(cornExpression = "0 0 6 * * ?", taskDesc = "垂直活动方案，细案关闭回退预算定时任务")
    public void autoSyncXxlJob() {

        log.info("=====>    垂直活动方案，细案关闭回退预算[{}] start    <=====", DateUtil.dateStrNowAll());
        //设置基础信息
        loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        this.activityDetailPlanService.syncBudgetRollbackVertical();
        log.info("=====>    垂直活动方案，细案关闭回退预算[{}] end    <=====", DateUtil.dateStrNowAll());

    }
}
