package com.biz.crm.tpm.business.activity.detail.plan.local.xxjob;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.BusinessUnitSetTableService;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 业务单元套表_渠道-跑帆软
 */
@Slf4j
@Service
public class BusinessunitSetTableJob {

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private BusinessUnitSetTableService businessUnitSetTableService;

    /**
     * redis服务
     */
    @Autowired(required = false)
    private RedisLockService redisLockService;

    /**
     * 修正折扣率_量子-跑帆软
     */
    @DynamicTaskService(cornExpression = "0 20 3 * * ?", taskDesc = "业务单元套表_渠道-跑帆软")
    public void frJob() {
        loginUserService.refreshAuthentication(null);
        boolean hasLock = false;
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        String key = ActivityPlanConstant.BUSINESS_UNIT_SET_TABLE + sdf.format(date);
        try {
            hasLock = redisLockService.tryLock(key, TimeUnit.MINUTES, 30);
            if (!hasLock) {
                return;
            }
            log.info("=====>    业务单元套表_渠道-跑帆软[{}] start    <=====", DateUtil.dateStrNowAll());
            List<String> yearMonths = Lists.newArrayList();
            YearMonth yearMonth = YearMonth.now();
            yearMonths.add(yearMonth.format(DateTimeFormatter.ofPattern("yyyy-MM")));//本月的
            yearMonth = yearMonth.plusMonths(-1);
            yearMonths.add(yearMonth.format(DateTimeFormatter.ofPattern("yyyy-MM")));//上月的

            this.businessUnitSetTableService.frJob(yearMonths);
            log.info("=====>    业务单元套表_渠道-跑帆软[{}] end    <=====", DateUtil.dateStrNowAll());
        }catch (Exception e){
            throw new RuntimeException(ExceptionStackMsgUtil.stackMsg(e));
        }finally {
            redisLockService.unlock(key);
        }
    }

}
