/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.listener.ActivityDetailPlanProcessCompleteListener;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.PushActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanListDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_ACTIVITY_PLAN_PASS_CREATE_DETAIL_PLAN", consumerGroup="TPM_ACTIVITY_PLAN_PASS_CREATE_DETAIL_PLAN${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class ActivityPlanPassCreateDetailPlanConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanPassCreateDetailPlanConsumer.class);
    @Autowired(required=false)
    private ActivityPlanSdkService activityPlanSdkService;
    @Autowired(required=false)
    private ActivityDetailPlanService activityDetailPlanService;
    @Autowired(required=false)
    private PushActivityDetailPlanService pushActivityDetailPlanService;
    @Autowired(required=false)
    private ActivityDetailPlanProcessCompleteListener activityDetailPlanProcessCompleteListener;

    protected Object handleMessage(MqMessageVo message) {
        log.info("\u6d3b\u52a8\u65b9\u6848\u5ba1\u6279\u901a\u8fc7\u751f\u6210\u6d3b\u52a8\u7ec6\u6848 order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            List businessNoList = JSON.parseArray((String)message.getMsgBody(), String.class);
            List dtoList = this.activityPlanSdkService.buildActivityPlanParms(businessNoList);
            ActivityPlanListDto dto = new ActivityPlanListDto();
            dto.setList(dtoList);
            log.info("\u5f00\u59cb\u81ea\u52a8\u751f\u6210\u7ec6\u6848");
            List<String> detailPlanCodeList = this.activityDetailPlanService.autoBatchCreate(dto);
            log.info("\u81ea\u52a8\u751f\u6210\u7ec6\u6848\u7ed3\u675f");
            this.pushActivityDetailPlanService.passPushMqDirect(null, detailPlanCodeList);
        }
        catch (Exception e) {
            log.error(ActivityPlanPassMqTagEnum.PASS_CREATE_DETAIL_PLAN.getName() + "\u5904\u7406\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }
}

