/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DataTooLongGenerateRespUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanBudgetService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.PushActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanApproveSubmitDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanReportDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.sfa.SfaFeeDetailDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanReportVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanListDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/activityDetailPlan"})
@Api(tags={"\u6d3b\u52a8\u7ec6\u6848"})
public class ActivityDetailPlanController {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanController.class);
    @Autowired(required=false)
    private ActivityDetailPlanService activityDetailPlanService;
    @Autowired(required=false)
    private ActivityDetailPlanBudgetService activityDetailPlanBudgetService;
    @Autowired(required=false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired(required=false)
    private ActivityPlanSdkService activityPlanSdkService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private PushActivityDetailPlanService pushActivityDetailPlanService;
    @Autowired(required=false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<ActivityDetailPlanVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="activityDetailPlanDto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityDetailPlanDto activityDetailPlanDto) {
        try {
            Page<ActivityDetailPlanVo> page = this.activityDetailPlanService.findByConditions(pageable, activityDetailPlanDto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findPageForOut"})
    public Result<Page<ActivityDetailPlanVo>> findPageForOut(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="activityDetailPlanDto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityDetailPlanDto activityDetailPlanDto) {
        try {
            Page<ActivityDetailPlanVo> page = this.activityDetailPlanService.findPageForOut(pageable, activityDetailPlanDto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"activityDetailPlanItem/findPage"})
    @ApiOperation(value="\u6d3b\u52a8\u7ec6\u6848\u5217\u8868\u67e5\u8be2API")
    public Result<Page<ActivityDetailPlanItemVo>> findPage(@ApiParam(name="pageable") @PageableDefault(value=10) Pageable pageable, @ApiParam(name="dto") ActivityDetailPlanItemDto dto) {
        try {
            Page<ActivityDetailPlanItemVo> page = this.activityDetailPlanItemService.findByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u660e\u7ec6")
    @GetMapping(value={"findDetailByConditions"})
    public Result<Page<ActivityDetailPlanReportVo>> findDetailByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="ActivityDetailPlanReportDto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityDetailPlanReportDto dto) {
        try {
            Page<ActivityDetailPlanReportVo> page = this.activityDetailPlanService.findDetailByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u660e\u7ec6")
    @GetMapping(value={"findDetailByConditionsFotExport"})
    public Result<Page<ActivityDetailPlanReportVo>> findDetailByConditionsFotExport(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="ActivityDetailPlanReportDto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityDetailPlanReportDto dto) {
        try {
            Page<ActivityDetailPlanReportVo> page = this.activityDetailPlanService.findDetailByConditionsFotExport(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u6d3b\u52a8\u65b9\u6848\u6570\u636e")
    @GetMapping(value={"findById"})
    public Result<ActivityDetailPlanVo> findById(@ApiParam(value="id") @RequestParam String id) {
        try {
            ActivityDetailPlanVo vo = this.activityDetailPlanService.findById(id);
            return Result.ok((Object)vo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u7ec6\u6848\u65b0\u589e\u7f16\u8f91-\u80fd\u529b\u4e2d\u5fc3")
    @PostMapping(value={"saveActivityPlanNoCache"})
    public Result<ActivityDetailPlanDto> saveActivityPlanNoCache(@ApiParam(name="ActivityPlanDetailDto", value="\u6d3b\u52a8\u7ec6\u6848\u8868\u5934") @RequestBody ActivityDetailPlanDto dto) {
        try {
            this.loginUserService.refreshAuthentication(null);
            return Result.ok((Object)this.activityDetailPlanService.saveActivityDetailPlanNoCache(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, ActivityDetailPlan.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6d3b\u52a8\u7ec6\u6848\u65b0\u589e\u7f16\u8f91")
    @PostMapping(value={"saveActivityPlan"})
    public Result saveActivityPlan(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="ActivityPlanDetailDto", value="\u6d3b\u52a8\u7ec6\u6848\u8868\u5934") @RequestBody ActivityDetailPlanDto dto) {
        boolean lockSuccess = false;
        String lockKey = "activity_detail_plan:lock:save:" + cacheKey;
        try {
            lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 2L);
            if (!lockSuccess) {
                throw new RuntimeException("\u6570\u636e\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            this.activityDetailPlanService.saveActivityDetailPlan(dto, cacheKey);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u9009\u62e9\u7684\u6708\u5ea6\u9884\u7b97")
    @GetMapping(value={"findMonthBudgetByConditions"})
    public Result<Page<MonthBudgetVo>> findMonthBudgetByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="MonthBudgetDto", value="\u6708\u5ea6\u9884\u7b97\u4fe1\u606f") ActivityDetailPlanBudgetDto planBudgetDto, @ApiParam(name="MonthBudgetDto", value="\u6708\u5ea6\u9884\u7b97\u4fe1\u606f") MonthBudgetDto dto) {
        try {
            Page<MonthBudgetVo> page = this.activityDetailPlanService.findMonthBudgetByConditions(pageable, planBudgetDto, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ec6\u6848\u5ba2\u6237\u6c47\u603b\u66b4\u9732\u64cd\u4f5c\u9884\u7b97\u63a5\u53e3")
    @GetMapping(value={"operateCustomerMonthBudgetByPlanCodeList"})
    public Result<?> operateCustomerMonthBudgetByPlanCodeList(@RequestParam(value="detailPlanCodeList") @ApiParam(name="detailPlanCodeList", value="\u7ec6\u6848\u7f16\u7801\u96c6\u5408") List<String> detailPlanCodeList, @RequestParam(value="operationType") @ApiParam(name="operationType", value="\u64cd\u4f5c\u6708\u5ea6\u9884\u7b97\u7c7b\u578b") String operationType) {
        try {
            this.activityDetailPlanService.operateCustomerMonthBudgetByPlanCodeList(detailPlanCodeList, operationType);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ec6\u6848\u66b4\u9732\u64cd\u4f5c\u9884\u7b97\u63a5\u53e3")
    @GetMapping(value={"useMonthBudgetByDetailPlanCodeList"})
    public Result<?> useMonthBudgetByDetailPlanCodeList(@RequestBody @ApiParam(name="detailPlanCodeList", value="\u7ec6\u6848\u7f16\u7801\u96c6\u5408") List<String> detailPlanCodeList) {
        try {
            this.activityDetailPlanBudgetService.useMonthBudgetByPlanCodeList(detailPlanCodeList);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4")
    @PostMapping(value={"submitApproval"})
    public Result submitApproval(@ApiParam(value="\u63d0\u4ea4\u6d41\u7a0b\uff0c\u6309\u4e1a\u6001\uff0c\u4e1a\u52a1\u5355\u5143\u3001\u5f52\u5c5e\u90e8\u95e8\u3001\u7b56\u7565\u7c7b\u578b\u3001\u7b56\u7565\u5e74\u5ea6\u63d0\u4ea4") @RequestBody ActivityDetailPlanApproveSubmitDto dto) {
        List<String> ids = dto.getIds();
        boolean lockSuccess = false;
        try {
            if (CollectionUtils.isEmpty(ids)) {
                throw new RuntimeException("\u8bf7\u9009\u62e9\u6570\u636e\uff01");
            }
            lockSuccess = this.redisLockService.batchLock("activity_detail_plan:lock:approve:", ids, TimeUnit.HOURS, 1);
            if (!lockSuccess) {
                throw new RuntimeException("\u6570\u636e\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            this.activityDetailPlanService.submitApproval(dto.getIds(), dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (!CollectionUtils.isEmpty(ids) && lockSuccess) {
                this.redisLockService.batchUnLock("activity_detail_plan:lock:approve:", ids);
            }
        }
    }

    @ApiOperation(value="\u5220\u9664\u6d3b\u52a8\u65b9\u6848")
    @DeleteMapping(value={"delete"})
    public Result delete(@ApiParam(value="\u6d3b\u52a8\u65b9\u6848id\u96c6\u5408") @RequestParam List<String> ids) {
        try {
            this.activityDetailPlanService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6d3b\u52a8\u65b9\u6848")
    @PostMapping(value={"deletePos"})
    public Result deletePos(@ApiParam(value="\u6d3b\u52a8\u65b9\u6848id\u96c6\u5408") @RequestParam List<String> ids) {
        try {
            this.activityDetailPlanService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u7ec6\u6848\u7533\u8bf7\u53ef\u4ee5\u9009\u62e9\u7684\u6d3b\u52a8\u65b9\u6848")
    @GetMapping(value={"findRelateActivityPlanListByConditions"})
    public Result<Page<ActivityPlanVo>> findRelateActivityPlanListByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="MarketingStrategyDto", value="\u7b56\u7565\u67e5\u8be2\u5b9e\u4f53") ActivityPlanDto dto) {
        try {
            dto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            Page page = this.activityPlanSdkService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6")
    @GetMapping(value={"findActivityDetailPlanList"})
    public Result<Page<ActivityDetailPlanItemVo>> findActivityDetailPlanList(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto") ActivityDetailPlanItemDto dto) {
        try {
            dto.setProcessStatus(ProcessStatusEnum.PASS.getKey());
            return Result.ok((Object)this.activityDetailPlanSdkService.queryActivityDetailPlan(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6")
    @PostMapping(value={"queryActivityDetailPlan"})
    public Result<Page<ActivityDetailPlanItemVo>> queryActivityDetailPlan(@PageableDefault(value=50) Pageable pageable, @RequestBody ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        try {
            return Result.ok((Object)this.activityDetailPlanSdkService.queryActivityDetailPlan(pageable, activityDetailPlanItemDto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u63a8\u9001SFA\u8d39\u7528\u660e\u7ec6")
    @PostMapping(value={"pushSfaFeeDetailList"})
    public Result pushSfaFeeDetailList(@RequestBody List<SfaFeeDetailDto> dtoList) {
        try {
            log.info(JSONObject.toJSONString(dtoList));
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"autoBatchCreateByCode"})
    public Result autoBatchCreateByCode(@RequestBody List<String> businessNoList) {
        try {
            Assert.notEmpty(businessNoList, (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u65b9\u6848!");
            List dtoList = this.activityPlanSdkService.buildActivityPlanParms(businessNoList);
            Assert.notEmpty((Collection)dtoList, (String)("\u6d3b\u52a8\u65b9\u6848" + JSON.toJSONString(businessNoList) + "\u4e0d\u5b58\u5728!"));
            dtoList.forEach(vo -> Assert.isTrue((boolean)ProcessStatusEnum.PASS.getDictCode().equals(vo.getProcessStatus()), (String)("\u6d3b\u52a8\u65b9\u6848[" + vo.getPlanCode() + "]\u672a\u5ba1\u6279\u901a\u8fc7!")));
            ActivityPlanListDto dto = new ActivityPlanListDto();
            dto.setList(dtoList);
            List<String> detailPlanCodeList = this.activityDetailPlanService.autoBatchCreate(dto);
            this.pushActivityDetailPlanService.passPushMqDirect(null, detailPlanCodeList);
            return Result.ok(detailPlanCodeList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"autoBatchCreate"})
    public Result autoBatchCreate(@RequestBody ActivityPlanListDto listDto) {
        try {
            List<String> detailPlanCodeList = this.activityDetailPlanService.autoBatchCreate(listDto);
            return Result.ok(detailPlanCodeList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"textXxjob"})
    public Result<?> textXxjob() {
        try {
            this.activityDetailPlanService.syncBudgetRollbackVertical();
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"buildActivityDetailPlanParams"})
    public Result<?> buildActivityDetailPlanParams(@RequestBody List<String> detailPlanCodeList) {
        try {
            List<ActivityDetailPlanDto> activityDetailPlanDtos = this.activityDetailPlanService.buildActivityDetailPlanParams(detailPlanCodeList);
            return Result.ok(activityDetailPlanDtos);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\uff08\u4e3b\u4f53\uff09\u6839\u636e\u6c47\u603b\u7ef4\u5ea6\u8fdb\u884c\u6c47\u603b")
    @GetMapping(value={"summary"})
    public Result<?> summary(@ApiParam(name="activityDetailPlanDto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityDetailPlanDto activityDetailPlanDto) {
        try {
            this.activityDetailPlanService.summary(activityDetailPlanDto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u7ec6\u6848\u521b\u5efa\u539f\u5b50\u63a5\u53e3-\u80fd\u529b\u4e2d\u5fc3")
    @PostMapping(value={"atomicCreateForOut"})
    public Result<ActivityDetailPlanDto> atomicCreateForOut(@RequestBody ActivityDetailPlanDto dto) {
        try {
            ActivityDetailPlanDto result = this.activityDetailPlanService.atomicCreateForOut(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, ActivityDetailPlan.class));
        }
    }
}

