/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.enums.ActivitiesTemplateConfigTypeEnum;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemAsyncService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemTerminalService;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanService;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemTerminalVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanReportVo;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeSelectDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/activityDetailPlanItem"})
@Api(tags={"\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6"})
public class ActivityDetailPlanItemController
extends MnPageCacheController<ActivityDetailPlanItemVo, ActivityDetailPlanItemDto> {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanItemController.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;
    @Autowired(required=false)
    private ActivityDetailPlanService activityDetailPlanService;
    @Autowired(required=false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;
    @Autowired(required=false)
    private ActivityDetailPlanItemAsyncService activityDetailPlanItemAsyncService;
    @Autowired(required=false)
    private ActivityDetailPlanItemTerminalService activityDetailPlanItemTerminalService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<ActivityDetailPlanItemVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="activityDetailPlanItemDto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        try {
            Page<ActivityDetailPlanItemVo> page = this.activityDetailPlanItemService.findByConditions(pageable, activityDetailPlanItemDto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6d3b\u52a8\u65b9\u6848\u53ef\u4ee5\u9009\u62e9\u7684\u6a21\u677f")
    @PostMapping(value={"findItemColumnConfigSelect"})
    public Result<List<CommonSelectVo>> findItemColumnConfigSelect(@ApiParam(value="\u6a21\u677f\u7f16\u7801") ActivitiesTemplateConfigDto configDto, @ApiParam(value="\u6d3b\u52a8\u7c7b\u578bdto") @RequestBody CommonSelectDto dto) {
        try {
            Validate.notBlank((CharSequence)configDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)configDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            configDto.setType(ActivitiesTemplateConfigTypeEnum.SCHEME_DETAIL.getCode());
            if (BusinessUnitEnum.isDefaultBusinessUnit((String)configDto.getBusinessUnitCode())) {
                configDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            }
            List list = this.activitiesTemplateSdkService.findActivitiesTemplateConfigSelectList(dto, configDto);
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u6a21\u677f\u914d\u7f6e")
    @GetMapping(value={"getItemColumnConfig"})
    public Result<ActivitiesTemplateConfigVo> getItemColumnConfig(@ApiParam(value="\u6a21\u677f\u7f16\u7801") @RequestParam(required=true) String configCode) {
        try {
            ActivitiesTemplateConfigVo configVo = this.activitiesTemplateSdkService.findByCode(configCode);
            return Result.ok((Object)configVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u7c7b\u578b\u4e0b\u62c9")
    @PostMapping(value={"findActivityTypeSelectList"})
    public Result<List<CommonSelectVo>> findActivityTypeSelectList(@ApiParam(value="\u6d3b\u52a8\u7c7b\u578bdto") @RequestBody ActivityTypeSelectDto dto) {
        try {
            List<CommonSelectVo> list = this.activityDetailPlanItemService.findActivityTypeSelectList(dto);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u5f62\u5f0f\u4e0b\u62c9")
    @PostMapping(value={"findActivityFormSelectList"})
    public Result<List<CommonSelectVo>> findActivityFormSelectList(@ApiParam(value="\u6d3b\u52a8\u5f62\u5f0fdto") @RequestBody ActivityFormSelectDto dto) {
        try {
            List<CommonSelectVo> list = this.activityDetailPlanItemService.findActivityFormSelectList(dto);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u9884\u7b97\u6c47\u603b\u4fe1\u606f")
    @PostMapping(value={"findBudgetCacheSumList"})
    public Result<List<ActivityDetailPlanBudgetSumVo>> findActivityDetailPlanItemBudgetCacheSumList(@ApiParam(name="businessUnitCode", value="\u4e1a\u52a1\u5355\u5143") @RequestParam String businessUnitCode, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey) {
        try {
            List<ActivityDetailPlanBudgetSumVo> list = this.activityDetailPlanItemService.findBudgetCacheSumList(businessUnitCode, cacheKey);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5173\u8054\u65b9\u6848\u7f16\u7801\u5173\u95ed\u6d3b\u52a8\u7ec6\u6848")
    @PostMapping(value={"closeByPlanCodeItemList"})
    public Result<?> closeByPlanCodeItemList(@ApiParam(name="ids", value="\u8981\u5173\u95ed\u7684\u65b9\u6848\u7f16\u7801") @RequestBody List<String> businessNoList) {
        try {
            this.activityDetailPlanItemService.closeByPlanCodeItemList(businessNoList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5173\u95ed\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6")
    @PostMapping(value={"closeItem"})
    public Result<?> closeItem(@ApiParam(name="ids", value="\u8981\u5220\u9664\u7684\u6570\u636e") @RequestBody List<String> ids) {
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.batchLock("activity_detail_plan:lock:item_close:", ids, TimeUnit.HOURS, 1);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.activityDetailPlanItemService.closeItem(ids);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.batchUnLock("activity_detail_plan:lock:item_close:", ids);
            }
        }
    }

    @ApiOperation(value="\u5173\u95ed\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u63a8\u9001sd")
    @PostMapping(value={"closeSdActivityItem"})
    public Result<?> closeSdActivityItem(@RequestBody List<String> itemCodeList) {
        try {
            this.activityDetailPlanItemAsyncService.closeSdActivityItem(itemCodeList, this.loginUserService.getAbstractLoginUser());
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5782\u76f4\u6d3b\u52a8\u65b9\u6848\u7ec6\u6848\u660e\u7ec6\u5173\u95ed\u540e\u63a8\u9884\u7b97\u5b9a\u65f6\u4efb\u52a1\u624b\u52a8\u6267\u884c")
    @PostMapping(value={"syncBudgetRollbackVertical"})
    public Result<?> syncBudgetRollbackVertical() {
        try {
            this.activityDetailPlanService.syncBudgetRollbackVertical();
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5173\u95ed\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u63a8\u9001sd")
    @PostMapping(value={"findTerminalListByDetailPlanCode"})
    public Result<List<ActivityDetailPlanReportVo>> findTerminalListByDetailPlanCode(@RequestParam String detailPlanItemCode) {
        try {
            List<ActivityDetailPlanReportVo> list = this.activityDetailPlanItemTerminalService.findTerminalListByDetailPlanItemCode(detailPlanItemCode);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u67e5\u8be2\u95e8\u5e97\u8be6\u60c5")
    @GetMapping(value={"findTerminalByDetailPlanItemCode"})
    public Result<Page<ActivityDetailPlanItemTerminalVo>> findTerminalByDetailPlanItemCode(@PageableDefault(value=50) Pageable pageable, @RequestParam String detailPlanItemCode) {
        try {
            Page<ActivityDetailPlanItemTerminalVo> page = this.activityDetailPlanItemTerminalService.findTerminalByDetailPlanItemCode(pageable, detailPlanItemCode);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7ec6\u6848\u660e\u7ec6\u7f16\u67e5\u8be2\uff08\u7269\u6599\u91c7\u8d2d\u5355\u7528\uff09")
    @GetMapping(value={"findItemForMaterialPurchasing"})
    public Result<Page<ActivityDetailPlanItemVo>> findItemForMaterialPurchasing(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="activityDetailPlanItemDto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        try {
            Page<ActivityDetailPlanItemVo> page = this.activityDetailPlanItemService.findItemForMaterialPurchasing(pageable, activityDetailPlanItemDto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u91cd\u590d\u6d3b\u52a8\u7ec6\u6848\u67e5\u770b")
    @GetMapping(value={"repeatActivityDetailPlanItemPage"})
    public Result<Page<ActivityDetailPlanItemVo>> repeatActivityDetailPlanItemPage(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityDetailPlanItemDto dto) {
        try {
            Page<ActivityDetailPlanItemVo> page = this.activityDetailPlanItemService.repeatActivityDetailPlanItemPage(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

