/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.event;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.fxiaoke.sdk.dto.FXiaoKeRequestData;
import com.biz.crm.mn.third.system.fxiaoke.sdk.dto.FXiaoKeSearchQueryFilter;
import com.biz.crm.mn.third.system.fxiaoke.sdk.dto.FXiaoKeSearchQueryInfo;
import com.biz.crm.mn.third.system.fxiaoke.sdk.service.FXiaoKeService;
import com.biz.crm.mn.third.system.fxiaoke.sdk.vo.FXiaoKeQueryResult;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.foreign.ForeignActivityDetailPlanEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ForeignActivityDetailPlanEvent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FXiaoKeForeignActivityDetailPlanEvent
implements ForeignActivityDetailPlanEvent {
    private static final Logger log = LoggerFactory.getLogger(FXiaoKeForeignActivityDetailPlanEvent.class);
    @Autowired(required=false)
    private FXiaoKeService fXiaoKeService;

    public void createFinish(ForeignActivityDetailPlanEventDto event) {
        try {
            this.callBackFXiaoKe(event);
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u521b\u5efa\u7ec6\u6848\u56de\u8c03\u5931\u8d25-\u7eb7\u4eab\u9500\u5ba2" + e.getMessage());
        }
    }

    private void callBackFXiaoKe(ForeignActivityDetailPlanEventDto event) {
        Result fXiaoKeUpdateResult;
        Result eventResult = event.getResult();
        ActivityDetailPlanDto detailPlanDto = (ActivityDetailPlanDto)eventResult.getResult();
        FXiaoKeSearchQueryInfo fXiaoKeSearchQueryInfo = new FXiaoKeSearchQueryInfo();
        fXiaoKeSearchQueryInfo.setFieldProjection((List)Lists.newArrayList((Object[])new String[]{"_id"}));
        fXiaoKeSearchQueryInfo.setOffset(Integer.valueOf(0));
        fXiaoKeSearchQueryInfo.setLimit(Integer.valueOf(1));
        FXiaoKeSearchQueryFilter fXiaoKeSearchQueryFilter = new FXiaoKeSearchQueryFilter();
        fXiaoKeSearchQueryFilter.setOperator("EQ");
        fXiaoKeSearchQueryFilter.setFieldName("name");
        fXiaoKeSearchQueryFilter.setFieldValues((Object)detailPlanDto.getForeignPlanCode());
        fXiaoKeSearchQueryInfo.setFilters((List)Lists.newArrayList((Object[])new FXiaoKeSearchQueryFilter[]{fXiaoKeSearchQueryFilter}));
        Result fXiaoKeDetailPlanQueryResult = this.fXiaoKeService.queryData("object_a682y__c", fXiaoKeSearchQueryInfo);
        if (!fXiaoKeDetailPlanQueryResult.isSuccess()) {
            throw new RuntimeException(fXiaoKeDetailPlanQueryResult.getMessage());
        }
        List dataList = ((FXiaoKeQueryResult)fXiaoKeDetailPlanQueryResult.getResult()).getData().getDataList();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        String fXiaoKeDetailPlanId = ((JSONObject)dataList.get(0)).getString("_id");
        JSONObject objectData = new JSONObject();
        objectData.put("dataObjectApiName", (Object)"object_a682y__c");
        objectData.put("_id", (Object)fXiaoKeDetailPlanId);
        objectData.put("sync_status__c", (Object)(eventResult.isSuccess() ? "1" : "2"));
        objectData.put("field_2Pye9__c", (Object)detailPlanDto.getDetailPlanCode());
        objectData.put("field_RcfCb__c", (Object)(eventResult.isSuccess() ? "" : eventResult.getMessage()));
        ArrayList detailItems = Lists.newArrayList();
        if (eventResult.isSuccess() && !CollectionUtils.isEmpty((Collection)detailPlanDto.getItemList())) {
            List detailPlanItemForeignCodeList = detailPlanDto.getItemList().stream().map(ActivityDetailPlanItemBase::getForeignPlanItemCode).collect(Collectors.toList());
            fXiaoKeSearchQueryInfo = new FXiaoKeSearchQueryInfo();
            fXiaoKeSearchQueryInfo.setFieldProjection((List)Lists.newArrayList((Object[])new String[]{"_id", "name"}));
            fXiaoKeSearchQueryInfo.setOffset(Integer.valueOf(0));
            fXiaoKeSearchQueryInfo.setLimit(Integer.valueOf(detailPlanItemForeignCodeList.size()));
            fXiaoKeSearchQueryFilter = new FXiaoKeSearchQueryFilter();
            fXiaoKeSearchQueryFilter.setOperator("IN");
            fXiaoKeSearchQueryFilter.setFieldName("name");
            fXiaoKeSearchQueryFilter.setFieldValues(detailPlanItemForeignCodeList);
            fXiaoKeSearchQueryInfo.setFilters((List)Lists.newArrayList((Object[])new FXiaoKeSearchQueryFilter[]{fXiaoKeSearchQueryFilter}));
            fXiaoKeDetailPlanQueryResult = this.fXiaoKeService.queryData("object_DAx8Q__c", fXiaoKeSearchQueryInfo);
            if (!fXiaoKeDetailPlanQueryResult.isSuccess()) {
                throw new RuntimeException(fXiaoKeDetailPlanQueryResult.getMessage());
            }
            dataList = ((FXiaoKeQueryResult)fXiaoKeDetailPlanQueryResult.getResult()).getData().getDataList();
            if (CollectionUtils.isEmpty((Collection)dataList)) {
                throw new RuntimeException("\u7eb7\u4eab\u9500\u5ba2\u7ec6\u6848[" + detailPlanDto.getForeignPlanCode() + "]\u660e\u7ec6\u67e5\u8be2\u5931\u8d25");
            }
            Map<String, String> fXiaoKeItemCodeMap = dataList.stream().collect(Collectors.toMap(item -> item.getString("name"), item -> item.getString("_id")));
            for (ActivityDetailPlanItemDto activityDetailPlanItemDto : detailPlanDto.getItemList()) {
                String fXiaoKeItemId = fXiaoKeItemCodeMap.get(activityDetailPlanItemDto.getForeignPlanItemCode());
                JSONObject detailItemObject = new JSONObject();
                detailItemObject.put("_id", (Object)fXiaoKeItemId);
                detailItemObject.put("field_82dK6__c", (Object)activityDetailPlanItemDto.getDetailPlanItemCode());
                detailItems.add(detailItemObject);
            }
        }
        FXiaoKeRequestData fXiaoKeRequestData = new FXiaoKeRequestData();
        fXiaoKeRequestData.setObjectData(objectData);
        if (!CollectionUtils.isEmpty((Collection)detailItems)) {
            JSONObject details = new JSONObject();
            details.put("object_DAx8Q__c", (Object)detailItems);
            fXiaoKeRequestData.setDetails(details);
        }
        if (!(fXiaoKeUpdateResult = this.fXiaoKeService.updateData(fXiaoKeRequestData)).isSuccess()) {
            throw new RuntimeException(fXiaoKeUpdateResult.getMessage());
        }
    }
}

