/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanItemExportsVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ActivityDetailPlanItemExportsProcess
implements ExportProcess<ActivityDetailPlanItemExportsVo> {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanItemExportsProcess.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Integer total = this.activityDetailPlanItemService.getTotal((String)params.get("cacheKey"));
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        String cacheKey = (String)params.get("cacheKey");
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        ActivityDetailPlanItemDto dto = new ActivityDetailPlanItemDto();
        Page cachePage = this.activityDetailPlanItemService.findCachePageList((Pageable)pageable, dto, cacheKey);
        if (cachePage.getTotal() == 0L) {
            return new JSONArray();
        }
        Collection exportsVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)cachePage.getRecords(), ActivityDetailPlanItemVo.class, ActivityDetailPlanItemExportsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.adjustData(exportsVos);
        return JSON.parseArray((String)JSON.toJSONString((Object)exportsVos));
    }

    public String getBusinessCode() {
        return "TPM_ACTIVITY_DETAIL_PLAN_ITEM_EXPORT";
    }

    public String getBusinessName() {
        return "\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u5bfc\u51fa";
    }

    private void adjustData(Collection<ActivityDetailPlanItemExportsVo> data) {
        Map poMap = this.dictToolkitService.findMapByDictTypeCode("tpm_promotion_object");
        Map atMap = this.dictToolkitService.findMapByDictTypeCode("tpm_audit_type");
        Map ynMap = this.dictToolkitService.findMapByDictTypeCode("yesOrNo");
        for (ActivityDetailPlanItemExportsVo vo : data) {
            if (null != vo.getActivityBeginDate()) {
                vo.setActivityBeginDateStr(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)vo.getActivityBeginDate()));
            }
            if (null != vo.getActivityEndDate()) {
                vo.setActivityEndDateStr(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)vo.getActivityEndDate()));
            }
            if (null != vo.getOrderBeginDate()) {
                vo.setOrderBeginDateStr(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)vo.getOrderBeginDate()));
            }
            if (null != vo.getOrderEndDate()) {
                vo.setOrderEndDateStr(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)vo.getOrderEndDate()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getPromotionObject())) {
                vo.setPromotionObject(poMap.getOrDefault(vo.getPromotionObject(), vo.getPromotionObject()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getAuditType())) {
                vo.setAuditType(atMap.getOrDefault(vo.getAuditType(), vo.getAuditType()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getIsStartPatrol())) {
                vo.setIsStartPatrol(ynMap.getOrDefault(vo.getIsStartPatrol(), vo.getIsStartPatrol()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getRelateToPrice())) {
                vo.setRelateToPrice(ynMap.getOrDefault(vo.getRelateToPrice(), vo.getRelateToPrice()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getIncreasePricePromotion())) {
                vo.setIncreasePricePromotion(ynMap.getOrDefault(vo.getIncreasePricePromotion(), vo.getIncreasePricePromotion()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getDeductType())) {
                vo.setDeductType(ynMap.getOrDefault(vo.getDeductType(), vo.getDeductType()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getDutyProfitAdjust())) {
                vo.setDutyProfitAdjust(ynMap.getOrDefault(vo.getDutyProfitAdjust(), vo.getDutyProfitAdjust()));
            }
            if (!StringUtils.isNotBlank((CharSequence)vo.getOccupyTransferBudget())) continue;
            vo.setOccupyTransferBudget(ynMap.getOrDefault(vo.getOccupyTransferBudget(), vo.getOccupyTransferBudget()));
        }
    }

    public Class<ActivityDetailPlanItemExportsVo> findCrmExcelVoClass() {
        return ActivityDetailPlanItemExportsVo.class;
    }
}

