/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemService;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanItemsExportsVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.sdk.context.execute.RequestParameter;
import com.bizunited.nebula.europa.sdk.service.EuropaInfoVoService;
import com.bizunited.nebula.europa.sdk.service.ExecutionService;
import com.bizunited.nebula.europa.sdk.service.strategy.ExecutionStrategy;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.bizunited.nebula.europa.sdk.vo.ExecutionInfo;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityDetailPlanItemsExportProcess
implements ExportProcess<ActivityDetailPlanItemsExportsVo> {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanItemsExportProcess.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemService activityDetailPlanItemService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private EuropaInfoVoService europaInfoVoService;
    @Autowired
    private List<ExecutionStrategy> executionStrategies;
    @Autowired(required=false)
    private ExecutionService executionService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private RedisService redisService;
    private static final String ACTIVITY_PLAN_ITEM_EXPORT_KEY = "activity_plan:item_export:";

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        List<String> detailPlanCodeList = this.getPlanCodeList(params);
        if (CollectionUtils.isEmpty(detailPlanCodeList)) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u65e0\u9700\u6267\u884c\u5bfc\u51fa\uff01");
        }
        MarsAuthorityContextHolder.clearContext();
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        Page<ActivityDetailPlanItemsExportsVo> exportsVoPage = this.activityDetailPlanItemService.findExportListByDetailPlanCodes((Pageable)pageable, detailPlanCodeList);
        long maxCount = exportsVoPage.getTotal();
        Validate.isTrue((maxCount <= (long)CommonConstant.IE_EXPORT_MAX_TOTAL.intValue() ? 1 : 0) != 0, (String)("\u6267\u884c\u6570\u636e\u89c6\u56fe\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return Long.valueOf(maxCount).intValue();
    }

    private List<String> getPlanCodeList(Map<String, Object> params) {
        String europaInfoCode = "" + params.get("europaInfoCode");
        Validate.notBlank((CharSequence)europaInfoCode, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u4f20\u5165\u5bf9\u5e94\u7684\u6b27\u7f57\u5df4\u6570\u636e\u89c6\u56fe\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        EuropaInfoVo europaInfoVo = this.europaInfoVoService.findByTenantCodeAndCode(tenantCode, europaInfoCode);
        Validate.notNull((Object)europaInfoVo, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u6b27\u7f57\u5df4\u6570\u636e\u89c6\u56fe\u57fa\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        ExecutionStrategy matchedExecutionStrategy = this.getMatchedExecution(europaInfoVo);
        PageRequest pageRequest = PageRequest.of((int)0, (int)999999);
        RequestParameter requestParameter = this.buildRequestParameter((Pageable)pageRequest, europaInfoCode, params);
        ExecutionInfo execution = this.executionService.execution(europaInfoVo, (Pageable)pageRequest, requestParameter, matchedExecutionStrategy);
        List results = execution.getExecuteContent().getResults();
        return results.stream().map(item -> String.valueOf(item.get("detail_plan_code"))).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        List parentOrgVos;
        List parentOrgCodeList;
        List orgVos;
        List<String> detailPlanCodes = this.getPlanCodeList(params);
        MarsAuthorityContextHolder.clearContext();
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        Page<ActivityDetailPlanItemsExportsVo> exportsVoListPage = this.activityDetailPlanItemService.findExportListByDetailPlanCodes((Pageable)pageable, detailPlanCodes);
        List exportsVoList = exportsVoListPage.getRecords();
        List orgCodeList = exportsVoList.stream().filter(Objects::nonNull).map(ActivityDetailPlanItemsExportsVo::getDepartmentCode).filter(Objects::nonNull).flatMap(item -> Arrays.stream(item.split(","))).distinct().collect(Collectors.toList());
        if (!(CollectionUtils.isEmpty(orgCodeList) || CollectionUtils.isEmpty((Collection)(orgVos = this.orgVoService.findByOrgCodes(orgCodeList))) || CollectionUtils.isEmpty(parentOrgCodeList = orgVos.stream().map(OrgVo::getParentCode).distinct().collect(Collectors.toList())) || CollectionUtils.isEmpty((Collection)(parentOrgVos = this.orgVoService.findByOrgCodes(parentOrgCodeList))))) {
            Map<String, String> orgParentMap = orgVos.stream().filter(item -> StringUtil.isNotEmpty((CharSequence)item.getParentCode())).collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getParentCode, (o, n) -> n));
            Map<String, String> parentNameMap = parentOrgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName, (o, n) -> n));
            for (ActivityDetailPlanItemsExportsVo activityDetailPlanItemsExportsVo : exportsVoList) {
                String departmentCode = activityDetailPlanItemsExportsVo.getDepartmentCode();
                String orgCodes = String.valueOf(departmentCode);
                for (String orgCode : orgCodes.split(",")) {
                    String parentOrgName;
                    String parentOrgCode = orgParentMap.get(orgCode);
                    if (StringUtil.isEmpty((CharSequence)parentOrgCode) || StringUtil.isEmpty((CharSequence)parentOrgCode) || StringUtil.isEmpty((CharSequence)(parentOrgName = parentNameMap.get(parentOrgCode)))) continue;
                    activityDetailPlanItemsExportsVo.setParentOrgName(parentOrgName);
                }
            }
        }
        Collection exportsVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)exportsVoList, ActivityDetailPlanItemsExportsVo.class, ActivityDetailPlanItemsExportsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.adjustDate(exportsVos);
        return JSON.parseArray((String)JSON.toJSONString((Object)exportsVos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
    }

    private void adjustDate(Collection<ActivityDetailPlanItemsExportsVo> data) {
        Map poMap = this.dictToolkitService.findMapByDictTypeCode("tpm_promotion_object");
        Map atMap = this.dictToolkitService.findMapByDictTypeCode("tpm_audit_type");
        Map ynMap = this.dictToolkitService.findMapByDictTypeCode("yesOrNo");
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (ActivityDetailPlanItemsExportsVo vo : data) {
            if (null != vo.getActivityBeginDate()) {
                vo.setActivityBeginDateStr(dayFormat.format(vo.getActivityBeginDate()));
            }
            if (null != vo.getActivityEndDate()) {
                vo.setActivityEndDateStr(dayFormat.format(vo.getActivityEndDate()));
            }
            if (null != vo.getOrderBeginDate()) {
                vo.setOrderBeginDateStr(dayFormat.format(vo.getOrderBeginDate()));
            }
            if (null != vo.getOrderEndDate()) {
                vo.setOrderEndDateStr(dayFormat.format(vo.getOrderEndDate()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getPromotionObject())) {
                vo.setPromotionObject(poMap.getOrDefault(vo.getPromotionObject(), vo.getPromotionObject()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getAuditType())) {
                vo.setAuditType(atMap.getOrDefault(vo.getAuditType(), vo.getAuditType()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getIsStartPatrol())) {
                vo.setIsStartPatrol(ynMap.getOrDefault(vo.getIsStartPatrol(), vo.getIsStartPatrol()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getRelateToPrice())) {
                vo.setRelateToPrice(ynMap.getOrDefault(vo.getRelateToPrice(), vo.getRelateToPrice()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getIncreasePricePromotion())) {
                vo.setIncreasePricePromotion(ynMap.getOrDefault(vo.getIncreasePricePromotion(), vo.getIncreasePricePromotion()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getDeductType())) {
                vo.setDeductType(ynMap.getOrDefault(vo.getDeductType(), vo.getDeductType()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getDutyProfitAdjust())) {
                vo.setDutyProfitAdjust(ynMap.getOrDefault(vo.getDutyProfitAdjust(), vo.getDutyProfitAdjust()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getOccupyTransferBudget())) {
                vo.setOccupyTransferBudget(ynMap.getOrDefault(vo.getOccupyTransferBudget(), vo.getOccupyTransferBudget()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getBusinessFormatCode())) {
                vo.setBusinessFormatName(BusinessFormatEnum.getDesc((String)vo.getBusinessFormatCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getProcessStatus())) {
                vo.setProcessStatus(ProcessStatusEnum.getStatusNameByKey((String)vo.getProcessStatus()));
            }
            if (!StringUtils.isNotBlank((CharSequence)vo.getBusinessUnitCode())) continue;
            vo.setBusinessUnitName(BusinessUnitEnum.getDesc((String)vo.getBusinessUnitCode()));
        }
    }

    public String getBusinessCode() {
        return "TPM_ACTIVITY_DETAIL_PLAN_ITEMS_EXPORT";
    }

    public String getBusinessName() {
        return "\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u5bfc\u51fa";
    }

    public Class<ActivityDetailPlanItemsExportsVo> findCrmExcelVoClass() {
        return ActivityDetailPlanItemsExportsVo.class;
    }

    private ExecutionStrategy getMatchedExecution(EuropaInfoVo europaInfoVo) {
        ExecutionStrategy matchedExecutionStrategy = null;
        for (ExecutionStrategy executionStrategy : this.executionStrategies) {
            if (!executionStrategy.validate(europaInfoVo)) continue;
            matchedExecutionStrategy = executionStrategy;
            break;
        }
        Validate.notNull(matchedExecutionStrategy, (String)"\u6267\u884c\u6570\u636e\u89c6\u56fe\u65f6\uff0c\u672a\u627e\u5230\u5339\u914d\u7684\u6267\u884c\u5668\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u89c6\u56fe\u6570\u636e", (Object[])new Object[0]);
        return matchedExecutionStrategy;
    }

    private RequestParameter buildRequestParameter(Pageable pageable, String europaInfoCode, Map<String, Object> params) {
        DatabaseExecuteExternalRequest requestParameter = new DatabaseExecuteExternalRequest();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            requestParameter.setAttribute(key, entry.getValue());
            if (!"sort".equalsIgnoreCase(key)) continue;
            String sortAtt = "" + entry.getValue();
            String[] split = sortAtt.split(",");
            if (split.length == 1) {
                requestParameter.setAttribute(StringUtils.join((Object[])new String[]{"sort.", split[0]}), (Object)"ASC");
                continue;
            }
            if (split.length < 2) continue;
            requestParameter.setAttribute(StringUtils.join((Object[])new String[]{"sort.", split[0]}), (Object)split[1]);
        }
        requestParameter.setAttribute("europaInfoCode", (Object)europaInfoCode);
        requestParameter.setPageable(pageable);
        return requestParameter;
    }

    public String getTaskFileName(ExportTaskProcessVo task) {
        return super.getTaskFileName(task);
    }
}

