/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.MarketingApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.MarketingApprovalService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.MarketingApprovalExportVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.MarketingApprovalVo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MarketingApprovalExportProcess
implements ExportProcess<MarketingApprovalExportVo> {
    private static final Logger log = LoggerFactory.getLogger(MarketingApprovalExportProcess.class);
    @Autowired(required=false)
    private MarketingApprovalService marketingApprovalService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Integer getTotal(Map<String, Object> params) {
        MarketingApprovalDto dto;
        params = this.convertEuropaParam(params);
        PageRequest pageable = PageRequest.of((int)1, (int)1);
        Page pageResult = this.marketingApprovalService.findAllConditions((Pageable)pageable, dto = this.convertParams(params));
        Validate.isTrue((pageResult.getTotal() < (long)CommonConstant.IE_EXPORT_MAX_TOTAL.intValue() ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    @Transactional(readOnly=true)
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        log.info("=====>      \u9500\u552e\u8d39\u7528\u6279\u590d\u8868\u5bfc\u51fa[{}]    <=====", (Object)JSON.toJSONString((Object)vo));
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        MarketingApprovalDto dto = this.convertParams(params);
        Page pageResult = this.marketingApprovalService.findAllConditions((Pageable)pageable, dto);
        if (CollectionUtils.isEmpty((Collection)pageResult.getRecords())) {
            return new JSONArray();
        }
        List records = pageResult.getRecords();
        this.adjustData(records);
        return JSON.parseArray((String)JSON.toJSONString((Object)records, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
    }

    public Class<MarketingApprovalExportVo> findCrmExcelVoClass() {
        return MarketingApprovalExportVo.class;
    }

    public String getBusinessCode() {
        return "TPM_MARKETING_APPROVAL_EXPORT";
    }

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    private MarketingApprovalDto convertParams(Map<String, Object> params) {
        return (MarketingApprovalDto)JSON.parseObject((String)JSON.toJSONString(params), MarketingApprovalDto.class);
    }

    private void adjustData(Collection<MarketingApprovalVo> data) {
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"tpm_budget_data_type", "mdm_business_format", "tpm_department_belong", "tpm_promotion_object", "yesOrNO"}));
        for (MarketingApprovalVo vo : data) {
            vo.setRegionDataTypeCode(this.findDictValue(mapDict, "tpm_budget_data_type", String.valueOf(vo.getRegionDataTypeCode())));
            vo.setHeadquartersDataTypeCode(this.findDictValue(mapDict, "tpm_budget_data_type", String.valueOf(vo.getHeadquartersDataTypeCode())));
            vo.setRegionDepartmentBelongCode(this.findDictValue(mapDict, "tpm_department_belong", String.valueOf(vo.getRegionDepartmentBelongCode())));
            vo.setHeadquartersDepartmentBelongCode(this.findDictValue(mapDict, "tpm_department_belong", String.valueOf(vo.getHeadquartersDepartmentBelongCode())));
            vo.setBusinessCode(this.findDictValue(mapDict, "mdm_business_format", String.valueOf(vo.getBusinessCode())));
            vo.setIsStartPatrol(this.findDictValue(mapDict, "yesOrNO", String.valueOf(vo.getIsStartPatrol())));
            vo.setWhetherTwentyTerminal(this.findDictValue(mapDict, "yesOrNO", String.valueOf(vo.getWhetherTwentyTerminal())));
            vo.setIsTemporary(this.findDictValue(mapDict, "yesOrNO", String.valueOf(vo.getIsTemporary())));
            vo.setPromotionObject(this.findDictValue(mapDict, "tpm_promotion_object", String.valueOf(vo.getPromotionObject())));
        }
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }

    public String getBusinessName() {
        return "TPM\u884c\u9500\u8d39\u7528\u6279\u590d\u8868";
    }
}

