/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.exports;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.SubRelatedDetailPlanItemExportsVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.AcceptTypeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.SubRelatedMainActivityFormVo;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class SubRelatedDetailPlanItemExportsProcess
implements ExportProcess<SubRelatedDetailPlanItemExportsVo> {
    private static final Logger log = LoggerFactory.getLogger(SubRelatedDetailPlanItemExportsProcess.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    private static final String mdm_channel_r_sap = "mdm_channel_r_sap";

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Class<SubRelatedDetailPlanItemExportsVo> findCrmExcelVoClass() {
        return SubRelatedDetailPlanItemExportsVo.class;
    }

    public Integer getTotal(Map<String, Object> params) {
        Integer total;
        String feeYearMonth = (String)params.get("feeYearMonth");
        String customerCode = (String)params.get("customerCode");
        String customerName = (String)params.get("customerName");
        String channelCode = (String)params.get("channel");
        String typeCode = (String)params.get("activityTypeCode");
        List<String> typeCodes = this.conversionTypeCode(typeCode);
        String formCode = (String)params.get("activityFormCode");
        List<String> formCodes = this.conversionFormCode(formCode);
        ActivityDetailPlanItemDto dto = new ActivityDetailPlanItemDto();
        dto.setFeeYearMonth((Date)DateUtil.parse((CharSequence)feeYearMonth, (String)"yyyy-MM"));
        dto.setCustomerCode(customerCode);
        dto.setCustomerName(customerName);
        dto.setDistributionChannelCode(channelCode);
        dto.setTenantCode(TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(typeCodes)) {
            dto.setTypeCodes(typeCodes);
        }
        if (!CollectionUtils.isEmpty(formCodes)) {
            dto.setFormCodes(formCodes);
        }
        Validate.isTrue(((total = this.activityDetailPlanItemSdkService.getSubRelatedItemTotal(dto)) < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Integer total;
        String feeYearMonth = (String)params.get("feeYearMonth");
        String customerCode = (String)params.get("customerCode");
        String customerName = (String)params.get("customerName");
        String channelCode = (String)params.get("channel");
        String typeCode = (String)params.get("activityTypeCode");
        List<String> typeCodes = this.conversionTypeCode(typeCode);
        String formCode = (String)params.get("activityFormCode");
        List<String> formCodes = this.conversionFormCode(formCode);
        ActivityDetailPlanItemDto dto = new ActivityDetailPlanItemDto();
        dto.setFeeYearMonth((Date)DateUtil.parse((CharSequence)feeYearMonth, (String)"yyyy-MM"));
        dto.setCustomerCode(customerCode);
        dto.setCustomerName(customerName);
        dto.setDistributionChannelCode(channelCode);
        dto.setTenantCode(TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(typeCodes)) {
            dto.setTypeCodes(typeCodes);
        }
        if (!CollectionUtils.isEmpty(formCodes)) {
            dto.setFormCodes(formCodes);
        }
        if (Objects.isNull(total = this.activityDetailPlanItemSdkService.getSubRelatedItemTotal(dto)) || total <= 0) {
            throw new IllegalArgumentException("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u65e0\u9700\u6267\u884c\u5bfc\u51fa\uff01");
        }
        Integer pageSize = this.getPageSize();
        Integer num = total / pageSize;
        ArrayList planItemList = new ArrayList(total + 1);
        for (int i = 0; i <= num; ++i) {
            List dataList = this.activityDetailPlanItemSdkService.findSubRelatedCachePageList(Integer.valueOf(i), pageSize, dto);
            if (CollectionUtils.isEmpty((Collection)dataList)) continue;
            planItemList.addAll(dataList);
        }
        if (CollectionUtils.isEmpty(planItemList)) {
            return new JSONArray();
        }
        List exportsList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(planItemList, ActivityDetailPlanItemVo.class, SubRelatedDetailPlanItemExportsVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.convertData(exportsList, typeCode, formCode);
        SubRelatedDetailPlanItemExportsVo top = new SubRelatedDetailPlanItemExportsVo();
        top.setColumn1("*\u7528\u4e8e\u5bfc\u5165\u65f6\u683c\u5f0f\u6821\u9a8c\uff0c\u6b64\u884c\u52ff\u5220");
        exportsList.add(0, top);
        return JSON.parseArray((String)JSON.toJSONString((Object)exportsList));
    }

    private void convertData(Collection<SubRelatedDetailPlanItemExportsVo> exportsList, String typeCode, String formCode) {
        List mainFormCodes;
        List formVoList;
        if (CollectionUtils.isEmpty(exportsList)) {
            return;
        }
        List mdmChannelRelatedSap = this.dictDataVoService.findByDictTypeCode(mdm_channel_r_sap);
        Map<String, DictDataVo> channelCodeMap = mdmChannelRelatedSap.stream().collect(Collectors.toMap(DictDataVo::getDictCode, o -> o));
        List planCustomerCodes = exportsList.stream().map(SubRelatedDetailPlanItemExportsVo::getCustomerCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List customerVos = this.customerVoService.findByCustomerCodes(planCustomerCodes);
        List mdgCodes = customerVos.stream().map(CustomerVo::getErpCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, String> mdgMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, CustomerVo::getErpCode, (v1, v2) -> v1));
        List salesOrgSubComOrgVos = this.salesOrgSubComOrgService.listBySubComOrgCodeList(mdgCodes);
        Map<String, SalesOrgSubComOrgVo> orgCodeMap = salesOrgSubComOrgVos.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSubComOrgCode, each -> each, (v1, v2) -> v1));
        Map<String, List<SubRelatedMainActivityFormVo>> formCodeMap = null;
        if (StringUtils.isBlank((CharSequence)formCode) && !CollectionUtils.isEmpty((Collection)(formVoList = this.activityFormService.findSubRelatedMainByCodes(mainFormCodes = exportsList.stream().map(SubRelatedDetailPlanItemExportsVo::getActivityFormCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()))))) {
            formCodeMap = formVoList.stream().collect(Collectors.groupingBy(SubRelatedMainActivityFormVo::getMainFormCode));
        }
        SimpleDateFormat sif1 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sif2 = new SimpleDateFormat("yyyy-MM");
        for (SubRelatedDetailPlanItemExportsVo export : exportsList) {
            String mdgCode;
            SalesOrgSubComOrgVo orgVo;
            DictDataVo dictDataVo;
            BigDecimal headFeeAmount = Optional.ofNullable(export.getHeadFeeAmount()).orElse(BigDecimal.ZERO);
            BigDecimal departmentFeeAmount = Optional.ofNullable(export.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO);
            BigDecimal customerFeeAmount = Optional.ofNullable(export.getCustomerFeeAmount()).orElse(BigDecimal.ZERO);
            export.setTotalCostAmount(headFeeAmount.add(departmentFeeAmount).add(customerFeeAmount));
            export.setHeadInvestmentFeeAmount(headFeeAmount.add(departmentFeeAmount));
            export.setSelfInvestmentFeeAmount(customerFeeAmount);
            if (!ObjectUtils.isEmpty((Object)export.getActivityBeginDate())) {
                export.setActivityBeginDateStr(sif1.format(export.getActivityBeginDate()));
            }
            if (!ObjectUtils.isEmpty((Object)export.getActivityEndDate())) {
                export.setActivityEndDateStr(sif1.format(export.getActivityEndDate()));
            }
            if (!ObjectUtils.isEmpty((Object)export.getOrderBeginDate())) {
                export.setOrderBeginDateStr(sif1.format(export.getOrderBeginDate()));
            }
            if (!ObjectUtils.isEmpty((Object)export.getOrderEndDate())) {
                export.setOrderEndDateStr(sif1.format(export.getOrderEndDate()));
            }
            if (!ObjectUtils.isEmpty((Object)export.getFeeYearMonth())) {
                export.setFeeYearMonthStr(sif2.format(export.getFeeYearMonth()));
            }
            if (!StringUtils.isBlank((CharSequence)formCode)) {
                export.setActivityFormCode(formCode);
            } else if (!CollectionUtils.isEmpty(formCodeMap)) {
                List<SubRelatedMainActivityFormVo> fromVoList = formCodeMap.get(export.getActivityFormCode());
                export.setActivityFormCode("");
                export.setActivityFormName("");
                export.setActivityTypeCode("");
                if (!CollectionUtils.isEmpty(fromVoList)) {
                    List subFormCodes = fromVoList.stream().map(SubRelatedMainActivityFormVo::getSubFormCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List subFormNames = fromVoList.stream().map(SubRelatedMainActivityFormVo::getSubFormName).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List subTypeCodes = fromVoList.stream().map(SubRelatedMainActivityFormVo::getActivityTypeCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    StringBuilder formCodes = new StringBuilder();
                    Iterator codtIt = subFormCodes.iterator();
                    while (codtIt.hasNext()) {
                        String next = (String)codtIt.next();
                        formCodes.append(next);
                        if (!codtIt.hasNext()) continue;
                        formCodes.append(",");
                    }
                    StringBuilder formNames = new StringBuilder();
                    Iterator nameIt = subFormNames.iterator();
                    while (nameIt.hasNext()) {
                        String next = (String)nameIt.next();
                        formNames.append(next);
                        if (!nameIt.hasNext()) continue;
                        formNames.append(",");
                    }
                    StringBuilder typeCodes = new StringBuilder();
                    Iterator codeIt = subTypeCodes.iterator();
                    while (codeIt.hasNext()) {
                        String next = (String)codeIt.next();
                        typeCodes.append(next);
                        if (!codeIt.hasNext()) continue;
                        typeCodes.append(",");
                    }
                    export.setActivityTypeCode(typeCodes.toString());
                    export.setActivityFormCode(formCodes.toString());
                    export.setActivityFormName(formNames.toString());
                }
            } else {
                export.setActivityFormCode("");
                export.setActivityFormName("");
            }
            if (!StringUtils.isBlank((CharSequence)export.getFirstChannelCode()) && !Objects.isNull(dictDataVo = channelCodeMap.get(export.getFirstChannelCode()))) {
                export.setFirstChannelCode(dictDataVo.getDictValue());
            }
            if (!StringUtils.isBlank((CharSequence)export.getUndertakingMode())) {
                export.setUndertakingMode(AcceptTypeEnum.getDesc((String)export.getUndertakingMode()));
            }
            if (!ObjectUtils.isEmpty((Object)(orgVo = orgCodeMap.get(mdgCode = mdgMap.get(export.getCustomerCode()))))) {
                export.setSalesInstitutionCode(orgVo.getSalesOrgCode());
                continue;
            }
            export.setSalesInstitutionCode("");
        }
    }

    public String getBusinessCode() {
        return "TPM_SUB_RELATED_ACTIVITY_DETAIL_PLAN_ITEM_EXPORT";
    }

    public String getBusinessName() {
        return "\u5206\u5b50\u5411\u4e0a\u5173\u8054\u6d3b\u52a8\u7ec6\u6848\u5bfc\u51fa";
    }

    private List<String> conversionFormCode(String formCode) {
        if (StringUtils.isBlank((CharSequence)formCode)) {
            return null;
        }
        ActivityFormVo formVo = this.activityFormService.findOneByCode(formCode);
        String subMainActivityFormCode = formVo.getSubMainActivityFormCode();
        if (StringUtils.isBlank((CharSequence)subMainActivityFormCode)) {
            return null;
        }
        Object[] split = subMainActivityFormCode.split(",");
        return Lists.newArrayList((Object[])split);
    }

    private List<String> conversionTypeCode(String typeCode) {
        if (StringUtils.isBlank((CharSequence)typeCode)) {
            return null;
        }
        ArrayList<String> typeCodes = new ArrayList<String>();
        typeCodes.add(typeCode);
        List typeVos = this.activityTypeService.findByCodes(typeCodes);
        if (CollectionUtils.isEmpty((Collection)typeVos) || ObjectUtils.isEmpty(typeVos.get(0))) {
            return null;
        }
        String subMainActivityTypeCode = ((ActivityTypeVo)typeVos.get(0)).getSubMainActivityTypeCode();
        if (StringUtils.isBlank((CharSequence)subMainActivityTypeCode)) {
            return null;
        }
        Object[] split = subMainActivityTypeCode.split(",");
        return Lists.newArrayList((Object[])split);
    }
}

