/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.imports;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.imports.vo.ActivityDetailPlanDY00000008CarItemImportVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.internal.ActivityDetailPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.RtmModelCodeEnum;
import com.biz.crm.tpm.business.activity.form.sdk.enums.ApplicationDimensionEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetGroupEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityDetailPlanDY00000008CarImportsProcess
implements ImportProcess<ActivityDetailPlanDY00000008CarItemImportVo> {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanDY00000008CarImportsProcess.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ActivityDetailPlanItemPageCacheHelper activityDetailPlanItemPageCacheHelper;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private MdmTerminalChannelVoService terminalChannelVoService;
    @Autowired(required=false)
    private ProductBrandService productBrandService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private SupplierVoService supplierVoService;
    @Autowired(required=false)
    private MaterialVoService materialVoService;
    @Autowired(required=false)
    private AuditFormulaMainService auditFormulaMainService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    private static final String tpm_audit_type = "tpm_audit_type";
    private static final String accept_type = "accept_type";
    private static final String tpm_activity_import_template_mapping = "tpm_activity_import_template_mapping";

    /*
     * WARNING - void declaration
     */
    public Map<Integer, String> execute(LinkedHashMap<Integer, ActivityDetailPlanDY00000008CarItemImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap errorMap = Maps.newHashMap();
        try {
            List auditFormulaList;
            List salesOrgVos;
            List channelVos;
            String salesOrgCode;
            String regionCode;
            String insCode;
            List<String> formCodes;
            List<String> typeCodes;
            ActivityDetailPlanDY00000008CarItemImportVo importVo;
            Integer index;
            Integer key;
            ArrayList<String> errorMsgList;
            Object cacheKeyObj = params.get("cacheKey");
            Validate.notNull((Object)cacheKeyObj, (String)"\u6269\u5c55\u53c2\u6570cacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            String cacheKey = String.valueOf(cacheKeyObj);
            String[] split1 = cacheKey.split(":");
            String templateCode = split1[split1.length - 1];
            DictDataVo dictDataVo = this.dictDataVoService.findByDictTypeCodeAndDictCode(tpm_activity_import_template_mapping, templateCode);
            if (null == dictDataVo) {
                throw new RuntimeException("\u5bfc\u5165\u6a21\u677f[" + templateCode + "]\u672a\u5728\u6570\u636e\u5b57\u5178[tpm_activity_import_template_mapping]\u4e2d\u914d\u7f6e");
            }
            if (!dictDataVo.getDictValue().equals(this.getTemplateCode())) {
                throw new RuntimeException("\u7ec6\u6848\u6a21\u677f\u4e0e\u5bfc\u5165\u6a21\u677f\u8bf7\u4fdd\u6301\u4e00\u81f4\u3002");
            }
            Object isSummary = params.get("isGather");
            Validate.notNull((Object)isSummary, (String)"\u6269\u5c55\u53c2\u6570isSummary\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((BooleanEnum.TRUE.getCapital().equals(isSummary) || BooleanEnum.FALSE.getCapital().equals(isSummary) ? 1 : 0) != 0, (String)"\u6269\u5c55\u53c2\u6570isSummary\u53ea\u80fd\u4e3aY\u6216N", (Object[])new Object[0]);
            Validate.isTrue((boolean)BooleanEnum.FALSE.getCapital().equals(isSummary), (String)"\u9500\u552e\u8d39\u7528\u5bfc\u5165\u4e0d\u652f\u6301\u6c47\u603b\uff01", (Object[])new Object[0]);
            Object businessFormatCodeObj = params.get("businessFormatCode");
            String businessFormatCode = null;
            if (null != businessFormatCodeObj) {
                businessFormatCode = businessFormatCodeObj.toString();
            }
            if (CollectionUtil.isEmpty(data)) {
                return null;
            }
            ArrayList importVos = Lists.newArrayList(data.values());
            ArrayList dictCodeList = Lists.newArrayList();
            dictCodeList.add(tpm_audit_type);
            dictCodeList.add(accept_type);
            Map dictMap = this.dictDataVoService.findByDictTypeCodeList((List)dictCodeList);
            Map<String, Map<String, String>> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> ((List)item.getValue()).stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode, (o, n) -> n)), (o, n) -> n));
            HashSet activityTypeCodeSet = Sets.newHashSet();
            HashSet activityFormCodeSet = Sets.newHashSet();
            HashSet salesOrgCodeSet = Sets.newHashSet();
            HashSet monthBudgetCodeSet = Sets.newHashSet();
            HashSet customerCodeSet = Sets.newHashSet();
            HashSet terminalChannelSet = Sets.newHashSet();
            HashSet productBrandCodeSet = Sets.newHashSet();
            HashSet productLevelCodeSet = Sets.newHashSet();
            HashSet productCodeSet = Sets.newHashSet();
            HashSet supplierCodeSet = Sets.newHashSet();
            HashSet materialCodeSet = Sets.newHashSet();
            HashSet auditFormulaCodeSet = Sets.newHashSet();
            HashSet cusChannelCodeSet = Sets.newHashSet();
            for (Map.Entry<Integer, ActivityDetailPlanDY00000008CarItemImportVo> entry : data.entrySet()) {
                errorMsgList = new ArrayList<String>();
                key = entry.getKey();
                index = key + 2;
                importVo = entry.getValue();
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityTypeCode())) {
                    typeCodes = Arrays.asList(importVo.getActivityTypeCode().split(","));
                    activityTypeCodeSet.addAll(typeCodes);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityFormCode())) {
                    formCodes = Arrays.asList(importVo.getActivityFormCode().split(","));
                    activityFormCodeSet.addAll(formCodes);
                }
                if (StringUtils.isNotBlank((CharSequence)importVo.getDistributionChannelCode())) {
                    cusChannelCodeSet.add(importVo.getDistributionChannelCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getSalesInstitutionCode())) {
                    if (StringUtils.isEmpty((CharSequence)importVo.getDistributionChannelCode())) {
                        errorMsgList.add("\u7b2c[" + index + "]\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    insCode = importVo.getDistributionChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode();
                    salesOrgCodeSet.add(insCode);
                    if (StringUtils.isNotEmpty((CharSequence)importVo.getSalesRegionCode())) {
                        regionCode = insCode + importVo.getSalesRegionCode();
                        salesOrgCodeSet.add(regionCode);
                        if (StringUtils.isNotEmpty((CharSequence)importVo.getSalesOrgCode())) {
                            salesOrgCode = regionCode + importVo.getSalesOrgCode();
                            salesOrgCodeSet.add(salesOrgCode);
                        }
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getHeadMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getHeadMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getCustomerCode())) {
                    if (StringUtils.isEmpty((CharSequence)importVo.getDistributionChannelCode())) {
                        errorMsgList.add("\u7b2c[" + index + "]\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((CharSequence)importVo.getSalesInstitutionCode())) {
                        errorMsgList.add("\u7b2c[" + index + "]\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    customerCodeSet.add(importVo.getCustomerCode() + importVo.getSalesInstitutionCode() + importVo.getDistributionChannelCode() + businessFormatCode);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductBrandCode())) {
                    productBrandCodeSet.add(importVo.getProductBrandCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductItemCode())) {
                    productLevelCodeSet.add(importVo.getProductItemCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductCategoryCode())) {
                    productLevelCodeSet.add(importVo.getProductCategoryCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductCode())) {
                    productCodeSet.add(importVo.getProductCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getAuditConditionCode())) {
                    auditFormulaCodeSet.add(importVo.getAuditConditionCode());
                }
                if (CollectionUtils.isEmpty(errorMsgList)) continue;
                errorMap.put(key, String.join((CharSequence)",", errorMsgList));
            }
            for (Map.Entry<Integer, ActivityDetailPlanDY00000008CarItemImportVo> entry : data.entrySet()) {
                errorMsgList = new ArrayList();
                key = entry.getKey();
                index = key + 2;
                importVo = entry.getValue();
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityTypeCode())) {
                    typeCodes = Arrays.asList(importVo.getActivityTypeCode().split(","));
                    activityTypeCodeSet.addAll(typeCodes);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityFormCode())) {
                    formCodes = Arrays.asList(importVo.getActivityFormCode().split(","));
                    activityFormCodeSet.addAll(formCodes);
                }
                if (StringUtils.isNotBlank((CharSequence)importVo.getDistributionChannelCode())) {
                    cusChannelCodeSet.add(importVo.getDistributionChannelCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getSalesInstitutionCode())) {
                    if (StringUtils.isEmpty((CharSequence)importVo.getDistributionChannelCode())) {
                        errorMsgList.add("\u7b2c[" + index + "]\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    insCode = importVo.getDistributionChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode();
                    salesOrgCodeSet.add(insCode);
                    if (StringUtils.isNotEmpty((CharSequence)importVo.getSalesRegionCode())) {
                        regionCode = insCode + importVo.getSalesRegionCode();
                        salesOrgCodeSet.add(regionCode);
                        if (StringUtils.isNotEmpty((CharSequence)importVo.getSalesOrgCode())) {
                            salesOrgCode = regionCode + importVo.getSalesOrgCode();
                            salesOrgCodeSet.add(salesOrgCode);
                        }
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getHeadMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getHeadMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getCustomerCode())) {
                    if (StringUtils.isEmpty((CharSequence)importVo.getDistributionChannelCode())) {
                        errorMsgList.add("\u7b2c[" + index + "]\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((CharSequence)importVo.getSalesInstitutionCode())) {
                        errorMsgList.add("\u7b2c[" + index + "]\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    customerCodeSet.add(importVo.getCustomerCode() + importVo.getSalesInstitutionCode() + importVo.getDistributionChannelCode() + businessFormatCode);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductBrandCode())) {
                    productBrandCodeSet.add(importVo.getProductBrandCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductItemCode())) {
                    productLevelCodeSet.add(importVo.getProductItemCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductCategoryCode())) {
                    productLevelCodeSet.add(importVo.getProductCategoryCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getProductCode())) {
                    productCodeSet.add(importVo.getProductCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getAuditConditionCode())) {
                    auditFormulaCodeSet.add(importVo.getAuditConditionCode());
                }
                if (CollectionUtils.isEmpty(errorMsgList)) continue;
                if (errorMap.containsKey(key)) {
                    errorMsgList.add(0, (String)errorMap.get(key));
                }
                errorMap.put(key, String.join((CharSequence)",", errorMsgList));
            }
            Map<Object, Object> activityTypeMap = Maps.newHashMap();
            Map<Object, Object> activityFormMap = Maps.newHashMap();
            Map<Object, Object> salesOrgMap = Maps.newHashMap();
            Map<Object, Object> monthBudgetMap = Maps.newHashMap();
            Map<Object, Object> customerMap = Maps.newHashMap();
            Map<Object, Object> terminalChannelMap = Maps.newHashMap();
            Map<Object, Object> productBrandMap = Maps.newHashMap();
            Map<Object, Object> productLevelMap = Maps.newHashMap();
            Map<Object, Object> productMap = Maps.newHashMap();
            Map<Object, Object> auditFormulaMap = Maps.newHashMap();
            Map<Object, Object> cusChannelMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)activityTypeCodeSet)) {
                List activityTypeList = this.activityTypeService.findByCodes((List)Lists.newArrayList((Iterable)activityTypeCodeSet));
                activityTypeMap = activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, ActivityTypeVo::getActivityTypeName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)activityFormCodeSet)) {
                ArrayList activityFormCodeList = Lists.newArrayList((Iterable)activityFormCodeSet);
                List activityFormVos = this.activityFormService.findByCodes((List)activityFormCodeList);
                activityFormMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)cusChannelCodeSet) && !CollectionUtils.isEmpty((Collection)(channelVos = this.customerChannelVoService.findByCodes(new ArrayList(cusChannelCodeSet))))) {
                cusChannelMap = channelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)monthBudgetCodeSet)) {
                List monthBudgetVos = this.monthBudgetService.listByCodes((List)Lists.newArrayList((Iterable)monthBudgetCodeSet));
                monthBudgetMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)salesOrgCodeSet) && !CollectionUtils.isEmpty((Collection)(salesOrgVos = this.salesOrgVoService.findBySalesOrgCodes((List)Lists.newArrayList((Iterable)salesOrgCodeSet))))) {
                salesOrgMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)terminalChannelSet)) {
                List mdmTerminalChannelVos = this.terminalChannelVoService.listByCodes((List)Lists.newArrayList((Iterable)terminalChannelSet));
                terminalChannelMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode, MdmTerminalChannelVo::getTerminalChannelName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)productBrandCodeSet)) {
                List productBrandVos = this.productBrandService.listByCodes((List)Lists.newArrayList((Iterable)productBrandCodeSet));
                productBrandMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, ProductBrandVo::getProductBrandName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)productLevelCodeSet)) {
                List productLevelVos = this.productLevelVoSdkService.findListByBusinessFormatAndCodes(businessFormatCode, (List)Lists.newArrayList((Iterable)productLevelCodeSet));
                productLevelMap = productLevelVos.stream().collect(Collectors.toMap(item -> item.getProductLevelType() + item.getProductLevelCode(), ProductLevelVo::getProductLevelName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)productCodeSet)) {
                List productVos = this.productVoService.findByCodes((List)Lists.newArrayList((Iterable)productCodeSet));
                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)customerCodeSet)) {
                ArrayList customerCodeList = Lists.newArrayList((Iterable)customerCodeSet);
                List customerVos = this.customerVoService.findBaseByCustomerCodes((List)customerCodeList);
                customerMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)auditFormulaCodeSet) && !CollectionUtils.isEmpty((Collection)(auditFormulaList = this.auditFormulaMainService.findByCodeList((List)Lists.newArrayList((Iterable)auditFormulaCodeSet))))) {
                auditFormulaMap = auditFormulaList.stream().collect(Collectors.toMap(AuditFormulaMainVo::getAuditFormulaCode, Function.identity(), (o, n) -> n));
            }
            ArrayList newList = Lists.newArrayList();
            for (Map.Entry<Integer, ActivityDetailPlanDY00000008CarItemImportVo> entry : data.entrySet()) {
                CustomerVo customerVo;
                String cusCode;
                MonthBudgetVo monthBudgetVo;
                String productLevelName;
                ProductVo productVo;
                ArrayList<String> errorMsgList2 = new ArrayList<String>();
                Integer key2 = entry.getKey();
                Integer index2 = key2 + 2;
                ActivityDetailPlanDY00000008CarItemImportVo importVo2 = entry.getValue();
                ActivityDetailPlanItemDto itemDto = (ActivityDetailPlanItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)importVo2, ActivityDetailPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
                this.validateAndConvertDictData(dictMapMap, tpm_audit_type, importVo2.getAuditType(), arg_0 -> ((ActivityDetailPlanItemDto)itemDto).setAuditType(arg_0), errorMsgList2, "\u7b2c[" + index2 + "]\u6838\u9500\u7c7b\u578b");
                this.validateAndConvertDictData(dictMapMap, accept_type, importVo2.getUndertakingMode(), arg_0 -> ((ActivityDetailPlanItemDto)itemDto).setUndertakingMode(arg_0), errorMsgList2, "\u7b2c[" + index2 + "]\u6d3b\u52a8\u627f\u63a5\u5f62\u5f0f");
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getActivityTypeCode())) {
                    String[] codes = importVo2.getActivityTypeCode().split(",");
                    LinkedList<String> allNames = new LinkedList<String>();
                    for (String string : codes) {
                        String activityTypeName = (String)activityTypeMap.get(string);
                        if (StringUtils.isEmpty((CharSequence)activityTypeName)) {
                            errorMsgList2.add("\u7b2c[" + index2 + "]\u6d3b\u52a8\u5206\u7c7b[" + string + "]\u6709\u8bef");
                            continue;
                        }
                        allNames.add(activityTypeName);
                    }
                    itemDto.setActivityType(importVo2.getActivityTypeCode());
                    itemDto.setActivityTypeName(String.join((CharSequence)",", allNames));
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getActivityFormCode())) {
                    boolean customerNotEmpty = false;
                    boolean terminalNotEmpty = false;
                    boolean orgNotEmpty = false;
                    String[] codes = importVo2.getActivityFormCode().split(",");
                    LinkedList<String> allNames = new LinkedList<String>();
                    for (String code2 : codes) {
                        ActivityFormVo activityFormVo = (ActivityFormVo)activityFormMap.get(code2);
                        if (null == activityFormVo) {
                            errorMsgList2.add("\u7b2c[" + index2 + "]\u6d3b\u52a8\u5f62\u5f0f[" + code2 + "]\u6709\u8bef");
                            continue;
                        }
                        allNames.add(activityFormVo.getActivityFormName());
                        if (!StringUtils.isNotEmpty((CharSequence)activityFormVo.getApplyDimensionality())) continue;
                        if (activityFormVo.getApplyDimensionality().contains(ApplicationDimensionEnum.ORG.getCode())) {
                            orgNotEmpty = true;
                        }
                        if (activityFormVo.getApplyDimensionality().contains(ApplicationDimensionEnum.CUSTOMER.getCode())) {
                            customerNotEmpty = true;
                        }
                        if (!activityFormVo.getApplyDimensionality().contains(ApplicationDimensionEnum.TERMINAL.getCode())) continue;
                        terminalNotEmpty = true;
                    }
                    itemDto.setActivityForm(importVo2.getActivityFormCode());
                    itemDto.setActivityFormName(String.join((CharSequence)",", allNames));
                    if (customerNotEmpty && StringUtils.isEmpty((CharSequence)importVo2.getCustomerCode())) {
                        errorMsgList2.add("\u7b2c[" + index2 + "]\u6d3b\u52a8\u5f62\u5f0f[" + importVo2.getActivityFormCode() + "]\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getAuditConditionCode())) {
                    AuditFormulaMainVo auditFormula = (AuditFormulaMainVo)auditFormulaMap.get(importVo2.getAuditConditionCode());
                    if (auditFormula == null) {
                        errorMsgList2.add("\u7b2c[" + index2 + "]\u6838\u9500\u6761\u4ef6[" + importVo2.getAuditConditionCode() + "]\u6709\u8bef");
                    } else {
                        itemDto.setAuditConditionName(auditFormula.getAuditFormulaName());
                    }
                } else if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(importVo2.getAuditType())) {
                    errorMsgList2.add("\u7b2c[" + index2 + "]\u6838\u9500\u6761\u4ef6\u7f16\u7801\u5fc5\u586b");
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getProductCode())) {
                    productVo = (ProductVo)productMap.get(importVo2.getProductCode());
                    if (null == productVo) {
                        errorMsgList2.add("\u7b2c[" + index2 + "]\u4ea7\u54c1\u7f16\u7801[" + importVo2.getProductCode() + "]\u6709\u8bef");
                    } else {
                        itemDto.setProductName(productVo.getProductName());
                        if (StringUtils.isEmpty((CharSequence)importVo2.getProductUnit())) {
                            itemDto.setProductUnit(productVo.getBaseUnit());
                        }
                        itemDto.setProductBrandCode(productVo.getProductBrandCode());
                        itemDto.setProductBrandName(productVo.getProductBrandName());
                        itemDto.setProductCategoryCode(productVo.getProductCategoryCode());
                        itemDto.setProductCategoryName(productVo.getProductCategoryName());
                        itemDto.setProductItemCode(productVo.getProductLevelCode());
                        itemDto.setProductItemName(productVo.getProductLevelName());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getProductBrandCode())) {
                    String brandName = (String)productBrandMap.get(importVo2.getProductBrandCode());
                    if (StringUtils.isEmpty((CharSequence)brandName)) {
                        errorMsgList2.add("\u7b2c[" + index2 + "]\u54c1\u724c[" + importVo2.getProductBrandCode() + "]\u6709\u8bef");
                    }
                    itemDto.setProductBrandName(brandName);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getProductCategoryCode())) {
                    productLevelName = (String)productLevelMap.get(ProductLevelEnum.category.getCode() + importVo2.getProductCategoryCode());
                    if (StringUtils.isEmpty((CharSequence)productLevelName)) {
                        errorMsgList2.add("\u7b2c[" + index2 + "]\u54c1\u7c7b[" + importVo2.getProductCategoryCode() + "]\u6709\u8bef");
                    }
                    itemDto.setProductCategoryName(productLevelName);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getProductItemCode())) {
                    productLevelName = (String)productLevelMap.get(ProductLevelEnum.items.getCode() + importVo2.getProductItemCode());
                    if (StringUtils.isEmpty((CharSequence)productLevelName)) {
                        errorMsgList2.add("\u7b2c[" + index2 + "]\u54c1\u9879[" + importVo2.getProductItemCode() + "]\u6709\u8bef");
                    }
                    itemDto.setProductItemName(productLevelName);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getGiftCode())) {
                    productVo = (ProductVo)productMap.get(importVo2.getGiftCode());
                    if (null == productVo) {
                        errorMsgList2.add("\u7b2c[" + index2 + "]\u8d60\u54c1\u7f16\u7801[" + importVo2.getGiftCode() + "]\u6709\u8bef");
                    } else {
                        itemDto.setGiftName(productVo.getProductName());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getHeadMonthBudgetCode())) {
                    monthBudgetVo = (MonthBudgetVo)monthBudgetMap.get(importVo2.getHeadMonthBudgetCode());
                    if (null == monthBudgetVo) {
                        errorMsgList2.add("\u7b2c[" + index2 + "]\u603b\u90e8\u8d39\u7528\u9884\u7b97\u7f16\u7801" + importVo2.getHeadMonthBudgetCode() + "\u6709\u8bef");
                    } else {
                        if (!MonthBudgetGroupEnum.organization.getCode().equals(monthBudgetVo.getGroupCode())) {
                            errorMsgList2.add("\u7b2c[" + index2 + "]\u6708\u5ea6\u9884\u7b97[" + monthBudgetVo.getMonthBudgetCode() + "],\u5fc5\u987b\u4e3a\u90e8\u95e8\u5206\u7ec4");
                        }
                        itemDto.setHeadBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                        itemDto.setHeadBudgetItemName(monthBudgetVo.getBudgetItemName());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getMonthBudgetCode())) {
                    monthBudgetVo = (MonthBudgetVo)monthBudgetMap.get(importVo2.getMonthBudgetCode());
                    if (null == monthBudgetVo) {
                        errorMsgList2.add("\u7b2c[" + index2 + "]\u5927\u533a\u81ea\u63a7\u9884\u7b97\u7f16\u7801" + importVo2.getHeadMonthBudgetCode() + "\u6709\u8bef");
                    } else {
                        if (!MonthBudgetGroupEnum.organization.getCode().equals(monthBudgetVo.getGroupCode())) {
                            errorMsgList2.add("\u7b2c[" + index2 + "]\u6708\u5ea6\u9884\u7b97[" + monthBudgetVo.getMonthBudgetCode() + "],\u5fc5\u987b\u4e3a\u90e8\u95e8\u5206\u7ec4");
                        }
                        itemDto.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                        itemDto.setBudgetItemName(monthBudgetVo.getBudgetItemName());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getDistributionChannelCode())) {
                    CustomerChannelVo channelVo = (CustomerChannelVo)cusChannelMap.get(importVo2.getDistributionChannelCode());
                    if (null == channelVo) {
                        errorMsgList2.add("\u7b2c[" + index2 + "]\u6e20\u9053\u7f16\u7801" + importVo2.getDistributionChannelCode() + "\u6709\u8bef");
                    } else {
                        itemDto.setDistributionChannelCode(channelVo.getCustomerChannelCode());
                        itemDto.setDistributionChannelName(channelVo.getCustomerChannelName());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getCustomerCode())) {
                    cusCode = importVo2.getCustomerCode() + importVo2.getSalesInstitutionCode() + importVo2.getDistributionChannelCode() + businessFormatCode;
                    customerVo = (CustomerVo)customerMap.get(cusCode);
                    if (null == customerVo) {
                        errorMsgList2.add("\u7b2c[" + index2 + "]\u5ba2\u6237\u7f16\u7801" + importVo2.getCustomerCode() + "\u6709\u8bef");
                    } else {
                        itemDto.setCustomerName(customerVo.getCustomerName());
                        itemDto.setCustomerCode(customerVo.getCustomerCode());
                        itemDto.setCustomerErpCode(customerVo.getErpCode());
                        itemDto.setSalesInstitutionCode(customerVo.getSalesInstitutionCode());
                        itemDto.setSalesInstitutionName(customerVo.getSalesInstitutionName());
                        itemDto.setSalesInstitutionErpCode(customerVo.getSalesInstitutionErpCode());
                        itemDto.setSalesRegionCode(customerVo.getSalesRegionCode());
                        itemDto.setSalesRegionName(customerVo.getSalesRegionName());
                        itemDto.setSalesRegionErpCode(customerVo.getSalesRegionErpCode());
                        itemDto.setSalesOrgCode(customerVo.getSalesOrgCode());
                        itemDto.setSalesOrgName(customerVo.getSalesOrgName());
                        itemDto.setSalesOrgErpCode(customerVo.getSalesOrgErpCode());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getSalesInstitutionCode())) {
                    String insCode2 = importVo2.getDistributionChannelCode() + businessFormatCode + importVo2.getSalesInstitutionCode();
                    SalesOrgVo salesOrgVo = (SalesOrgVo)salesOrgMap.get(insCode2);
                    if (null == salesOrgVo) {
                        errorMsgList2.add("\u7b2c[" + index2 + "]\u9500\u552e\u673a\u6784\u7f16\u7801[" + importVo2.getSalesInstitutionCode() + "]\u6709\u8bef");
                    } else {
                        itemDto.setSalesInstitutionCode(salesOrgVo.getSalesOrgCode());
                        itemDto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                        itemDto.setSalesInstitutionErpCode(salesOrgVo.getErpCode());
                    }
                    if (StringUtils.isEmpty((CharSequence)importVo2.getSalesOrgCode())) {
                        itemDto.setActivityOrgCode(itemDto.getSalesInstitutionCode());
                        itemDto.setActivityOrgName(itemDto.getSalesInstitutionName());
                        itemDto.setActivityOrgErpCode(itemDto.getSalesInstitutionErpCode());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)importVo2.getSalesRegionCode())) {
                        String regionCode2 = insCode2 + importVo2.getSalesRegionCode();
                        SalesOrgVo salesOrgVo2 = (SalesOrgVo)salesOrgMap.get(regionCode2);
                        if (null == salesOrgVo2) {
                            errorMsgList2.add("\u7b2c[" + index2 + "]\u9500\u552e\u5927\u533a\u7f16\u7801[" + importVo2.getSalesRegionCode() + "]\u6709\u8bef");
                        } else {
                            itemDto.setSalesRegionCode(salesOrgVo2.getSalesOrgCode());
                            itemDto.setSalesRegionErpCode(salesOrgVo2.getErpCode());
                            itemDto.setSalesRegionName(salesOrgVo2.getSalesOrgName());
                        }
                        if (StringUtils.isEmpty((CharSequence)importVo2.getSalesOrgCode())) {
                            itemDto.setActivityOrgCode(itemDto.getSalesRegionCode());
                            itemDto.setActivityOrgName(itemDto.getSalesRegionName());
                            itemDto.setActivityOrgErpCode(itemDto.getSalesRegionErpCode());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)importVo2.getSalesOrgCode())) {
                            String salesCode;
                            SalesOrgVo salesOrgVo3;
                            if (StringUtils.isEmpty((CharSequence)itemDto.getSalesRegionCode())) {
                                errorMsgList2.add("\u7b2c[" + index2 + "]\u7701\u533a\u7f16\u7801[" + importVo2.getSalesOrgCode() + "]\u672a\u83b7\u53d6\u5230\u9500\u552e\u5927\u533a");
                            }
                            if (null == (salesOrgVo3 = (SalesOrgVo)salesOrgMap.get(salesCode = itemDto.getSalesRegionCode() + importVo2.getSalesOrgCode()))) {
                                errorMsgList2.add("\u7b2c[" + index2 + "]\u7701\u533a\u7f16\u7801[" + importVo2.getSalesOrgCode() + "]\u6709\u8bef");
                            } else {
                                itemDto.setSalesOrgCode(salesOrgVo3.getSalesOrgCode());
                                itemDto.setSalesOrgErpCode(salesOrgVo.getErpCode());
                                itemDto.setSalesOrgName(salesOrgVo.getSalesOrgName());
                                itemDto.setActivityOrgCode(itemDto.getSalesOrgCode());
                                itemDto.setActivityOrgName(itemDto.getSalesOrgName());
                                itemDto.setActivityOrgErpCode(itemDto.getSalesOrgErpCode());
                            }
                        }
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getActivityFormCode())) {
                    SalesOrgVo split;
                    for (SalesOrgVo str : split = importVo2.getActivityFormCode().split(",")) {
                        List list = this.activityTypeService.getActivityTypeByActivityFormCode((String)str);
                        list.forEach(act -> {
                            if (StringUtils.isNotEmpty((CharSequence)importVo2.getActivityTypeCode())) {
                                String[] actType = importVo2.getActivityTypeCode().split(",");
                                if (!Arrays.asList(actType).contains(act.getActivityTypeCode())) {
                                    errorMsgList2.add("\u7b2c[" + index2 + "]\u6d3b\u52a8\u5f62\u5f0f\u9700\u5728\u6d3b\u52a8\u5206\u7c7b\u4e0b\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u586b\u5199\u662f\u5426\u6b63\u786e");
                                }
                            } else {
                                errorMsgList2.add("\u7b2c[" + index2 + "]\u6d3b\u52a8\u5f62\u5f0f\u9700\u5728\u6d3b\u52a8\u5206\u7c7b\u4e0b\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u586b\u5199\u662f\u5426\u6b63\u786e");
                            }
                        });
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getHeadMonthBudgetCode()) && StringUtils.isEmpty((CharSequence)importVo2.getHeadFeeAmountStr())) {
                    errorMsgList2.add("\u7b2c[" + index2 + "]\u603b\u90e8\u627f\u62c5\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u586b\u5199\u662f\u5426\u6b63\u786e");
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getMonthBudgetCode()) && StringUtils.isEmpty((CharSequence)importVo2.getDepartmentFeeAmountStr())) {
                    errorMsgList2.add("\u7b2c[" + index2 + "]\u5927\u533a\u627f\u62c5\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u586b\u5199\u662f\u5426\u6b63\u786e");
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo2.getCustomerCode())) {
                    cusCode = importVo2.getCustomerCode() + importVo2.getSalesInstitutionCode() + importVo2.getDistributionChannelCode() + businessFormatCode;
                    customerVo = (CustomerVo)customerMap.get(cusCode);
                    Validate.notNull((Object)customerVo, (String)("\u5ba2\u6237\u7f16\u7801[" + importVo2.getCustomerCode() + "]\u6709\u8bef"), (Object[])new Object[0]);
                    String rtmModelCode = customerVo.getRtmModelCode();
                    if (StringUtils.isNotEmpty((CharSequence)rtmModelCode)) {
                        if (rtmModelCode.equals(RtmModelCodeEnum.SON_COMPANY.getCode())) {
                            void var54_75;
                            BigDecimal subtract;
                            BigDecimal headFeeAmountStr = new BigDecimal(0);
                            BigDecimal departmentFeeAmountStr = new BigDecimal(0);
                            BigDecimal bigDecimal = new BigDecimal(0);
                            BigDecimal offPointAmountStr = new BigDecimal(0);
                            if (StringUtils.isNotEmpty((CharSequence)importVo2.getHeadFeeAmountStr())) {
                                try {
                                    headFeeAmountStr = new BigDecimal(importVo2.getHeadFeeAmountStr());
                                }
                                catch (NumberFormatException e) {
                                    errorMsgList2.add("\u7b2c[" + index2 + "]\u603b\u90e8\u627f\u62c5\u91d1\u989d\u3010" + importVo2.getHeadFeeAmountStr() + "\u3011\u6570\u5b57\u8f6c\u6362\u5f02\u5e38");
                                }
                            }
                            if (StringUtils.isNotEmpty((CharSequence)importVo2.getDepartmentFeeAmountStr())) {
                                try {
                                    departmentFeeAmountStr = new BigDecimal(importVo2.getDepartmentFeeAmountStr());
                                }
                                catch (NumberFormatException e) {
                                    errorMsgList2.add("\u7b2c[" + index2 + "]\u5927\u533a\u627f\u62c5\u91d1\u989d\u3010" + importVo2.getDepartmentFeeAmountStr() + "\u3011\u6570\u5b57\u8f6c\u6362\u5f02\u5e38");
                                }
                            }
                            if (StringUtils.isNotEmpty((CharSequence)importVo2.getIntraCompanyAmountStr())) {
                                try {
                                    BigDecimal bigDecimal2 = new BigDecimal(importVo2.getIntraCompanyAmountStr());
                                }
                                catch (NumberFormatException e) {
                                    errorMsgList2.add("\u7b2c[" + index2 + "]\u5206\u5b50\u516c\u53f8\u70b9\u5185\u91d1\u989d\u3010" + importVo2.getIntraCompanyAmountStr() + "\u3011\u6570\u5b57\u8f6c\u6362\u5f02\u5e38");
                                }
                            }
                            if (StringUtils.isNotEmpty((CharSequence)importVo2.getOffPointAmountStr())) {
                                try {
                                    offPointAmountStr = new BigDecimal(importVo2.getOffPointAmountStr());
                                }
                                catch (NumberFormatException e) {
                                    errorMsgList2.add("\u7b2c[" + index2 + "]\u5206\u5b50\u516c\u53f8\u70b9\u5916\u91d1\u989d\u3010" + importVo2.getOffPointAmountStr() + "\u3011\u6570\u5b57\u8f6c\u6362\u5f02\u5e38");
                                }
                            }
                            if ((subtract = headFeeAmountStr.add(departmentFeeAmountStr).subtract((BigDecimal)var54_75)).compareTo(offPointAmountStr) != 0) {
                                errorMsgList2.add("\u7b2c[" + index2 + "]\u5206\u5b50\u516c\u53f8\u70b9\u5916\u91d1\u989d=\u603b\u90e8\u627f\u62c5\u91d1\u989d+\u5927\u533a\u627f\u62c5\u91d1\u989d-\u5206\u5b50\u516c\u53f8\u70b9\u5185\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u586b\u5199\u662f\u5426\u6b63\u786e");
                            }
                        } else if (rtmModelCode.equals(RtmModelCodeEnum.DEALER.getCode())) {
                            if (StringUtils.isNotEmpty((CharSequence)importVo2.getIntraCompanyAmountStr()) && StringUtils.isNotEmpty((CharSequence)importVo2.getOffPointAmountStr())) {
                                errorMsgList2.add("\u7b2c[" + index2 + "]\u5206\u5b50\u516c\u53f8\u70b9\u5916\u91d1\u989d\u4e0e\u5206\u5b50\u516c\u53f8\u70b9\u5185\u91d1\u989d\u5fc5\u987b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u586b\u5199\u662f\u5426\u6b63\u786e");
                            }
                            if (StringUtils.isNotEmpty((CharSequence)importVo2.getIntraCompanyAmountStr())) {
                                errorMsgList2.add("\u7b2c[" + index2 + "]\u5206\u5b50\u516c\u53f8\u70b9\u5185\u91d1\u989d\u5fc5\u987b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u586b\u5199\u662f\u5426\u6b63\u786e");
                            }
                            if (StringUtils.isNotEmpty((CharSequence)importVo2.getOffPointAmountStr())) {
                                errorMsgList2.add("\u7b2c[" + index2 + "]\u5206\u5b50\u516c\u53f8\u70b9\u5916\u91d1\u989d\u5fc5\u987b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u586b\u5199\u662f\u5426\u6b63\u786e");
                            }
                        }
                    }
                }
                newList.add(itemDto);
                if (CollectionUtils.isEmpty(errorMsgList2)) continue;
                if (errorMap.containsKey(key2)) {
                    errorMsgList2.add(0, (String)errorMap.get(key2));
                }
                errorMap.put(key2, String.join((CharSequence)",", errorMsgList2));
            }
            if (errorMap.isEmpty()) {
                this.activityDetailPlanItemPageCacheHelper.importNewItem(cacheKey.toString(), newList);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
                errorMsg = "\u6570\u636e\u5904\u7406\u5931\u8d25\uff01";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return errorMap;
    }

    public void validateAndConvertDictData(Map<String, Map<String, String>> dictMap, String dictTypeCode, String dictValue, Consumer<String> setMethod, List<String> errorMsgList, String desc) {
        if (StringUtils.isEmpty((CharSequence)dictValue)) {
            return;
        }
        Map<String, String> dictDataMap = dictMap.get(dictTypeCode);
        String dictCode = dictDataMap.get(dictValue);
        if (StringUtils.isEmpty((CharSequence)dictCode)) {
            errorMsgList.add(desc + "[" + dictValue + "]\u6709\u8bef");
        }
        setMethod.accept(dictCode);
    }

    public Class<ActivityDetailPlanDY00000008CarItemImportVo> findCrmExcelVoClass() {
        return ActivityDetailPlanDY00000008CarItemImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_DETAIL_ACTIVITY_PLAN_IMPORT_DY00000008_CAR";
    }

    public String getTemplateName() {
        return "\u6d3b\u52a8\u7ec6\u6848\u968f\u8f66\u642d\u589e\u5bfc\u5165\u6a21\u677f\uff08\u4e3b\u4f53\uff09";
    }

    public String getBusinessCode() {
        return "TPM_ACTIVITY_DETAIL_PLAN_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u5bfc\u5165";
    }
}

