/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.modify.listener;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.rocketmq.event.RocketMqProducerEvent;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.modify.enums.ActivityDetailPlanModifyMqTagEnum;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityDetailPlanModifyCompleteListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanModifyCompleteListener.class);
    @Autowired(required=false)
    private ActivityDetailPlanModifyService activityPlanModifyService;
    @Autowired(required=false)
    private ApplicationEventPublisher eventPublisher;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public String getBusinessCode() {
        return "activity_detail_plan_modify";
    }

    public void onProcessComplete(ProcessStatusDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessNo())) {
            return;
        }
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty((CharSequence)dto.getProcessNo(), (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            this.activityPlanModifyService.processPass(dto);
            this.passPushMq(dto.getProcessNo(), dto.getBusinessNo());
        } else if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) || ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            this.activityPlanModifyService.processRejectAndRecover(dto);
        }
    }

    private void passPushMq(String processNo, String businessNo) {
        if (StringUtils.isEmpty((CharSequence)businessNo)) {
            return;
        }
        ArrayList pushTagList = Lists.newArrayList();
        for (ActivityDetailPlanModifyMqTagEnum mqTagEnum : ActivityDetailPlanModifyMqTagEnum.values()) {
            if (!ActivityDetailPlanModifyMqTagEnum.PushType.code.equals((Object)mqTagEnum.getPushType())) continue;
            pushTagList.add(mqTagEnum);
        }
        if (CollectionUtils.isEmpty((Collection)pushTagList)) {
            return;
        }
        String accountJson = "";
        String currentAccount = "";
        if (this.loginUserService != null) {
            currentAccount = this.loginUserService.getLoginAccountName();
            AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
            accountJson = Objects.isNull(userIdentity) ? null : JSON.toJSONString((Object)userIdentity);
        }
        for (ActivityDetailPlanModifyMqTagEnum mqTagEnum : pushTagList) {
            RocketMqProducerEvent rocketMqProducerEvent = new RocketMqProducerEvent((Object)this, currentAccount, accountJson, false, businessNo, "TPM_ACTIVITY_DETAIL_PLAN_MODIFY_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment(), mqTagEnum.getCode(), businessNo);
            this.eventPublisher.publishEvent((ApplicationEvent)rocketMqProducerEvent);
        }
    }
}

