/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanBudgetModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.mapper.ActivityDetailPlanBudgetModifyMapper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityDetailPlanBudgetModifyRepository
extends ServiceImpl<ActivityDetailPlanBudgetModifyMapper, ActivityDetailPlanBudgetModify> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<ActivityDetailPlanBudgetModifyDto> listDtoByModifyCodeList(List<String> modifyCodeList) {
        List<ActivityDetailPlanBudgetModify> activityPlanBudgets = this.listByModifyCodeList(modifyCodeList);
        if (CollectionUtils.isNotEmpty(activityPlanBudgets)) {
            List dtoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(activityPlanBudgets, ActivityDetailPlanBudgetModify.class, ActivityDetailPlanBudgetModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
            return dtoList;
        }
        return Lists.newArrayList();
    }

    public List<ActivityDetailPlanBudgetModify> listByModifyCodeList(List<String> modifyCodeList) {
        if (org.springframework.util.CollectionUtils.isEmpty(modifyCodeList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlanBudgetModify::getModifyBusinessCode, modifyCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<ActivityDetailPlanBudgetModify> listByDetailCodeList(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlanBudgetModify::getDetailPlanItemCode, itemCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void deleteByIds(List<String> ids) {
        if (org.springframework.util.CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void deletePhysicalByModifyBusinessCode(String modifyBusinessCode) {
        if (StringUtils.isEmpty((CharSequence)modifyBusinessCode)) {
            return;
        }
        LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
        updateWrapper.eq(ActivityDetailPlanBudgetModify::getModifyBusinessCode, (Object)modifyBusinessCode);
        this.remove((Wrapper)updateWrapper);
    }

    public void deleteByModifyBusinessCodes(List<String> modifyBusinessCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(modifyBusinessCodes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityDetailPlanBudgetModify::getModifyBusinessCode, modifyBusinessCodes);
        this.update((Wrapper)updateWrapper);
    }

    public void fillVoListProperties(List<ActivityDetailPlanBudgetVo> voList) {
        if (org.springframework.util.CollectionUtils.isEmpty(voList)) {
            return;
        }
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityDetailPlanBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        for (ActivityDetailPlanBudgetVo item : voList) {
            this.fillVoProperties(item, propertyMap);
        }
    }

    public void fillVoProperties(ActivityDetailPlanBudgetVo item) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityDetailPlanBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        this.fillVoProperties(item, propertyMap);
    }

    public void fillVoProperties(ActivityDetailPlanBudgetVo item, Map<String, PropertyDescriptor> propertyMap) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, ActivityDetailPlanBudgetVo.class, propertyMap);
    }
}

