/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanItemModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.mapper.ActivityDetailPlanItemModifyMapper;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.vo.ActivityDetailPlanItemModifyVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ActivityDetailPlanItemModifyRepository
extends ServiceImpl<ActivityDetailPlanItemModifyMapper, ActivityDetailPlanItemModify> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<ActivityDetailPlanItemModifyDto> findDtoListByModifyCode(String modifyCode) {
        if (StringUtils.isBlank((CharSequence)modifyCode)) {
            return Lists.newArrayList();
        }
        ActivityPlanItemModifyDto dto = new ActivityPlanItemModifyDto();
        dto.setModifyBusinessCode(modifyCode);
        List<ActivityDetailPlanItemModify> itemList = this.findList(dto);
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityDetailPlanItemModify.class, ActivityDetailPlanItemModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillDtoListProperties(dtoList);
        return dtoList;
    }

    public List<ActivityDetailPlanItemModifyDto> findDtoList(ActivityPlanItemModifyDto planItem) {
        List<ActivityDetailPlanItemModify> itemList = this.findList(planItem);
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityDetailPlanItemModify.class, ActivityDetailPlanItemModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillDtoListProperties(dtoList);
        return dtoList;
    }

    public List<ActivityDetailPlanItemModify> findListByModifyBusinessCode(String modifyBusinessCode) {
        if (StringUtils.isBlank((CharSequence)modifyBusinessCode)) {
            return Lists.newArrayList();
        }
        ActivityPlanItemModifyDto dto = new ActivityPlanItemModifyDto();
        dto.setModifyBusinessCode(modifyBusinessCode);
        return this.findList(dto);
    }

    public List<ActivityDetailPlanItemModify> findList(ActivityPlanItemModifyDto planItem) {
        return this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityDetailPlanItemModify.class).eq(StringUtils.isNotBlank((CharSequence)planItem.getModifyBusinessCode()), ActivityDetailPlanItemModify::getModifyBusinessCode, (Object)planItem.getModifyBusinessCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode()));
    }

    public void fillVoListProperties(List<ActivityDetailPlanItemModifyVo> voList) {
        if (org.springframework.util.CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (ActivityDetailPlanItemModifyVo item : voList) {
            this.fillVoProperties(item);
        }
    }

    public void fillVoProperties(ActivityDetailPlanItemModifyVo item) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)((Object)item), ActivityDetailPlanItemModifyVo.class);
        BigDecimal feeAmount = Optional.ofNullable(item.getTotalFeeAmount()).orElse(BigDecimal.ZERO);
    }

    public void fillDtoListProperties(List<ActivityDetailPlanItemModifyDto> dtoList) {
        if (org.springframework.util.CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (ActivityDetailPlanItemModifyDto item : dtoList) {
            this.fillDtoProperties(item);
        }
    }

    public void fillDtoProperties(ActivityDetailPlanItemModifyDto item) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, ActivityDetailPlanItemModifyDto.class);
        item.setActivityType(item.getActivityTypeCode());
        item.setActivityForm(item.getActivityFormCode());
    }

    public void deleteByIds(ArrayList<String> ids) {
        if (org.springframework.util.CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void deleteByDetailModifyBusinessCodes(List<String> modifyBusinessCodeList) {
        if (org.springframework.util.CollectionUtils.isEmpty(modifyBusinessCodeList)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityDetailPlanItemModify::getModifyBusinessCode, modifyBusinessCodeList);
        this.update((Wrapper)updateWrapper);
    }

    public List<ActivityDetailPlanItemModifyDto> findListByModifyBusinessCodes(List<String> modifyBusinessCodes) {
        if (CollectionUtils.isEmpty(modifyBusinessCodes)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        List itemList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(ActivityDetailPlanItemModify::getModifyBusinessCode, modifyBusinessCodes)).list();
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)itemList, ActivityDetailPlanItemModify.class, ActivityDetailPlanItemModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillDtoListProperties(dtoList);
        return dtoList;
    }

    public Page<ActivityDetailPlanItemModifyVo> findByConditions(Pageable pageable, ActivityDetailPlanItemModifyDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<ActivityDetailPlanItemModifyVo> pageList = ((ActivityDetailPlanItemModifyMapper)this.baseMapper).findByConditions((Page<ActivityDetailPlanItemModifyVo>)page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }

    public Page<ActivityDetailPlanItemModifyVo> findItemBeforeModifyList(Pageable pageable, ActivityDetailPlanItemModifyDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<ActivityDetailPlanItemModifyVo> pageList = ((ActivityDetailPlanItemModifyMapper)this.baseMapper).findItemBeforeModifyList((Page<ActivityDetailPlanItemModifyVo>)page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }
}

