/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.mapper.ActivityDetailPlanModifyMapper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityDetailPlanModifyRepository
extends ServiceImpl<ActivityDetailPlanModifyMapper, ActivityDetailPlanModify> {
    @Autowired
    private ActivityDetailPlanModifyMapper activityDetailPlanModifyMapper;

    public Page<ActivityDetailPlanVo> findToModifyList(Pageable pageable, ActivityDetailPlanDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ActivityDetailPlanVo> pageList = this.activityDetailPlanModifyMapper.findToModifyList((Page<ActivityDetailPlanVo>)page, dto);
        return pageList;
    }

    public void deleteIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void updateProcessStatusAndProcessNo(String modifyBusinessCode, String processStatus, String processNo) {
        if (StringUtils.isEmpty((CharSequence)modifyBusinessCode)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ActivityDetailPlanModify.class).set(ActivityDetailPlanModify::getProcessStatus, (Object)processStatus)).set(ActivityDetailPlanModify::getProcessNo, (Object)processNo)).in(ActivityDetailPlanModify::getModifyBusinessCode, new Object[]{modifyBusinessCode})).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public void updateProcessStatus(String businessNo, String processStatus) {
        if (StringUtils.isEmpty((CharSequence)businessNo)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ActivityDetailPlanModify.class).set(ActivityDetailPlanModify::getProcessStatus, (Object)processStatus)).in(ActivityDetailPlanModify::getModifyBusinessCode, new Object[]{businessNo})).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public ActivityDetailPlanModify getByCode(String modifyBusinessCode) {
        if (StringUtils.isEmpty((CharSequence)modifyBusinessCode)) {
            return null;
        }
        return (ActivityDetailPlanModify)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ActivityDetailPlanModify::getModifyBusinessCode, (Object)modifyBusinessCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())));
    }
}

