/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanBudgetModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository.ActivityDetailPlanBudgetModifyRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanBudgetModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.OperateActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanBudgetOccupyTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityDetailPlanBudgetModifyServiceImpl
implements ActivityDetailPlanBudgetModifyService {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;
    @Autowired(required=false)
    private ActivityDetailPlanBudgetModifyRepository activityDetailPlanBudgetModifyRepository;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private ActivityPlanSdkService activityPlanSdkService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveActivityDetailPlanBudgetList(ActivityDetailPlanModify entity, boolean update, List<ActivityDetailPlanItemModifyDto> itemDtoList) {
        HashMap oldMap = Maps.newHashMap();
        if (update) {
            this.activityDetailPlanBudgetModifyRepository.deletePhysicalByModifyBusinessCode(entity.getModifyBusinessCode());
        }
        for (ActivityDetailPlanItemModifyDto itemDto : itemDtoList) {
            if (CollectionUtils.isEmpty((Collection)itemDto.getBudgetShares())) continue;
            itemDto.getBudgetShares().forEach(item -> {
                item.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                item.setDetailPlanCode(itemDto.getDetailPlanCode());
                item.setModifyBusinessCode(entity.getModifyBusinessCode());
            });
        }
        List budgetDtoList = itemDtoList.stream().map(ActivityDetailPlanItemModifyDto::getBudgetShares).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(budgetDtoList, ActivityDetailPlanBudgetModifyDto.class, ActivityDetailPlanBudgetModify.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (ActivityDetailPlanBudgetModify item2 : list) {
            item2.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item2.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item2.setTenantCode(entity.getTenantCode());
            item2.setId(null);
            saveList.add(item2);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.activityDetailPlanBudgetModifyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.activityDetailPlanBudgetModifyRepository.updateBatchById(updateList);
        }
    }

    @Override
    public void deleteByModifyCodes(List<String> planCodes) {
        this.activityDetailPlanBudgetModifyRepository.deleteByModifyBusinessCodes(planCodes);
    }

    @Override
    public void useMonthBudgetByModifyCode(String modifyCode, String detailPlanCode, boolean doSave) {
        List<ActivityDetailPlanBudgetModifyDto> modifyItemBudgetList = this.activityDetailPlanBudgetModifyRepository.listDtoByModifyCodeList(Lists.newArrayList((Object[])new String[]{modifyCode}));
        this.useMonthBudget(modifyItemBudgetList, detailPlanCode, doSave);
    }

    @Override
    public void useMonthBudget(List<ActivityDetailPlanBudgetModifyDto> modifyItemBudgetList, String detailPlanCode, final boolean doSave) {
        List<ActivityDetailPlanBudget> originBudgetList = this.activityDetailPlanBudgetRepository.listByDetailPlanCode(detailPlanCode);
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream().filter(item -> null != item.getUseAmount()).collect(Collectors.toMap(item -> item.getDetailPlanItemCode() + item.getRelatePlanItemCode() + item.getMonthBudgetCode(), ActivityDetailPlanBudget::getUseAmount));
        ArrayList strategyOperateList = Lists.newArrayList();
        ArrayList budgetOperateList = Lists.newArrayList();
        ArrayList planBudgetOperateList = Lists.newArrayList();
        for (final ActivityDetailPlanBudgetModifyDto budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            String key = budgetShareModify.getDetailPlanItemCode() + budgetShareModify.getRelatePlanItemCode() + budgetShareModify.getMonthBudgetCode();
            final BigDecimal originUseAmount = originBudgetMap.getOrDefault(key, BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) <= 0) continue;
            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType())) {
                budgetOperateList.add(new OperateMonthBudgetDto(){
                    {
                        this.setBusinessCode(budgetShareModify.getDetailPlanItemCode());
                        this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                        this.setOperationAmount(budgetShareModify.getUseAmount().subtract(originUseAmount));
                        this.setDoSave(doSave);
                    }
                });
            }
            if (!ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShareModify.getOccupyType()) || !StringUtils.isNotEmpty((CharSequence)budgetShareModify.getRelatePlanItemCode())) continue;
            planBudgetOperateList.add(new OperateActivityPlanBudgetDto(){
                {
                    this.setBusinessCode(budgetShareModify.getDetailPlanItemCode());
                    this.setPlanCode(budgetShareModify.getRelatePlanCode());
                    this.setPlanItemCode(budgetShareModify.getRelatePlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                    this.setOperationAmount(budgetShareModify.getUseAmount().subtract(originUseAmount));
                    this.setDoSave(doSave);
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)budgetOperateList)) {
            this.monthBudgetService.operateBudget((List)budgetOperateList);
        }
        if (!CollectionUtils.isEmpty((Collection)planBudgetOperateList)) {
            this.activityPlanSdkService.operateBudget((List)planBudgetOperateList);
        }
    }

    @Override
    public void returnMonthBudgetByModifyCode(String modifyCode, String detailPlanCode) {
        List<ActivityDetailPlanBudgetModify> modifyItemBudgetList = this.activityDetailPlanBudgetModifyRepository.listByModifyCodeList(Lists.newArrayList((Object[])new String[]{modifyCode}));
        List<ActivityDetailPlanBudget> originBudgetList = this.activityDetailPlanBudgetRepository.listByDetailPlanCode(detailPlanCode);
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream().collect(Collectors.toMap(item -> item.getDetailPlanItemCode() + item.getRelatePlanItemCode() + item.getMonthBudgetCode(), ActivityDetailPlanBudget::getUseAmount));
        ArrayList budgetOperateList = Lists.newArrayList();
        ArrayList planBudgetOperateList = Lists.newArrayList();
        for (final ActivityDetailPlanBudgetModify budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            String key = budgetShareModify.getOccupyType() + budgetShareModify.getDetailPlanItemCode() + budgetShareModify.getRelateStrategyItemCode() + budgetShareModify.getRelatePlanItemCode() + budgetShareModify.getMonthBudgetCode();
            final BigDecimal originUseAmount = originBudgetMap.getOrDefault(key, BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) <= 0) continue;
            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType())) {
                budgetOperateList.add(new OperateMonthBudgetDto(){
                    {
                        this.setBusinessCode(budgetShareModify.getDetailPlanItemCode());
                        this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                        this.setOperationAmount(budgetShareModify.getUseAmount().subtract(originUseAmount));
                    }
                });
            }
            if (!ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShareModify.getOccupyType()) || !StringUtils.isNotEmpty((CharSequence)budgetShareModify.getRelatePlanItemCode())) continue;
            planBudgetOperateList.add(new OperateActivityPlanBudgetDto(){
                {
                    this.setBusinessCode(budgetShareModify.getDetailPlanItemCode());
                    this.setPlanCode(budgetShareModify.getRelatePlanCode());
                    this.setPlanItemCode(budgetShareModify.getRelatePlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(budgetShareModify.getUseAmount());
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)budgetOperateList)) {
            this.monthBudgetService.operateBudget((List)budgetOperateList);
        }
        if (!CollectionUtils.isEmpty((Collection)planBudgetOperateList)) {
            this.activityPlanSdkService.operateBudget((List)planBudgetOperateList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void passReturnMonthBudgetByModifyCode(List<ActivityDetailPlanBudget> originBudgetList, List<ActivityDetailPlanBudgetModify> modifyItemBudgetList) {
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream().filter(item -> null != item.getUseAmount()).collect(Collectors.toMap(item -> item.getDetailPlanItemCode() + item.getRelatePlanItemCode() + item.getMonthBudgetCode(), ActivityDetailPlanBudget::getUseAmount));
        ArrayList budgetOperateList = Lists.newArrayList();
        ArrayList planBudgetOperateList = Lists.newArrayList();
        for (final ActivityDetailPlanBudgetModify budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            String key = budgetShareModify.getDetailPlanItemCode() + budgetShareModify.getRelatePlanItemCode() + budgetShareModify.getMonthBudgetCode();
            final BigDecimal originUseAmount = originBudgetMap.getOrDefault(key, BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) >= 0) continue;
            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType())) {
                budgetOperateList.add(new OperateMonthBudgetDto(){
                    {
                        this.setBusinessCode(budgetShareModify.getDetailPlanItemCode());
                        this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                        this.setOperationAmount(originUseAmount.subtract(budgetShareModify.getUseAmount()));
                    }
                });
            }
            if (!ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShareModify.getOccupyType()) || !StringUtils.isNotEmpty((CharSequence)budgetShareModify.getRelatePlanItemCode())) continue;
            planBudgetOperateList.add(new OperateActivityPlanBudgetDto(){
                {
                    this.setBusinessCode(budgetShareModify.getDetailPlanItemCode());
                    this.setPlanCode(budgetShareModify.getRelatePlanCode());
                    this.setPlanItemCode(budgetShareModify.getRelatePlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(originUseAmount.subtract(budgetShareModify.getUseAmount()));
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)budgetOperateList)) {
            this.monthBudgetService.operateBudget((List)budgetOperateList);
        }
        if (!CollectionUtils.isEmpty((Collection)planBudgetOperateList)) {
            this.activityPlanSdkService.operateBudget((List)planBudgetOperateList);
        }
    }
}

