/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanItemModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository.ActivityDetailPlanItemModifyRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.vo.ActivityDetailPlanItemModifyVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityDetailPlanItemModifyPageCacheHelper
extends MnPageCacheHelper<ActivityDetailPlanItemModifyVo, ActivityDetailPlanItemModifyDto> {
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private ActivityDetailPlanItemModifyRepository activityDetailPlanItemModifyRepository;
    @Autowired(required=false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getCacheKeyPrefix() {
        return "activity_detail_plan:item_cache:modify:";
    }

    public Class<ActivityDetailPlanItemModifyDto> getDtoClass() {
        return ActivityDetailPlanItemModifyDto.class;
    }

    public Class<ActivityDetailPlanItemModifyVo> getVoClass() {
        return ActivityDetailPlanItemModifyVo.class;
    }

    public List<ActivityDetailPlanItemModifyDto> findDtoListFromRepository(ActivityDetailPlanItemModifyDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getModifyBusinessCode()) && StringUtils.isEmpty((CharSequence)dto.getDetailPlanCode())) {
            return Lists.newArrayList();
        }
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        List<ActivityDetailPlanItemDto> planItemDtos = this.activityDetailPlanItemRepository.findDtoAndAttachListByDetailPlanCode(dto.getDetailPlanCode());
        List<Object> allDtoList = null;
        if (StringUtils.isNotEmpty((CharSequence)dto.getModifyBusinessCode())) {
            allDtoList = this.activityDetailPlanItemModifyRepository.findDtoListByModifyCode(dto.getModifyBusinessCode());
            Map planItemDtoMap = planItemDtos.stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, Function.identity()));
            for (ActivityDetailPlanItemModifyDto activityDetailPlanItemModifyDto : allDtoList) {
                ActivityDetailPlanItemModify modifyItem = (ActivityDetailPlanItemModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityDetailPlanItemModifyDto, ActivityDetailPlanItemModify.class, HashSet.class, ArrayList.class, new String[0]));
                BeanUtils.copyProperties(planItemDtoMap.get(activityDetailPlanItemModifyDto.getDetailPlanItemCode()), (Object)activityDetailPlanItemModifyDto);
                BeanUtils.copyProperties((Object)((Object)modifyItem), (Object)activityDetailPlanItemModifyDto);
            }
            this.activityDetailPlanItemModifyRepository.fillDtoListProperties(allDtoList);
        } else {
            allDtoList = Lists.newArrayList();
            for (ActivityDetailPlanItemDto planItemDto : planItemDtos) {
                ActivityDetailPlanItemModifyDto activityDetailPlanItemModifyDto = (ActivityDetailPlanItemModifyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)planItemDto, ActivityDetailPlanItemModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
                if (!CollectionUtils.isEmpty((Collection)planItemDto.getBudgetShares())) {
                    // empty if block
                }
                allDtoList.add(activityDetailPlanItemModifyDto);
            }
        }
        allDtoList.sort(Comparator.comparing(ActivityDetailPlanItemBase::getDetailPlanItemCode));
        Map<String, List<ActivityDetailPlanItemModifyDto>> allMap = allDtoList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemBase::getTemplateConfigCode));
        for (Map.Entry entry : allMap.entrySet()) {
            String thisRedisIdCacheKey = redisCacheIdKey.replace(templateCode, (CharSequence)entry.getKey());
            String thisRedisDataCacheKey = redisCacheDataKey.replace(templateCode, (CharSequence)entry.getKey());
            Map newItemMap = ((List)entry.getValue()).stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
            this.redisService.lPushAll(thisRedisIdCacheKey, Long.valueOf(this.getExpireTime()), ((List)entry.getValue()).stream().map(this::getDtoKey).toArray());
            this.redisTemplate.opsForHash().putAll((Object)thisRedisDataCacheKey, newItemMap);
            this.redisService.expire(thisRedisDataCacheKey, this.getExpireTime());
        }
        return allMap.get(templateCode);
    }

    public boolean initToCacheFromRepository() {
        return false;
    }

    public List<ActivityDetailPlanItemModifyDto> newItem(String cacheKey, List<ActivityDetailPlanItemModifyDto> itemList) {
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        ActivityDetailPlanItemModifyDto newItem = new ActivityDetailPlanItemModifyDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newItem.setTemplateConfigCode(templateCode);
        return Lists.newArrayList((Object[])new ActivityDetailPlanItemModifyDto[]{newItem});
    }

    public List<ActivityDetailPlanItemModifyDto> copyItem(String cacheKey, List<ActivityDetailPlanItemModifyDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityDetailPlanItemModifyDto.class, ActivityDetailPlanItemModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (ActivityDetailPlanItemModifyDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setDetailPlanItemCode(null);
        }
        return newItemList;
    }

    public Object getDtoKey(ActivityDetailPlanItemModifyDto ActivityDetailPlanItemModifyDto2) {
        return ActivityDetailPlanItemModifyDto2.getId();
    }

    public String getCheckedStatus(ActivityDetailPlanItemModifyDto ActivityDetailPlanItemModifyDto2) {
        return ActivityDetailPlanItemModifyDto2.getChecked();
    }

    public String getRedisCacheInitKey(String cacheKey) {
        String redisCacheInitKey = super.getRedisCacheInitKey(cacheKey);
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        return redisCacheInitKey.replace(templateCode, "");
    }
}

