/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.entity.ActivityDetailPlanPlanModify;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.repository.ActivityDetailPlanPlanModifyRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.modify.service.ActivityDetailPlanPlanModifyService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.modify.dto.ActivityDetailPlanPlanModifyDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityDetailPlanPlanModifyServiceImpl
implements ActivityDetailPlanPlanModifyService {
    @Autowired(required=false)
    private ActivityDetailPlanPlanModifyRepository activityDetailPlanPlanModifyRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveActivityDetailPlanPlanList(ActivityDetailPlanModify entity, boolean update, List<ActivityDetailPlanPlanModifyDto> relatePlanlist) {
        if (CollectionUtils.isEmpty(relatePlanlist)) {
            return;
        }
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (update) {
            List<ActivityDetailPlanPlanModify> oldList = this.activityDetailPlanPlanModifyRepository.findListByModifyBusinessCode(entity.getModifyBusinessCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        List activityPlanStrategies = (List)this.nebulaToolkitService.copyCollectionByWhiteList(relatePlanlist, ActivityDetailPlanPlanModifyDto.class, ActivityDetailPlanPlanModify.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (ActivityDetailPlanPlanModify item : activityPlanStrategies) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setModifyBusinessCode(entity.getModifyBusinessCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.activityDetailPlanPlanModifyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.activityDetailPlanPlanModifyRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.activityDetailPlanPlanModifyRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    @Override
    public void deleteByModifyCodes(List<String> modifyCodes) {
        this.activityDetailPlanPlanModifyRepository.deleteByModifyCodes(modifyCodes);
    }
}

