/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.bizunited.nebula.europa.database.register.sdk.service.MnDataviewRegister;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteParameter;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterOperatorBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityDetailPlanDataViewRegister
implements MnDataviewRegister {
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    @Qualifier(value="inParameterOperatorBindingStrategy")
    private ParameterOperatorBindingStrategy inParameterOperatorBindingStrategy;
    @Autowired(required=false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;
    @Autowired(required=false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;

    public String code() {
        return "tpm_activity_detail_plan_data_view";
    }

    public String desc() {
        return "TPM-\u6d3b\u52a8\u7ec6\u6848";
    }

    public String buildSql() {
        return "select\na.*,'' as parent_department_name,\n'' as detail_plan_item_code,\n'' as relate_plan_code\n from tpm_activity_detail_plan a\nwhere a.tenant_code = :tenantCode\nand a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'";
    }

    public Object customBindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
        if (!(executeParameter instanceof DatabaseExecuteParameter)) {
            return null;
        }
        DatabaseExecuteParameter databaseExecuteParameter = (DatabaseExecuteParameter)executeParameter;
        String paramName = databaseExecuteParameter.getParamName();
        Object value = databaseExecuteExternalRequest.getAttribute(paramName);
        if (value == null) {
            return null;
        }
        String valueStr = String.valueOf(value);
        if ("parent_department_name".equals(databaseExecuteParameter.getTargetFieldName())) {
            return this.parentDepartmentNameQuery(databaseExecuteParameter, valueStr);
        }
        if ("detail_plan_item_code".equals(databaseExecuteParameter.getTargetFieldName())) {
            return this.detailPlanItemQuery(databaseExecuteParameter, valueStr);
        }
        if ("relate_plan_code".equals(databaseExecuteParameter.getTargetFieldName())) {
            return this.relatePlanCodeQuery(databaseExecuteParameter, valueStr);
        }
        return valueStr;
    }

    private Object parentDepartmentNameQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "department_code";
        String parameterName = databaseExecuteParameter.getParamName();
        String expression = this.inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);
        ArrayList orgCodeList = Lists.newArrayList((Object[])new String[]{"_"});
        OrgQueryDto orgQueryDto = new OrgQueryDto();
        orgQueryDto.setOrgName(valueStr);
        Set parentCodeSet = this.orgVoService.findByOrgQueryDto(orgQueryDto);
        if (CollectionUtils.isEmpty((Collection)parentCodeSet)) {
            return orgCodeList;
        }
        orgQueryDto.setOrgName(null);
        ArrayList parentOrgCodeList = Lists.newArrayList((Iterable)parentCodeSet);
        orgQueryDto.setParentOrgCodeList((List)parentOrgCodeList);
        Set codeSet = this.orgVoService.findByOrgQueryDto(orgQueryDto);
        orgCodeList.addAll(codeSet);
        return orgCodeList;
    }

    private Object relatePlanCodeQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "detail_plan_code";
        String parameterName = databaseExecuteParameter.getParamName();
        String expression = this.inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);
        ArrayList planCodeList = Lists.newArrayList((Object[])new String[]{"_"});
        planCodeList.addAll(this.activityDetailPlanBudgetRepository.findDetailPlanCodeListByRelatePlanCodeList(Arrays.asList(valueStr.split("[, \uff0c]"))));
        return planCodeList;
    }

    private Object detailPlanItemQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "detail_plan_code";
        String parameterName = databaseExecuteParameter.getParamName();
        String expression = this.inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);
        ArrayList planCodeList = Lists.newArrayList((Object[])new String[]{"_"});
        planCodeList.addAll(this.activityDetailPlanItemRepository.findDetailPlanCodeListByItemCodeList(Arrays.asList(valueStr.split("[, \uff0c]"))));
        return planCodeList;
    }
}

