/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.report.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.service.SalesApprovalAsyncService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.SalesApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.dto.UpdateActivityApprovalDataDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.SalesApprovalService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.SalesApprovalVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/salesApproval"})
@Api(tags={"\u9500\u552e\u8d39\u7528\u6279\u590d\u8868"})
public class SalesApprovalController {
    private static final Logger log = LoggerFactory.getLogger(SalesApprovalController.class);
    @Autowired(required=false)
    private SalesApprovalService salesApprovalService;
    @Autowired(required=false)
    private SalesApprovalAsyncService salesApprovalAsyncService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u9500\u552e\u8d39\u7528\u6279\u590d\u8868")
    @GetMapping(value={"findAllConditions"})
    public Result<Page<SalesApprovalVo>> findAllConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="salesApprovalDto", value="\u67e5\u8be2\u5b9e\u4f53") SalesApprovalDto salesApprovalDto) {
        try {
            Page page = this.salesApprovalService.findAllConditions(pageable, salesApprovalDto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u8d39\u7528\u6279\u590d\u8868\u6570\u636e\u751f\u6210")
    @PostMapping(value={"updateActivityApprovalData"})
    public Result<?> updateActivityApprovalData(@RequestBody UpdateActivityApprovalDataDto dto) {
        try {
            UserIdentity userIdentity = this.loginUserService.getLoginUser();
            this.salesApprovalAsyncService.updateActivityApprovalDataAsync(dto, userIdentity);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9500\u552e\u8d39\u7528\u6279\u590d\u8868\u81ea\u5b9a\u4e49\u5206\u9875")
    @GetMapping(value={"findAllConditionsOtherPage"})
    public Result<Page<SalesApprovalVo>> findAllConditionsOtherPage(Integer page, Integer size, @ApiParam(name="salesApprovalDto", value="\u67e5\u8be2\u5b9e\u4f53") SalesApprovalDto salesApprovalDto) {
        try {
            PageRequest pageable = PageRequest.of((int)page, (int)size);
            Page pageInfo = this.salesApprovalService.findAllConditions((Pageable)pageable, salesApprovalDto);
            return Result.ok((Object)pageInfo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

