/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.report.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.repository.ActivityDetailPlanApprovalActivityInfoRepository;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.SalesApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.dto.LargeDateCallbackDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.LargeDateCallbackService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.LargeDateCallbackVo;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="largeDateCallbackServiceImpl")
public class LargeDateCallbackServiceImpl
implements LargeDateCallbackService {
    private static final Logger log = LoggerFactory.getLogger(LargeDateCallbackServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityDetailPlanApprovalActivityInfoRepository activityDetailPlanApprovalActivityInfoRepository;
    @Autowired(required=false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;

    public Page<LargeDateCallbackVo> findAllConditions(Pageable pageable, LargeDateCallbackDto largeDateCallbackDto) {
        SalesApprovalDto salesApprovalDto;
        Page<LargeDateCallbackVo> page;
        List records;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(largeDateCallbackDto)) {
            largeDateCallbackDto = new LargeDateCallbackDto();
        }
        if (null == largeDateCallbackDto.getYearMonthLy()) {
            largeDateCallbackDto.setYearMonthLy(DateUtil.format((Date)new Date(), (String)"yyyy-MM"));
        }
        if (!CollectionUtils.isEmpty((Collection)(records = (page = this.activityDetailPlanApprovalActivityInfoRepository.findLargeDateCallabckList(pageable, salesApprovalDto = (SalesApprovalDto)this.nebulaToolkitService.copyObjectByBlankList((Object)largeDateCallbackDto, SalesApprovalDto.class, HashSet.class, ArrayList.class, new String[0]))).getRecords()))) {
            this.setPeriodSale(records);
            BigDecimal bigDecimal100 = new BigDecimal(100);
            for (LargeDateCallbackVo e : records) {
                if (e.getPeriodSale() != null && BigDecimal.ZERO.compareTo(e.getPeriodSale()) != 0) {
                    e.setCallbackRate(e.getBigDateQty().multiply(bigDecimal100).divide(e.getPeriodSale(), 4, 4) + "%");
                    continue;
                }
                e.setCallbackRate("100%");
            }
        }
        return page;
    }

    private void setPeriodSale(List<LargeDateCallbackVo> records) {
        Map<String, List<LargeDateCallbackVo>> groupMap = records.stream().collect(Collectors.groupingBy(item -> item.getYearMonthLy() + item.getBusinessFormatCode() + item.getBusinessUnitCode()));
        for (Map.Entry<String, List<LargeDateCallbackVo>> entry : groupMap.entrySet()) {
            List<LargeDateCallbackVo> list = entry.getValue();
            List customerCodeList = list.stream().map(LargeDateCallbackVo::getCustomerCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List productCodeList = list.stream().map(LargeDateCallbackVo::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(customerCodeList) || CollectionUtils.isEmpty(productCodeList)) continue;
            LargeDateCallbackVo largeDateCallbackVo = list.get(0);
            MainOnedaySalesDataDto mainOnedaySalesDataDto = new MainOnedaySalesDataDto();
            mainOnedaySalesDataDto.setYearMonthLy(largeDateCallbackVo.getYearMonthLy().replace("-", ""));
            mainOnedaySalesDataDto.setCustomerCodeList(customerCodeList);
            mainOnedaySalesDataDto.setBusinessFormatCode(largeDateCallbackVo.getBusinessFormatCode());
            mainOnedaySalesDataDto.setBusinessUnitCode(largeDateCallbackVo.getBusinessUnitCode());
            List mainOnedaySalesDataVos = this.mainOnedaySaleDataService.listMainOnedaySalesDataForMonthBudget(mainOnedaySalesDataDto);
            if (CollectionUtils.isEmpty((Collection)mainOnedaySalesDataVos)) continue;
            Map<String, BigDecimal> saleQuantityMap = mainOnedaySalesDataVos.stream().collect(Collectors.toMap(item -> item.getCustomerCode() + item.getProductCode(), MainOnedaySalesDataVo::getSaleQuantity));
            for (LargeDateCallbackVo record : records) {
                record.setPeriodSale(saleQuantityMap.get(record.getCustomerCode() + record.getProductCode()));
            }
        }
    }
}

