/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.report.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.repository.ActivityDetailPlanApprovalActivityInfoRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.MarketingApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.MarketingApprovalService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.MarketingApprovalVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="marketingApprovalServiceImpl")
public class MarketingApprovalServiceImpl
implements MarketingApprovalService {
    private static final Logger log = LoggerFactory.getLogger(MarketingApprovalServiceImpl.class);
    private static final String SECOND_CHANNEL_CODE = "C202";
    private static final String dict_up_account_status = "up_account_status";
    private static final String YESORNO = "yesOrNo";
    @Autowired(required=false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;
    @Autowired(required=false)
    private ActivityDetailPlanApprovalActivityInfoRepository activityDetailPlanApprovalActivityInfoRepository;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Page<MarketingApprovalVo> findAllConditions(Pageable pageable, MarketingApprovalDto marketingApprovalDto) {
        Page<MarketingApprovalVo> page;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(marketingApprovalDto)) {
            marketingApprovalDto = new MarketingApprovalDto();
        }
        if (CollectionUtils.isEmpty((Collection)(page = this.activityDetailPlanApprovalActivityInfoRepository.findPsmMarketingConditions(pageable, marketingApprovalDto)).getRecords())) {
            return page;
        }
        ArrayList dictCodeList = Lists.newArrayList();
        dictCodeList.add(dict_up_account_status);
        dictCodeList.add(YESORNO);
        Map dictMap = this.dictDataVoService.findByDictTypeCodeList((List)dictCodeList);
        Map<String, Map> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> ((List)item.getValue()).stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> n)), (o, n) -> n));
        for (MarketingApprovalVo vo : page.getRecords()) {
            ArrayList upAccountStatusNameList;
            Map accountStatusMap;
            String[] upAccountStatusArr;
            if (StringUtils.isNotEmpty((CharSequence)vo.getUpAccountStatus())) {
                upAccountStatusArr = vo.getUpAccountStatus().split(",");
                accountStatusMap = dictMapMap.get(dict_up_account_status);
                upAccountStatusNameList = Lists.newArrayList();
                for (String upAccountStatus : upAccountStatusArr) {
                    upAccountStatusNameList.add(accountStatusMap.getOrDefault(upAccountStatus, upAccountStatus));
                }
                vo.setUpAccountStatus(String.join((CharSequence)",", upAccountStatusNameList));
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getReimburseUpAccountStatus())) {
                upAccountStatusArr = vo.getReimburseUpAccountStatus().split(",");
                accountStatusMap = dictMapMap.get(dict_up_account_status);
                upAccountStatusNameList = Lists.newArrayList();
                for (String upAccountStatus : upAccountStatusArr) {
                    upAccountStatusNameList.add(accountStatusMap.getOrDefault(upAccountStatus, upAccountStatus));
                }
                vo.setReimburseUpAccountStatus(String.join((CharSequence)",", upAccountStatusNameList));
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getWholeAudit())) {
                if (vo.getWholeAudit().contains(BooleanEnum.TRUE.getCapital())) {
                    vo.setWholeAudit(BooleanEnum.TRUE.getSure());
                } else {
                    vo.setWholeAudit(BooleanEnum.FALSE.getSure());
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)vo.getIsPushSap())) continue;
            if (vo.getIsPushSap().contains(BooleanEnum.TRUE.getCapital())) {
                vo.setIsPushSap(BooleanEnum.TRUE.getSure());
                continue;
            }
            vo.setIsPushSap(BooleanEnum.FALSE.getSure());
        }
        return page;
    }
}

