/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.report.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitTypeEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.entity.ActivityDetailPlanApprovalActivityInfo;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.entity.ActivityDetailPlanApprovalAuditInfo;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.enums.ActivityApprovalReportTypeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.register.MarketApprovalDataViewRegister;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.repository.ActivityDetailPlanApprovalActivityInfoRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.report.repository.ActivityDetailPlanApprovalAuditInfoRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.util.SalesApprovalInfoBuilder;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.SalesApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.RtmModelCodeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.dto.UpdateActivityApprovalDataDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.SalesApprovalService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ApprovalReportAudit;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.SalesApprovalVo;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemControlConditionVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="salesApprovalServiceImpl")
public class SalesApprovalServiceImpl
implements SalesApprovalService {
    private static final Logger log = LoggerFactory.getLogger(SalesApprovalServiceImpl.class);
    private static final String SECOND_CHANNEL_CODE = "C202";
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityDetailPlanApprovalActivityInfoRepository activityDetailPlanApprovalActivityInfoRepository;
    @Autowired(required=false)
    private ActivityDetailPlanApprovalAuditInfoRepository activityDetailPlanApprovalAuditInfoRepository;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private SalesApprovalService salesApprovalService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SalesApprovalInfoBuilder salesApprovalInfoBuilder;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private ActivityPlanSdkService activityPlanSdkService;
    private static final String dict_up_account_status = "up_account_status";
    private static final String YESORNO = "yesOrNo";
    @Autowired(required=false)
    private RedisLockService redisLockService;

    public Page<SalesApprovalVo> findAllConditions(Pageable pageable, SalesApprovalDto salesApprovalDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(salesApprovalDto)) {
            salesApprovalDto = new SalesApprovalDto();
        }
        Page<SalesApprovalVo> page = this.activityDetailPlanApprovalActivityInfoRepository.findPsmConditions(pageable, salesApprovalDto);
        List salesApprovalVos = page.getRecords();
        ArrayList dictCodeList = Lists.newArrayList();
        dictCodeList.add(dict_up_account_status);
        dictCodeList.add(YESORNO);
        Map dictMap = this.dictDataVoService.findByDictTypeCodeList((List)dictCodeList);
        Map<String, Map> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> ((List)item.getValue()).stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> n)), (o, n) -> n));
        for (SalesApprovalVo vo : salesApprovalVos) {
            ArrayList upAccountStatusNameList;
            Map accountStatusMap;
            String[] upAccountStatusArr;
            if (StringUtils.isNotEmpty((CharSequence)vo.getUpAccountStatus())) {
                upAccountStatusArr = vo.getUpAccountStatus().split(",");
                accountStatusMap = dictMapMap.get(dict_up_account_status);
                upAccountStatusNameList = Lists.newArrayList();
                for (String upAccountStatus : upAccountStatusArr) {
                    upAccountStatusNameList.add(accountStatusMap.getOrDefault(upAccountStatus, upAccountStatus));
                }
                vo.setUpAccountStatus(String.join((CharSequence)",", upAccountStatusNameList));
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getReimburseUpAccountStatus())) {
                upAccountStatusArr = vo.getReimburseUpAccountStatus().split(",");
                accountStatusMap = dictMapMap.get(dict_up_account_status);
                upAccountStatusNameList = Lists.newArrayList();
                for (String upAccountStatus : upAccountStatusArr) {
                    upAccountStatusNameList.add(accountStatusMap.getOrDefault(upAccountStatus, upAccountStatus));
                }
                vo.setReimburseUpAccountStatus(String.join((CharSequence)",", upAccountStatusNameList));
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getWholeAudit())) {
                if (vo.getWholeAudit().contains(BooleanEnum.TRUE.getCapital())) {
                    vo.setWholeAudit(BooleanEnum.TRUE.getSure());
                } else {
                    vo.setWholeAudit(BooleanEnum.FALSE.getSure());
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)vo.getIsPushSap())) continue;
            if (vo.getIsPushSap().contains(BooleanEnum.TRUE.getCapital())) {
                vo.setIsPushSap(BooleanEnum.TRUE.getSure());
                continue;
            }
            vo.setIsPushSap(BooleanEnum.FALSE.getSure());
        }
        return page;
    }

    public void updateActivityApprovalData(UpdateActivityApprovalDataDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new UpdateActivityApprovalDataDto();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageSize())) {
            dto.setPageSize("400");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getUpdateDate()) && !StringUtils.isNotEmpty((CharSequence)dto.getDetailPlanCode()) && !StringUtils.isNotEmpty((CharSequence)dto.getDetailPlanItemCode())) {
            Calendar now = Calendar.getInstance();
            now.add(5, -1);
            Date nowTime = now.getTime();
            dto.setUpdateDate(DateUtil.date_yyyy_MM_dd.format(nowTime));
        }
        if (Objects.isNull(dto.getAddDay())) {
            dto.setAddDay(Integer.valueOf(1));
        }
        int addDay = dto.getAddDay();
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
        String lockKey = dayFormat.format(new Date());
        boolean lock = true;
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            Date startDate = null;
            if (null != dto.getUpdateDate()) {
                startDate = dayFormat.parse(dto.getUpdateDate());
            }
            for (int i = 0; i < addDay; ++i) {
                if (null != startDate) {
                    dto.setUpdateDate(dayFormat.format(DateUtil.dateAddDay((Date)startDate, (Integer)i)));
                }
                this.salesApprovalService.doUpdateActivityApprovalData(dto);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("\u65f6\u95f4\u89e3\u6790\u5f02\u5e38");
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void doUpdateActivityApprovalData(UpdateActivityApprovalDataDto dto) {
        dto.setBusinessUnitCodeList(this.getBusinessUnitCodeList());
        List<SalesApprovalVo> list = this.activityDetailPlanApprovalActivityInfoRepository.getUpdateActivityApprovalData(dto);
        HashSet detailPlanItemCodeSet = Sets.newHashSet();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            this.loadActivityInfo(list);
            detailPlanItemCodeSet.addAll(list.stream().map(SalesApprovalVo::getDetailPlanItemCode).collect(Collectors.toList()));
            log.info("\u9500\u552e\u8d39\u7528\u6279\u590d\u8868\u672c\u6b21\u65b0\u589e" + list.size() + "\u6761\u6d3b\u52a8\u6570\u636e");
        }
        if (!StringUtils.isEmpty((CharSequence)dto.getUpdateDate())) {
            ApprovalReportAudit approvalReportAudit = new ApprovalReportAudit();
            approvalReportAudit.setUpdateDate(dto.getUpdateDate());
            approvalReportAudit.setBusinessUnitCodeList(dto.getBusinessUnitCodeList());
            List<String> auditDetailPlanItemCodeList = this.activityDetailPlanApprovalAuditInfoRepository.findApprovalReportAuditDetailPlanItemCodeList(approvalReportAudit);
            if (!CollectionUtils.isEmpty(auditDetailPlanItemCodeList)) {
                detailPlanItemCodeSet.addAll(auditDetailPlanItemCodeList);
            }
        }
        if (CollectionUtils.isEmpty((Collection)detailPlanItemCodeSet)) {
            return;
        }
        List<ApprovalReportAudit> auditInfoList = this.activityDetailPlanApprovalAuditInfoRepository.findApprovalReportAuditInfoList(Lists.newArrayList((Iterable)detailPlanItemCodeSet));
        if (!CollectionUtils.isEmpty(auditInfoList)) {
            log.info("\u9500\u552e\u8d39\u7528\u6279\u590d\u8868\u672c\u6b21\u65b0\u589e" + auditInfoList.size() + "\u6761\u6838\u9500\u6570\u636e");
        }
        this.saveOrUpdate(list, auditInfoList);
    }

    private List<String> getBusinessUnitCodeList() {
        ArrayList businessUnitCodeList = Lists.newArrayList();
        for (BusinessUnitEnum value : BusinessUnitEnum.values()) {
            if (!BusinessUnitTypeEnum.HEADQUARTERS_TYPE.equals((Object)value.getType())) continue;
            businessUnitCodeList.add(value.getCode());
        }
        return businessUnitCodeList;
    }

    private void saveOrUpdate(List<SalesApprovalVo> activityList, List<ApprovalReportAudit> auditList) {
        String tenantCode = TenantUtils.getTenantCode();
        if (!CollectionUtils.isEmpty(activityList)) {
            List<String> detailPlanItemCodeList = activityList.stream().map(SalesApprovalVo::getDetailPlanItemCode).collect(Collectors.toList());
            this.activityDetailPlanApprovalActivityInfoRepository.deleteByDetailPlanItemCodeList(detailPlanItemCodeList);
            Collection activityEntityList = this.nebulaToolkitService.copyCollectionByWhiteList(activityList, SalesApprovalVo.class, ActivityDetailPlanApprovalActivityInfo.class, HashSet.class, ArrayList.class, new String[0]);
            for (ActivityDetailPlanApprovalActivityInfo activityDetailPlanApprovalActivityInfo : activityEntityList) {
                if (MarketApprovalDataViewRegister.maReportTemplateConfigCodeList.contains(activityDetailPlanApprovalActivityInfo.getTemplateConfigCode())) {
                    activityDetailPlanApprovalActivityInfo.setApprovalReportType(ActivityApprovalReportTypeEnum.MARKETING.getCode());
                } else {
                    activityDetailPlanApprovalActivityInfo.setApprovalReportType(ActivityApprovalReportTypeEnum.SALES.getCode());
                }
                activityDetailPlanApprovalActivityInfo.setTenantCode(tenantCode);
            }
            this.activityDetailPlanApprovalActivityInfoRepository.saveBatch(activityEntityList);
            this.activityDetailPlanApprovalActivityInfoRepository.updateTenantOp(detailPlanItemCodeList);
        }
        if (!CollectionUtils.isEmpty(auditList)) {
            List<String> detailPlanItemCodeList2 = auditList.stream().map(ApprovalReportAudit::getDetailPlanItemCode).collect(Collectors.toList());
            this.activityDetailPlanApprovalAuditInfoRepository.deleteByDetailPlanItemCodeList(detailPlanItemCodeList2);
            Collection auditEntityList = this.nebulaToolkitService.copyCollectionByWhiteList(auditList, ApprovalReportAudit.class, ActivityDetailPlanApprovalAuditInfo.class, HashSet.class, ArrayList.class, new String[0]);
            for (ActivityDetailPlanApprovalAuditInfo auditInfo : auditEntityList) {
                auditInfo.setTenantCode(tenantCode);
            }
            this.activityDetailPlanApprovalAuditInfoRepository.saveBatch(auditEntityList);
        }
    }

    private boolean lock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u6d3b\u52a8\u8d39\u7528\u6279\u590d\u8868\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisLockService.tryLock("activity_detail_plan:lock:approve:report:" + yearMonthDay, TimeUnit.HOURS, 12L);
    }

    private void unLock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u6d3b\u52a8\u8d39\u7528\u6279\u590d\u8868\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.redisLockService.unlock("activity_detail_plan:lock:approve:report:" + yearMonthDay);
    }

    public void loadActivityInfo(List<SalesApprovalVo> salesApprovalVos) {
        List terminalVoList;
        List customerVoList;
        if (CollectionUtils.isEmpty(salesApprovalVos)) {
            return;
        }
        HashSet customerCodeSet = new HashSet();
        HashSet terminalCodeSet = new HashSet();
        HashSet headBudgetItemCodeSet = new HashSet();
        HashSet budgetItemCodeSet = new HashSet();
        HashSet detailPlanCodeSet = new HashSet();
        salesApprovalVos.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getCustomerCode())) {
                customerCodeSet.add(item.getCustomerCode());
            }
            if (StringUtils.isNotBlank((CharSequence)item.getTerminalCode())) {
                terminalCodeSet.add(item.getTerminalCode());
            }
            if (StringUtils.isNotBlank((CharSequence)item.getHeadBudgetItemCode())) {
                headBudgetItemCodeSet.add(item.getHeadBudgetItemCode());
            }
            if (StringUtils.isNotBlank((CharSequence)item.getBudgetItemCode())) {
                budgetItemCodeSet.add(item.getBudgetItemCode());
            }
            if (StringUtils.isNotBlank((CharSequence)item.getDetailPlanCode())) {
                detailPlanCodeSet.add(item.getDetailPlanCode());
            }
        });
        HashMap<String, CustomerVo> customerVoMap = new HashMap<String, CustomerVo>();
        if (CollectionUtil.isNotEmpty(customerCodeSet) && CollectionUtil.isNotEmpty((Collection)(customerVoList = this.customerVoService.findBaseByCustomerCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap.putAll(customerVoList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getCustomerCode())).collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v, (newValue, oldValue) -> newValue)));
        }
        HashMap<String, TerminalVo> terminalVoMap = new HashMap<String, TerminalVo>();
        if (CollectionUtil.isNotEmpty(terminalCodeSet) && CollectionUtil.isNotEmpty((Collection)(terminalVoList = this.terminalVoService.findMainDetailsByTerminalCodesUsePost(new ArrayList(terminalCodeSet))))) {
            terminalVoMap.putAll(terminalVoList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getTerminalCode())).collect(Collectors.toMap(TerminalVo::getTerminalCode, v -> v, (newValue, oldValue) -> newValue)));
        }
        Map<String, BudgetItemVo> budgetItemVoMap = this.salesApprovalInfoBuilder.getBudgetItemDataTypeCodeMap(salesApprovalVos);
        Map<String, ActivityDetailPlanBudgetVo> planInfoVoMap = this.salesApprovalInfoBuilder.getPlanInfoMap(salesApprovalVos);
        Map<Object, Object> activityPlanBudgetVoMap = new HashMap();
        if (planInfoVoMap != null) {
            Set planCodes = planInfoVoMap.values().stream().map(ActivityDetailPlanBudgetVo::getRelatePlanCode).collect(Collectors.toSet());
            List activityPlanBudgetVoList = this.activityPlanSdkService.findHeadquartersByRegionPlanCodes(planCodes);
            activityPlanBudgetVoMap = activityPlanBudgetVoList.stream().collect(Collectors.groupingBy(ActivityPlanBudgetVo::getPlanCode));
        }
        for (SalesApprovalVo vo2 : salesApprovalVos) {
            List activityPlanBudgetVos;
            BudgetItemVo budgetItem;
            String formatCode;
            String collect;
            List conditionVos;
            BudgetItemVo budgetItemVo;
            TerminalVo terminalVo;
            CustomerVo customerVo;
            if (SECOND_CHANNEL_CODE.equals(vo2.getSecondChannelCode())) {
                vo2.setWhetherTwentyTerminal(YesOrNoEnum.YES.getCode());
            } else {
                vo2.setWhetherTwentyTerminal(YesOrNoEnum.NO.getCode());
            }
            if (vo2.getHeadFeeAmount() == null) {
                vo2.setHeadFeeAmount(BigDecimal.ZERO);
            }
            if (vo2.getDepartmentFeeAmount() == null) {
                vo2.setDepartmentFeeAmount(BigDecimal.ZERO);
            }
            if (vo2.getCustomerFeeAmount() == null) {
                vo2.setCustomerFeeAmount(BigDecimal.ZERO);
            }
            vo2.setRegion(vo2.getActivityOrgName());
            if (StringUtils.isNotEmpty((CharSequence)vo2.getCustomerCode()) && Objects.nonNull(customerVo = (CustomerVo)customerVoMap.get(vo2.getCustomerCode()))) {
                vo2.setRtmModelCode(customerVo.getRtmModelCode());
                vo2.setCustomerTypeName(customerVo.getCustomerLevel());
                vo2.setRegion(customerVo.getSalesRegionName());
            }
            if (StringUtils.isNotEmpty((CharSequence)vo2.getTerminalCode()) && Objects.nonNull(terminalVo = (TerminalVo)terminalVoMap.get(vo2.getTerminalCode()))) {
                if (StringUtils.isNotEmpty((CharSequence)terminalVo.getSecondChannelCode()) && SECOND_CHANNEL_CODE.equals(terminalVo.getSecondChannelCode())) {
                    vo2.setWhetherTwentyTerminal(YesOrNoEnum.YES.getCode());
                } else {
                    vo2.setWhetherTwentyTerminal(YesOrNoEnum.NO.getCode());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)vo2.getHeadBudgetItemCode()) && budgetItemVoMap.containsKey(vo2.getHeadBudgetItemCode()) && !ObjectUtils.isEmpty((Object)(budgetItemVo = budgetItemVoMap.get(vo2.getHeadBudgetItemCode())))) {
                vo2.setHeadquartersDataTypeCode(budgetItemVo.getDataTypeCode());
                conditionVos = budgetItemVo.getControlConditionDtoList();
                if (!CollectionUtils.isEmpty((Collection)conditionVos)) {
                    collect = conditionVos.stream().map(BudgetItemControlConditionVo::getDepartmentBelongCode).distinct().filter(Objects::nonNull).collect(Collectors.joining(","));
                    vo2.setHeadquartersDepartmentBelongCode(collect);
                    formatCode = conditionVos.stream().map(BudgetItemControlConditionVo::getBusinessFormatCode).distinct().filter(Objects::nonNull).collect(Collectors.joining(","));
                    vo2.setBusinessCode(formatCode);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)vo2.getBudgetItemCode()) && budgetItemVoMap.containsKey(vo2.getBudgetItemCode()) && !ObjectUtils.isEmpty((Object)(budgetItem = budgetItemVoMap.get(vo2.getBudgetItemCode())))) {
                vo2.setRegionDataTypeCode(budgetItem.getDataTypeCode());
                conditionVos = budgetItem.getControlConditionDtoList();
                if (!CollectionUtils.isEmpty((Collection)conditionVos)) {
                    collect = conditionVos.stream().map(BudgetItemControlConditionVo::getDepartmentBelongCode).distinct().filter(Objects::nonNull).collect(Collectors.joining(","));
                    vo2.setRegionDepartmentBelongCode(collect);
                    formatCode = conditionVos.stream().map(BudgetItemControlConditionVo::getBusinessFormatCode).distinct().filter(Objects::nonNull).collect(Collectors.joining(","));
                    vo2.setBusinessCode(formatCode);
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)vo2.getDetailPlanItemCode()) || !planInfoVoMap.containsKey(vo2.getDetailPlanItemCode())) continue;
            ActivityDetailPlanBudgetVo planVo = planInfoVoMap.get(vo2.getDetailPlanItemCode());
            if (planVo != null) {
                if (StringUtils.isNotEmpty((CharSequence)planVo.getRelatePlanName())) {
                    vo2.setRegionalFileName(planVo.getRelatePlanName());
                    vo2.setPlanName(planVo.getRelatePlanName());
                }
                if (StringUtils.isNotEmpty((CharSequence)planVo.getRelatePlanCode())) {
                    vo2.setRegionalFileCode(planVo.getRelatePlanCode());
                    vo2.setPlanCode(planVo.getRelatePlanCode());
                }
                vo2.setRelatePlanItemCode(planVo.getRelatePlanItemCode());
            }
            if (CollectionUtils.isEmpty((Collection)(activityPlanBudgetVos = (List)activityPlanBudgetVoMap.get(vo2.getPlanCode())))) continue;
            for (ActivityPlanBudgetVo activityPlanBudgetVo : activityPlanBudgetVos) {
                String headquartersFileName = StringUtils.isNotEmpty((CharSequence)activityPlanBudgetVo.getRelatePlanName()) ? activityPlanBudgetVo.getRelatePlanName() : activityPlanBudgetVo.getRelateStrategyName();
                String headquartersFileCode = StringUtils.isNotEmpty((CharSequence)activityPlanBudgetVo.getRelatePlanCode()) ? activityPlanBudgetVo.getRelatePlanCode() : activityPlanBudgetVo.getRelateStrategyCode();
                vo2.setHeadquartersFileName(headquartersFileName);
                vo2.setHeadquartersFileCode(headquartersFileCode);
            }
        }
        List subComCustomerCodeList = salesApprovalVos.stream().filter(e -> RtmModelCodeEnum.SON_COMPANY.getCode().equals(e.getRtmModelCode())).map(SalesApprovalVo::getCustomerCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(subComCustomerCodeList)) {
            List subComOrgCodeList = subComCustomerCodeList.stream().map(e -> e.substring(0, 10)).collect(Collectors.toList());
            List subComOrgVoList = this.salesOrgSubComOrgService.listBySubComOrgCodeList(subComOrgCodeList);
            Map subComOrgCodeToVoMap = subComOrgVoList.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSubComOrgCode, Function.identity(), (e1, e2) -> e1));
            salesApprovalVos.stream().filter(e -> RtmModelCodeEnum.SON_COMPANY.getCode().equals(e.getRtmModelCode())).forEach(vo -> {
                String subComOrgCode = vo.getCustomerCode().substring(0, 10);
                if (subComOrgCodeToVoMap.containsKey(subComOrgCode)) {
                    SalesOrgSubComOrgVo salesOrgSubComOrgVo = (SalesOrgSubComOrgVo)subComOrgCodeToVoMap.get(subComOrgCode);
                    vo.setOrgCode(salesOrgSubComOrgVo.getOrgCode());
                }
            });
        }
    }
}

