/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget;
import com.biz.crm.tpm.business.activity.detail.plan.local.mapper.ActivityDetailPlanBudgetMapper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ActivityDetailPlanBudgetRepository
extends ServiceImpl<ActivityDetailPlanBudgetMapper, ActivityDetailPlanBudget> {
    public List<ActivityDetailPlanBudget> listByDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isEmpty((CharSequence)detailPlanCode)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityDetailPlanBudget::getDetailPlanCode, (Object)detailPlanCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<ActivityDetailPlanBudget> listByDetailPlanItemCodeList(Collection<String> detailPlanItemCodeList) {
        if (CollectionUtils.isEmpty(detailPlanItemCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlanBudget::getDetailPlanItemCode, detailPlanItemCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<ActivityDetailPlanBudget> listByDetailPlanCodeList(List<String> detailPlanCodeList) {
        if (CollectionUtils.isEmpty(detailPlanCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlanBudget::getDetailPlanCode, detailPlanCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<ActivityDetailPlanBudget> listByDetailCodeList(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlanBudget::getDetailPlanItemCode, itemCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void deleteByIds(List<String> ids) {
        if (org.springframework.util.CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public List<ActivityDetailPlanBudgetDto> listDtoListByDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isEmpty((CharSequence)detailPlanCode)) {
            return null;
        }
        return ((ActivityDetailPlanBudgetMapper)this.baseMapper).listDtoListByDetailPlanCode(detailPlanCode);
    }

    public void deletePhysicalByDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isEmpty((CharSequence)detailPlanCode)) {
            return;
        }
        LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
        updateWrapper.eq(ActivityDetailPlanBudget::getDetailPlanCode, (Object)detailPlanCode);
        this.remove((Wrapper)updateWrapper);
    }

    public List<ActivityDetailPlanBudget> findBudgetByCodes(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlanBudget::getDetailPlanItemCode, detailPlanItemCodes)).list();
    }

    public LinkedList<ActivityDetailPlanBudget> listByOperateCodeListVertical(List<String> operateCodeList) {
        if (CollectionUtils.isEmpty(operateCodeList)) {
            return null;
        }
        return ((ActivityDetailPlanBudgetMapper)this.baseMapper).listByOperateCodeListVertical(operateCodeList);
    }

    public void deletePhysicalByDetailPlanCodeAndOccupyType(List<String> delItemCodeList, String occupyType) {
        if (StringUtils.isEmpty((CharSequence)occupyType) || CollectionUtils.isEmpty(delItemCodeList)) {
            return;
        }
        LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)updateWrapper.in(ActivityDetailPlanBudget::getDetailPlanCode, delItemCodeList)).eq(ActivityDetailPlanBudget::getOccupyType, (Object)occupyType);
        this.remove((Wrapper)updateWrapper);
    }

    public List<ActivityDetailPlanBudgetVo> findByPlanItemCode(Set<String> itemCodeSet) {
        return ((ActivityDetailPlanBudgetMapper)this.baseMapper).findByPlanItemCode(itemCodeSet, TenantUtils.getTenantCode());
    }

    public List<String> detailPlanRelatePlanCodeList(Set<String> detailPlanCodeSet) {
        return ((ActivityDetailPlanBudgetMapper)this.baseMapper).detailPlanRelatePlanCodeList(detailPlanCodeSet, TenantUtils.getTenantCode());
    }

    public Collection<String> findDetailPlanCodeListByRelatePlanCodeList(List<String> planCodeList) {
        if (org.springframework.util.CollectionUtils.isEmpty(planCodeList)) {
            return Lists.newArrayList();
        }
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityDetailPlanBudget.class).in(ActivityDetailPlanBudget::getRelatePlanCode, planCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).select(new SFunction[]{ActivityDetailPlanBudget::getDetailPlanCode})).stream().map(ActivityDetailPlanBudget::getDetailPlanCode).distinct().collect(Collectors.toList());
    }

    public List<ActivityDetailPlanBudgetVo> findPlanItemCodeByActivityDetailItemCodes(List<String> activityDetailCodes) {
        if (CollectionUtils.isEmpty(activityDetailCodes)) {
            return Lists.newArrayList();
        }
        return ((ActivityDetailPlanBudgetMapper)this.getBaseMapper()).findPlanItemCodeByActivityDetailItemCodes(activityDetailCodes);
    }

    public List<ActivityDetailPlanBudgetVo> findRegionIsRelateHead(List<String> planCodes, String tenantCode) {
        return ((ActivityDetailPlanBudgetMapper)this.baseMapper).findRegionIsRelateHead(planCodes, tenantCode);
    }

    public List<String> hasRelateDetailPlanCodeList(Set<String> planItemCodeList) {
        return ((ActivityDetailPlanBudgetMapper)this.baseMapper).hasRelateDetailPlanCodeList(planItemCodeList, TenantUtils.getTenantCode());
    }
}

