/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.repository;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.extend.field.service.ExtendFieldService;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItem;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItemExtend;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanItemExtendField;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanProduct;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.BusinessUnitSetTable;
import com.biz.crm.tpm.business.activity.detail.plan.local.mapper.ActivityDetailPlanItemMapper;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemExtendFieldRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemExtendRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanProductRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityDetailPlanItemsExportsVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanRollbackBudgetEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemStatisticsVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.DiscountAccountFeeGroupVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.DiscountAccountFeeVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.NextMonthPredictAccountFeeVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.RedPacketQueryScheme2Dto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityDetailPlanItemRepository
extends ServiceImpl<ActivityDetailPlanItemMapper, ActivityDetailPlanItem> {
    @Autowired(required=false)
    private ActivityDetailPlanItemMapper activityDetailPlanItemMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;
    @Autowired(required=false)
    private ActivityDetailPlanItemExtendFieldRepository activityDetailPlanItemExtendFieldRepository;
    @Autowired(required=false)
    private ActivityDetailPlanItemExtendRepository activityDetailPlanItemExtendRepository;
    @Autowired(required=false)
    private ActivityDetailPlanProductRepository activityDetailPlanProductRepository;
    @Autowired(required=false)
    private ExtendFieldService extendFieldService;

    public List<ActivityDetailPlanItemDto> findDtoListByActivityDetailPlanCode(String planCode) {
        if (StringUtils.isBlank((CharSequence)planCode)) {
            return Collections.emptyList();
        }
        List<ActivityDetailPlanItem> itemList = this.findListByActivityDetailPlanCode(planCode);
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityDetailPlanItem.class, ActivityDetailPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillDtoListProperties(dtoList);
        return dtoList;
    }

    public List<ActivityDetailPlanItemVo> findVoListByActivityDetailPlanCode(List<String> detailPlanCodeList) {
        if (CollectionUtils.isEmpty(detailPlanCodeList)) {
            return Collections.emptyList();
        }
        List<ActivityDetailPlanItem> itemList = this.findListByDetailPlanCodeList(detailPlanCodeList);
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillVoListProperties(voList);
        return voList;
    }

    public List<ActivityDetailPlanItemDto> findDtoAndAttachListByDetailPlanCode(String detailPlanCode) {
        List<ActivityDetailPlanItemExtendField> itemExtendFields;
        List<ActivityDetailPlanItemDto> dtoList = this.findDtoListByActivityDetailPlanCode(detailPlanCode);
        List<ActivityDetailPlanBudgetDto> budgetList = this.activityDetailPlanBudgetRepository.listDtoListByDetailPlanCode(detailPlanCode);
        if (!CollectionUtils.isEmpty(budgetList)) {
            this.convertMonthBudgetProperty(budgetList);
            for (ActivityDetailPlanBudgetDto activityDetailPlanBudgetDto : budgetList) {
                NumberStringDealUtil.setStringIfNotNull((Object)activityDetailPlanBudgetDto.getUseAmount(), arg_0 -> ((ActivityDetailPlanBudgetDto)activityDetailPlanBudgetDto).setUseAmountStr(arg_0));
            }
            Map<String, List<ActivityDetailPlanBudgetDto>> budgetMap = budgetList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getDetailPlanItemCode())).collect(Collectors.groupingBy(ActivityDetailPlanBudgetDto::getDetailPlanItemCode));
            for (ActivityDetailPlanItemDto itemDto : dtoList) {
                if (!budgetMap.containsKey(itemDto.getDetailPlanItemCode())) continue;
                itemDto.setBudgetShares(budgetMap.get(itemDto.getDetailPlanItemCode()));
            }
        }
        if (!CollectionUtils.isEmpty(itemExtendFields = this.activityDetailPlanItemExtendFieldRepository.listByPlanCode(detailPlanCode))) {
            Map<String, List<ActivityDetailPlanItemExtendField>> map = itemExtendFields.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemExtendField::getDetailPlanItemCode));
            for (ActivityDetailPlanItemDto itemDto : dtoList) {
                this.extendFieldService.fillExtendField((Object)itemDto, ActivityDetailPlanItemDto.class, map.get(itemDto.getDetailPlanItemCode()));
            }
        }
        return dtoList;
    }

    public void convertMonthBudgetProperty(List<ActivityDetailPlanBudgetDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Object, Object> feeSourceMap = Maps.newHashMap();
        if (null != this.dictDataVoService) {
            try {
                List feeSourceList = this.dictDataVoService.findByDictTypeCode("tpm_fee_belong_us");
                if (!CollectionUtils.isEmpty((Collection)feeSourceList)) {
                    feeSourceMap = feeSourceList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> o));
                }
            }
            catch (Exception e) {
                this.log.error("\u8d39\u7528\u5f52\u53e3\u6570\u636e\u5b57\u5178\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        for (ActivityDetailPlanBudgetDto vo : list) {
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)vo.getFeeBelongCode())) continue;
            vo.setFeeSourceName(feeSourceMap.getOrDefault(vo.getFeeBelongCode(), vo.getFeeBelongCode()));
        }
    }

    public List<ActivityDetailPlanItemDto> findDtoList(ActivityDetailPlanItemDto planItem) {
        List<ActivityDetailPlanItem> itemList = this.findList(planItem);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityDetailPlanItem.class, ActivityDetailPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ActivityDetailPlanItem> findListByActivityDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isBlank((CharSequence)detailPlanCode)) {
            return Collections.emptyList();
        }
        ActivityDetailPlanItemDto activityDetailPlanItem = new ActivityDetailPlanItemDto();
        activityDetailPlanItem.setDetailPlanCode(detailPlanCode);
        return this.findList(activityDetailPlanItem);
    }

    public List<ActivityDetailPlanItem> findListByRelatePlanItemCodeList(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)) {
            return Collections.emptyList();
        }
        ActivityDetailPlanItemDto activityDetailPlanItem = new ActivityDetailPlanItemDto();
        activityDetailPlanItem.setRelatePlanItemCodeList(planItemCodeList);
        return this.findList(activityDetailPlanItem);
    }

    public List<ActivityDetailPlanItem> findList(ActivityDetailPlanItemDto planItem) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityDetailPlanItem.class).eq(StringUtils.isNotBlank((CharSequence)planItem.getDetailPlanCode()), ActivityDetailPlanItem::getDetailPlanCode, (Object)planItem.getDetailPlanCode())).eq(StringUtils.isNotBlank((CharSequence)planItem.getTemplateConfigCode()), ActivityDetailPlanItem::getTemplateConfigCode, (Object)planItem.getTemplateConfigCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        if (!CollectionUtils.isEmpty((Collection)planItem.getRelatePlanItemCodeList())) {
            wrapper.in(ActivityDetailPlanItem::getRelatePlanItemCode, (Collection)planItem.getRelatePlanItemCodeList());
        }
        return this.list((Wrapper<ActivityDetailPlanItem>)wrapper);
    }

    public List<ActivityDetailPlanItem> findListByDetailPlanCodeList(List<String> detailPlanCodeList) {
        if (CollectionUtils.isEmpty(detailPlanCodeList)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        return this.list((Wrapper<ActivityDetailPlanItem>)((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityDetailPlanItem.class).in(ActivityDetailPlanItem::getDetailPlanCode, detailPlanCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())));
    }

    public Page<ActivityDetailPlanItemVo> findByConditions(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        String detailPlanItemCode = activityDetailPlanItemDto.getDetailPlanItemCode();
        if (StringUtils.isNotBlank((CharSequence)detailPlanItemCode)) {
            detailPlanItemCode = detailPlanItemCode.trim().replaceAll("\\s+", " ");
            List<String> detailPlanItemCodeList = Arrays.asList(detailPlanItemCode.trim().split(" "));
            activityDetailPlanItemDto.setDetailPlanItemCode(null);
            activityDetailPlanItemDto.setDetailPlanItemCodeList(detailPlanItemCodeList);
        }
        Page<ActivityDetailPlanItemVo> pageList = this.activityDetailPlanItemMapper.findByConditions((Page<ActivityDetailPlanItemVo>)page, activityDetailPlanItemDto);
        return pageList;
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public List<ActivityDetailPlanItem> listByDetailCodeList(List<String> detailItemCodeList) {
        if (CollectionUtils.isEmpty(detailItemCodeList)) {
            return Collections.emptyList();
        }
        return this.list((Wrapper<ActivityDetailPlanItem>)((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(ActivityDetailPlanItem::getDetailPlanItemCode, detailItemCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())));
    }

    public Page<ActivityDetailPlanItemVo> findForAudit(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)activityDetailPlanItemDto.getDetailPlanItemCode()) && (activityDetailPlanItemDto.getDetailPlanItemCode().contains(",") || activityDetailPlanItemDto.getDetailPlanItemCode().contains(" "))) {
            activityDetailPlanItemDto.setDetailPlanItemCodeList(Arrays.asList(activityDetailPlanItemDto.getDetailPlanItemCode().split("[, \uff0c]")));
            activityDetailPlanItemDto.setDetailPlanItemCode(null);
        }
        Page<ActivityDetailPlanItemVo> pageList = this.activityDetailPlanItemMapper.findForAudit((Page<ActivityDetailPlanItemVo>)page, activityDetailPlanItemDto);
        return pageList;
    }

    public List<ActivityDetailPlanItemVo> findDetailItemByParams(AutoAuditParamsDto autoAuditParams) {
        return this.activityDetailPlanItemMapper.findDetailItemList(autoAuditParams);
    }

    public List<ActivityDetailPlanItemVo> findDetailPlanItemByCodes(List<String> codes, String autoDate, String autoAudit, String wholeAudit) {
        return this.activityDetailPlanItemMapper.findPlanItemList(codes, wholeAudit, autoDate, autoAudit);
    }

    public List<ActivityDetailPlanItemVo> findForAuditByCodes(Set<String> activityDetails) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlanItem::getDetailPlanItemCode, activityDetails)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<ActivityDetailPlanItemVo>();
        }
        Collection activityDetailPlanItemVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)list, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)activityDetailPlanItemVos;
    }

    public List<ActivityDetailPlanItem> findByActivityDetailItemCodes(Set<String> itemCodes, String activityDetailPlanRollbackBudget) {
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityDetailPlanItem.class).in(ActivityDetailPlanItem::getDetailPlanItemCode, itemCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        if (StringUtils.isNotBlank((CharSequence)activityDetailPlanRollbackBudget)) {
            lambdaQueryWrapper = (LambdaQueryWrapper)lambdaQueryWrapper.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.ne(ActivityDetailPlanItem::getRollbackBudgetTag, (Object)activityDetailPlanRollbackBudget)).or()).isNull(ActivityDetailPlanItem::getRollbackBudgetTag);
            });
        }
        List<ActivityDetailPlanItem> list = this.list((Wrapper<ActivityDetailPlanItem>)lambdaQueryWrapper);
        return list;
    }

    public List<ActivityDetailPlanItemStatisticsVo> statisticsFeeAmountByCusOrgCodes(ActivityDetailPlanItemStatisticsDto dto) {
        return this.activityDetailPlanItemMapper.statisticsFeeAmountByCusOrgCodes(dto);
    }

    public List<ActivityDetailPlanItemStatisticsVo> statisticsDetailPlanItemTotalFee(ActivityDetailPlanItemStatisticsDto dto) {
        return this.activityDetailPlanItemMapper.statisticsDetailPlanItemTotalFee(dto);
    }

    public List<NextMonthPredictAccountFeeVo> statisNextMonthPredictAccountFee(ActivityDetailPlanItemStatisticsDto dto) {
        return this.activityDetailPlanItemMapper.statisNextMonthPredictAccountFee(dto);
    }

    public List<DiscountAccountFeeVo> statisDiscountAccountFee(ActivityDetailPlanItemStatisticsDto dto) {
        return this.activityDetailPlanItemMapper.statisDiscountAccountFee(dto);
    }

    public Page<ActivityDetailPlanItemVo> findByProcessStatusAndUpAccountStatus(Pageable pageable, ActivityDetailPlanItemDto dto, String processStatus, String upAccountStatus) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activityDetailPlanItemMapper.findByProcessStatusAndUpAccountStatus((Page<ActivityDetailPlanItemVo>)page, dto, processStatus, upAccountStatus);
    }

    public void deleteByDetailPlanCodes(List<String> detailPlanCodes) {
        if (CollectionUtils.isEmpty(detailPlanCodes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        updateWrapper.in(ActivityDetailPlanItem::getDetailPlanCode, detailPlanCodes);
        this.update((Wrapper)updateWrapper);
        LambdaUpdateWrapper updateWrapper2 = new UpdateWrapper().lambda();
        updateWrapper2.eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        updateWrapper2.in(ActivityDetailPlanItemExtend::getDetailPlanCode, detailPlanCodes);
        this.activityDetailPlanItemExtendRepository.remove((Wrapper)updateWrapper2);
    }

    public void closeItem(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ActivityDetailPlanItem.class).set(ActivityDetailPlanItem::getIsClose, (Object)BooleanEnum.TRUE.getCapital())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ActivityDetailPlanItem::getDetailPlanItemCode, itemCodeList));
    }

    public void closeItemVertical(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ActivityDetailPlanItem.class).set(ActivityDetailPlanItem::getIsClose, (Object)BooleanEnum.TRUE.getCapital())).set(ActivityDetailPlanItem::getCloseDate, (Object)DateUtil.getDate((SimpleDateFormat)DateUtil.date_yyyy_MM_dd_HH_mm_ss))).set(ActivityDetailPlanItem::getRollbackBudgetTag, (Object)ActivityDetailPlanRollbackBudgetEnum.NO_ROLLBACK.getCode())).in(ActivityDetailPlanItem::getDetailPlanItemCode, itemCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public List<ActivityDetailPlanItemVo> findItemsByActivityDetailItemCodes(List<String> detailPlanCodes) {
        if (CollectionUtils.isEmpty(detailPlanCodes)) {
            return Collections.emptyList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlanItem::getDetailPlanCode, detailPlanCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ActivityDetailPlanItemVo> findByItemCodes(List<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            return Collections.emptyList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlanItem::getDetailPlanItemCode, itemCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public void updateDetailPlanCowManagerState(List<String> successCodes) {
        if (CollectionUtils.isEmpty(successCodes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(ActivityDetailPlanItem::getCowManagerState, (Object)InterfacePushStateEnum.SUCCESS.getCode());
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        updateWrapper.in(ActivityDetailPlanItem::getDetailPlanItemCode, successCodes);
        this.update((Wrapper)updateWrapper);
    }

    public void updateDetailPlanSapState(String code, boolean success) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(ActivityDetailPlanItem::getSapInterfaceState, (Object)(success ? InterfacePushStateEnum.SUCCESS.getCode() : InterfacePushStateEnum.FAIL.getCode()));
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        updateWrapper.eq(ActivityDetailPlanItem::getDetailPlanItemCode, (Object)code);
        this.update((Wrapper)updateWrapper);
    }

    public void fillVoListProperties(List<ActivityDetailPlanItemVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (ActivityDetailPlanItemVo item : voList) {
            this.fillVoProperties(item);
        }
    }

    public void fillVoProperties(ActivityDetailPlanItemVo item) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, ActivityDetailPlanItemVo.class);
    }

    public void fillDtoListProperties(List<ActivityDetailPlanItemDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (ActivityDetailPlanItemDto item : dtoList) {
            this.fillDtoProperties(item);
        }
    }

    public void fillDtoProperties(ActivityDetailPlanItemDto item) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, ActivityDetailPlanItemDto.class);
        item.setActivityType(item.getActivityTypeCode());
        item.setActivityForm(item.getActivityFormCode());
    }

    public List<ActivityDetailPlanItemVo> findSubComActivityDetailByYearMonth(String beginDate, String endDate, String mainCode, List<String> inConditionList) {
        return this.activityDetailPlanItemMapper.findSubComActivityDetailByYearMonth(beginDate, endDate, mainCode, inConditionList, TenantUtils.getTenantCode());
    }

    public Page<ActivityDetailPlanItemVo> findUpwardDetailForWithholding(Page<ActivityDetailPlanItemVo> page, List<String> customerCodeInStrList, ActivityDetailPlanItemDto upwardDto, String upAccountStatus, String processStatus, Set<String> excludeActivityTypeCodeSet) {
        upwardDto.setTenantCode(TenantUtils.getTenantCode());
        return this.activityDetailPlanItemMapper.findUpwardDetailForWithholding(page, customerCodeInStrList, upwardDto, upAccountStatus, processStatus, excludeActivityTypeCodeSet);
    }

    public Map<String, String> findItemCodesByDetailPlanCodes(String planCode) {
        List<ActivityDetailPlanItemVo> itemList = this.activityDetailPlanItemMapper.findItemCodesByDetailPlanCodes(planCode, TenantUtils.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(itemList)) {
            return map;
        }
        itemList.forEach(item -> {
            if (!StringUtils.isBlank((CharSequence)item.getDetailPlanItemCode()) && !StringUtils.isBlank((CharSequence)item.getActivityOrgCode())) {
                map.put(item.getDetailPlanItemCode(), item.getActivityOrgCode());
            }
        });
        return map;
    }

    public List<RedPacketQueryScheme2Vo> redPacketQueryScheme(RedPacketQueryScheme2Dto dto2) {
        return this.activityDetailPlanItemMapper.redPacketQueryScheme(dto2);
    }

    public BigDecimal findByCode(String detailPlanItemCode) {
        return this.activityDetailPlanItemMapper.findByCode(detailPlanItemCode, TenantUtils.getTenantCode());
    }

    public List<String> findApprovedDetailItemCodeListByPlanItemCodeList(List<String> planItemCodeList) {
        return this.activityDetailPlanItemMapper.findApprovedDetailItemCodeListByPlanItemCodeList(planItemCodeList);
    }

    public int findTotalForAudit(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)activityDetailPlanItemDto.getDetailPlanItemCode()) && (activityDetailPlanItemDto.getDetailPlanItemCode().contains(",") || activityDetailPlanItemDto.getDetailPlanItemCode().contains(" "))) {
            activityDetailPlanItemDto.setDetailPlanItemCodeList(Arrays.asList(activityDetailPlanItemDto.getDetailPlanItemCode().split("[, \uff0c]")));
            activityDetailPlanItemDto.setDetailPlanItemCode(null);
        }
        return this.activityDetailPlanItemMapper.findTotalForAudit(activityDetailPlanItemDto);
    }

    public List<String> getNoClosePlanItemNo(List<String> itemNos) {
        if (CollectionUtils.isEmpty(itemNos)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        return this.activityDetailPlanItemMapper.getNoClosePlanItemNo(itemNos, TenantUtils.getTenantCode());
    }

    public Page<ActivityDetailPlanItemVo> findCanAutoAuditItemPage(Page<ActivityDetailPlanItemVo> page, AutoAuditParamsDto autoAuditParams) {
        ArrayList resultList = com.google.common.collect.Lists.newArrayList();
        Page<ActivityDetailPlanItemVo> itemPage = this.activityDetailPlanItemMapper.findCanAutoAuditItemPage(page, autoAuditParams);
        List itemList = itemPage.getRecords();
        if (CollUtil.isEmpty((Collection)itemList)) {
            return itemPage;
        }
        String endCaseForm = autoAuditParams.getEndCaseForm();
        List<String> endCaseFormList = null;
        if (CharSequenceUtil.isNotEmpty((CharSequence)endCaseForm)) {
            endCaseFormList = Arrays.asList(endCaseForm.split(","));
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        for (ActivityDetailPlanItemVo item : itemList) {
            if (CollUtil.isNotEmpty(endCaseFormList)) {
                String auditForm = item.getAuditForm();
                if (CharSequenceUtil.isEmpty((CharSequence)auditForm) && CharSequenceUtil.isNotEmpty((CharSequence)autoAuditParams.getEndCaseForm())) continue;
                List<String> list = Arrays.asList(auditForm.split(","));
                ArrayList filterEndCaseFormList = com.google.common.collect.Lists.newArrayList();
                for (String s : list) {
                    if (!endCaseFormList.contains(s)) continue;
                    filterEndCaseFormList.add(s);
                }
                if (CollUtil.isEmpty((Collection)filterEndCaseFormList)) continue;
            }
            try {
                item.setFeeYearMonth(format.parse(format.format(item.getFeeYearMonth())));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            resultList.add(item);
        }
        itemPage.setRecords((List)resultList);
        return itemPage;
    }

    public Page<ActivityDetailPlanItemVo> findNoRollBackByConditions(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ActivityDetailPlanItemVo> pageList = this.activityDetailPlanItemMapper.findNoRollBackByConditions((Page<ActivityDetailPlanItemVo>)page, activityDetailPlanItemDto);
        return pageList;
    }

    public Integer getSubRelatedItemTotal(ActivityDetailPlanItemDto dto) {
        return this.activityDetailPlanItemMapper.getSubRelatedItemTotal(dto);
    }

    public List<ActivityDetailPlanItemVo> getDetailItemList(Integer num, Integer pageSize, ActivityDetailPlanItemDto dto) {
        return this.activityDetailPlanItemMapper.getDetailItemList(num, pageSize, dto);
    }

    public List<ActivityDetailPlanItemVo> findByCodes(Set<String> set) {
        return this.activityDetailPlanItemMapper.findByCodes(set);
    }

    public List<ActivityDetailPlanItemVo> listForVariable(ActivityDetailPlanItemDto dto) {
        return this.activityDetailPlanItemMapper.listForVariable(dto, TenantUtils.getTenantCode());
    }

    public List<ActivityDetailPlanItem> list(Wrapper<ActivityDetailPlanItem> queryWrapper) {
        List list = super.list(queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List<String> detailPlanItemCodeList;
            List<ActivityDetailPlanProduct> productList;
            List idList = list.stream().map(UuidEntity::getId).collect(Collectors.toList());
            List extendEntityList = this.activityDetailPlanItemExtendRepository.listByIds(idList);
            if (!CollectionUtils.isEmpty((Collection)extendEntityList)) {
                Map extendMap = extendEntityList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
                String[] ignoreFieldArr = ActivityDetailPlanItemExtendRepository.excludeFieldList.toArray(new String[0]);
                for (ActivityDetailPlanItem activityDetailPlanItem : list) {
                    ActivityDetailPlanItemExtend activityDetailPlanItemExtend = (ActivityDetailPlanItemExtend)((Object)extendMap.get(activityDetailPlanItem.getId()));
                    if (null == activityDetailPlanItemExtend) continue;
                    BeanUtil.copyProperties((Object)((Object)activityDetailPlanItemExtend), (Object)((Object)activityDetailPlanItem), (String[])ignoreFieldArr);
                }
            }
            if (!CollectionUtils.isEmpty(productList = this.activityDetailPlanProductRepository.listByDetailPlanItemCodes(detailPlanItemCodeList = list.stream().map(ActivityDetailPlanItem::getDetailPlanItemCode).collect(Collectors.toList())))) {
                Map<String, List<ActivityDetailPlanProduct>> productMap = productList.stream().collect(Collectors.groupingBy(ActivityDetailPlanProduct::getDetailPlanItemCode));
                for (ActivityDetailPlanItem activityDetailPlanItem : list) {
                    if (!productMap.containsKey(activityDetailPlanItem.getDetailPlanItemCode())) continue;
                    List<ActivityDetailPlanProduct> itemProductList = productMap.get(activityDetailPlanItem.getDetailPlanItemCode());
                    String productCode = itemProductList.stream().map(ActivityDetailPlanProduct::getProductCode).collect(Collectors.joining(","));
                    activityDetailPlanItem.setProductCode(productCode);
                    String productName = itemProductList.stream().map(ActivityDetailPlanProduct::getProductName).collect(Collectors.joining(","));
                    activityDetailPlanItem.setProductName(productName);
                }
            }
        }
        return list;
    }

    public boolean save(ActivityDetailPlanItem entity) {
        String productCode = entity.getProductCode();
        String productName = entity.getProductName();
        boolean save = super.save((Object)entity);
        ActivityDetailPlanItemExtend extendEntity = (ActivityDetailPlanItemExtend)((Object)BeanUtil.copyProperties((Object)((Object)entity), ActivityDetailPlanItemExtend.class, (String[])new String[0]));
        extendEntity.setId(null);
        this.activityDetailPlanItemExtendRepository.save((Object)extendEntity);
        return save;
    }

    public boolean saveOrUpdate(ActivityDetailPlanItem entity, Wrapper<ActivityDetailPlanItem> updateWrapper) {
        boolean result = super.saveOrUpdate((Object)entity, updateWrapper);
        ActivityDetailPlanItemExtend extendEntity = (ActivityDetailPlanItemExtend)((Object)BeanUtil.copyProperties((Object)((Object)entity), ActivityDetailPlanItemExtend.class, (String[])new String[0]));
        if (this.activityDetailPlanItemExtendRepository.hasNotEmptyProperty(extendEntity)) {
            this.activityDetailPlanItemExtendRepository.saveOrUpdate((Object)extendEntity);
        }
        return result;
    }

    public boolean saveBatch(Collection<ActivityDetailPlanItem> entityList, int batchSize) {
        boolean result = super.saveBatch(entityList, batchSize);
        ArrayList extendEntityList = Lists.newArrayList();
        for (ActivityDetailPlanItem entity : entityList) {
            ActivityDetailPlanItemExtend extendEntity = (ActivityDetailPlanItemExtend)((Object)BeanUtil.copyProperties((Object)((Object)entity), ActivityDetailPlanItemExtend.class, (String[])new String[0]));
            if (!this.activityDetailPlanItemExtendRepository.hasNotEmptyProperty(extendEntity)) continue;
            extendEntityList.add(extendEntity);
        }
        if (!CollectionUtils.isEmpty((Collection)extendEntityList)) {
            this.activityDetailPlanItemExtendRepository.saveBatch(extendEntityList, batchSize);
        }
        return result;
    }

    public boolean saveOrUpdateBatch(Collection<ActivityDetailPlanItem> entityList, int batchSize) {
        boolean result = super.saveOrUpdateBatch(entityList, batchSize);
        ArrayList extendEntityList = Lists.newArrayList();
        ArrayList idList = com.google.common.collect.Lists.newArrayList();
        for (ActivityDetailPlanItem entity : entityList) {
            ActivityDetailPlanItemExtend extendEntity = (ActivityDetailPlanItemExtend)((Object)BeanUtil.copyProperties((Object)((Object)entity), ActivityDetailPlanItemExtend.class, (String[])new String[0]));
            if (this.activityDetailPlanItemExtendRepository.hasNotEmptyProperty(extendEntity)) {
                extendEntityList.add(extendEntity);
            }
            idList.add(entity.getId());
        }
        if (!CollectionUtils.isEmpty((Collection)extendEntityList)) {
            this.activityDetailPlanItemExtendRepository.saveOrUpdateBatch(extendEntityList, batchSize);
        }
        return result;
    }

    public boolean updateBatchById(Collection<ActivityDetailPlanItem> entityList, int batchSize) {
        boolean result = super.updateBatchById(entityList, batchSize);
        ArrayList extendEntityList = Lists.newArrayList();
        ArrayList idList = com.google.common.collect.Lists.newArrayList();
        for (ActivityDetailPlanItem entity : entityList) {
            ActivityDetailPlanItemExtend extendEntity = (ActivityDetailPlanItemExtend)((Object)BeanUtil.copyProperties((Object)((Object)entity), ActivityDetailPlanItemExtend.class, (String[])new String[0]));
            if (this.activityDetailPlanItemExtendRepository.hasNotEmptyProperty(extendEntity)) {
                extendEntityList.add(extendEntity);
            }
            idList.add(entity.getId());
        }
        if (!CollectionUtils.isEmpty((Collection)extendEntityList)) {
            this.activityDetailPlanItemExtendRepository.saveOrUpdateBatch(extendEntityList, batchSize);
        }
        return result;
    }

    public void updateHeadStatus(List<String> itemCodeList) {
        this.activityDetailPlanItemMapper.updateHeadStatus(itemCodeList);
    }

    public ActivityDetailPlanItemVo getDetailPlanItemByCode(String itemCode) {
        if (CharSequenceUtil.isEmpty((CharSequence)itemCode)) {
            return null;
        }
        return ((ActivityDetailPlanItemMapper)this.baseMapper).getDetailPlanItemByCode(itemCode, TenantUtils.getTenantCode());
    }

    public List<ActivityDetailPlanItem> findByIdList(List<String> ids) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public Integer getExtractAuditDetailPlanCheckDataTotal(ActivityDetailPlanItemDto selectDto) {
        return ((ActivityDetailPlanItemMapper)this.baseMapper).getExtractAuditDetailPlanCheckDataTotal(selectDto);
    }

    public List<ActivityDetailPlanItemVo> extractAuditDetailPlanCheckData(ActivityDetailPlanItemDto selectDto, int pageNumber, int pageSize) {
        return ((ActivityDetailPlanItemMapper)this.baseMapper).extractAuditDetailPlanCheckData(selectDto, pageNumber, pageSize);
    }

    public List<ActivityDetailPlanItem> findListByRelatePlanItemCode(String planItemCode) {
        if (StringUtils.isBlank((CharSequence)planItemCode)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityDetailPlanItem::getRelatePlanItemCode, (Object)planItemCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<ActivityDetailPlanItem> findByRegionPlanItemCodes(List<String> planItemCodes) {
        if (CollectionUtils.isEmpty(planItemCodes)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        return ((ActivityDetailPlanItemMapper)this.getBaseMapper()).findByRegionPlanItemCodes(planItemCodes);
    }

    public Integer findByItemCodesOrPlanCods(Set<String> detailPlanItemCodes, Set<String> planCodes) {
        return ((ActivityDetailPlanItemMapper)this.baseMapper).findByItemCodesOrPlanCods(detailPlanItemCodes, planCodes, TenantUtils.getTenantCode());
    }

    public List<ActivityDetailPlanItemVo> findByPlanCodes(Set<String> cods) {
        return ((ActivityDetailPlanItemMapper)this.baseMapper).findByPlanCodes(cods, TenantUtils.getTenantCode());
    }

    public List<ActivityDetailPlanItem> findByPlanItemCode(String planItemCode) {
        if (StringUtils.isBlank((CharSequence)planItemCode)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        return ((ActivityDetailPlanItemMapper)this.getBaseMapper()).findByPlanItemCode(planItemCode);
    }

    public List<ActivityDetailPlanItemVo> findByPlanItemCodes(Set<String> set) {
        return this.activityDetailPlanItemMapper.findByPlanItemCodes(set, TenantUtils.getTenantCode());
    }

    public List<String> findDetailItemCodesByPlanItemCodes(List<String> planItemCodes) {
        if (CollectionUtils.isEmpty(planItemCodes)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        return this.activityDetailPlanItemMapper.findDetailItemCodesByPlanItemCodes(planItemCodes);
    }

    public List<ActivityDetailPlanItemVo> findByRelatePlanItemCodes(Set<String> set) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlanItem::getRelatePlanItemCode, set)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        return CollectionUtils.isEmpty((Collection)list) ? new ArrayList<ActivityDetailPlanItemVo>() : new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public List<ActivityDetailPlanItemVo> findByConditionsList(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return this.activityDetailPlanItemMapper.findByConditionsList(activityDetailPlanItemDto);
    }

    public Page<ActivityDetailPlanItemsExportsVo> findExportListByDetailPlanCodes(Pageable pageable, List<String> detailPlanCodes) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (CollectionUtils.isEmpty(detailPlanCodes)) {
            page.setTotal(0L);
            return page;
        }
        return this.activityDetailPlanItemMapper.findExportListByDetailPlanCodes((Page<ActivityDetailPlanItemsExportsVo>)page, TenantUtils.getTenantCode(), detailPlanCodes);
    }

    public void updateAuditStatusByActivityDetailCodes(List<String> newActivityDetailCodes, List<String> delActivityDetailCodes, ProcessStatusEnum processStatus) {
        if (!CollectionUtils.isEmpty(newActivityDetailCodes)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ActivityDetailPlanItem::getDetailPlanItemCode, newActivityDetailCodes)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(ActivityDetailPlanItem::getAuditProcessStatus, (Object)processStatus.getDictCode())).update();
        }
        if (!CollectionUtils.isEmpty(delActivityDetailCodes)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ActivityDetailPlanItem::getDetailPlanItemCode, newActivityDetailCodes)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(ActivityDetailPlanItem::getAuditProcessStatus, null)).update();
        }
    }

    public List<ActivityDetailPlanItemDto> findListByDetailCodesForRedPayLedger(List<String> businessNoList) {
        if (CollectionUtils.isEmpty(businessNoList)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        List activityDetailPlanItems = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlanItem::getDetailPlanCode, businessNoList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(ActivityDetailPlanItem::getTemplateConfigCode, (Object)"HDMBPZ0062")).list();
        if (CollectionUtils.isEmpty((Collection)activityDetailPlanItems)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        Collection activityDetailPlanItemDtos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)activityDetailPlanItems, ActivityDetailPlanItem.class, ActivityDetailPlanItemDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)activityDetailPlanItemDtos;
    }

    public Collection<String> findDetailPlanCodeListByItemCodeList(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        return this.list((Wrapper<ActivityDetailPlanItem>)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityDetailPlanItem.class).in(ActivityDetailPlanItem::getDetailPlanItemCode, itemCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).select(new SFunction[]{ActivityDetailPlanItem::getDetailPlanCode})).stream().map(ActivityDetailPlanItem::getDetailPlanCode).distinct().collect(Collectors.toList());
    }

    public Page<DiscountAccountFeeGroupVo> findPageStatisDiscountAccountFee(ActivityDetailPlanItemStatisticsDto dto, Pageable pageable) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<DiscountAccountFeeGroupVo> pageList = this.activityDetailPlanItemMapper.findPageStatisDiscountAccountFee((Page<DiscountAccountFeeGroupVo>)page, dto);
        return pageList;
    }

    public Page<ActivityDetailPlanItemVo> findConditionByPlanCodes(Page<ActivityDetailPlanItemVo> page, ActivityDetailPlanItemDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((ActivityDetailPlanItemMapper)this.baseMapper).findConditionByPlanCodes(page, dto);
    }

    public Page<ActivityDetailPlanItemVo> findItemForMaterialPurchasing(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (Objects.isNull(activityDetailPlanItemDto) && StringUtils.isBlank((CharSequence)activityDetailPlanItemDto.getMaterialCode())) {
            return new Page();
        }
        Page<ActivityDetailPlanItemVo> pageList = this.activityDetailPlanItemMapper.findItemForMaterialPurchasing((Page<ActivityDetailPlanItemVo>)page, activityDetailPlanItemDto);
        return pageList;
    }

    public List<ActivityDetailPlanItem> findByDetailPlanCodes(List<String> detailPlanCode) {
        if (CollectionUtils.isEmpty(detailPlanCode)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlanItem::getDetailPlanCode, detailPlanCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<ActivityDetailPlanItemVo> findChangeStatus(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return com.google.common.collect.Lists.newArrayListWithCapacity((int)0);
        }
        return this.activityDetailPlanItemMapper.findChangeStatus(detailPlanItemCodes, TenantUtils.getTenantCode());
    }

    public Page<String> findByDtoForPrediction(Page<String> page, ActivityDetailPlanItemDto dto) {
        return this.activityDetailPlanItemMapper.findByDtoForPrediction(page, dto);
    }

    public Page<BusinessUnitSetTable> findListForFR(Page<BusinessUnitSetTable> page, List<String> yearMonths) {
        return this.activityDetailPlanItemMapper.findListForFR(page, yearMonths);
    }

    public List<ActivityDetailPlanItemVo> findListByDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isBlank((CharSequence)detailPlanCode)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityDetailPlanItem::getDetailPlanCode, (Object)detailPlanCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        Collection activityDetailPlanItemVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, ActivityDetailPlanItem.class, ActivityDetailPlanItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)activityDetailPlanItemVos;
    }

    public void useProductNumber(ActivityDetailPlanItemVo item) {
        if (Objects.isNull(item) || StringUtil.isEmpty((CharSequence)item.getDetailPlanItemCode()) || Objects.isNull(item.getPeriodPromotionalNumberUse())) {
            return;
        }
        this.activityDetailPlanItemMapper.useProductNumber(item);
    }

    public void updateActivityDetailPurchasingOrder(String code, List<String> thisNewActivityDetailCodes, List<String> thisDelActivityDetailCodes) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return;
        }
        if (!CollectionUtils.isEmpty(thisNewActivityDetailCodes)) {
            this.activityDetailPlanItemExtendRepository.addActivityDetailPurchasingOrder(code, thisNewActivityDetailCodes);
        }
        if (!CollectionUtils.isEmpty(thisDelActivityDetailCodes)) {
            this.activityDetailPlanItemExtendRepository.delActivityDetailPurchasingOrder(code, thisDelActivityDetailCodes);
        }
    }

    public void updateActivityDetailPurchasingOrderProcessStatus(List<String> activityDetailItemCodes, String processStatus) {
        if (StringUtils.isBlank((CharSequence)processStatus)) {
            return;
        }
        if (CollectionUtils.isEmpty(activityDetailItemCodes)) {
            return;
        }
        this.activityDetailPlanItemExtendRepository.updateActivityDetailPurchasingOrderProcessStatus(activityDetailItemCodes, processStatus);
    }

    public List<AuditCustomerDetailCollectionVo> findAuditDetailListByDetailPlanCodeList(List<String> detailPlanItemCodeList) {
        if (CollectionUtils.isEmpty(detailPlanItemCodeList)) {
            return Collections.emptyList();
        }
        return ((ActivityDetailPlanItemMapper)this.baseMapper).findAuditDetailListByDetailPlanCodeList(detailPlanItemCodeList, TenantUtils.getTenantCode());
    }

    public Page<ActivityDetailPlanItemVo> repeatActivityDetailPlanItemPage(Pageable pageable, ActivityDetailPlanItemDto dto, ActivityDetailPlanItemDto sourceDto) {
        if (Objects.isNull(sourceDto)) {
            return new Page();
        }
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new ActivityDetailPlanItemDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        String detailPlanItemCode = dto.getDetailPlanItemCode();
        if (StringUtils.isNotBlank((CharSequence)detailPlanItemCode)) {
            detailPlanItemCode = detailPlanItemCode.trim().replaceAll("\\s+", " ");
            List<String> detailPlanItemCodeList = Arrays.asList(detailPlanItemCode.trim().split(" "));
            dto.setDetailPlanItemCode(null);
            dto.setDetailPlanItemCodeList(detailPlanItemCodeList);
        }
        if (StringUtil.isEmpty((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtil.isEmpty((CharSequence)sourceDto.getTenantCode())) {
            sourceDto.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.activityDetailPlanItemMapper.repeatActivityDetailPlanItemPage((Page<ActivityDetailPlanItemVo>)page, dto, sourceDto);
    }
}

