/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.mapper.ActivityDetailPlanPlanMapper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityDetailPlanPlanRepository
extends ServiceImpl<ActivityDetailPlanPlanMapper, ActivityDetailPlanPlan> {
    @Autowired(required=false)
    private ActivityDetailPlanPlanMapper activityDetailPlanPlanMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<ActivityDetailPlanPlanVo> findListVoByDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isBlank((CharSequence)detailPlanCode)) {
            return null;
        }
        List<ActivityDetailPlanPlanVo> list = this.activityDetailPlanPlanMapper.findListVoByDetailPlanCode(detailPlanCode);
        for (ActivityDetailPlanPlanVo item : list) {
            BigDecimal feeAmount = Optional.ofNullable(item.getTotalFeeAmount()).orElse(BigDecimal.ZERO);
            BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
            item.setUsedAmount(usedAmount);
            item.setUsableAmount(feeAmount.subtract(usedAmount));
        }
        return list;
    }

    public List<ActivityDetailPlanPlan> findListByDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isBlank((CharSequence)detailPlanCode)) {
            return null;
        }
        return this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityDetailPlanPlan.class).eq(ActivityDetailPlanPlan::getDetailPlanCode, (Object)detailPlanCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode()));
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public List<ActivityDetailPlanPlanVo> findActPlan(String detailPlanCode) {
        return this.activityDetailPlanPlanMapper.findActPlan(detailPlanCode);
    }

    public List<ActivityDetailPlanPlan> findDetailPlanAndPlanList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlanPlan::getPlanCode, planCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void deleteByDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isBlank((CharSequence)detailPlanCode)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.eq(ActivityDetailPlanPlan::getDetailPlanCode, (Object)detailPlanCode);
        this.update((Wrapper)updateWrapper);
    }

    public List<ActivityDetailPlanBudgetVo> findForSalesApproval(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return this.activityDetailPlanPlanMapper.findForSalesApproval(detailPlanItemCodes);
    }
}

