/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanProduct;
import com.biz.crm.tpm.business.activity.detail.plan.local.mapper.ActivityDetailPlanProductMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class ActivityDetailPlanProductRepository
extends ServiceImpl<ActivityDetailPlanProductMapper, ActivityDetailPlanProduct> {
    public List<ActivityDetailPlanProduct> findApportionProductByActivityDetailCodes(Set<String> activityDetailCodeSet) {
        List<ActivityDetailPlanProduct> list = new ArrayList<ActivityDetailPlanProduct>();
        if (CollectionUtils.isNotEmpty(activityDetailCodeSet)) {
            list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlanProduct::getDetailPlanItemCode, activityDetailCodeSet)).list();
        }
        return list;
    }

    public void deleteByDetailPlanCode(String detailPlanCode) {
        if (StringUtil.isEmpty((CharSequence)detailPlanCode)) {
            return;
        }
        LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
        updateWrapper.eq(ActivityDetailPlanProduct::getDetailPlanCode, (Object)detailPlanCode);
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        this.remove((Wrapper)updateWrapper);
    }

    public List<ActivityDetailPlanProduct> findListByDetailPlanCode(String detailPlanCode) {
        if (StringUtils.isBlank((CharSequence)detailPlanCode)) {
            return null;
        }
        return this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityDetailPlanProduct.class).eq(ActivityDetailPlanProduct::getDetailPlanCode, (Object)detailPlanCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public List<ActivityDetailPlanProduct> listByDetailPlanItemCodes(List<String> detailPlanItemCodeList) {
        if (CollectionUtils.isEmpty(detailPlanItemCodeList)) {
            return null;
        }
        return this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityDetailPlanProduct.class).in(ActivityDetailPlanProduct::getDetailPlanItemCode, detailPlanItemCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }
}

