/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.mapper.ActivityDetailPlanMapper;
import com.biz.crm.tpm.business.activity.detail.plan.local.vo.ActivityPlanMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanReportDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanReportVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanStatusEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityDetailPlanPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityDetailPlanRepository
extends ServiceImpl<ActivityDetailPlanMapper, ActivityDetailPlan> {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanRepository.class);
    @Autowired(required=false)
    private ActivityDetailPlanMapper activityDetailPlanMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    private static final String AUTO_AUDIT_KEY = "Y";
    private static final String WHOLE_AUDIT_KEY = "Y";

    public Page<ActivityDetailPlanVo> findByConditions(Pageable pageable, ActivityDetailPlanDto activityDetailPlan) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ActivityDetailPlanVo> pageList = this.activityDetailPlanMapper.findByConditions((Page<ActivityDetailPlanVo>)page, activityDetailPlan);
        return pageList;
    }

    public Page<ActivityDetailPlanReportVo> findDetailByConditions(Pageable pageable, ActivityDetailPlanReportDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activityDetailPlanMapper.findDetailByConditions((Page<ActivityDetailPlanReportVo>)page, dto);
    }

    public Page<ActivityDetailPlanItemVo> queryActivityDetailPlan(Pageable pageable, ActivityDetailPlanItemDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<ActivityDetailPlanItemVo> pageList = this.activityDetailPlanMapper.queryActivityDetailPlan((Page<ActivityDetailPlanItemVo>)page, dto);
        return pageList;
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void updateProcessStatus(List<String> codeList, String processStatus) {
        if (CollectionUtils.isEmpty(codeList)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ActivityDetailPlan.class).set(ActivityDetailPlan::getProcessStatus, (Object)processStatus)).in(ActivityDetailPlan::getDetailPlanCode, codeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public void updateProcessStatusAndProcessNo(List<String> codeList, String processStatus, String processNo) {
        if (CollectionUtils.isEmpty(codeList)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ActivityDetailPlan.class).set(ActivityDetailPlan::getProcessStatus, (Object)processStatus)).set(ActivityDetailPlan::getProcessNo, (Object)processNo)).in(ActivityDetailPlan::getDetailPlanCode, codeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public List<ActivityDetailPlan> findByPlanCode(String planCode) {
        if (StringUtils.isEmpty((CharSequence)planCode)) {
            return null;
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityDetailPlan::getPlanCode, (Object)planCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return list;
        }
        return null;
    }

    public List<ActivityDetailPlanItemVo> getCanAutoAuditDto() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        System.out.println(cal.getTime());
        return ((ActivityDetailPlanMapper)this.getBaseMapper()).getCanAutoAuditDto(cal.getTime());
    }

    public List<ActivityDetailPlanVo> findCanAutoAudit(Page<ActivityDetailPlanVo> page, String auditDate) {
        Page<ActivityDetailPlanVo> resultPage = ((ActivityDetailPlanMapper)this.getBaseMapper()).listDetailPlanCanAudoAudit(page, auditDate, "Y", "Y");
        if (resultPage != null) {
            return resultPage.getRecords();
        }
        return null;
    }

    public List<ActivityDetailPlanVo> findCanAutoAudit(Page<ActivityDetailPlanVo> page, AutoAuditParamsDto autoAuditParams) {
        Page<ActivityDetailPlanVo> resultPage = ((ActivityDetailPlanMapper)this.baseMapper).findCanAutoAudit(page, autoAuditParams);
        return resultPage.getRecords();
    }

    public int getCanAutoAuditNumber(String autoDate, String businessUnitCode) {
        Integer canAutoAuditTotalNumber = ((ActivityDetailPlanMapper)this.getBaseMapper()).getCanAutoAuditTotalNumber(autoDate, "Y", "Y", businessUnitCode);
        return canAutoAuditTotalNumber == null || canAutoAuditTotalNumber < 0 ? 0 : canAutoAuditTotalNumber;
    }

    public int getActivityTotalNumber(AutoAuditParamsDto autoAuditParams) {
        Integer resultNumber = ((ActivityDetailPlanMapper)this.baseMapper).getActivityTotalNumber(autoAuditParams);
        return resultNumber == null ? 0 : resultNumber;
    }

    public void updateActivityDetailPlanAutoAudit(String detailPlanCode) {
        ((ActivityDetailPlanMapper)this.getBaseMapper()).updateActivityDetailPlanAutoAudit(detailPlanCode, "Y");
    }

    public List<ActivityDetailPlanVo> findByPlanCodes(Set<String> detailPlanCodes) {
        if (CollectionUtils.isEmpty(detailPlanCodes)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlan::getDetailPlanCode, detailPlanCodes)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        Collection activityDetailPlanVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, ActivityDetailPlan.class, ActivityDetailPlanVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)activityDetailPlanVos;
    }

    public List<ActivityDetailPlan> findByDetailPlanCodeList(List<String> detailPlanCodeList) {
        if (CollectionUtils.isEmpty(detailPlanCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlan::getDetailPlanCode, detailPlanCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<ActivityDetailPlan> findByForeignPlanCodeList(List<String> foreignPlanCodeList) {
        if (CollectionUtils.isEmpty(foreignPlanCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityDetailPlan::getForeignPlanCode, foreignPlanCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<ActivityDetailPlanVo> findPlanCodes(Set<String> codeSet) {
        if (CollectionUtils.isEmpty(codeSet)) {
            return Collections.emptyList();
        }
        return this.activityDetailPlanMapper.findPlanCodes(codeSet, TenantUtils.getTenantCode(), ActivityPlanStatusEnum.allClose.getCode());
    }

    public List<ActivityPlanMessageVo> findPlanMessageByDetailPlanCodeSet(Set<String> detailPlanCodeSet) {
        if (CollectionUtils.isEmpty(detailPlanCodeSet)) {
            return Collections.emptyList();
        }
        return this.activityDetailPlanMapper.findPlanMessageByDetailPlanCodeSet(detailPlanCodeSet);
    }

    public void updateAutoAuditFlag(List<String> codeList, String autoAudit) {
        if (CollectionUtils.isEmpty(codeList)) {
            return;
        }
        List partition = Lists.partition(codeList, (int)800);
        partition.forEach(list -> ((ActivityDetailPlanMapper)this.baseMapper).updateAutoAuditFlag((List<String>)list, autoAudit));
    }

    public ActivityDetailPlan findById(String id) {
        return (ActivityDetailPlan)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public List<ActivityDetailPlan> findHaveNotAuditDetailPlanEntity(ActivityDetailPlanDto dto) {
        return this.activityDetailPlanMapper.findHaveNotAuditDetailPlanEntity(dto);
    }

    public Page<ActivityDetailPlanVo> findPageForOut(Pageable pageable, ActivityDetailPlanDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activityDetailPlanMapper.findPageForOut((Page<ActivityDetailPlanVo>)page, dto);
    }

    public void updatePlanStatusByDetailPlanCodeList(List<String> detailPlanCodeList, ActivityPlanStatusEnum statusEnum) {
        if (CollectionUtil.isEmpty(detailPlanCodeList) || Objects.isNull(statusEnum)) {
            return;
        }
        log.info("\u6d3b\u52a8\u7ec6\u6848\u6d3b\u52a8\u72b6\u6001\u66f4\u65b0repository {} {}", detailPlanCodeList, (Object)statusEnum);
        this.activityDetailPlanMapper.updatePlanStatusByDetailPlanCodeList(detailPlanCodeList, statusEnum.getCode(), TenantUtils.getTenantCode());
    }

    public List<ActivityDetailPlanPlanVo> getDetailPlanInfoByPlanItemCodeList(List<String> planItemCodeList) {
        if (CollectionUtil.isEmpty(planItemCodeList)) {
            return Collections.emptyList();
        }
        return this.activityDetailPlanMapper.getDetailPlanInfoByPlanItemCodeList(planItemCodeList, TenantUtils.getTenantCode());
    }

    public List<ActivityDetailPlanPlanVo> findPlanByRelateDetailPlanCode(List<String> detailPlanCodeList) {
        if (CollectionUtil.isEmpty(detailPlanCodeList)) {
            return Collections.emptyList();
        }
        return this.activityDetailPlanMapper.findPlanByRelateDetailPlanCode(detailPlanCodeList, TenantUtils.getTenantCode());
    }
}

