/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanBudgetService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.OperateActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanBudgetOccupyTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityDetailPlanBudgetServiceImpl
implements ActivityDetailPlanBudgetService {
    @Autowired(required=false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;
    @Autowired(required=false)
    private ActivityPlanSdkService activityPlanSdkService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveActivityDetailPlanBudgetList(ActivityDetailPlan entity, boolean update, List<ActivityDetailPlanItemDto> itemDtoList) {
        HashMap oldMap = Maps.newHashMap();
        if (update) {
            this.activityDetailPlanBudgetRepository.deletePhysicalByDetailPlanCode(entity.getDetailPlanCode());
        }
        for (ActivityDetailPlanItemDto itemDto : itemDtoList) {
            if (CollectionUtils.isEmpty((Collection)itemDto.getBudgetShares())) continue;
            itemDto.getBudgetShares().forEach(item -> {
                item.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                item.setDetailPlanCode(itemDto.getDetailPlanCode());
                item.setIntraCompanyAmount(itemDto.getIntraCompanyAmount());
                item.setCustomerCode(itemDto.getCustomerCode());
            });
        }
        List budgetDtoList = itemDtoList.stream().map(ActivityDetailPlanItemDto::getBudgetShares).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(budgetDtoList, ActivityDetailPlanBudgetDto.class, ActivityDetailPlanBudget.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (ActivityDetailPlanBudget item2 : list) {
            item2.setDetailPlanCode(entity.getDetailPlanCode());
            item2.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item2.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item2.setTenantCode(entity.getTenantCode());
            item2.setId(null);
            saveList.add(item2);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.activityDetailPlanBudgetRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.activityDetailPlanBudgetRepository.updateBatchById(updateList);
        }
    }

    @Override
    public void useMonthBudgetByPlanCodeList(List<String> planCodeList) {
        List<ActivityDetailPlanBudget> activityPlanBudgets = this.activityDetailPlanBudgetRepository.listByDetailPlanCodeList(planCodeList);
        if (CollectionUtils.isEmpty(activityPlanBudgets)) {
            return;
        }
        List budgetList = (List)this.nebulaToolkitService.copyCollectionByBlankList(activityPlanBudgets, ActivityDetailPlanBudget.class, ActivityDetailPlanBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.useMonthBudget(budgetList);
    }

    @Override
    public void useMonthBudget(List<ActivityDetailPlanBudgetDto> budgetList) {
        this.useMonthBudget(budgetList, true);
    }

    @Override
    public void useMonthBudget(List<ActivityDetailPlanBudgetDto> budgetList, boolean doSave) {
        List customerBudgetOperateList;
        List planBudgetOperateList;
        List budgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(item.getOccupyType())).map(item -> new OperateMonthBudgetDto((ActivityDetailPlanBudgetDto)item, doSave){
            final /* synthetic */ ActivityDetailPlanBudgetDto val$item;
            final /* synthetic */ boolean val$doSave;
            {
                this.val$item = activityDetailPlanBudgetDto;
                this.val$doSave = bl;
                this.setBusinessCode(this.val$item.getDetailPlanItemCode());
                this.setIndexNo(this.val$item.getIndexNo());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
                this.setDoSave(this.val$doSave);
            }
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(budgetOperateList)) {
            this.monthBudgetService.operateBudget(budgetOperateList);
        }
        if (!CollectionUtils.isEmpty(planBudgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(item.getOccupyType()) && StringUtils.isNotEmpty((CharSequence)item.getRelatePlanItemCode())).map(item -> new OperateActivityPlanBudgetDto((ActivityDetailPlanBudgetDto)item, doSave){
            final /* synthetic */ ActivityDetailPlanBudgetDto val$item;
            final /* synthetic */ boolean val$doSave;
            {
                this.val$item = activityDetailPlanBudgetDto;
                this.val$doSave = bl;
                this.setBusinessCode(this.val$item.getDetailPlanItemCode());
                this.setPlanCode(this.val$item.getRelatePlanCode());
                this.setIndexNo(this.val$item.getIndexNo());
                this.setPlanItemCode(this.val$item.getRelatePlanItemCode());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
                this.setDoSave(this.val$doSave);
            }
        }).collect(Collectors.toList()))) {
            this.activityPlanSdkService.operateBudget(planBudgetOperateList);
        }
        if (!CollectionUtils.isEmpty(customerBudgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.CUSTOMER.getCode().equals(item.getOccupyType()) && StringUtils.isNotEmpty((CharSequence)item.getRelatePlanItemCode())).map(item -> new OperateActivityPlanBudgetDto((ActivityDetailPlanBudgetDto)item, doSave){
            final /* synthetic */ ActivityDetailPlanBudgetDto val$item;
            final /* synthetic */ boolean val$doSave;
            {
                this.val$item = activityDetailPlanBudgetDto;
                this.val$doSave = bl;
                this.setBusinessCode(this.val$item.getDetailPlanItemCode());
                this.setIndexNo(this.val$item.getIndexNo());
                this.setPlanCode(this.val$item.getRelatePlanCode());
                this.setPlanItemCode(this.val$item.getRelatePlanItemCode());
                this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
                this.setDoSave(this.val$doSave);
            }
        }).collect(Collectors.toList()))) {
            this.activityPlanSdkService.operateCustomerBudget(customerBudgetOperateList);
        }
    }

    @Override
    public void returnMonthBudgetByDetailPlanCodeList(List<String> detailPlanItemCodeList) {
        if (CollectionUtils.isEmpty(detailPlanItemCodeList)) {
            return;
        }
        List<ActivityDetailPlanBudget> activityPlanBudgets = this.activityDetailPlanBudgetRepository.listByDetailPlanItemCodeList(detailPlanItemCodeList);
        if (CollectionUtils.isEmpty(activityPlanBudgets)) {
            return;
        }
        this.returnMonthBudget(activityPlanBudgets);
    }

    @Override
    public void returnMonthBudgetByPlanCodeList(List<String> detailPlanCodeList) {
        if (CollectionUtils.isEmpty(detailPlanCodeList)) {
            return;
        }
        List<ActivityDetailPlanBudget> activityPlanBudgets = this.activityDetailPlanBudgetRepository.listByDetailPlanCodeList(detailPlanCodeList);
        if (CollectionUtils.isEmpty(activityPlanBudgets)) {
            return;
        }
        this.returnMonthBudget(activityPlanBudgets);
    }

    @Override
    public void saveActivityDetailPlanBudgetList(List<ActivityDetailPlanBudget> activityDetailPlanBudgetList) {
        if (!CollectionUtils.isEmpty(activityDetailPlanBudgetList)) {
            activityDetailPlanBudgetList.forEach(item -> {
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            this.activityDetailPlanBudgetRepository.saveBatch(activityDetailPlanBudgetList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void atomicCreateForOut(ActivityDetailPlan entity, List<ActivityDetailPlanItemDto> itemDtoList) {
        for (ActivityDetailPlanItemDto itemDto : itemDtoList) {
            if (CollectionUtils.isEmpty((Collection)itemDto.getBudgetShares())) continue;
            itemDto.getBudgetShares().forEach(item -> {
                item.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                item.setDetailPlanCode(itemDto.getDetailPlanCode());
                item.setIntraCompanyAmount(itemDto.getIntraCompanyAmount());
                item.setCustomerCode(itemDto.getCustomerCode());
            });
        }
        List budgetDtoList = itemDtoList.stream().map(ActivityDetailPlanItemDto::getBudgetShares).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(budgetDtoList, ActivityDetailPlanBudgetDto.class, ActivityDetailPlanBudget.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        for (ActivityDetailPlanBudget item2 : list) {
            item2.setDetailPlanCode(entity.getDetailPlanCode());
            item2.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item2.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item2.setTenantCode(entity.getTenantCode());
            item2.setId(null);
            saveList.add(item2);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.activityDetailPlanBudgetRepository.saveBatch(saveList);
        }
    }

    @Override
    public List<ActivityDetailPlanBudgetVo> findPlanItemCodeByActivityDetailItemCodes(List<String> detailPlanItemCodes) {
        if (CollectionUtils.isEmpty(detailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return this.activityDetailPlanBudgetRepository.findPlanItemCodeByActivityDetailItemCodes(detailPlanItemCodes);
    }

    public void returnMonthBudget(List<ActivityDetailPlanBudget> budgetList) {
        List customerBudgetOperateList;
        List budgetOperateList;
        List planBudgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && StringUtils.isNotEmpty((CharSequence)item.getRelatePlanItemCode()) && ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(item.getOccupyType())).map(item -> new OperateActivityPlanBudgetDto((ActivityDetailPlanBudget)((Object)item)){
            final /* synthetic */ ActivityDetailPlanBudget val$item;
            {
                this.val$item = activityDetailPlanBudget;
                this.setBusinessCode(this.val$item.getDetailPlanItemCode());
                this.setPlanCode(this.val$item.getRelatePlanCode());
                this.setPlanItemCode(this.val$item.getRelatePlanItemCode());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
            }
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(planBudgetOperateList)) {
            this.activityPlanSdkService.operateBudget(planBudgetOperateList);
        }
        if (!CollectionUtils.isEmpty(budgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(item.getOccupyType())).map(item -> new OperateMonthBudgetDto((ActivityDetailPlanBudget)((Object)item)){
            final /* synthetic */ ActivityDetailPlanBudget val$item;
            {
                this.val$item = activityDetailPlanBudget;
                this.setBusinessCode(this.val$item.getDetailPlanItemCode());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
            }
        }).collect(Collectors.toList()))) {
            this.monthBudgetService.operateBudget(budgetOperateList);
        }
        if (!CollectionUtils.isEmpty(customerBudgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.CUSTOMER.getCode().equals(item.getOccupyType()) && StringUtils.isNotEmpty((CharSequence)item.getRelatePlanItemCode())).map(item -> new OperateActivityPlanBudgetDto((ActivityDetailPlanBudget)((Object)item)){
            final /* synthetic */ ActivityDetailPlanBudget val$item;
            {
                this.val$item = activityDetailPlanBudget;
                this.setBusinessCode(this.val$item.getDetailPlanItemCode());
                this.setPlanCode(this.val$item.getRelatePlanCode());
                this.setPlanItemCode(this.val$item.getRelatePlanItemCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
            }
        }).collect(Collectors.toList()))) {
            this.activityPlanSdkService.operateCustomerBudget(customerBudgetOperateList);
        }
    }
}

