/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanBudget;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanBudgetVerticalService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.OperateActivityDetailPlanBudgetDto;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityDetailPlanBudgetVerticalServiceImpl
implements ActivityDetailPlanBudgetVerticalService {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanBudgetVerticalServiceImpl.class);
    @Autowired(required=false)
    private ActivityDetailPlanBudgetRepository activityDetailPlanBudgetRepository;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void operateBudget(List<OperateActivityDetailPlanBudgetDto> operateList) {
        List<ActivityDetailPlanBudget> activityPlanBudgets = this.validateOperateBudget(operateList);
        Map<String, List<ActivityDetailPlanBudget>> budgetEntityMap = activityPlanBudgets.stream().collect(Collectors.groupingBy(ActivityDetailPlanBudget::getDetailPlanItemCode));
        block0: for (OperateActivityDetailPlanBudgetDto operateMonthBudgetDto : operateList) {
            log.error("\u9000\u9884\u7b97\u6d3b\u52a8\u7ec6\u6848\u7f16\u7801\uff1a{}", (Object)operateMonthBudgetDto.getDetailPlanItemCode());
            BigDecimal operationAmount = operateMonthBudgetDto.getOperationAmount();
            List<ActivityDetailPlanBudget> monthBudgetEntities = budgetEntityMap.get(operateMonthBudgetDto.getDetailPlanItemCode());
            for (int i = 0; i < monthBudgetEntities.size(); ++i) {
                ActivityDetailPlanBudget monthBudgetEntity = monthBudgetEntities.get(i);
                BigDecimal usableAmount = monthBudgetEntity.getUseAmount().subtract(monthBudgetEntity.getReturnAmount());
                BigDecimal thisOperationAmount = operationAmount;
                if (BigDecimal.ZERO.compareTo(operationAmount) >= 0) continue block0;
                if (thisOperationAmount.compareTo(usableAmount) > 0) {
                    thisOperationAmount = usableAmount;
                }
                operationAmount = operationAmount.subtract(thisOperationAmount);
                monthBudgetEntity.setReturnAmount(monthBudgetEntity.getReturnAmount().subtract(thisOperationAmount));
            }
        }
        this.activityDetailPlanBudgetRepository.updateBatchById(activityPlanBudgets);
    }

    public List<ActivityDetailPlanBudget> validateOperateBudget(List<OperateActivityDetailPlanBudgetDto> operateList) {
        for (OperateActivityDetailPlanBudgetDto operateMonthBudgetDto : operateList) {
            Validate.notNull((Object)operateMonthBudgetDto.getOperationAmount(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01\u7ec6\u6848\u7f16\u7801\uff1a%s,\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\uff1a%s", (Object[])new Object[]{operateMonthBudgetDto.getDetailPlanCode(), operateMonthBudgetDto.getDetailPlanItemCode()});
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getOperationType(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getDetailPlanItemCode(), (String)"\u64cd\u4f5c\u65b9\u6848\u9884\u7b97\u65f6\uff0c\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        List<String> operateCodeList = operateList.stream().map(OperateActivityDetailPlanBudgetDto::getDetailPlanItemCode).distinct().collect(Collectors.toList());
        LinkedList<ActivityDetailPlanBudget> budgetEntityList = this.activityDetailPlanBudgetRepository.listByOperateCodeListVertical(operateCodeList);
        for (ActivityDetailPlanBudget activityPlanItem : budgetEntityList) {
            if (null == activityPlanItem.getUseAmount()) {
                activityPlanItem.setUseAmount(BigDecimal.ZERO);
            }
            if (null == activityPlanItem.getUsedAmount()) {
                activityPlanItem.setUsedAmount(BigDecimal.ZERO);
            }
            if (null != activityPlanItem.getReturnAmount()) continue;
            activityPlanItem.setReturnAmount(BigDecimal.ZERO);
        }
        return budgetEntityList;
    }
}

