/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemAsyncService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanCloseMqTagEnum;
import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="activityDetailPlanItemAsyncService")
public class ActivityDetailPlanItemAsyncServiceImpl
implements ActivityDetailPlanItemAsyncService {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanItemAsyncServiceImpl.class);
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    public void closeSdActivityItem(List<String> itemCodeList, AbstractCrmUserIdentity userIdentity) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return;
        }
        this.loginUserService.refreshAuthentication((Object)userIdentity);
        List entityGroupList = Lists.partition(itemCodeList, (int)400);
        entityGroupList.forEach(list -> {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(JSON.toJSONString((Object)list));
            mqMessageVo.setTopic("TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag("TPM_ACTIVITY_DETAIL_PLAN_CLOSE_SAP_SD");
            this.rocketMqProducer.sendMqMsg(mqMessageVo);
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        });
    }

    @Override
    public void closeCowManagerActivityItem(List<String> itemCodeList, AbstractCrmUserIdentity userIdentity) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return;
        }
        this.loginUserService.refreshAuthentication((Object)userIdentity);
        List entityGroupList = Lists.partition(itemCodeList, (int)400);
        entityGroupList.forEach(list -> {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(JSON.toJSONString((Object)list));
            mqMessageVo.setTopic("TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag("TPM_ACTIVITY_DETAIL_PLAN_CLOSE_COW_MANAGER");
            this.rocketMqProducer.sendMqMsg(mqMessageVo);
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        });
    }

    @Override
    @Async
    public void closeActivityDetailPlanItemMqPush(String businessUnitCode, List<String> itemCodeList, AbstractCrmUserIdentity userIdentity) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return;
        }
        this.loginUserService.refreshAuthentication((Object)userIdentity);
        this.closeSdActivityItem(itemCodeList, this.loginUserService.getAbstractLoginUser());
        if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            this.closeCowManagerActivityItem(itemCodeList, this.loginUserService.getAbstractLoginUser());
        }
        List entityGroupList = Lists.partition(itemCodeList, (int)400);
        entityGroupList.forEach(list -> {
            for (ActivityDetailPlanCloseMqTagEnum mqTagEnum : ActivityDetailPlanCloseMqTagEnum.values()) {
                MqMessageVo mqMessageVo = new MqMessageVo();
                mqMessageVo.setMsgBody(JSON.toJSONString((Object)list));
                mqMessageVo.setTopic("TPM_ACTIVITY_DETAIL_PLAN_CLOSE_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
                mqMessageVo.setTag(mqTagEnum.getCode());
                this.rocketMqProducer.sendMqMsg(mqMessageVo);
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        });
        MqMessageVo closeRecordVo = new MqMessageVo();
        closeRecordVo.setTopic("TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
        closeRecordVo.setTag("DETAIL_PLAN_ITEM_UPDATE_CLOSE_RECORD");
        closeRecordVo.setMsgBody(JSON.toJSONString(itemCodeList));
        this.rocketMqProducer.sendMqMsg(closeRecordVo, 10L);
    }
}

