/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanItemTerminalRepository;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class ActivityDetailPlanItemPageCacheHelper
extends MnPageCacheHelper<ActivityDetailPlanItemVo, ActivityDetailPlanItemDto> {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanItemPageCacheHelper.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityDetailPlanItemRepository activityDetailPlanItemRepository;
    @Autowired(required=false)
    private ActivityDetailPlanItemTerminalRepository activityDetailPlanItemTerminalRepository;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;
    @Autowired(required=false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    public String getCacheKeyPrefix() {
        return "activity_detail_plan:item_cache:new:";
    }

    public Class<ActivityDetailPlanItemDto> getDtoClass() {
        return ActivityDetailPlanItemDto.class;
    }

    public Class<ActivityDetailPlanItemVo> getVoClass() {
        return ActivityDetailPlanItemVo.class;
    }

    public List<ActivityDetailPlanItemDto> findDtoListFromRepository(ActivityDetailPlanItemDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getDetailPlanCode())) {
            return Lists.newArrayList();
        }
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        List<Object> allDtoList = this.activityDetailPlanItemRepository.findDtoAndAttachListByDetailPlanCode(dto.getDetailPlanCode());
        List<ActivityDetailPlanItemTerminalDto> allTerminalDtoList = this.activityDetailPlanItemTerminalRepository.findTerminalDtoListByDetailItemCodeList(allDtoList.stream().map(ActivityDetailPlanItemBase::getDetailPlanItemCode).collect(Collectors.toList()));
        Map<String, List<ActivityDetailPlanItemTerminalDto>> itemCodeToTerminalDtoListMap = allTerminalDtoList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemTerminalDto::getDetailPlanItemCode));
        allDtoList.forEach(item -> {
            if (itemCodeToTerminalDtoListMap.containsKey(item.getDetailPlanItemCode())) {
                List terminalDtoList = (List)itemCodeToTerminalDtoListMap.get(item.getDetailPlanItemCode());
                ArrayList terminalList = Lists.newArrayList();
                terminalDtoList.forEach(terminalDto -> {
                    ActivityDetailPlanItemTerminalDto temp = (ActivityDetailPlanItemTerminalDto)this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityDetailPlanItemTerminalDto.class, HashSet.class, ArrayList.class, new String[0]);
                    temp.setTerminalCode(terminalDto.getTerminalCode());
                    temp.setTerminalName(terminalDto.getTerminalName());
                    temp.setTerminalType(terminalDto.getTerminalType());
                    temp.setDisplayQuantityStr(terminalDto.getDisplayQuantityStr());
                    temp.setDisplayPriceStr(terminalDto.getDisplayPriceStr());
                    temp.setTerminalMonthSalesAmountStr(terminalDto.getTerminalMonthSalesAmountStr());
                    temp.setPersonIdCard(terminalDto.getPersonIdCard());
                    temp.setPersonType(terminalDto.getPersonType());
                    temp.setPersonName(terminalDto.getPersonName());
                    temp.setPersonCode(terminalDto.getPersonCode());
                    temp.setTotalFeeAmountStr(terminalDto.getTotalFeeAmountStr());
                    temp.setHeadFeeAmountStr(terminalDto.getHeadFeeAmountStr());
                    temp.setDepartmentFeeAmountStr(terminalDto.getDepartmentFeeAmountStr());
                    temp.setIntraCompanyAmountStr(terminalDto.getIntraCompanyAmountStr());
                    temp.setOffPointAmountStr(terminalDto.getOffPointAmountStr());
                    temp.setCustomerFeeAmountStr(terminalDto.getCustomerFeeAmountStr());
                    terminalList.add(temp);
                });
                item.setTerminalList((List)terminalList);
            }
        });
        allDtoList.sort(Comparator.comparing(ActivityDetailPlanItemBase::getDetailPlanItemCode));
        if (StringUtils.isNotBlank((CharSequence)dto.getDetailPlanItemCode())) {
            allDtoList = allDtoList.stream().filter(a -> dto.getDetailPlanItemCode().equals(a.getDetailPlanItemCode())).collect(Collectors.toList());
        }
        Map<String, List<ActivityDetailPlanItemDto>> allMap = allDtoList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemBase::getTemplateConfigCode));
        for (Map.Entry<String, List<ActivityDetailPlanItemDto>> entry : allMap.entrySet()) {
            String thisRedisIdCacheKey = redisCacheIdKey.replace(templateCode, entry.getKey());
            String thisRedisDataCacheKey = redisCacheDataKey.replace(templateCode, entry.getKey());
            Map newItemMap = entry.getValue().stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
            this.redisService.lPushAll(thisRedisIdCacheKey, Long.valueOf(this.getExpireTime()), entry.getValue().stream().map(this::getDtoKey).toArray());
            this.redisTemplate.opsForHash().putAll((Object)thisRedisDataCacheKey, newItemMap);
            this.redisService.expire(thisRedisDataCacheKey, this.getExpireTime());
        }
        List<Object> dtoList = allMap.get(templateCode);
        if (StringUtils.isNotBlank((CharSequence)dto.getDetailPlanItemCode())) {
            ArrayList detailPlanItemCodeList = Lists.newArrayList((Object[])dto.getDetailPlanItemCode().split("[, \uff0c]"));
            dtoList = dtoList.stream().filter(item -> detailPlanItemCodeList.contains(item.getDetailPlanItemCode())).collect(Collectors.toList());
        }
        return dtoList;
    }

    public boolean initToCacheFromRepository() {
        return false;
    }

    public List<ActivityDetailPlanItemDto> newItem(String cacheKey, List<ActivityDetailPlanItemDto> itemList) {
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        ActivityDetailPlanItemDto newItem = new ActivityDetailPlanItemDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newItem.setTemplateConfigCode(templateCode);
        return Lists.newArrayList((Object[])new ActivityDetailPlanItemDto[]{newItem});
    }

    public void importNewItem(String cacheKey, List<ActivityDetailPlanItemDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        for (ActivityDetailPlanItemDto newItem : itemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTemplateConfigCode(templateCode);
        }
        Object[] newIdArr = itemList.stream().map(this::getDtoKey).toArray();
        this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), newIdArr);
        Map updateMap = itemList.stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, updateMap);
        this.redisService.expire(redisCacheDataKey, this.getExpireTime());
    }

    public List<ActivityDetailPlanItemDto> copyItem(String cacheKey, List<ActivityDetailPlanItemDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityDetailPlanItemDto.class, ActivityDetailPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (ActivityDetailPlanItemDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setDetailPlanItemCode(null);
        }
        return newItemList;
    }

    public void updateItem(String cacheKey, List<ActivityDetailPlanItemDto> itemList) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null != requestAttributes) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
            String businessUnitCode = servletRequestAttributes.getRequest().getParameter("businessUnitCode");
            String isTemporary = servletRequestAttributes.getRequest().getParameter("isTemporary");
            if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
                for (ActivityDetailPlanItemDto itemDto : itemList) {
                    if (CollectionUtils.isEmpty((Collection)itemDto.getBudgetShares())) continue;
                    BigDecimal headFeeAmount = BigDecimal.ZERO;
                    BigDecimal regionAutomaticFeeAmount = BigDecimal.ZERO;
                    BigDecimal regionReferendumFeeAmount = BigDecimal.ZERO;
                    HashSet headMonthBudgetCodeSet = Sets.newHashSet();
                    HashSet regionAutomaticMonthBudgetCodeSet = Sets.newHashSet();
                    HashSet regionReferendumMonthBudgetCodeSet = Sets.newHashSet();
                    HashSet headBudgetItemCodeSet = Sets.newHashSet();
                    HashSet regionAutomaticBudgetItemCodeSet = Sets.newHashSet();
                    HashSet regionReferendumBudgetItemCodeSet = Sets.newHashSet();
                    HashSet headBudgetItemNameSet = Sets.newHashSet();
                    HashSet regionAutomaticBudgetItemNameSet = Sets.newHashSet();
                    HashSet regionReferendumBudgetItemNameSet = Sets.newHashSet();
                    for (ActivityDetailPlanBudgetDto budgetDto : itemDto.getBudgetShares()) {
                        if (StringUtils.isEmpty((CharSequence)budgetDto.getFeeBelongCode())) continue;
                        if (StringUtils.isNotEmpty((CharSequence)budgetDto.getUseAmountStr())) {
                            NumberStringDealUtil.validateNumberStrAndSet((String)budgetDto.getUseAmountStr(), (String)"\u672c\u6b21\u4f7f\u7528\u9884\u7b97\u91d1\u989d", (boolean)false, arg_0 -> ((ActivityDetailPlanBudgetDto)budgetDto).setUseAmount(arg_0), BigDecimal.class);
                            if (FeeBelongEnum.HEAD.getCode().equals(budgetDto.getFeeBelongCode())) {
                                headFeeAmount = headFeeAmount.add(budgetDto.getUseAmount());
                            } else if (FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(budgetDto.getFeeBelongCode())) {
                                regionAutomaticFeeAmount = regionAutomaticFeeAmount.add(budgetDto.getUseAmount());
                            } else if (FeeBelongEnum.REGION_REFERENDUM.getCode().equals(budgetDto.getFeeBelongCode())) {
                                regionReferendumFeeAmount = regionReferendumFeeAmount.add(budgetDto.getUseAmount());
                            }
                        }
                        if (FeeBelongEnum.HEAD.getCode().equals(budgetDto.getFeeBelongCode())) {
                            if (StringUtils.isNotEmpty((CharSequence)budgetDto.getMonthBudgetCode())) {
                                headMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemCode())) {
                                headBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemName())) continue;
                            headBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                            continue;
                        }
                        if (FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(budgetDto.getFeeBelongCode())) {
                            if (StringUtils.isNotEmpty((CharSequence)budgetDto.getMonthBudgetCode())) {
                                regionAutomaticMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemCode())) {
                                regionAutomaticBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemName())) continue;
                            regionAutomaticBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                            continue;
                        }
                        if (!FeeBelongEnum.REGION_REFERENDUM.getCode().equals(budgetDto.getFeeBelongCode())) continue;
                        if (StringUtils.isNotEmpty((CharSequence)budgetDto.getMonthBudgetCode())) {
                            regionReferendumMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemCode())) {
                            regionReferendumBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemName())) continue;
                        regionReferendumBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                    }
                    itemDto.setHeadFeeAmount(headFeeAmount);
                    itemDto.setHeadFeeAmountStr(headFeeAmount.toString());
                    itemDto.setRegionAutomaticFeeAmount(regionAutomaticFeeAmount);
                    itemDto.setRegionAutomaticFeeAmountStr(regionAutomaticFeeAmount.toString());
                    itemDto.setRegionReferendumFeeAmount(regionReferendumFeeAmount);
                    itemDto.setRegionReferendumFeeAmountStr(regionReferendumFeeAmount.toString());
                    itemDto.setHeadMonthBudgetCode(String.join((CharSequence)",", headMonthBudgetCodeSet));
                    itemDto.setRegionAutomaticMonthBudgetCode(String.join((CharSequence)",", regionAutomaticMonthBudgetCodeSet));
                    itemDto.setRegionReferendumMonthBudgetCode(String.join((CharSequence)",", regionReferendumMonthBudgetCodeSet));
                    itemDto.setHeadBudgetItemCode(String.join((CharSequence)",", headBudgetItemCodeSet));
                    itemDto.setRegionAutomaticBudgetItemCode(String.join((CharSequence)",", regionAutomaticBudgetItemCodeSet));
                    itemDto.setRegionReferendumBudgetItemCode(String.join((CharSequence)",", regionReferendumBudgetItemCodeSet));
                    itemDto.setHeadBudgetItemName(String.join((CharSequence)",", headBudgetItemNameSet));
                    itemDto.setRegionAutomaticBudgetItemName(String.join((CharSequence)",", regionAutomaticBudgetItemNameSet));
                    itemDto.setRegionReferendumBudgetItemName(String.join((CharSequence)",", regionReferendumBudgetItemNameSet));
                }
            }
            if (BusinessUnitEnum.HEADQUARTERS.getCode().equals(businessUnitCode) && BooleanEnum.FALSE.getCapital().equals(isTemporary)) {
                List relatePlanItemCodes = itemList.stream().map(ActivityDetailPlanItemBase::getRelatePlanItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List activityPlanItemVoList = this.activityPlanItemSdkService.findRelatedPlanItemByCodes(relatePlanItemCodes);
                Map activityPlanMap = activityPlanItemVoList.stream().collect(Collectors.toMap(ActivityPlanItemBase::getPlanItemCode, Function.identity()));
                List templateCodes = itemList.stream().map(ActivityDetailPlanItemBase::getTemplateConfigCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List templateList = this.activitiesTemplateSdkService.findByCodeList(templateCodes);
                Map templateMap = templateList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
                for (ActivityDetailPlanItemDto item : itemList) {
                    Object itemInvoke;
                    PropertyDescriptor propertyDescriptor;
                    if (StringUtils.isEmpty((CharSequence)item.getRelatePlanItemCode())) continue;
                    ActivityPlanItemVo relatePlanItemVo = (ActivityPlanItemVo)activityPlanMap.get(item.getRelatePlanItemCode());
                    if (null == relatePlanItemVo) {
                        throw new IllegalArgumentException("\u83b7\u53d6\u627f\u63a5\u7684\u65b9\u6848\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u5173\u8054\u7684\u65b9\u6848\u660e\u7ec6\u4fe1\u606f! \u65b9\u6848\u660e\u7ec6\u7f16\u7801[" + item.getRelatePlanItemCode() + "]");
                    }
                    ActivitiesTemplateConfigVo templateConfigVo = (ActivitiesTemplateConfigVo)templateMap.get(item.getTemplateConfigCode());
                    if (null == templateConfigVo) {
                        throw new IllegalArgumentException("\u5904\u7406\u627f\u63a5\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6d3b\u52a8\u6a21\u677f\u914d\u7f6e\u4fe1\u606f! \u6a21\u677f\u7f16\u7801[" + item.getTemplateConfigCode() + "]");
                    }
                    ActivityDetailPlanItemDto correspondenceData = this.correspondence(relatePlanItemVo);
                    ObjectConvertStringUtil.fillObjectStrProperties((Object)correspondenceData, ActivityDetailPlanItemDto.class);
                    PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityDetailPlanItemDto.class);
                    Map propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
                    if (BooleanEnum.TRUE.getNumStr().equals(relatePlanItemVo.getFullAccept())) {
                        for (ActivitiesTemplateConfigDetailVo config : templateConfigVo.getDetails()) {
                            if (null == config.getEditableWhenUndertake() || config.getEditableWhenUndertake().booleanValue()) continue;
                            if (!propertyMap.containsKey(config.getField())) {
                                throw new RuntimeException("\u6a21\u677f[" + templateConfigVo.getConfigCode() + templateConfigVo.getConfigName() + "]\u5c5e\u6027[" + config.getTitle() + "]\u7684\u5c5e\u6027[" + config.getField() + "]\u914d\u7f6e\u6709\u8bef!");
                            }
                            propertyDescriptor = (PropertyDescriptor)propertyMap.get(config.getField());
                            if (null != propertyDescriptor) {
                                try {
                                    itemInvoke = propertyDescriptor.getReadMethod().invoke((Object)correspondenceData, new Object[0]);
                                    if (null == itemInvoke) continue;
                                    propertyDescriptor.getWriteMethod().invoke((Object)item, itemInvoke);
                                    continue;
                                }
                                catch (IllegalAccessException | InvocationTargetException e) {
                                    throw new RuntimeException("[" + config.getTitle() + "]\u8bfb\u53d6\u5931\u8d25\uff01");
                                }
                            }
                            throw new RuntimeException("[" + config.getTitle() + "]\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                        }
                        continue;
                    }
                    for (ActivitiesTemplateConfigDetailVo config : templateConfigVo.getDetails()) {
                        if (null == config.getEditableWhenUndertakePart() || config.getEditableWhenUndertakePart().booleanValue()) continue;
                        if (!propertyMap.containsKey(config.getField())) {
                            throw new RuntimeException("\u6a21\u677f[" + templateConfigVo.getConfigCode() + templateConfigVo.getConfigName() + "]\u5c5e\u6027[" + config.getTitle() + "]\u7684\u5c5e\u6027[" + config.getField() + "]\u914d\u7f6e\u6709\u8bef!");
                        }
                        propertyDescriptor = (PropertyDescriptor)propertyMap.get(config.getField());
                        if (null != propertyDescriptor) {
                            try {
                                itemInvoke = propertyDescriptor.getReadMethod().invoke((Object)correspondenceData, new Object[0]);
                                if (null == itemInvoke) continue;
                                propertyDescriptor.getWriteMethod().invoke((Object)item, itemInvoke);
                                continue;
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                throw new RuntimeException("[" + config.getTitle() + "]\u8bfb\u53d6\u5931\u8d25\uff01");
                            }
                        }
                        throw new RuntimeException("[" + config.getTitle() + "]\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                }
            }
        }
    }

    public String getRedisCacheInitKey(String cacheKey) {
        String redisCacheInitKey = super.getRedisCacheInitKey(cacheKey);
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        return redisCacheInitKey.replace(templateCode, "");
    }

    public Object getDtoKey(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return activityDetailPlanItemDto.getId();
    }

    public String getCheckedStatus(ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        return activityDetailPlanItemDto.getChecked();
    }

    private ActivityDetailPlanItemDto correspondence(ActivityPlanItemVo relateVo) {
        ActivityDetailPlanItemDto dto = (ActivityDetailPlanItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)relateVo, ActivityDetailPlanItemDto.class, HashSet.class, ArrayList.class, new String[]{"activityNumber"});
        return dto;
    }
}

