/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.detail.plan.local.service.internal;

import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlan;
import com.biz.crm.tpm.business.activity.detail.plan.local.entity.ActivityDetailPlanProduct;
import com.biz.crm.tpm.business.activity.detail.plan.local.repository.ActivityDetailPlanProductRepository;
import com.biz.crm.tpm.business.activity.detail.plan.local.service.ActivityDetailPlanItemProductService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import liquibase.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityDetailPlanItemProductServiceImpl
implements ActivityDetailPlanItemProductService {
    @Autowired(required=false)
    private ActivityDetailPlanProductRepository activityPlanItemProductRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveActivityDetailPlanItemProductList(ActivityDetailPlan entity, boolean update, List<ActivityDetailPlanItemDto> itemDtoList) {
        if (CollectionUtils.isEmpty(itemDtoList)) {
            return;
        }
        if (update) {
            this.activityPlanItemProductRepository.deleteByDetailPlanCode(entity.getDetailPlanCode());
        }
        ArrayList saveList = Lists.newArrayList();
        for (ActivityDetailPlanItemDto itemDto : itemDtoList) {
            if (!StringUtil.isNotEmpty((String)itemDto.getProductCode()) || !itemDto.getProductCode().contains(",")) continue;
            String[] productCodeSplit = itemDto.getProductCode().split(",");
            if (StringUtil.isEmpty((String)itemDto.getProductName())) {
                throw new RuntimeException("\u4ea7\u54c1\u540d\u79f0\u6709\u8bef\uff01");
            }
            String[] productNameSplit = itemDto.getProductName().split(",");
            if (productNameSplit.length != productCodeSplit.length) {
                throw new RuntimeException("\u4ea7\u54c1\u540d\u79f0\u4e0e\u7f16\u7801\u6570\u91cf\u4e0d\u5339\u914d\uff01");
            }
            for (int i = 0; i < productCodeSplit.length; ++i) {
                ActivityDetailPlanProduct itemProduct = new ActivityDetailPlanProduct();
                itemProduct.setDetailPlanCode(entity.getDetailPlanCode());
                itemProduct.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                itemProduct.setProductCode(productCodeSplit[i]);
                itemProduct.setProductName(productNameSplit[i]);
                saveList.add(itemProduct);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.activityPlanItemProductRepository.saveBatch(saveList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void atomicCreateForOut(ActivityDetailPlan entity, List<ActivityDetailPlanItemDto> itemDtoList) {
        if (CollectionUtils.isEmpty(itemDtoList)) {
            return;
        }
        ArrayList saveList = Lists.newArrayList();
        for (ActivityDetailPlanItemDto itemDto : itemDtoList) {
            if (!StringUtil.isNotEmpty((String)itemDto.getProductCode()) || !itemDto.getProductCode().contains(",")) continue;
            String[] productCodeSplit = itemDto.getProductCode().split(",");
            if (StringUtil.isEmpty((String)itemDto.getProductName())) {
                throw new RuntimeException("\u4ea7\u54c1\u540d\u79f0\u6709\u8bef\uff01");
            }
            String[] productNameSplit = itemDto.getProductName().split(",");
            if (productNameSplit.length != productCodeSplit.length) {
                throw new RuntimeException("\u4ea7\u54c1\u540d\u79f0\u4e0e\u7f16\u7801\u6570\u91cf\u4e0d\u5339\u914d\uff01");
            }
            for (int i = 0; i < productCodeSplit.length; ++i) {
                ActivityDetailPlanProduct itemProduct = new ActivityDetailPlanProduct();
                itemProduct.setDetailPlanCode(entity.getDetailPlanCode());
                itemProduct.setDetailPlanItemCode(itemDto.getDetailPlanItemCode());
                itemProduct.setProductCode(productCodeSplit[i]);
                itemProduct.setProductName(productNameSplit[i]);
                saveList.add(itemProduct);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.activityPlanItemProductRepository.saveBatch(saveList);
        }
    }
}

